


/*
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

/*
 * Purpose of this file :
 *
 * This file contains all compiler specifics for the TASKING C++ compilers. The
 * macro __TASKING__ indicates that a TASKING C++ compiler is used for the
 * compilation. As the TASKING C++ compilers are used for a wide range of embedded
 * targets, several conditional blocks can occur. These are usually named like
 * __CP<target>__.
 * 
 */
# ifndef _STLP_TASKING_H
#  define  _STLP_TASKING_H

// Size of a 32-bit unsigned integer
#  define _STLP_UINT32_T unsigned long

// Define the integer width of the hardware
#define __TSW_INT_WIDTH 32

// Disable wide character support if not supported by the compiler
#  if !defined(_WCHAR_T)
#   define _STLP_NO_WCHAR_T  1
#   define _STLP_NO_MBSTATE_T  1
#  endif

// Check if long long is available
#  if !defined(__NO_LONG_LONG)
#   define _STLP_LONG_LONG long long
#  endif

// Check for bool type
#  if !defined(_BOOL)
#   define  _STLP_NO_BOOL 1
#  endif

// Enable __attribute__((weak)) support
#  define _STLP_WEAK_ATTRIBUTE 1

// Check for namespace support
#  if !defined(__NAMESPACES)
#   define _STLP_NO_NAMESPACES
#  endif

// Check for exception handling
#  if !defined(__EXCEPTIONS)
#   define _STLP_HAS_NO_EXCEPTIONS 1
#   define _STLP_DONT_USE_EXCEPTIONS 1
#   define _STLP_NO_EXCEPTION_SPEC 1
#  endif

// Disable loop inlining
#  define _STLP_LOOP_INLINE_PROBLEMS 1

// Disable threads
#  define _NOTHREADS 1

// Use C-style standard I/O.
#  define _STLP_USE_STDIO_IO 1

// Disable compatibility anachronisms
#  define _STLP_NO_ANACHRONISMS 1

// New-style header <new> is available
#  define _STLP_HAS_NEW_NEW_HEADER 1

// Disable initialization of static data members
#  define _STLP_STATIC_CONST_INIT_BUG 1

// Force string termination.
#  define _STLP_FORCE_STRING_TERMINATION 1

// Various include directories
#  define _STLP_NATIVE_HEADER(header)    <../include.cpp/header>
#  define _STLP_NATIVE_C_HEADER(header)    <../include/header>
#  define _STLP_NATIVE_CPP_C_HEADER(header)    <../include.cpp/header>
#  define _STLP_NATIVE_CPP_RUNTIME_HEADER(header) <../include.cpp/header>

// Enable uncaugh and unexpected except support
#  undef _STLP_NO_UNCAUGHT_EXCEPT_SUPPORT
#  undef _STLP_NO_UNEXPECTED_EXCEPT_SUPPORT

//==========================================================
# endif
