////////////////////////////////////////////////////////////////////////////
//
//  File        :  arm.lsl
//
//  Version     :  @(#)arm.lsl  1.27  08/06/23
//
//  Description :  Default LSL file for ARM processors
//
//  Copyright 2008 Altium BV     
//
////////////////////////////////////////////////////////////////////////////


#include <arm_arch.lsl>


////////////////////////////////////////////////////////////////////////////
//
// If no memory is defined yet use the following memory settings
//
#ifndef __MEMORY

// define rom size
#ifndef __ROM_SIZE
#define __ROM_SIZE              256k
#endif

// define ram size
#ifndef __RAM_SIZE
#define __RAM_SIZE              256k
#endif

memory xrom
{
    mau = 8;
    type = rom;
    size = __ROM_SIZE;
    map ( size = __ROM_SIZE, dest_offset = 0, dest = bus:ARM:local_bus );
}

memory xram
{
    mau = 8;
    type = ram;
    size = __RAM_SIZE;
    map ( size = __RAM_SIZE, dest_offset = __ROM_SIZE, dest = bus:ARM:local_bus );
}

#endif /* __MEMORY */

