##  ARM specific specification file 
##
##  FILE:               @(#)pre_ccarm.spec      1.20.1.1        10/04/12
##
##  COPYRIGHT:          Copyright 2004-2010 Altium BV
##

# tool configuration
TARGET          = arm
CPFE            = cp$(TARGET)
CFE             = c$(TARGET)
ASM             = as$(TARGET)
LLNG            = lk$(TARGET)

# output extensions
CPFE_OUT = ic
PRE_OUT  = pre
DEP_OUT  = d
MIL_OUT  = mil
CFE_OUT  = src
ASM_OUT  = obj
ASM_LST  = lst
LLNG_OUT = abs
LK_OUT   = out
HEX_OUT  = hex
SREC_OUT = sre
BIN_OUT  = bin

# input file handling
# Note: The Perennial testsuite uses *.C as extension for cpp files
%file   *.cc *.cpp *.cxx *.C
{
        # When --force-c is used, all C++ input files are handled as C files by the control program
        %if option(FORCE_C)
        {
                C_FILES = $(C_FILES) $(MATCH)
        }
        %else
        {
                CPLUS_FILES = $(CPLUS_FILES) $(MATCH)
                HAVE_CPLUS = 1
        }
}

%file   *.c
{
        # When --force-c++ is used, all C input files are handled as C++ files by the control program
        %if option(FORCE_CPLUS)
        {
                CPLUS_FILES = $(CPLUS_FILES) $(MATCH)
                HAVE_CPLUS = 1
        }
        %else
        {
                C_FILES = $(C_FILES) $(MATCH)
        }
}

%file   *.mil
{
        MIL_FILES = $(MIL_FILES) $(MATCH)
}

%file   *.ic
{
        # All .ic files are always compiled using the C compiler
        IC_FILES = $(IC_FILES) $(MATCH)
        %if !option(FORCE_C)
        {
                HAVE_CPLUS = 1
        }
}

%file   *.asm *.src
{
        ASM_FILES = $(ASM_FILES) $(MATCH)
}

%file   *.obj *.o *.out
{
        OBJ_FILES = $(OBJ_FILES) $(MATCH)
}

%file   *.a *.lib
{
        LIB_FILES = $(LIB_FILES) $(MATCH)
}

%file   *.lsl
{
        LSL_FLAGS = $(LSL_FLAGS) -d$(MATCH)
}

# handle options
%if option(ISO_MODE) == "99"
{
        C_FLAGS = -c99 $(C_FLAGS)
}
%elif option(ISO_MODE) == "90"
{
        C_FLAGS = -c90 $(C_FLAGS)
}

%option SINGLE_FP
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) -F
        C_FLAGS = $(C_FLAGS) -F
}

%option STATIC
{
        STATIC_FLAGS = --static
}

%option ENDIAN_BE
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) --endianness=big
        C_FLAGS = $(C_FLAGS) --endianness=big
        ASM_FLAGS = $(ASM_FLAGS) --endianness=big
        LLNG_FLAGS = $(LLNG_FLAGS) --endianness=big
}

%option SINTBF
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) --signed-bitfields
        C_FLAGS = $(C_FLAGS) --signed-bitfields
}

%option UCHAR
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) --uchar
        C_FLAGS = $(C_FLAGS) --uchar
}

%option CPU
{
        CPU=$(MATCH)
}

%if option (CPU)
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) -C$(CPU)
        C_FLAGS = $(C_FLAGS) -C$(CPU)
        ASM_FLAGS = $(ASM_FLAGS) -C$(CPU)
        LLNG_FLAGS = $(LLNG_FLAGS) -C$(CPU)
}

%option CHECK
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) --check
        C_FLAGS = $(C_FLAGS) --check
        ASM_FLAGS = $(ASM_FLAGS) --check
}

%option ERROR_FILE
{
        C_FLAGS = $(C_FLAGS) --error-file
        ASM_FLAGS = $(ASM_FLAGS) --error-file
        LLNG_FLAGS = $(LLNG_FLAGS) --error-file
}

%option MACRO_DEFINE
{
        # Add macro definitions
        CPLUS_FLAGS = $(CPLUS_FLAGS) -D$(MATCH)
        C_FLAGS = $(C_FLAGS) -D$(MATCH)
        ASM_DEFINE_FLAGS = $(ASM_DEFINE_FLAGS) -D$(MATCH)
}

%option MACRO_UNDEF
{
        # Add macro un-definitions
        CPLUS_FLAGS = $(CPLUS_FLAGS) -U$(MATCH)
        C_FLAGS = $(C_FLAGS) -U$(MATCH)
}

%option INCLUDE_DIR
{
        # Add include directories
        CPLUS_FLAGS = $(CPLUS_FLAGS) -I$(MATCH)
        C_FLAGS = $(C_FLAGS) -I$(MATCH)
        ASM_FLAGS = $(ASM_FLAGS) -I$(MATCH)
}

%option IO_STREAMS
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) --io-streams
}

%if option (NO_DEFLIB_PATH)
{
        LIB_FLAGS = -L
}

%option LIBRARY_DIR
{
        # Add library directories
        LIB_FLAGS = $(LIB_FLAGS) -L$(MATCH)
}

%option LIBRARY_FILE
{
        # Add libraries
        LIB_FLAGS = $(LIB_FLAGS) -l$(MATCH)
}

%option BUGS
{
        %if $(MATCH) == "all"
        {
                C_FLAGS = $(C_FLAGS) --silicon-bug
                ASM_FLAGS = $(ASM_FLAGS) --silicon-bug
        }
        %else
        {
                C_FLAGS = $(C_FLAGS) --silicon-bug=$(MATCH)
                ASM_FLAGS = $(ASM_FLAGS) --silicon-bug=$(MATCH)
        }
}

# We have suboptions PROFBLOCK, PROFCALL, PROFFUNC, PROFTIME and BR_STAT.
# PROFEDGE is not yet available.
# We have libraries for block/function, callgraph, callgraph/timing and timing,
# so do something smart with correct combinations, and nothing with the rest.

P_LIB_TYPE      =
%option PROFILE
{
        PROFILING_FLAGS = $(PROFILING_FLAGS)$(MATCH)

        %if !option(PROFCALL) && !option(PROFTIME) && ( option(PROFBLOCK) || option(PROFFUNC) )
        {
                # function or block
                P_LIB_TYPE = b
        }
        %elif !option(PROFCALL) && !option(PROFBLOCK) && option(PROFTIME)
        {
                # timing
                P_LIB_TYPE = t
        }
        %elif option(PROFCALL) && !option(PROFBLOCK) && !option(PROFTIME)
        {
                # callgraph
                P_LIB_TYPE = c
        }
        %elif option(PROFCALL) && !option(PROFBLOCK) && option(PROFTIME)
        {
                # callgraph + timing
                P_LIB_TYPE = ct
        }
        %elif option(BR_STAT) && (!option(PROFBLOCK) || (!option(PROFCALL) && !option(PROFTIME)))
        {
                # no profiling libraries needed for static profiling
                # and the combination that does need libraries is valid.
        }
        %else
        {
                %diag F_profiling_combo
        }
}

%if option(PROFILE)
{
        C_FLAGS = $(C_FLAGS) -p$(PROFILING_FLAGS)

        %if $(P_LIB_TYPE)
        {
                # Settings for dynamic profiling
                ASM_DEFINE_FLAGS = $(ASM_DEFINE_FLAGS) -D__PROF_ENABLE__

                %if !option(SYMBOLIC_DEBUG)
                {
                        C_FLAGS = $(C_FLAGS) -g
                }
        }
}


%if !option(NO_SYSLIBS)
{
        # Use THUMB libraries if requested
        %if option(THUMB) || option(CPU) == "ARMv6M" || option(CPU) == "ARMv7M"
        {
                INSTR_SET = thumb
        }
        %else
        {
                INSTR_SET = $(TARGET)
        }

        %if option(SINGLE_FP)
        {
                FP_TAG = s
        }

        %if option(EXCEPTIONS) || option(IO_STREAMS)
        {
                EH_TAG = x
        }

        %if $(HAVE_CPLUS) || option(FORCE_CPLUS)
        {
                %if option(IO_STREAMS)
                {
                        STL_LIB = -lstl$(INSTR_SET)$(FP_TAG)$(EH_TAG)
                }
                CPLUS_LIB = $(STL_LIB) -lcp$(INSTR_SET)$(FP_TAG)$(EH_TAG)
        }

        %if $(P_LIB_TYPE)
        {
                P_LIB   = -lp$(P_LIB_TYPE)$(INSTR_SET)
        }

        C_LIB   = -lc$(INSTR_SET)$(FP_TAG)

        FP_LIB  = -lfp$(INSTR_SET)

        # NOTE: No $(FP_TAG) suffix, because we have no need for an 's' type library (yet)
        RT_LIB = -lrt$(INSTR_SET)

        SYSLIBS = $(CPLUS_LIB) $(P_LIB) $(C_LIB) $(FP_LIB) $(RT_LIB)
}

%option ERRWARN
{
        %if !$(MATCH)
        {
                CPLUS_FLAGS = $(CPLUS_FLAGS) --warnings-as-errors
                C_FLAGS = $(C_FLAGS) --warnings-as-errors
                ASM_FLAGS = $(ASM_FLAGS) --warnings-as-errors
                LLNG_FLAGS = $(LLNG_FLAGS) --warnings-as-errors
        }
}

%option NOWARN
{
        %if !$(MATCH)
        {
                CPLUS_FLAGS = $(CPLUS_FLAGS) --no-warnings
                C_FLAGS = $(C_FLAGS) --no-warnings
                ASM_FLAGS = $(ASM_FLAGS) --no-warnings
                LLNG_FLAGS = $(LLNG_FLAGS) --no-warnings
        }
}

%if !option(SHOW_CPLUS_WARN) && !option(NOWARN)
{       
        IC_FLAGS = $(IC_FLAGS) --no-warnings
}

%option OUTPUT_FORMAT
{
        LLNG_OUTPUT_FLAGS = :$(MATCH)
        %switch $(MATCH)
        {
                %case "ihex" "IHEX"
                {
                        LLNG_OUT = $(HEX_OUT)
                }
                %case "srec" "SREC"
                {
                        LLNG_OUT = $(SREC_OUT)
                }
                %case "bin" "BIN"
                {
                        LLNG_OUT = $(BIN_OUT)
                }
        }
        %if option(OUTPUT_ADDRSIZE)
        {
                LLNG_OUTPUT_FLAGS = $(LLNG_OUTPUT_FLAGS):option(OUTPUT_ADDRSIZE)
        }
}

%option PREPROC
{       # -E -> use only for preprocessing, remember flags in PP_FLAGS
        PP_FLAGS = $(PP_FLAGS) -E$(MATCH)
}

%if option(PREPROC_COMP)
{
        PREPROC_ONLY="1"        # For single input file, we should only use the basename of $(OUTPUT)
}                               # to specify the name of the pre-processor output file
%else
{
        PREPROC_ONLY=""         # For single input file, we should use $(OUTPUT) to specify the name
}                               # of the pre-processor output file

%option SYMBOLIC_DEBUG
{
#       CPLUS_FLAGS = $(CPLUS_FLAGS) -g
        C_FLAGS = $(C_FLAGS) -g
        ASM_FLAGS = $(ASM_FLAGS) -g
}

%option TYPE_CHECK
{
        C_FLAGS = $(C_FLAGS) --global-type-checking
        LLNG_FLAGS = $(LLNG_FLAGS) --global-type-checking
}

%option KEEP_FILES
{
        # Not implemented in the C++ compiler
        C_FLAGS = $(C_FLAGS) -k
        ASM_FLAGS = $(ASM_FLAGS) -k
        LLNG_FLAGS = $(LLNG_FLAGS) -k
}

%option TRADEOFF
{
        C_FLAGS = $(C_FLAGS) -t$(MATCH)
}

%option EXCEPTIONS
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) -x
}

%if option(NO_AUTO_INST)
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) --no-auto-instantiation
}

%option INSTANTIATE
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) -t$(MATCH)
}

%if $(HAVE_CPLUS) || option(FORCE_MUNCH)
{
        LLNG_FLAGS = $(LLNG_FLAGS) --munch
}

%option PASS_CPLUS
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) $(MATCH)
}

%option PASS_C
{
        C_FLAGS = $(C_FLAGS) $(MATCH)
}

%option PASS_ASM
{
        ASM_FLAGS = $(ASM_FLAGS) $(MATCH)
}

%option PASS_LLNG
{
        LLNG_FLAGS = $(LLNG_FLAGS) $(MATCH)
}

%if !option(NO_MAPFILE) && !option(MAP_FILE)
{
        LLNG_FLAGS = $(LLNG_FLAGS) --map-file
}
%option MAP_FILE
{
        %if $(MATCH)
        {
                LLNG_FLAGS = $(LLNG_FLAGS) --map-file=$(MATCH)
        }
        %else
        {
                LLNG_FLAGS = $(LLNG_FLAGS) --map-file
        }
}

%option LSL_FILE
{
        LSL_FLAGS = $(LSL_FLAGS) -d$(MATCH)
}

%option ASM_LISTFILE
{
        ASM_LIST_FILE = 1
        ASM_LIST_NAME = $(MATCH)
}

%if option(THUMB)
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) --thumb
        C_FLAGS     = $(C_FLAGS) --thumb
        ASM_FLAGS   = $(ASM_FLAGS) --thumb
}

# non-control program options
#
# priority:     C  compiler and C++ compiler / Linker/Locator / Assembler

%set_option CPLUS_FLAGS
{
%include opt-cparm.spec
}

%set_option C_FLAGS
{
%include opt-carm.spec
}

%set_option LLNG_FLAGS
{
%include opt-lkarm.spec
}

%set_option ASM_FLAGS
{
%include opt-asarm.spec
}

# get all input files
ALL_FILES = $(CPLUS_FILES) $(C_FILES) $(MIL_FILES) $(ASM_FILES)
%if count(ALL_FILES) == 1
{
        SINGLE_INPUT = 1
}
%elif   has_arg(DEPFILE)
{
        %diag F_depfile_file
}

%option DEPFILE
{
        DEPFILEARG = $(MATCH)
}

%option MAKETARGET
{
        DEP_TARGET = --make-target=$(MATCH)
}

# preprocessing

%if option(PREPROC)
{
        %action $(CPLUS_FILES)
        {
                %if option(DUMP)
                {
                        OUT =   # Always send to stdout
                }
                %elif option(MAKEDEP)
                {
                        OUT = -o output_file($(MATCH), $(DEP_OUT), $(SINGLE_INPUT), "1", $(PREPROC_ONLY) )
                        DEP_FLAGS = $(DEP_TARGET)
                }
                %else
                {
                        OUT = -o output_file($(MATCH), $(PRE_OUT), $(SINGLE_INPUT), "1", $(PREPROC_ONLY) )
                }

                $(CPFE) $(PP_FLAGS) $(DEP_FLAGS) $(CPLUS_FLAGS) $(STATIC_FLAGS) $(OUT) $(MATCH)
        }

        %action $(C_FILES)
        {
                %if option(DUMP)
                {
                        OUT =   # Always send to stdout
                }
                %elif option(MAKEDEP)
                {
                        OUT = -o output_file($(MATCH), $(DEP_OUT), $(SINGLE_INPUT), "1", $(PREPROC_ONLY) )
                        DEP_FLAGS = $(DEP_TARGET)
                }
                %else
                {
                        OUT = -o output_file($(MATCH), $(PRE_OUT), $(SINGLE_INPUT), "1", $(PREPROC_ONLY) )
                }

                $(CFE) $(PP_FLAGS) $(DEP_FLAGS) $(C_FLAGS) $(STATIC_FLAGS) $(OUT) $(MATCH)
        }
}

%stop option(PREPROC) && !option(PREPROC_COMP) 

# compilation actions

%if     count(CPLUS_FILES) == 1 && count(C_FILES) == 0 && count(ASM_FILES) == 0 && count(OBJ_FILES) == 0 && count(LIB_FILES) == 0 &&
        !(option(C_CFILE) || option(C_ASSEMBLY) || option(C_OBJECT) || option(C_RELOCATION)) &&
        !option(INSTANTIATE)
{
        CPLUS_FLAGS = $(CPLUS_FLAGS) -tused
}

%action $(CPLUS_FILES)
{
        %if option(ERROR_FILE)
        {
                ERR_FLAGS = --error-file=replace_extension($(MATCH), ecp)
        }

        %if option(DEPFILE)
        {
                %if !$(DEPFILEARG)
                {
                        DEP_FLAGS = --dep-file=output_file($(MATCH), $(DEP_OUT), "", "1") $(DEP_TARGET)
                }
                %else
                {
                        DEP_FLAGS = --dep-file=$(DEPFILEARG) $(DEP_TARGET)
                }
        }

        OUT = output_file($(MATCH), $(CPFE_OUT), $(SINGLE_INPUT), option(C_CFILE))
        $(CPFE) $(DEP_FLAGS) $(CPLUS_FLAGS) $(ERR_FLAGS) -o $(OUT) $(MATCH)
        %if !option(CHECK)
        {
                GEN_C_FILES = $(GEN_C_FILES) $(OUT)
        }
}

%stop option(C_CFILE)

%action $(C_FILES)
{
        %if option(DEPFILE)
        {
                %if !$(DEPFILEARG)
                {
                        DEP_FLAGS = --dep-file=output_file($(MATCH), $(DEP_OUT), "", "1") $(DEP_TARGET)
                }
                %else
                {
                        DEP_FLAGS = --dep-file=$(DEPFILEARG) $(DEP_TARGET)
                }
        }
        %if option(MILLINK)
        {
                OUT = output_file($(MATCH), $(MIL_OUT), $(SINGLE_INPUT), option(C_MIL), "1" )
                $(CFE) $(DEP_FLAGS) $(C_FLAGS) --mil -o $(OUT) $(MATCH)

                %if !option(CHECK)
                {
                        GEN_MIL_FILES = $(GEN_MIL_FILES) $(OUT)
                }
        }
        %else
        {       
                OUT = output_file($(MATCH), $(CFE_OUT), $(SINGLE_INPUT), option(C_ASSEMBLY))
                $(CFE) $(DEP_FLAGS) $(C_FLAGS) $(STATIC_FLAGS) -o $(OUT) $(MATCH)

                %if !option(CHECK)
                {
                        GEN_ASM_FILES = $(GEN_ASM_FILES) $(OUT)
                }
        }
}

%action $(IC_FILES) $(GEN_C_FILES)
{
        %if option(MILLINK)
        {
                OUT = output_file($(MATCH), $(MIL_OUT), $(SINGLE_INPUT), option(C_MIL), "1" )
                $(CFE) $(C_FLAGS) $(IC_FLAGS) --mil -o $(OUT) $(MATCH)

                %if !option(CHECK)
                {
                        GEN_MIL_FILES = $(GEN_MIL_FILES) $(OUT)
                }
        }
        %else
        {       
                OUT = output_file($(MATCH), $(CFE_OUT), $(SINGLE_INPUT), option(C_ASSEMBLY))
                $(CFE) $(C_FLAGS) $(IC_FLAGS) $(STATIC_FLAGS) -o $(OUT) $(MATCH)

                %if !option(CHECK)
                {
                        GEN_ASM_FILES = $(GEN_ASM_FILES) $(OUT)
                }
        }
}

%stop option(C_MIL)

%single_action $(MIL_FILES) $(GEN_MIL_FILES)
{
        OUT_FILE = output_file($(MATCH), $(CFE_OUT), $(SINGLE_INPUT), option(C_ASSEMBLY))

        $(CFE) $(C_FLAGS) $(STATIC_FLAGS) -o $(OUT_FILE) $(MATCH)

        %if !option(CHECK)
        {
                GEN_ASM_FILES = $(GEN_ASM_FILES) $(OUT_FILE)
        }
}

%stop option(C_ASSEMBLY)

%action $(ASM_FILES)
{
        OUT = output_file($(MATCH), $(ASM_OUT), $(SINGLE_INPUT), option(C_OBJECT))
        %if     $(ASM_LIST_FILE)
        {
                LST_NAME = ""
                %if     $(SINGLE_INPUT)
                {
                        LST_NAME = $(ASM_LIST_NAME)
                }
                %if     ! $(LST_NAME)
                {
                        LST_NAME = output_file($(MATCH), $(ASM_LST), $(SINGLE_INPUT), "1", "1")
                }
                ASM_LST_FLAGS = -l$(LST_NAME)
        }
        %else
        {
                ASM_LST_FLAGS = ""
        }

        $(ASM) $(ASM_DEFINE_FLAGS) $(ASM_FLAGS) $(ASM_LST_FLAGS) -o $(OUT) $(MATCH)

        %if !option(CHECK)
        {
                GEN_OBJ_FILES = $(GEN_OBJ_FILES) $(OUT)
        }
}

%action $(GEN_ASM_FILES)
{
        OUT = output_file($(MATCH), $(ASM_OUT), $(SINGLE_INPUT), option(C_OBJECT))
        %if     $(ASM_LIST_FILE)
        {
                LST_NAME = ""
                %if     $(SINGLE_INPUT)
                {
                        LST_NAME = $(ASM_LIST_NAME)
                }
                %if     ! $(LST_NAME)
                {
                        LST_NAME = output_file($(MATCH), $(ASM_LST), $(SINGLE_INPUT), "1", "1")
                }
                ASM_LST_FLAGS = -l$(LST_NAME)
        }
        %else
        {
                ASM_LST_FLAGS = ""
        }

        $(ASM) $(ASM_FLAGS) $(ASM_LST_FLAGS) -o $(OUT) $(MATCH)

        %if !option(CHECK)
        {
                GEN_OBJ_FILES = $(GEN_OBJ_FILES) $(OUT)
        }
}

%stop option(C_OBJECT)

%single_action $(OBJ_FILES) $(GEN_OBJ_FILES) $(LIB_FILES)
{
        OBJ_FILES = $(OBJ_FILES) $(GEN_OBJ_FILES) $(LIB_FILES)
}

%single_action $(OBJ_FILES)
{
        # Use variable OUTPUT to set the output name
        %if option(C_RELOCATION)
        {
                LLNG_FLAGS = --incremental $(LLNG_FLAGS)
                LLNG_OUT = $(LK_OUT)
        }
        OUT_FILE = output_file($(OUTPUT), $(LLNG_OUT), "1", "1" )
        $(LLNG) $(MATCH) -o $(OUT_FILE)$(LLNG_OUTPUT_FLAGS) $(LSL_FLAGS) $(LLNG_FLAGS) $(LIB_FLAGS) $(SYSLIBS)
}


# Local Variables:
# mode:                 text
# fill-column:          125
# comment-start:        "#"
# End:
