-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
-- Each data bit is represented by 2 bit times:                                                                                                                                -- IncludeIf_RX_Enabled
--             _   _   _   _   _   _   _   _   _   _   _                                                                                                                       -- IncludeIf_RX_Enabled
-- Clock     _| |_| |_| |_| |_| |_| |_| |_| |_| |_| |_| |                                                                                                                      -- IncludeIf_RX_Enabled
--             ___         _______     ___         ___                                                                                                                         -- IncludeIf_RX_Enabled
-- Data Bit  _|   |_______|       |___|   |_______|   |_                                                                                                                       -- IncludeIf_RX_Enabled
--           0  1   0   0   1   1   0   1   0   0   1   0                                                                                                                      -- IncludeIf_RX_Enabled
--             _   ___     _   _   ___   _     ___   _                                                                                                                         -- IncludeIf_RX_Enabled
-- SPDIF In  _| |_|   |___| |_| |_|   |_| |___|   |_| |_                                                                                                                       -- IncludeIf_RX_Enabled
--           0 1 0 1 1 0 0 1 0 1 0 1 1 0 1 0 0 1 1 0 1 0                                                                                                                       -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
-- Received data word - always 32 bit [0..31]                                                                                                                                  -- IncludeIf_RX_Enabled
-- 0-3    - Preamble                                                                                                                                                           -- IncludeIf_RX_Enabled
-- 4-7    - Audio sample bits [0..3]                                                                                                                                           -- IncludeIf_RX_Enabled
-- 8-27   - Audio sample bits [4..23]                                                                                                                                          -- IncludeIf_RX_Enabled
-- 28     - Validity bit, when set, data is invalid                                                                                                                            -- IncludeIf_RX_Enabled
-- 29     - User Data bit                                                                                                                                                      -- IncludeIf_RX_Enabled
-- 30     - Channel Status bit                                                                                                                                                 -- IncludeIf_RX_Enabled
-- 31     - Parity bit (bits 0-3 are not included)                                                                                                                             -- IncludeIf_RX_Enabled
--                                                                                                                                                                             -- IncludeIf_RX_Enabled
-- Preamble is a sequence of transitions that violate bi-phase pattern                                                                                                         -- IncludeIf_RX_Enabled
-- it is intended to be used for synchronization purposes.                                                                                                                     -- IncludeIf_RX_Enabled
--                        Last cell 0         Last cell 1                                                                                                                      -- IncludeIf_RX_Enabled
-- PREAMBLE_BLOCK_START   11101000            00010111                                                                                                                         -- IncludeIf_RX_Enabled
-- PREAMBLE_CHANNEL_A     11100010            00011101                                                                                                                         -- IncludeIf_RX_Enabled
-- PREAMBLE_CHANNEL_B     11100100            00011011                                                                                                                         -- IncludeIf_RX_Enabled
--                                                                                                                                                                             -- IncludeIf_RX_Enabled
-- PREAMBLE_BLOCK_START is also used as PREAMBLE_CHANNEL_A with exception it                                                                                                   -- IncludeIf_RX_Enabled
-- is present on first frame within block. It is both start of block and start of                                                                                              -- IncludeIf_RX_Enabled
-- channel A data.                                                                                                                                                             -- IncludeIf_RX_Enabled
-- Total of 192 frames are sent per block.                                                                                                                                     -- IncludeIf_RX_Enabled
-- Each frame is 2 32-bit words :                                                                                                                                              -- IncludeIf_RX_Enabled
-- [PREAMBLE_CHANNEL_A, ChannelAData, StatusA] [PREAMBLE_CHANNEL_B, ChannelBData, StatusB]                                                                                     -- IncludeIf_RX_Enabled
-- First frame in block is:                                                                                                                                                    -- IncludeIf_RX_Enabled
-- PREAMBLE_BLOCK_START, ChannelAData, PREAMBLE_CHANNEL_B, ChannelBData                                                                                                        -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
Library IEEE;                                                                                                                                                                  -- IncludeIf_RX_Enabled
Use     IEEE.Std_Logic_1164.All;                                                                                                                                               -- IncludeIf_RX_Enabled
Use     IEEE.Std_Logic_Unsigned.All;                                                                                                                                           -- IncludeIf_RX_Enabled
Use     IEEE.Std_Logic_Arith.All;                                                                                                                                              -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
Entity ReplaceWith_Designator_DIGITAL_AUDIO_PHASE_DETECTOR Is                                                                                                                  -- IncludeIf_RX_Enabled
Generic (                                                                                                                                                                      -- IncludeIf_RX_Enabled
     gPulseWidthCounterWidth : Integer := 7;                                                                                                                                   -- IncludeIf_RX_Enabled
     gBitTimeCounterWidth    : Integer := 7                                                                                                                                    -- IncludeIf_RX_Enabled
);                                                                                                                                                                             -- IncludeIf_RX_Enabled
Port (                                                                                                                                                                         -- IncludeIf_RX_Enabled
     CLK_I                           : In  Std_Logic;                      -- Wishbone Clock                                                                                   -- IncludeIf_RX_Enabled
     RST_I                           : In  Std_Logic;                      -- Wishbone Reset                                                                                   -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
     DIGITAL_AUDIO_IN                : In  Std_Logic;                      -- SPDIF Input                                                                                      -- IncludeIf_RX_Enabled
     RX_ENABLE                       : In  Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_AUDIO_TIME_END         : In  Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_LOCKED                       : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_DATA                   : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_BLOCK_START            : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_START                  : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNELA_ACTIVE        : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNELB_ACTIVE        : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_AUDIO_ENABLE           : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_DATA_VALIDITY_ENABLE   : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_USER_DATA_ENABLE       : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNEL_STATUS_ENABLE  : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_PARITY_ENABLE          : Out Std_Logic                                                                                                                           -- IncludeIf_RX_Enabled
);                                                                                                                                                                             -- IncludeIf_RX_Enabled
End;                                                                                                                                                                           -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
Architecture RTL Of ReplaceWith_Designator_DIGITAL_AUDIO_PHASE_DETECTOR is                                                                                                     -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   Type   TPulse        Is ( tPulseNone,                                                                                                                                       -- IncludeIf_RX_Enabled
                             tPulseShort,                                                                                                                                      -- IncludeIf_RX_Enabled
                             tPulseMedium,                                                                                                                                     -- IncludeIf_RX_Enabled
                             tPulseLong );                                                                                                                                     -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Type  TPulseWidth Is ( sPulseWidth_Idle,                                                                                                                                    -- IncludeIf_RX_Enabled
                             sPulseWidth_Start,                                                                                                                                -- IncludeIf_RX_Enabled
                             sPulseWidth_CountAfterRising,                                                                                                                     -- IncludeIf_RX_Enabled
                             sPulseWidth_CountAFterFalling,                                                                                                                    -- IncludeIf_RX_Enabled
                             sPulseWidth_Count,                                                                                                                                -- IncludeIf_RX_Enabled
                             sPulseWidth_Latch);                                                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Type   TBlockState   Is ( sBlockState_Idle,                                                                                                                                 -- IncludeIf_RX_Enabled
                             sBlockState_Start,                                                                                                                                -- IncludeIf_RX_Enabled
                             sBlockState_ChannelA,                                                                                                                             -- IncludeIf_RX_Enabled
                             sBlockState_ChannelB);                                                                                                                            -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Type   TFrameState   Is ( sFrame_Idle,                                                                                                                                      -- IncludeIf_RX_Enabled
                             sFrame_Audio,                                                                                                                                     -- IncludeIf_RX_Enabled
                             sFrame_Validity,                                                                                                                                  -- IncludeIf_RX_Enabled
                             sFrame_UserData,                                                                                                                                  -- IncludeIf_RX_Enabled
                             sFrame_ChannelStatus,                                                                                                                             -- IncludeIf_RX_Enabled
                             sFrame_Parity);                                                                                                                                   -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Type  TPulseBuffer   Is Array (3 Downto 0) Of TPulse;                                                                                                                       -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Constant cPREAMBLE_BLOCK_START_0     : TPulseBuffer := tPulseLong & tPulseShort  & tPulseShort & tPulseLong;    --:= "11101000";  -- LONG, SHORT, SHORT, LONG               -- IncludeIf_RX_Enabled
   Constant cPREAMBLE_CHANNEL_A_START_0 : TPulseBuffer := tPulseLong & tPulseLong   & tPulseShort & tPulseShort;   --:= "11100010";  -- LONG, LONG, SHORT, SHORT               -- IncludeIf_RX_Enabled
   Constant cPREAMBLE_CHANNEL_B_START_0 : TPulseBuffer := tPulseLong & tPulseLong   & tPulseShort & tPulseMedium;  --:= "11100100";  -- LONG, LONG, SHORT, MED                 -- IncludeIf_RX_Enabled
   Constant cPREAMBLE_BLOCK_START_1     : TPulseBuffer := tPulseLong & tPulseShort  & tPulseShort & tPulseLong;    --:= "00010111";  -- LONG, SHORT, SHORT, LONG               -- IncludeIf_RX_Enabled
   Constant cPREAMBLE_CHANNEL_A_START_1 : TPulseBuffer := tPulseLong & tPulseLong   & tPulseShort & tPulseShort;   --:= "00011101";  -- LONG, LONG, SHORT, SHORT               -- IncludeIf_RX_Enabled
   Constant cPREAMBLE_CHANNEL_B_START_1 : TPulseBuffer := tPulseLong & tPulseMedium & tPulseShort & tPulseMedium;  --:= "00011011";  -- LONG, MED, SHORT, MED                  -- IncludeIf_RX_Enabled
   Constant cTransitionCounterWidth     : Integer := 7;                                                                                                                        -- IncludeIf_RX_Enabled
   Constant cTransitionCounterZero      : Std_Logic_Vector(cTransitionCounterWidth - 1 Downto 0) := Conv_Std_Logic_Vector( 0, cTransitionCounterWidth);                        -- IncludeIf_RX_Enabled
   Constant cMaxTransitionCount         : Std_Logic_Vector(cTransitionCounterWidth - 1 Downto 0) := Conv_Std_Logic_Vector(70, cTransitionCounterWidth);                        -- IncludeIf_RX_Enabled
   Constant cBitTimeIsOne               : Std_Logic_Vector(gPulseWidthCounterWidth - 1 Downto 0) := Conv_Std_Logic_Vector( 1, gPulseWidthCounterWidth);                        -- IncludeIf_RX_Enabled
   Constant cBitTimeIsMax               : Std_Logic_Vector(gPulseWidthCounterWidth - 1 Downto 0) := (Others => '1');                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal InputPulse                    : TPulse;                                                                                                                              -- IncludeIf_RX_Enabled
   Signal InputShiftRegister            : TPulseBuffer;                                                                                                                        -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal InputMetastableFilter         : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal InputSynchStage1              : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal InputSynchStage2              : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal InputStable                   : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal InputTransition_Falling       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal InputTransition_Rising        : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal InputTransition               : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal PulseWidth_State              : TPulseWidth;                                                                                                                         -- IncludeIf_RX_Enabled
   Signal PulseWidth_State_Next         : TPulseWidth;                                                                                                                         -- IncludeIf_RX_Enabled
   Signal PulseWidth_Start              : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal PulseWidth_IncrementCounter   : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal PulseWidth_ResetCounter       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal PulseWidthCounter             : Std_Logic_Vector(gPulseWidthCounterWidth - 1 Downto 0);                                                                              -- IncludeIf_RX_Enabled
   Signal TransitionCounter             : Std_Logic_Vector(cTransitionCounterWidth - 1 Downto 0);                                                                              -- IncludeIf_RX_Enabled
   Signal MinPulseWidth                 : Std_Logic_Vector(gPulseWidthCounterWidth - 1 Downto 0);                                                                              -- IncludeIf_RX_Enabled
   Signal PulseWidth                    : Std_Logic_Vector(gPulseWidthCounterWidth - 1 Downto 0);                                                                              -- IncludeIf_RX_Enabled
   Signal MidPulseWidth                 : Std_Logic_Vector(gPulseWidthCounterWidth - 1 Downto 0);                                                                              -- IncludeIf_RX_Enabled
   Signal MaxPulseWidth                 : Std_Logic_Vector(gPulseWidthCounterWidth - 1 Downto 0);                                                                              -- IncludeIf_RX_Enabled
   Signal PulseWidthMax                 : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal TransitionCounterIsZero       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal Preamble_BlockStart           : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal Preamble_ChannelAStart        : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal Preamble_ChannelBStart        : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal Preamble_BlockStart0          : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal Preamble_ChannelAStart0       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal Preamble_ChannelBStart0       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal Preamble_BlockStart1          : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal Preamble_ChannelAStart1       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal Preamble_ChannelBStart1       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal ReceiverEnabled               : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal LongPulse                     : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal MidPulse                      : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal ShortPulse                    : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdatePulseWidth              : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal NewPulseDetected              : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal Block_State                   : TBlockState;                                                                                                                         -- IncludeIf_RX_Enabled
   Signal Block_State_Next              : TBlockState;                                                                                                                         -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal Frame_State                   : TFrameState;                                                                                                                         -- IncludeIf_RX_Enabled
   Signal Frame_State_Next              : TFrameState;                                                                                                                         -- IncludeIf_RX_Enabled
   Signal FrameStart                    : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal FrameAudioEnd                 : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal FrameBitDetected              : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal DecodeDataBit                 : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal DataBitIsValid                : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal DataBit                       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal UpdateFrameBit_Audio          : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdateFrameBit_Validity       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdateFrameBit_UserData       : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdateFrameBit_ChannelStatus  : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdateFrameBit_Parity         : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal ChannelA_Active               : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal ChannelB_Active               : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal Preamble_Detected             : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal PreviousShortPulse            : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   Signal AnyChannelActive              : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdateChannelAudioData        : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdateUserData                : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdateChannelStatus           : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdateParity                  : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal UpdateAudioValidityBit        : Std_Logic;                                                                                                                           -- IncludeIf_RX_Enabled
   Signal IsLockedShift                 : Std_Logic_Vector(2 Downto 0);                                                                                                        -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
Begin                                                                                                                                                                          -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   -- Input synchronization stage and edge detection                                                                                                                           -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   Process(CLK_I)                                                                                                                                                              -- IncludeIf_RX_Enabled
   Begin                                                                                                                                                                       -- IncludeIf_RX_Enabled
        If Rising_Edge(CLK_I) Then                                                                                                                                             -- IncludeIf_RX_Enabled
           InputMetastableFilter <= DIGITAL_AUDIO_IN;                                                                                                                          -- IncludeIf_RX_Enabled
           InputSynchStage1      <= InputMetastableFilter;                                                                                                                     -- IncludeIf_RX_Enabled
           InputSynchStage2      <= InputSynchStage1;                                                                                                                          -- IncludeIf_RX_Enabled
        End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
   End Process;                                                                                                                                                                -- IncludeIf_RX_Enabled
   InputTransition_Falling <= Not InputSynchStage1 And     InputSynchStage2;                                                                                                   -- IncludeIf_RX_Enabled
   InputTransition_Rising  <=     InputSynchStage1 And Not InputSynchStage2;                                                                                                   -- IncludeIf_RX_Enabled
   InputTransition         <= InputTransition_Rising Or InputTransition_Falling;                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
--   DEBUG_TRANSITION <= InputTransition;                                                                                                                                      -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   -- Bit Time Controller                                                                                                                                                      -- IncludeIf_RX_Enabled
   -- Count cycles between input edges                                                                                                                                         -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   Process(PulseWidth_State,                                                                                                                                                   -- IncludeIf_RX_Enabled
           PulseWidth_Start,                                                                                                                                                   -- IncludeIf_RX_Enabled
           InputTransition_Falling,                                                                                                                                            -- IncludeIf_RX_Enabled
           InputTransition_Rising)                                                                                                                                             -- IncludeIf_RX_Enabled
   Begin                                                                                                                                                                       -- IncludeIf_RX_Enabled
        PulseWidth_State_Next       <= PulseWidth_State;                                                                                                                       -- IncludeIf_RX_Enabled
        PulseWidth_IncrementCounter <= '0';                                                                                                                                    -- IncludeIf_RX_Enabled
        PulseWidth_ResetCounter     <= '0';                                                                                                                                    -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
        Case PulseWidth_State Is                                                                                                                                               -- IncludeIf_RX_Enabled
             When sPulseWidth_Idle  =>                                                                                                                                         -- IncludeIf_RX_Enabled
                  If PulseWidth_Start='1' Then                                                                                                                                 -- IncludeIf_RX_Enabled
                     PulseWidth_State_Next <= sPulseWidth_Start;                                                                                                               -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
             When sPulseWidth_Start =>                                                                                                                                         -- IncludeIf_RX_Enabled
                  If InputTransition_Rising='1' Then                                                                                                                           -- IncludeIf_RX_Enabled
                     PulseWidth_State_Next       <= sPulseWidth_CountAfterRising;                                                                                              -- IncludeIf_RX_Enabled
                     PulseWidth_IncrementCounter <= '1';                                                                                                                       -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
             When sPulseWidth_CountAfterRising =>                                                                                                                              -- IncludeIf_RX_Enabled
                  If PulseWidth_Start = '1' Then                                                                                                                               -- IncludeIf_RX_Enabled
                     PulseWidth_IncrementCounter <= '1';                                                                                                                       -- IncludeIf_RX_Enabled
                     If InputTransition_Falling='1' Then                                                                                                                       -- IncludeIf_RX_Enabled
                         PulseWidth_ResetCounter <= '1';                                                                                                                       -- IncludeIf_RX_Enabled
                         PulseWidth_State_Next   <= sPulseWidth_CountAfterFalling;                                                                                             -- IncludeIf_RX_Enabled
                     End If;                                                                                                                                                   -- IncludeIf_RX_Enabled
                  Else                                                                                                                                                         -- IncludeIf_RX_Enabled
                      PulseWidth_ResetCounter <= '1';                                                                                                                          -- IncludeIf_RX_Enabled
                      PulseWidth_State_Next   <= sPulseWidth_Idle;                                                                                                             -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
             When sPulseWidth_CountAfterFalling =>                                                                                                                             -- IncludeIf_RX_Enabled
                  If PulseWidth_Start = '1' Then                                                                                                                               -- IncludeIf_RX_Enabled
                     PulseWidth_IncrementCounter <= '1';                                                                                                                       -- IncludeIf_RX_Enabled
                     If InputTransition_Rising='1' Then                                                                                                                        -- IncludeIf_RX_Enabled
                         PulseWidth_ResetCounter <= '1';                                                                                                                       -- IncludeIf_RX_Enabled
                         PulseWidth_State_Next   <= sPulseWidth_CountAfterRising;                                                                                              -- IncludeIf_RX_Enabled
                     End If;                                                                                                                                                   -- IncludeIf_RX_Enabled
                  Else                                                                                                                                                         -- IncludeIf_RX_Enabled
                      PulseWidth_ResetCounter <= '1';                                                                                                                          -- IncludeIf_RX_Enabled
                      PulseWidth_State_Next   <= sPulseWidth_Idle;                                                                                                             -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
             When Others               =>                                                                                                                                      -- IncludeIf_RX_Enabled
                  PulseWidth_State_Next <= sPulseWidth_Idle;                                                                                                                   -- IncludeIf_RX_Enabled
        End Case;                                                                                                                                                              -- IncludeIf_RX_Enabled
   End Process;                                                                                                                                                                -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   Process(CLK_I)                                                                                                                                                              -- IncludeIf_RX_Enabled
   Begin                                                                                                                                                                       -- IncludeIf_RX_Enabled
        If Rising_Edge(CLK_I) Then                                                                                                                                             -- IncludeIf_RX_Enabled
           If RST_I='1' Then                                                                                                                                                   -- IncludeIf_RX_Enabled
               PulseWidth_State <= sPulseWidth_Idle;                                                                                                                           -- IncludeIf_RX_Enabled
               Block_State      <= sBlockState_Idle;                                                                                                                           -- IncludeIf_RX_Enabled
               Frame_State      <= sFrame_Idle;                                                                                                                                -- IncludeIf_RX_Enabled
           Else                                                                                                                                                                -- IncludeIf_RX_Enabled
               PulseWidth_State <= PulseWidth_State_Next;                                                                                                                      -- IncludeIf_RX_Enabled
               Block_State      <= Block_State_Next;                                                                                                                           -- IncludeIf_RX_Enabled
               Frame_State      <= Frame_State_Next;                                                                                                                           -- IncludeIf_RX_Enabled
               If ReceiverEnabled = '0' Then                                                                                                                                   -- IncludeIf_RX_Enabled
                   Block_State <= sBlockState_Idle;                                                                                                                            -- IncludeIf_RX_Enabled
                   Frame_State <= sFrame_Idle;                                                                                                                                 -- IncludeIf_RX_Enabled
               End If;                                                                                                                                                         -- IncludeIf_RX_Enabled
           End If;                                                                                                                                                             -- IncludeIf_RX_Enabled
        End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
   End Process;                                                                                                                                                                -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   -- Keep track of all pulses, detect current pulse                                                                                                                           -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   Process(CLK_I)                                                                                                                                                              -- IncludeIf_RX_Enabled
   Begin                                                                                                                                                                       -- IncludeIf_RX_Enabled
        If Rising_Edge(CLK_I) Then                                                                                                                                             -- IncludeIf_RX_Enabled
           If RST_I='1' Then                                                                                                                                                   -- IncludeIf_RX_Enabled
               PulseWidthCounter <= (Others=>'1');                                                                                                                             -- IncludeIf_RX_Enabled
               MinPulseWidth     <= (Others=>'0');                                                                                                                             -- IncludeIf_RX_Enabled
               MidPulseWidth     <= (Others=>'0');                                                                                                                             -- IncludeIf_RX_Enabled
               MaxPulseWidth     <= (Others=>'0');                                                                                                                             -- IncludeIf_RX_Enabled
               PulseWidth        <= (Others=>'1');                                                                                                                             -- IncludeIf_RX_Enabled
               LongPulse         <= '0';                                                                                                                                       -- IncludeIf_RX_Enabled
               MidPulse          <= '0';                                                                                                                                       -- IncludeIf_RX_Enabled
               ShortPulse        <= '0';                                                                                                                                       -- IncludeIf_RX_Enabled
               UpdatePulseWidth  <= '0';                                                                                                                                       -- IncludeIf_RX_Enabled
               NewPulseDetected  <= '0';                                                                                                                                       -- IncludeIf_RX_Enabled
           Else                                                                                                                                                                -- IncludeIf_RX_Enabled
               If PulseWidth_ResetCounter = '1' Then                                                                                                                           -- IncludeIf_RX_Enabled
                  If PulseWidthCounter > cBitTimeIsOne Then                                                                                                                    -- IncludeIf_RX_Enabled
                     PulseWidth  <= PulseWidthCounter;                                                                                                                         -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
                  PulseWidthCounter   <= (Others=>'1');                                                                                                                        -- IncludeIf_RX_Enabled
                  UpdatePulseWidth <= '1';                                                                                                                                     -- IncludeIf_RX_Enabled
               Else                                                                                                                                                            -- IncludeIf_RX_Enabled
                   UpdatePulseWidth <= '0';                                                                                                                                    -- IncludeIf_RX_Enabled
                   If PulseWidth_IncrementCounter = '1' Then                                                                                                                   -- IncludeIf_RX_Enabled
                      PulseWidthCounter <= PulseWidthCounter + 1;                                                                                                              -- IncludeIf_RX_Enabled
                   End If;                                                                                                                                                     -- IncludeIf_RX_Enabled
               End If;                                                                                                                                                         -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
               If UpdatePulseWidth='1' Then                                                                                                                                    -- IncludeIf_RX_Enabled
                   If PulseWidth > MidPulseWidth + 2 And                                                                                                                       -- IncludeIf_RX_Enabled
                      PulseWidthMax = '0'            Then                                                                                                                      -- IncludeIf_RX_Enabled
                      MaxPulseWidth <= PulseWidth;                                                                                                                             -- IncludeIf_RX_Enabled
                      LongPulse     <= '1';                                                                                                                                    -- IncludeIf_RX_Enabled
                   End If;                                                                                                                                                     -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
                   If PulseWidth < MaxPulseWidth - 2 And                                                                                                                       -- IncludeIf_RX_Enabled
                      PulseWidth > MinPulseWidth + 2 Then                                                                                                                      -- IncludeIf_RX_Enabled
                      MidPulseWidth <= PulseWidth;                                                                                                                             -- IncludeIf_RX_Enabled
                      MidPulse      <= '1';                                                                                                                                    -- IncludeIf_RX_Enabled
                   End If;                                                                                                                                                     -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
                   If PulseWidth < MidPulseWidth - 2 Then                                                                                                                      -- IncludeIf_RX_Enabled
                      MinPulseWidth <= PulseWidth;                                                                                                                             -- IncludeIf_RX_Enabled
                      ShortPulse    <= '1';                                                                                                                                    -- IncludeIf_RX_Enabled
                   End If;                                                                                                                                                     -- IncludeIf_RX_Enabled
               Else                                                                                                                                                            -- IncludeIf_RX_Enabled
                   LongPulse  <= '0';                                                                                                                                          -- IncludeIf_RX_Enabled
                   MidPulse   <= '0';                                                                                                                                          -- IncludeIf_RX_Enabled
                   ShortPulse <= '0';                                                                                                                                          -- IncludeIf_RX_Enabled
               End If;                                                                                                                                                         -- IncludeIf_RX_Enabled
               NewPulseDetected <= LongPulse Or MidPulse Or ShortPulse;                                                                                                        -- IncludeIf_RX_Enabled
           End If;                                                                                                                                                             -- IncludeIf_RX_Enabled
        End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
   End Process;                                                                                                                                                                -- IncludeIf_RX_Enabled
   PulseWidthMax <= '1' When PulseWidth = cBitTimeIsMax Else '0';                                                                                                              -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   -- Buffer Pulses                                                                                                                                                            -- IncludeIf_RX_Enabled
   -- Decode start of frame and start of channel                                                                                                                               -- IncludeIf_RX_Enabled
   -- Decode Raw Data bits                                                                                                                                                     -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   Process(CLK_I)                                                                                                                                                              -- IncludeIf_RX_Enabled
   Begin                                                                                                                                                                       -- IncludeIf_RX_Enabled
        If Rising_Edge(CLK_I) Then                                                                                                                                             -- IncludeIf_RX_Enabled
           If RST_I='1' Then                                                                                                                                                   -- IncludeIf_RX_Enabled
              InputShiftRegister      <= tPulseNone & tPulseNone & tPulseNone & tPulseNone;                                                                                    -- IncludeIf_RX_Enabled
              Preamble_BlockStart0    <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_BlockStart1    <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_ChannelAStart0 <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_ChannelAStart1 <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_ChannelBStart0 <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_ChannelBStart1 <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              DecodeDataBit           <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              PreviousShortPulse      <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              DataBit                 <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              DataBitIsValid          <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
           Else                                                                                                                                                                -- IncludeIf_RX_Enabled
                  If LongPulse ='1' Then InputShiftRegister <= InputShiftRegister(2 Downto 0) & tPulseLong;                                                                    -- IncludeIf_RX_Enabled
               ElsIf MidPulse  ='1' Then InputShiftRegister <= InputShiftRegister(2 Downto 0) & tPulseMedium;                                                                  -- IncludeIf_RX_Enabled
               ElsIf ShortPulse='1' Then InputShiftRegister <= InputShiftRegister(2 Downto 0) & tPulseShort;                                                                   -- IncludeIf_RX_Enabled
               End If;                                                                                                                                                         -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
              Preamble_BlockStart0    <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_BlockStart1    <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_ChannelAStart0 <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_ChannelAStart1 <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_ChannelBStart0 <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
              Preamble_ChannelBStart1 <= '0';                                                                                                                                  -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
              If InputShiftRegister = cPREAMBLE_BLOCK_START_0     Then                                                                                                         -- IncludeIf_RX_Enabled
                  Preamble_BlockStart0 <= '1';                                                                                                                                 -- IncludeIf_RX_Enabled
              End If;                                                                                                                                                          -- IncludeIf_RX_Enabled
              If InputShiftRegister = cPREAMBLE_BLOCK_START_1     Then                                                                                                         -- IncludeIf_RX_Enabled
                  Preamble_BlockStart1 <= '1';                                                                                                                                 -- IncludeIf_RX_Enabled
              End If;                                                                                                                                                          -- IncludeIf_RX_Enabled
              If InputShiftRegister = cPREAMBLE_CHANNEL_A_START_0 Then                                                                                                         -- IncludeIf_RX_Enabled
                  Preamble_ChannelAStart0 <= '1';                                                                                                                              -- IncludeIf_RX_Enabled
              End If;                                                                                                                                                          -- IncludeIf_RX_Enabled
              If InputShiftRegister = cPREAMBLE_CHANNEL_A_START_1 Then                                                                                                         -- IncludeIf_RX_Enabled
                  Preamble_ChannelAStart1 <= '1';                                                                                                                              -- IncludeIf_RX_Enabled
              End If;                                                                                                                                                          -- IncludeIf_RX_Enabled
              If InputShiftRegister = cPREAMBLE_CHANNEL_B_START_0 Then                                                                                                         -- IncludeIf_RX_Enabled
                  Preamble_ChannelBStart0 <= '1';                                                                                                                              -- IncludeIf_RX_Enabled
              End If;                                                                                                                                                          -- IncludeIf_RX_Enabled
              If InputShiftRegister = cPREAMBLE_CHANNEL_B_START_1 Then                                                                                                         -- IncludeIf_RX_Enabled
                  Preamble_ChannelBStart1 <= '1';                                                                                                                              -- IncludeIf_RX_Enabled
              End If;                                                                                                                                                          -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
              DecodeDataBit <= NewPulseDetected;                                                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
              DataBitIsValid <= '0';                                                                                                                                           -- IncludeIf_RX_Enabled
              If Preamble_Detected = '1' Then                                                                                                                                  -- IncludeIf_RX_Enabled
                 PreviousShortPulse <= '0';                                                                                                                                    -- IncludeIf_RX_Enabled
              Else                                                                                                                                                             -- IncludeIf_RX_Enabled
                  If DecodeDataBit='1' Then                                                                                                                                    -- IncludeIf_RX_Enabled
                     If InputShiftRegister(0) = tPulseShort Then                                                                                                               -- IncludeIf_RX_Enabled
                        PreviousShortPulse <= '1';                                -- RAF: TODO: clear it when we have short/med combination                                    -- IncludeIf_RX_Enabled
                        If PreviousShortPulse = '1' Then                                                                                                                       -- IncludeIf_RX_Enabled
                           PreviousShortPulse <= '0';                                                                                                                          -- IncludeIf_RX_Enabled
                           DataBit            <= '1';                                                                                                                          -- IncludeIf_RX_Enabled
                           DataBitIsValid     <= '1';                                                                                                                          -- IncludeIf_RX_Enabled
                        End If;                                                                                                                                                -- IncludeIf_RX_Enabled
                     End If;                                                                                                                                                   -- IncludeIf_RX_Enabled
                     If InputShiftRegister(0) = tPulseMedium Then                                                                                                              -- IncludeIf_RX_Enabled
                        DataBit        <= '0';                                                                                                                                 -- IncludeIf_RX_Enabled
                        DataBitIsValid <= '1';                                                                                                                                 -- IncludeIf_RX_Enabled
                     End If;                                                                                                                                                   -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
              End If;                                                                                                                                                          -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
           End If;                                                                                                                                                             -- IncludeIf_RX_Enabled
        End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
   End Process;                                                                                                                                                                -- IncludeIf_RX_Enabled
   Preamble_BlockStart    <= Preamble_BlockStart0    Or Preamble_BlockStart1;                                                                                                  -- IncludeIf_RX_Enabled
   Preamble_ChannelAStart <= Preamble_ChannelAStart0 Or Preamble_ChannelAStart1;                                                                                               -- IncludeIf_RX_Enabled
   Preamble_ChannelBStart <= Preamble_ChannelBStart0 Or Preamble_ChannelBStart1;                                                                                               -- IncludeIf_RX_Enabled
   Preamble_Detected      <= Preamble_BlockStart Or Preamble_ChannelAStart Or Preamble_ChannelBStart;                                                                          -- IncludeIf_RX_Enabled
   FrameBitDetected       <= DataBitIsValid;                                                                                                                                   -- IncludeIf_RX_Enabled
   FrameStart             <= (Preamble_BlockStart Or Preamble_ChannelAStart Or Preamble_ChannelBStart);                                                                        -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   -- High Level Block Stream Control                                                                                                                                          -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   Process(Block_State,                                                                                                                                                        -- IncludeIf_RX_Enabled
           Preamble_BlockStart,                                                                                                                                                -- IncludeIf_RX_Enabled
           Preamble_BlockStart,                                                                                                                                                -- IncludeIf_RX_Enabled
           Preamble_ChannelAStart,                                                                                                                                             -- IncludeIf_RX_Enabled
           Preamble_ChannelBStart)                                                                                                                                             -- IncludeIf_RX_Enabled
   Begin                                                                                                                                                                       -- IncludeIf_RX_Enabled
        Block_State_Next <= Block_State;                                                                                                                                       -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
        ChannelA_Active <= '0';                                                                                                                                                -- IncludeIf_RX_Enabled
        ChannelB_Active <= '0';                                                                                                                                                -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
        Case Block_State Is                                                                                                                                                    -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sBlockState_Idle       =>                                                                                                                                    -- IncludeIf_RX_Enabled
                  If Preamble_BlockStart='1' Then                                                                                                                              -- IncludeIf_RX_Enabled
                      Block_State_Next <= sBlockState_Start;                                                                                                                   -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sBlockState_Start =>                                                                                                                                         -- IncludeIf_RX_Enabled
                  Block_State_Next <= sBlockState_ChannelA;                                                                                                                    -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sBlockState_ChannelA   =>                                                                                                                                    -- IncludeIf_RX_Enabled
                  ChannelA_Active <= '1';                                                                                                                                      -- IncludeIf_RX_Enabled
                  If Preamble_ChannelBStart = '1' Then                                                                                                                         -- IncludeIf_RX_Enabled
                      Block_State_Next <= sBlockState_ChannelB;                                                                                                                -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sBlockState_ChannelB   =>                                                                                                                                    -- IncludeIf_RX_Enabled
                  ChannelB_Active <= '1';                                                                                                                                      -- IncludeIf_RX_Enabled
                  If Preamble_BlockStart = '1' Then                                                                                                                            -- IncludeIf_RX_Enabled
                      Block_State_Next <= sBlockState_Start;                                                                                                                   -- IncludeIf_RX_Enabled
                  ElsIf Preamble_ChannelAStart='1' Then                                                                                                                        -- IncludeIf_RX_Enabled
                      Block_State_Next <= sBlockState_ChannelA;                                                                                                                -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When Others =>                                                                                                                                                    -- IncludeIf_RX_Enabled
                  Block_State_Next <= sBlockState_Idle;                                                                                                                        -- IncludeIf_RX_Enabled
        End Case;                                                                                                                                                              -- IncludeIf_RX_Enabled
   End Process;                                                                                                                                                                -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   Process(Frame_State,                                                                                                                                                        -- IncludeIf_RX_Enabled
           FrameStart,                                                                                                                                                         -- IncludeIf_RX_Enabled
           FrameAudioEnd,                                                                                                                                                      -- IncludeIf_RX_Enabled
           FrameBitDetected)                                                                                                                                                   -- IncludeIf_RX_Enabled
   Begin                                                                                                                                                                       -- IncludeIf_RX_Enabled
        Frame_State_Next <= Frame_State;                                                                                                                                       -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
        UpdateFrameBit_Audio         <= '0';                                                                                                                                   -- IncludeIf_RX_Enabled
        UpdateFrameBit_Validity      <= '0';                                                                                                                                   -- IncludeIf_RX_Enabled
        UpdateFrameBit_UserData      <= '0';                                                                                                                                   -- IncludeIf_RX_Enabled
        UpdateFrameBit_ChannelStatus <= '0';                                                                                                                                   -- IncludeIf_RX_Enabled
        UpdateFrameBit_Parity        <= '0';                                                                                                                                   -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
        Case Frame_State Is                                                                                                                                                    -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sFrame_Idle          =>                                                                                                                                      -- IncludeIf_RX_Enabled
                  If FrameStart = '1' Then                                                                                                                                     -- IncludeIf_RX_Enabled
                     Frame_State_Next <= sFrame_Audio;                                                                                                                         -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sFrame_Audio         =>                                                                                                                                      -- IncludeIf_RX_Enabled
                  If FrameAudioEnd = '1' Then                                                                                                                                  -- IncludeIf_RX_Enabled
                     Frame_State_Next <= sFrame_Validity;                                                                                                                      -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
                  If FrameBitDetected = '1' Then                                                                                                                               -- IncludeIf_RX_Enabled
                     UpdateFrameBit_Audio <= '1';                                                                                                                              -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sFrame_Validity      =>                                                                                                                                      -- IncludeIf_RX_Enabled
                  If FrameBitDetected='1' Then                                                                                                                                 -- IncludeIf_RX_Enabled
                     Frame_State_Next <= sFrame_UserData;                                                                                                                      -- IncludeIf_RX_Enabled
                     UpdateFrameBit_Validity <= '1';                                                                                                                           -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sFrame_UserData      =>                                                                                                                                      -- IncludeIf_RX_Enabled
                  If FrameBitDetected='1' Then                                                                                                                                 -- IncludeIf_RX_Enabled
                     Frame_State_Next <= sFrame_ChannelStatus;                                                                                                                 -- IncludeIf_RX_Enabled
                     UpdateFrameBit_UserData <= '1';                                                                                                                           -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sFrame_ChannelStatus =>                                                                                                                                      -- IncludeIf_RX_Enabled
                  If FrameBitDetected='1' Then                                                                                                                                 -- IncludeIf_RX_Enabled
                     Frame_State_Next <= sFrame_Parity;                                                                                                                        -- IncludeIf_RX_Enabled
                     UpdateFrameBit_ChannelStatus <= '1';                                                                                                                      -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When sFrame_Parity        =>                                                                                                                                      -- IncludeIf_RX_Enabled
                  If FrameBitDetected='1' Then                                                                                                                                 -- IncludeIf_RX_Enabled
                     Frame_State_Next <= sFrame_Idle;                                                                                                                          -- IncludeIf_RX_Enabled
                     UpdateFrameBit_Parity <= '1';                                                                                                                             -- IncludeIf_RX_Enabled
                  End If;                                                                                                                                                      -- IncludeIf_RX_Enabled
             -------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
             When Others               =>                                                                                                                                      -- IncludeIf_RX_Enabled
                  Frame_State_Next <= sFrame_Idle;                                                                                                                             -- IncludeIf_RX_Enabled
        End Case;                                                                                                                                                              -- IncludeIf_RX_Enabled
   End Process;                                                                                                                                                                -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
   -- --------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
     AnyChannelActive       <= ChannelA_Active Or ChannelB_Active;                                                                                                             -- IncludeIf_RX_Enabled
     UpdateChannelAudioData <= UpdateFrameBit_Audio         And AnyChannelActive;                                                                                              -- IncludeIf_RX_Enabled
     UpdateUserData         <= UpdateFrameBit_UserData      And AnyChannelActive;                                                                                              -- IncludeIf_RX_Enabled
     UpdateChannelStatus    <= UpdateFrameBit_ChannelStatus And AnyChannelActive;                                                                                              -- IncludeIf_RX_Enabled
     UpdateParity           <= UpdateFrameBit_Parity        And AnyChannelActive;                                                                                              -- IncludeIf_RX_Enabled
     UpdateAudioValidityBit <= UpdateFrameBit_Validity      And AnyChannelActive;                                                                                              -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
     ReceiverEnabled  <= RX_ENABLE;                                                                                                                                            -- IncludeIf_RX_Enabled
     PulseWidth_Start <= RX_ENABLE;                                                                                                                                            -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
     RX_LOCKED                      <= FrameStart;                                                                                                                             -- IncludeIf_RX_Enabled
     RX_FRAME_DATA                  <= DataBit;                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FRAME_BLOCK_START           <= Preamble_BlockStart;                                                                                                                    -- IncludeIf_RX_Enabled
     RX_FRAME_START                 <= FrameStart;                                                                                                                             -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNELA_ACTIVE       <= ChannelA_Active;                                                                                                                        -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNELB_ACTIVE       <= ChannelB_Active;                                                                                                                        -- IncludeIf_RX_Enabled
     RX_FRAME_AUDIO_ENABLE          <= UpdateChannelAudioData;                                                                                                                 -- IncludeIf_RX_Enabled
     RX_FRAME_USER_DATA_ENABLE      <= UpdateUserData;                                                                                                                         -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNEL_STATUS_ENABLE <= UpdateChannelStatus;                                                                                                                    -- IncludeIf_RX_Enabled
     RX_FRAME_PARITY_ENABLE         <= UpdateParity;                                                                                                                           -- IncludeIf_RX_Enabled
     RX_FRAME_DATA_VALIDITY_ENABLE  <= UpdateAudioValidityBit;                                                                                                                 -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
     FrameAudioEnd <= RX_FRAME_AUDIO_TIME_END;                                                                                                                                 -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
End RTL;                                                                                                                                                                       -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled



-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
Library IEEE;                                                                                                                                                                              -- IncludeIf_RX_Enabled
Use     IEEE.Std_Logic_1164.All;                                                                                                                                                           -- IncludeIf_RX_Enabled
Use     IEEE.Std_Logic_Unsigned.All;                                                                                                                                                       -- IncludeIf_RX_Enabled
Use     IEEE.Std_Logic_Arith.All;                                                                                                                                                          -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
Entity ReplaceWith_Designator_DIGITAL_AUDIO_DATA_ASSEMBLY_LINE Is                                                                                                                          -- IncludeIf_RX_Enabled
Generic (                                                                                                                                                                                  -- IncludeIf_RX_Enabled
    gRxFifoFreeSlotsWidth : Integer := ReplaceWith_RxFifo_DataCountWidth                                                                                                                   -- IncludeIf_RX_Enabled
);                                                                                                                                                                                         -- IncludeIf_RX_Enabled
Port (                                                                                                                                                                                     -- IncludeIf_RX_Enabled
     CLK_I : In Std_Logic;                                                                                                                                                                 -- IncludeIf_RX_Enabled
     RST_I : In Std_Logic;                                                                                                                                                                 -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
     RX_ENABLE             : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_BLOCK_START        : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FRAME_START        : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_CHANNELA_IS_ACTIVE : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_CHANNELB_IS_ACTIVE : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_AUDIO_DATA         : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_PARITY_BIT_VALID   : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_AUDIO_DATA_VALID   : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_AUDIO_END          : Out Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_USER_VALID         : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_STATUS_VALID       : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_VALIDITY_BIT       : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
     RX_FLAG_PARITY_ERROR  : Out  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FLAG_BLOCK_START   : Out  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
     -- Aux Bits Buffer --TODO                                                                                                                                                             -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_CHANNELA_STATUS_DATA : Out Std_Logic_Vector(15 Downto 0);                                                                                                               -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_CHANNELB_STATUS_DATA : Out Std_Logic_Vector(15 Downto 0);                                                                                                               -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_USER_DATA_A          : Out Std_Logic_Vector(15 Downto 0);                                                                                                               -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_USER_DATA_B          : Out Std_Logic_Vector(15 Downto 0);                                                                                                               -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_WRITE_DATA           : Out Std_Logic;                                                                                                                                   -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
     -- Audio Buffer Interface                                                                                                                                                             -- IncludeIf_RX_Enabled
     RX_FIFO_DATA          : Out Std_Logic_Vector(31 Downto 0);                                                                                                                            -- IncludeIf_RX_Enabled
     RX_FIFO_WRITE         : Out Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FIFO_FULL          : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FIFO_ALMOST_FULL   : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FIFO_FREE_SLOTS    : In  Std_Logic_Vector(gRxFifoFreeSlotsWidth - 1 Downto 0)                                                                                                      -- IncludeIf_RX_Enabled
);                                                                                                                                                                                         -- IncludeIf_RX_Enabled
End;                                                                                                                                                                                       -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
Architecture RTL Of ReplaceWith_Designator_DIGITAL_AUDIO_DATA_ASSEMBLY_LINE Is                                                                                                             -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Type TParityState Is (sParity_Idle,                                                                                                                                                    -- IncludeIf_RX_Enabled
                          sParity_Start,                                                                                                                                                   -- IncludeIf_RX_Enabled
                          sParity_Audio,                                                                                                                                                   -- IncludeIf_RX_Enabled
                          sParity_Valid,                                                                                                                                                   -- IncludeIf_RX_Enabled
                          sParity_User,                                                                                                                                                    -- IncludeIf_RX_Enabled
                          sParity_Status,                                                                                                                                                  -- IncludeIf_RX_Enabled
                          sParity_Done,                                                                                                                                                    -- IncludeIf_RX_Enabled
                          sParity_DataWrite);                                                                                                                                              -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    Constant cSampleSize           : Integer := 24;                                                                                                                                        -- IncludeIf_RX_Enabled
    Constant cAudioBitCounterWidth : Integer := 5;                                                                                                                                         -- IncludeIf_RX_Enabled
    Constant cAudioBitCount        : Std_Logic_Vector(cAudioBitCounterWidth - 1 Downto 0) := Conv_Std_Logic_Vector(cSampleSize, cAudioBitCounterWidth);                                    -- IncludeIf_RX_Enabled
    Constant cChannelSubFrameCount : Std_Logic_Vector(7 Downto 0)                         := Conv_Std_Logic_Vector(192, 8);                                                                -- IncludeIf_RX_Enabled
    Signal   AudioBitCounter       : Std_Logic_Vector(cAudioBitCounterWidth - 1 Downto 0);                                                                                                 -- IncludeIf_RX_Enabled
    Signal   AudioShiftRegister    : Std_Logic_Vector(23 Downto 0);                                                                                                                        -- IncludeIf_RX_Enabled
    Signal   DataShiftRegister     : Std_Logic_Vector(3  Downto 0);                                                                                                                        -- IncludeIf_RX_Enabled
    Signal   RxAudioBit            : Std_Logic;                                                                                                                                            -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Signal ChannelACounter        : Std_Logic_Vector(7 Downto 0);                                                                                                                          -- IncludeIf_RX_Enabled
    Signal ChannelBCounter        : Std_Logic_Vector(7 Downto 0);                                                                                                                          -- IncludeIf_RX_Enabled
    Signal ChannelACount          : Std_Logic_Vector(7 Downto 0);                                                                                                                          -- IncludeIf_RX_Enabled
    Signal ChannelBCount          : Std_Logic_Vector(7 Downto 0);                                                                                                                          -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Signal BlockStart             : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal BlockStartFF           : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal BlockStartFF1          : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal FrameStart             : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal FrameStartFF           : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal FrameStartFF1          : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Signal ChannelAError          : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal ChannelBError          : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal ErrorChannelA          : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal ErrorChannelB          : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Signal DataValidityError      : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal RxAudioEnd             : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Signal ParityState            : TParityState;                                                                                                                                          -- IncludeIf_RX_Enabled
    Signal ParityState_Next       : TParityState;                                                                                                                                          -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Signal ParityValue            : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal ParityError            : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal ErrorParity            : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal AnyParityEvent         : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal RxAudioDataValid       : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal ErrorSampleNotWritten  : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Signal WriteAudioSample       : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal ErrorFlagChannelA      : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal ErrorFlagChannelB      : Std_Logic;                                                                                                                                             -- IncludeIf_RX_Enabled
    Signal ParityErrorCount               : Std_Logic_Vector(7 Downto 0);                                                                                                                  -- IncludeIf_RX_Enabled
    Signal DataValidityErrorChannelACount : Std_Logic_Vector(7 Downto 0);                                                                                                                  -- IncludeIf_RX_Enabled
    Signal DataValidityErrorChannelBCount : Std_Logic_Vector(7 Downto 0);                                                                                                                  -- IncludeIf_RX_Enabled
    Signal SkippedSamplesCount            : Std_Logic_Vector(7 Downto 0);                                                                                                                  -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Signal SubframeStatus      : Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
    Signal ActiveChannel       : Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
    Signal LatchChannelInfo    : Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
    Signal LatchChannelInfoFF  : Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
    Signal LatchChannelInfoFF1 : Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
    Signal BlockStartAligned   : Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
    Signal BlockStartShiftReg  : Std_Logic_Vector(2 Downto 0);                                                                                                                             -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Signal ChannelAStatusBitsShift   : Std_Logic_Vector(15 Downto 0);                                                                                                                      -- IncludeIf_RX_Enabled
    Signal ChannelBStatusBitsShift   : Std_Logic_Vector(15 Downto 0);                                                                                                                      -- IncludeIf_RX_Enabled
    Signal UserDataABitsShift        : Std_Logic_Vector(15 Downto 0);                                                                                                                      -- IncludeIf_RX_Enabled
    Signal UserDataBBitsShift        : Std_Logic_Vector(15 Downto 0);                                                                                                                      -- IncludeIf_RX_Enabled
    Signal StoreAuxData              : Std_Logic;                                                                                                                                          -- IncludeIf_RX_Enabled
    Signal FrameCounter              : Integer Range 0 To 15;                                                                                                                              -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
Begin                                                                                                                                                                                      -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    --                                                                                                                                                                                     -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    Process(CLK_I)                                                                                                                                                                         -- IncludeIf_RX_Enabled
    Begin                                                                                                                                                                                  -- IncludeIf_RX_Enabled
        If Rising_Edge(CLK_I) Then                                                                                                                                                         -- IncludeIf_RX_Enabled
            If RST_I='1' Or RX_ENABLE='0' Then                                                                                                                                             -- IncludeIf_RX_Enabled
                AudioBitCounter    <= (Others=>'0');                                                                                                                                       -- IncludeIf_RX_Enabled
                RxAudioEnd         <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
                AudioShiftRegister <= (Others=>'0');                                                                                                                                       -- IncludeIf_RX_Enabled
                RxAudioBit         <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
                RxAudioDatavalid   <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
                DataShiftRegister  <= (Others=>'0');                                                                                                                                       -- IncludeIf_RX_Enabled
                ActiveChannel      <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
                SubframeStatus     <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
            Else                                                                                                                                                                           -- IncludeIf_RX_Enabled
                RxAudioBit       <= RX_AUDIO_DATA;                                                                                                                                         -- IncludeIf_RX_Enabled
                RxAudioDataValid <= RX_AUDIO_DATA_VALID;                                                                                                                                   -- IncludeIf_RX_Enabled
                If AudioBitCounter = cAudioBitCount Then                                                                                                                                   -- IncludeIf_RX_Enabled
                    AudioBitCounter <= (Others=>'0');                                                                                                                                      -- IncludeIf_RX_Enabled
                    RxAudioEnd <= '1';                                                                                                                                                     -- IncludeIf_RX_Enabled
                Else                                                                                                                                                                       -- IncludeIf_RX_Enabled
                    RxAudioEnd <= '0';                                                                                                                                                     -- IncludeIf_RX_Enabled
                    If RX_AUDIO_DATA_VALID='1' Then                                                                                                                                        -- IncludeIf_RX_Enabled
                        AudioBitCounter <= AudioBitCounter + 1;                                                                                                                            -- IncludeIf_RX_Enabled
                        AudioShiftRegister <= RX_AUDIO_DATA & AudioShiftRegister(23 Downto 1);                                                                                             -- IncludeIf_RX_Enabled
                    End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
                End If;                                                                                                                                                                    -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
                If (RX_VALIDITY_BIT='1' Or  RX_USER_VALID='1' Or RX_STATUS_VALID='1' Or RX_PARITY_BIT_VALID='1') Then                                                                      -- IncludeIf_RX_Enabled
                    DataShiftRegister <= RX_AUDIO_DATA & DataShiftRegister(3 Downto 1);                                                                                                    -- IncludeIf_RX_Enabled
                End If;                                                                                                                                                                    -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
                If FrameStart='1' Then                                                                                                                                                     -- IncludeIf_RX_Enabled
                    If RX_BLOCK_START='1' Then                                                                                                                                             -- IncludeIf_RX_Enabled
                        SubframeStatus <= '1';                                                                                                                                             -- IncludeIf_RX_Enabled
                    Else                                                                                                                                                                   -- IncludeIf_RX_Enabled
                        SubframeStatus <= '0';                                                                                                                                             -- IncludeIf_RX_Enabled
                    End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
                End If;                                                                                                                                                                    -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
                If LatchChannelInfo='1' Then                                                                                                                                               -- IncludeIf_RX_Enabled
                    If RX_CHANNELA_IS_ACTIVE='1' Then                                                                                                                                      -- IncludeIf_RX_Enabled
                        ActiveChannel <= '0';                                                                                                                                              -- IncludeIf_RX_Enabled
                    Else                                                                                                                                                                   -- IncludeIf_RX_Enabled
                        ActiveChannel <= '1';                                                                                                                                              -- IncludeIf_RX_Enabled
                    End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
                End If;                                                                                                                                                                    -- IncludeIf_RX_Enabled
            End If;                                                                                                                                                                        -- IncludeIf_RX_Enabled
        End If;                                                                                                                                                                            -- IncludeIf_RX_Enabled
    End Process;                                                                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    RX_AUDIO_END <= RxAudioEnd;                                                                                                                                                            -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    WriteAudioSample <= '1' When (ParityState = sParity_DataWrite) Else '0';                                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    RX_FIFO_WRITE <= WriteAudioSample And BlockStartAligned;                                                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    RX_FIFO_DATA <= SubframeStatus & ActiveChannel & ParityError & '0' & DataShiftRegister(0) & DataShiftRegister(1) & DataShiftRegister(2) & DataShiftRegister(3) & AudioShiftRegister;   -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    RX_FLAG_PARITY_ERROR <= WriteAudioSample And ParityError;                                                                                                                              -- IncludeIf_RX_Enabled
    RX_FLAG_BLOCK_START  <= WriteAudioSample And SubframeStatus;                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    -- Auxilary Bits - Channel Status and User Data                                                                                                                                        -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    Process(CLK_I)                                                                                                                                                                         -- IncludeIf_RX_Enabled
    Begin                                                                                                                                                                                  -- IncludeIf_RX_Enabled
        If Rising_Edge(CLK_I) Then                                                                                                                                                         -- IncludeIf_RX_Enabled
            If RST_I='1' Then                                                                                                                                                              -- IncludeIf_RX_Enabled
                ChannelAStatusBitsShift   <= (Others=>'0');   -- Channel A                                                                                                                 -- IncludeIf_RX_Enabled
                UserDataABitsShift        <= (Others=>'0');   -- Channel A                                                                                                                 -- IncludeIf_RX_Enabled
                ChannelBStatusBitsShift   <= (Others=>'0');   -- Channel B                                                                                                                 -- IncludeIf_RX_Enabled
                UserDataBBitsShift        <= (Others=>'0');   -- Channel B                                                                                                                 -- IncludeIf_RX_Enabled
                StoreAuxData              <= '0';                                                                                                                                          -- IncludeIf_RX_Enabled
                FrameCounter              <= 0;                                                                                                                                            -- IncludeIf_RX_Enabled
            Else                                                                                                                                                                           -- IncludeIf_RX_Enabled
                If BlockStartAligned = '1' And WriteAudioSample = '1' Then                                                                                                                 -- IncludeIf_RX_Enabled
                    If RX_CHANNELA_IS_ACTIVE='1' Then                                                                                                                                      -- IncludeIf_RX_Enabled
                        ChannelAStatusBitsShift <= DataShiftRegister(2) & ChannelAStatusBitsShift(15 Downto 1);                                                                            -- IncludeIf_RX_Enabled
                        UserDataABitsShift      <= DataShiftRegister(1) & UserDataABitsShift(15 Downto 1);                                                                                 -- IncludeIf_RX_Enabled
                    End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
                    If RX_CHANNELB_IS_ACTIVE='1' Then                                                                                                                                      -- IncludeIf_RX_Enabled
                        ChannelBStatusBitsShift <= DataShiftRegister(2) & ChannelBStatusBitsShift(15 Downto 1);                                                                            -- IncludeIf_RX_Enabled
                        UserDataBBitsShift      <= DataShiftRegister(1) & UserDataBBitsShift(15 Downto 1);                                                                                 -- IncludeIf_RX_Enabled
                        If FrameCounter=15 Then                                                                                                                                            -- IncludeIf_RX_Enabled
                            FrameCounter <= 0;                                                                                                                                             -- IncludeIf_RX_Enabled
                            StoreAuxData <= '1';                                                                                                                                           -- IncludeIf_RX_Enabled
                        Else                                                                                                                                                               -- IncludeIf_RX_Enabled
                            FrameCounter <= FrameCounter + 1;                                                                                                                              -- IncludeIf_RX_Enabled
                        End If;                                                                                                                                                            -- IncludeIf_RX_Enabled
                    End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
                Else                                                                                                                                                                       -- IncludeIf_RX_Enabled
                    StoreAuxData <= '0';                                                                                                                                                   -- IncludeIf_RX_Enabled
                End If;                                                                                                                                                                    -- IncludeIf_RX_Enabled
            End If;                                                                                                                                                                        -- IncludeIf_RX_Enabled
        End If;                                                                                                                                                                            -- IncludeIf_RX_Enabled
    End Process;                                                                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_CHANNELA_STATUS_DATA <= ChannelAStatusBitsShift;                                                                                                                         -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_CHANNELB_STATUS_DATA <= ChannelBStatusBitsShift;                                                                                                                         -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_USER_DATA_A          <= UserDataABitsShift;                                                                                                                              -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_USER_DATA_B          <= UserDataBBitsShift;                                                                                                                              -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_WRITE_DATA           <= StoreAuxData;                                                                                                                                    -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    -- Align first write point to block start-----------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    Process(CLK_I)                                                                                                                                                                         -- IncludeIf_RX_Enabled
    Begin                                                                                                                                                                                  -- IncludeIf_RX_Enabled
        If Rising_Edge(CLK_I) Then                                                                                                                                                         -- IncludeIf_RX_Enabled
            If RST_I='1' Then                                                                                                                                                              -- IncludeIf_RX_Enabled
                BlockStartAligned  <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
                BlockStartShiftReg <= (Others=>'0');                                                                                                                                       -- IncludeIf_RX_Enabled
            Else                                                                                                                                                                           -- IncludeIf_RX_Enabled
                If RX_ENABLE='1' Then                                                                                                                                                      -- IncludeIf_RX_Enabled
                    If BlockStart='1' Then                                                                                                                                                 -- IncludeIf_RX_Enabled
                        BlockStartShiftReg <= BlockStartShiftReg(1 Downto 0) & '1';                                                                                                        -- IncludeIf_RX_Enabled
                    End If;                                                                                                                                                                -- IncludeIf_RX_Enabled
                End If;                                                                                                                                                                    -- IncludeIf_RX_Enabled
                BlockStartAligned <= BlockStartShiftReg(2);                                                                                                                                -- IncludeIf_RX_Enabled
            End If;                                                                                                                                                                        -- IncludeIf_RX_Enabled
        End If;                                                                                                                                                                            -- IncludeIf_RX_Enabled
    End Process;                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    Process(CLK_I)                                                                                                                                                                         -- IncludeIf_RX_Enabled
    Begin                                                                                                                                                                                  -- IncludeIf_RX_Enabled
         If Rising_Edge(CLK_I) Then                                                                                                                                                        -- IncludeIf_RX_Enabled
            If RST_I='1' Then                                                                                                                                                              -- IncludeIf_RX_Enabled
               BlockStartFF        <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
               BlockStartFF1       <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
               FrameStartFF        <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
               FrameStartFF1       <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
               LatchChannelInfoFF  <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
               LatchChannelInfoFF1 <= '0';                                                                                                                                                 -- IncludeIf_RX_Enabled
            Else                                                                                                                                                                           -- IncludeIf_RX_Enabled
                BlockStartFF        <= RX_BLOCK_START;                                                                                                                                     -- IncludeIf_RX_Enabled
                BlockStartFF1       <= BlockStartFF;                                                                                                                                       -- IncludeIf_RX_Enabled
                FrameStartFF        <= RX_FRAME_START;                                                                                                                                     -- IncludeIf_RX_Enabled
                FrameStartFF1       <= FrameStartFF;                                                                                                                                       -- IncludeIf_RX_Enabled
                LatchChannelInfoFF  <= RX_FRAME_START;                                                                                                                                     -- IncludeIf_RX_Enabled
                LatchChannelInfoFF1 <= LatchChannelInfoFF;                                                                                                                                 -- IncludeIf_RX_Enabled
            End If;                                                                                                                                                                        -- IncludeIf_RX_Enabled
         End If;                                                                                                                                                                           -- IncludeIf_RX_Enabled
    End Process;                                                                                                                                                                           -- IncludeIf_RX_Enabled
    BlockStart       <=     BlockStartFF       And Not BlockStartFF1;                                                                                                                      -- IncludeIf_RX_Enabled
    FrameStart       <=     FrameStartFF       And Not FrameStartFF1;                                                                                                                      -- IncludeIf_RX_Enabled
    LatchChannelInfo <= Not LatchChannelInfoFF And     LatchChannelInfoFF1;                                                                                                                -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    -- Trace Parity                                                                                                                                                                        -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    Process(ParityState,                                                                                                                                                                   -- IncludeIf_RX_Enabled
            FrameStart,                                                                                                                                                                    -- IncludeIf_RX_Enabled
            RX_AUDIO_DATA_VALID,                                                                                                                                                           -- IncludeIf_RX_Enabled
            RxAudioEnd,                                                                                                                                                                    -- IncludeIf_RX_Enabled
            RX_VALIDITY_BIT,                                                                                                                                                               -- IncludeIf_RX_Enabled
            RX_USER_VALID,                                                                                                                                                                 -- IncludeIf_RX_Enabled
            RX_STATUS_VALID,                                                                                                                                                               -- IncludeIf_RX_Enabled
            RX_PARITY_BIT_VALID)                                                                                                                                                           -- IncludeIf_RX_Enabled
    Begin                                                                                                                                                                                  -- IncludeIf_RX_Enabled
        ParityState_Next <= ParityState;                                                                                                                                                   -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
        Case ParityState Is                                                                                                                                                                -- IncludeIf_RX_Enabled
            When sParity_Idle =>                                                                                                                                                           -- IncludeIf_RX_Enabled
                 If FrameStart='1' Then                                                                                                                                                    -- IncludeIf_RX_Enabled
                    ParityState_Next <= sParity_Start;                                                                                                                                     -- IncludeIf_RX_Enabled
                 End If;                                                                                                                                                                   -- IncludeIf_RX_Enabled
            When sParity_Start =>                                                                                                                                                          -- IncludeIf_RX_Enabled
                 If RX_AUDIO_DATA_VALID='1' Then                                                                                                                                           -- IncludeIf_RX_Enabled
                    ParityState_Next <= sParity_Audio;                                                                                                                                     -- IncludeIf_RX_Enabled
                 End If;                                                                                                                                                                   -- IncludeIf_RX_Enabled
            When sParity_Audio =>                                                                                                                                                          -- IncludeIf_RX_Enabled
                 If RxAudioEnd='1' Then                                                                                                                                                    -- IncludeIf_RX_Enabled
                    ParityState_Next <= sParity_Valid;                                                                                                                                     -- IncludeIf_RX_Enabled
                 End If;                                                                                                                                                                   -- IncludeIf_RX_Enabled
            When sParity_Valid =>                                                                                                                                                          -- IncludeIf_RX_Enabled
                 If RX_VALIDITY_BIT = '1' Then                                                                                                                                             -- IncludeIf_RX_Enabled
                    ParityState_Next <= sParity_User;                                                                                                                                      -- IncludeIf_RX_Enabled
                 End If;                                                                                                                                                                   -- IncludeIf_RX_Enabled
            When sParity_User  =>                                                                                                                                                          -- IncludeIf_RX_Enabled
                 If RX_USER_VALID = '1' Then                                                                                                                                               -- IncludeIf_RX_Enabled
                    ParityState_Next <= sParity_Status;                                                                                                                                    -- IncludeIf_RX_Enabled
                 End If;                                                                                                                                                                   -- IncludeIf_RX_Enabled
            When sParity_Status =>                                                                                                                                                         -- IncludeIf_RX_Enabled
                 If RX_STATUS_VALID='1' THen                                                                                                                                               -- IncludeIf_RX_Enabled
                    ParityState_Next <= sParity_Done;                                                                                                                                      -- IncludeIf_RX_Enabled
                 End If;                                                                                                                                                                   -- IncludeIf_RX_Enabled
            When sParity_Done =>                                                                                                                                                           -- IncludeIf_RX_Enabled
                 If RX_PARITY_BIT_VALID = '1' Then                                                                                                                                         -- IncludeIf_RX_Enabled
                    ParityState_Next <= sParity_DataWrite;                                                                                                                                 -- IncludeIf_RX_Enabled
                 End If;                                                                                                                                                                   -- IncludeIf_RX_Enabled
            When sParity_DataWrite =>                                                                                                                                                      -- IncludeIf_RX_Enabled
                 ParityState_Next <= sParity_Idle;                                                                                                                                         -- IncludeIf_RX_Enabled
            When Others =>                                                                                                                                                                 -- IncludeIf_RX_Enabled
                 ParityState_Next <= sParity_Idle;                                                                                                                                         -- IncludeIf_RX_Enabled
        End Case;                                                                                                                                                                          -- IncludeIf_RX_Enabled
    End Process;                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
    Process(CLK_I)                                                                                                                                                                         -- IncludeIf_RX_Enabled
    Begin                                                                                                                                                                                  -- IncludeIf_RX_Enabled
        If Rising_Edge(CLK_I) Then                                                                                                                                                         -- IncludeIf_RX_Enabled
            If RST_I='1' Then                                                                                                                                                              -- IncludeIf_RX_Enabled
                ParityState <= sParity_Idle;                                                                                                                                               -- IncludeIf_RX_Enabled
            Else                                                                                                                                                                           -- IncludeIf_RX_Enabled
                ParityState <= ParityState_Next;                                                                                                                                           -- IncludeIf_RX_Enabled
            End If;                                                                                                                                                                        -- IncludeIf_RX_Enabled
        End If;                                                                                                                                                                            -- IncludeIf_RX_Enabled
    End Process;                                                                                                                                                                           -- IncludeIf_RX_Enabled
    -- -------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    Process(CLK_I)                                                                                                                                                                         -- IncludeIf_RX_Enabled
    Begin                                                                                                                                                                                  -- IncludeIf_RX_Enabled
        If Rising_Edge(CLK_I) Then                                                                                                                                                         -- IncludeIf_RX_Enabled
            If RST_I='1' Then                                                                                                                                                              -- IncludeIf_RX_Enabled
                ParityValue <= '0';                                                                                                                                                        -- IncludeIf_RX_Enabled
                ParityError <= '0';                                                                                                                                                        -- IncludeIf_RX_Enabled
            Else                                                                                                                                                                           -- IncludeIf_RX_Enabled
                If AnyParityEvent='1' Then                                                                                                                                                 -- IncludeIf_RX_Enabled
                    Case ParityState Is                                                                                                                                                    -- IncludeIf_RX_Enabled
                        When sParity_Start =>  ParityValue <= RX_AUDIO_DATA;                                                                                                               -- IncludeIf_RX_Enabled
                        When sParity_Audio |                                                                                                                                               -- IncludeIf_RX_Enabled
                             sParity_Valid |                                                                                                                                               -- IncludeIf_RX_Enabled
                             sParity_User  |                                                                                                                                               -- IncludeIf_RX_Enabled
                             sParity_Status => ParityValue <= ParityValue Xor RX_AUDIO_DATA;                                                                                               -- IncludeIf_RX_Enabled
                        When sParity_Done =>                                                                                                                                               -- IncludeIf_RX_Enabled
                            If ParityValue = RX_AUDIO_DATA Then ParityError <= '0';                                                                                                        -- IncludeIf_RX_Enabled
                            Else                                ParityError <= '1';                                                                                                        -- IncludeIf_RX_Enabled
                            End If;                                                                                                                                                        -- IncludeIf_RX_Enabled
                        When Others => Null;                                                                                                                                               -- IncludeIf_RX_Enabled
                    End Case;                                                                                                                                                              -- IncludeIf_RX_Enabled
                End If;                                                                                                                                                                    -- IncludeIf_RX_Enabled
            End If;                                                                                                                                                                        -- IncludeIf_RX_Enabled
        End If;                                                                                                                                                                            -- IncludeIf_RX_Enabled
    End Process;                                                                                                                                                                           -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
    AnyParityEvent <=  RX_AUDIO_DATA_VALID Or  RX_USER_VALID Or  RX_STATUS_VALID Or RX_VALIDITY_BIT;                                                                                       -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
End RTL;                                                                                                                                                                                   -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled

-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
Library IEEE;                                                                                                                                        -- IncludeIf_RX_Enabled
Use     IEEE.Std_Logic_1164.All;                                                                                                                     -- IncludeIf_RX_Enabled
Use     IEEE.Std_Logic_Unsigned.All;                                                                                                                 -- IncludeIf_RX_Enabled
Use     IEEE.Numeric_Std.All;                                                                                                                        -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
Entity ReplaceWith_Designator_DIGITAL_AUDIO_RX_FIFO Is                                                                                               -- IncludeIf_RX_Enabled
   -- ------------------------------------------------------------------------                                                                       -- IncludeIf_RX_Enabled
   Generic (                                                                                                                                         -- IncludeIf_RX_Enabled
       gFifoAddressWidth     : Integer := ReplaceWith_RxFifo_DataCountWidth;                                                             -- IncludeIf_RX_Enabled
       gFifoDepth            : Integer := ReplaceWith_RxFifo_Depth;                                                                                    -- IncludeIf_RX_Enabled
       gFifoAlmostFullValue  : Integer := ReplaceWith_RxFifo_AlmostFullValue;                                                                       -- IncludeIf_RX_Enabled
       gFifoAlmostEmptyValue : Integer := ReplaceWith_RxFifo_AlmostEmptyValue;                                                                     -- IncludeIf_RX_Enabled
       gFifoDataWidth        : Integer := 32                                                                                                         -- IncludeIf_RX_Enabled
   );                                                                                                                                                -- IncludeIf_RX_Enabled
   Port (                                                                                                                                            -- IncludeIf_RX_Enabled
        RD_EMPTY        : Out Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_ALMOST_EMPTY : Out Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_DATA_COUNT   : Out Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
        WR_FULL         : Out Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_ALMOST_FULL  : Out Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_FREE_SLOTS   : Out Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                      -- IncludeIf_RX_Enabled

        WATERMARK       : In  Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
        RD_CLK          : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_RST          : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_EN           : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_DATA         : Out Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                         -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
        WR_CLK          : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_RST          : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_EN           : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_DATA         : In  Std_Logic_Vector(gFifoDataWidth - 1 Downto 0)                                                                          -- IncludeIf_RX_Enabled
   );                                                                                                                                                -- IncludeIf_RX_Enabled
   -- ------------------------------------------------------------------------                                                                       -- IncludeIf_RX_Enabled
End;                                                                                                                                                 -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
Architecture RTL Of ReplaceWith_Designator_DIGITAL_AUDIO_RX_FIFO Is                                                                                  -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
    Component ReplaceWith_Designator_RX_BUFFER Is                                                                                    -- IncludeIf_RX_Enabled
        Port(                                                                                                                                        -- IncludeIf_RX_Enabled
            CLKA  : In  Std_Logic;                                                                                                                   -- IncludeIf_RX_Enabled
            CLKB  : In  Std_Logic;                                                                                                                   -- IncludeIf_RX_Enabled
            WEA   : In  Std_Logic;                                                                                                                   -- IncludeIf_RX_Enabled
            WEB   : In  Std_Logic;                                                                                                                   -- IncludeIf_RX_Enabled
            DINA  : In  Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                               -- IncludeIf_RX_Enabled
            DINB  : In  Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                               -- IncludeIf_RX_Enabled
            DOUTA : Out Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                               -- IncludeIf_RX_Enabled
            DOUTB : Out Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                               -- IncludeIf_RX_Enabled
            ADDRA : In  Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                            -- IncludeIf_RX_Enabled
            ADDRB : In  Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0)                                                                             -- IncludeIf_RX_Enabled
        );                                                                                                                                           -- IncludeIf_RX_Enabled
    End Component;                                                                                                                                   -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    Signal ReadPointer       : Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                     -- IncludeIf_RX_Enabled
    Signal WritePointer      : Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                     -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    Signal FifoFull          : Std_Logic;                                                                                                            -- IncludeIf_RX_Enabled
    Signal FifoEmpty         : Std_Logic;                                                                                                            -- IncludeIf_RX_Enabled
    Signal FifoAlmostFull    : Std_Logic;                                                                                                            -- IncludeIf_RX_Enabled
    Signal FifoAlmostEmpty   : Std_Logic;                                                                                                            -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    Signal FifoDoWrite       : Std_Logic;                                                                                                            -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    Signal FifoWritePointer  : Integer Range 0 To gFifoDepth - 1;                                                                                    -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    Signal Signal_GND        : Std_Logic;                                                                                                            -- IncludeIf_RX_Enabled
    Signal Signal_GND_Bus    : Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                        -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
Begin                                                                                                                                                -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
    RD_EMPTY        <= FifoEmpty;                                                                                                                    -- IncludeIf_RX_Enabled
    RD_ALMOST_EMPTY <= FifoAlmostEmpty;                                                                                                              -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    WR_FULL         <= FifoFull;                                                                                                                     -- IncludeIf_RX_Enabled
    WR_ALMOST_FULL  <= FifoAlmostFull;                                                                                                               -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
    FifoFull               <= '1' When WritePointer + 1 = ReadPointer Else '0';                                                                      -- IncludeIf_RX_Enabled
    FifoEmpty              <= '1' When WritePointer     = ReadPointer Else '0';                                                                      -- IncludeIf_RX_Enabled
    FifoAlmostEmpty        <= '1' When (WritePointer    = ((ReadPointer + WATERMARK))) And FifoFull = '0' Else '0';                       -- IncludeIf_RX_Enabled
    FifoAlmostFull         <= '1' When (((WritePointer + 1 + WATERMARK)) = ReadPointer) And FifoEmpty='0' Else '0';                       -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
    FifoDoWrite <= '1' When (WR_EN='1' And FifoFull='0') Else '0';                                                                                   -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
    process(WritePointer, ReadPointer)                                                                                                               -- IncludeIf_RX_Enabled
    begin                                                                                                                                            -- IncludeIf_RX_Enabled
        if (WritePointer >= ReadPointer) then                                                                                                        -- IncludeIf_RX_Enabled
            WR_FREE_SLOTS <= (((2**gFifoAddressWidth) - 1) - (WritePointer - ReadPointer));                                                          -- IncludeIf_RX_Enabled
        else                                                                                                                                         -- IncludeIf_RX_Enabled
            WR_FREE_SLOTS <= (((2**gFifoAddressWidth) - 1) - ((2**gFifoAddressWidth) - ReadPointer + WritePointer));                                 -- IncludeIf_RX_Enabled
        end if;                                                                                                                                      -- IncludeIf_RX_Enabled
    end process;                                                                                                                                     -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    process(WritePointer, ReadPointer)                                                                                                               -- IncludeIf_RX_Enabled
    begin                                                                                                                                            -- IncludeIf_RX_Enabled
        if (WritePointer >= ReadPointer) then                                                                                                        -- IncludeIf_RX_Enabled
            RD_DATA_COUNT <= (WritePointer-ReadPointer);                                                                                             -- IncludeIf_RX_Enabled
        else                                                                                                                                         -- IncludeIf_RX_Enabled
            RD_DATA_COUNT <= ((2**gFifoAddressWidth)-ReadPointer+WritePointer);                                                                      -- IncludeIf_RX_Enabled
        end if;                                                                                                                                      -- IncludeIf_RX_Enabled
    end process;                                                                                                                                     -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
    Process(WR_CLK)                                                                                                                                  -- IncludeIf_RX_Enabled
    Begin                                                                                                                                            -- IncludeIf_RX_Enabled
         If rising_edge(WR_CLK) Then                                                                                                                 -- IncludeIf_RX_Enabled
             If WR_RST='1' Then                                                                                                                      -- IncludeIf_RX_Enabled
                 WritePointer <= (Others=>'0');                                                                                                      -- IncludeIf_RX_Enabled
             Else                                                                                                                                    -- IncludeIf_RX_Enabled
                 If FifoDoWrite = '1' Then                                                                                                           -- IncludeIf_RX_Enabled
                    WritePointer <= (WritePointer + 1);                                                                                              -- IncludeIf_RX_Enabled
                 End If;                                                                                                                             -- IncludeIf_RX_Enabled
             End If;                                                                                                                                 -- IncludeIf_RX_Enabled
         End If;                                                                                                                                     -- IncludeIf_RX_Enabled
    End Process;                                                                                                                                     -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
    Process(RD_CLK)                                                                                                                                  -- IncludeIf_RX_Enabled
    Begin                                                                                                                                            -- IncludeIf_RX_Enabled
        If rising_edge(RD_CLK) Then                                                                                                                  -- IncludeIf_RX_Enabled
            If RD_RST='1' Then                                                                                                                       -- IncludeIf_RX_Enabled
                ReadPointer <= (Others=>'0');                                                                                                        -- IncludeIf_RX_Enabled
            Else                                                                                                                                     -- IncludeIf_RX_Enabled
                If RD_EN='1' And FifoEmpty='0' Then                                                                                                  -- IncludeIf_RX_Enabled
                    ReadPointer <= (ReadPointer + 1);                                                                                                -- IncludeIf_RX_Enabled
                End If;                                                                                                                              -- IncludeIf_RX_Enabled
            End If;                                                                                                                                  -- IncludeIf_RX_Enabled
        End If;                                                                                                                                      -- IncludeIf_RX_Enabled
    End Process;                                                                                                                                     -- IncludeIf_RX_Enabled
    -- ------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
-- ------------------------------------------------------------------------                                                                          -- IncludeIf_RX_Enabled
    U_ReplaceWith_Designator_RX_BUFFER : ReplaceWith_Designator_RX_BUFFER Port Map (                                                   -- IncludeIf_RX_Enabled
        CLKA   => WR_CLK,                                                                                                                            -- IncludeIf_RX_Enabled
        CLKB   => RD_CLK,                                                                                                                            -- IncludeIf_RX_Enabled
        WEA    => FifoDoWrite,                                                                                                                       -- IncludeIf_RX_Enabled
        WEB    => Signal_GND,                                                                                                                        -- IncludeIf_RX_Enabled
        DINA   => WR_DATA,                                                                                                                           -- IncludeIf_RX_Enabled
        DINB   => Signal_GND_Bus,                                                                                                                    -- IncludeIf_RX_Enabled
        DOUTA  => Open,                                                                                                                              -- IncludeIf_RX_Enabled
        DOUTB  => RD_DATA,                                                                                                                           -- IncludeIf_RX_Enabled
        ADDRA  => WritePointer,                                                                                                                      -- IncludeIf_RX_Enabled
        ADDRB  => ReadPointer                                                                                                                        -- IncludeIf_RX_Enabled
    );                                                                                                                                               -- IncludeIf_RX_Enabled
  -- ------------------------------------------------------------------------                                                                        -- IncludeIf_RX_Enabled
    Signal_GND <= '0';                                                                                                                               -- IncludeIf_RX_Enabled
    Signal_GND_Bus <= (Others=>'0');                                                                                                                 -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
End RTL;                                                                                                                                             -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled


-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
Library IEEE;                                                                                                                                                                          -- IncludeIf_TX_Enabled
Use     IEEE.Std_Logic_1164.All;                                                                                                                                                       -- IncludeIf_TX_Enabled
Use     IEEE.Std_Logic_Unsigned.All;                                                                                                                                                   -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
Entity ReplaceWith_Designator_DIGITAL_AUDIO_TRANSMITTER Is                                                                                                                             -- IncludeIf_TX_Enabled
Generic (                                                                                                                                                                              -- IncludeIf_TX_Enabled
    gTxFifoDataCountWidht : Integer := ReplaceWith_TxFifo_FreeSlotsWidth                                                                                                                                              -- IncludeIf_TX_Enabled
);                                                                                                                                                                                     -- IncludeIf_TX_Enabled
Port (                                                                                                                                                                                 -- IncludeIf_TX_Enabled
    -- Transmitter control                                                                                                                                                             -- IncludeIf_TX_Enabled
    TX_RST             : In  Std_Logic;                                                                                                                                                -- IncludeIf_TX_Enabled
    TX_ENABLE          : In  Std_Logic;                                                                                                                                                -- IncludeIf_TX_Enabled
    CLK_BASE           : In  Std_Logic;  -- Base Audio Clock. multiple of bit rate                                                                                                     -- IncludeIf_TX_Enabled
    CLK_BASE_EN        : In  Std_Logic;  -- Prescaled Audio Clock Enable.                                                                                                              -- IncludeIf_TX_Enabled
    TX_FRAME_ENABLE    : In  Std_Logic;  -- Enable Hardware Framing                                                                                                                    -- IncludeIf_TX_Enabled
    TX_PARITY_ENABLE   : In  Std_Logic;  -- Enable Hardware Parity Generation                                                                                                          -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- Data Buffer                                                                                                                                                                     -- IncludeIf_TX_Enabled
    TX_FIFO_DATA       : In  Std_Logic_Vector(31 Downto 0);                                                                                                                            -- IncludeIf_TX_Enabled
    TX_FIFO_RD         : Out Std_Logic;                                                                                                                                                -- IncludeIf_TX_Enabled
    TX_FIFO_EMPTY      : In  Std_Logic;                                                                                                                                                -- IncludeIf_TX_Enabled
    TX_FIFO_DATA_COUNT : In  Std_Logic_Vector(gTxFifoDataCountWidht - 1 Downto 0);                                                                                                     -- IncludeIf_TX_Enabled

    -- Auxilary Buffers
    TX_AUX_CHANNEL_DATA      : In  Std_Logic_Vector(31 Downto 0);                                                                                                                      -- IncludeIf_TX_Enabled
    TX_AUX_CHANNEL_DATA_READ : Out Std_Logic;                                                                                                                                          -- IncludeIf_TX_Enabled
    TX_AUX_USER_DATA         : In  Std_Logic_Vector(31 Downto 0);                                                                                                                      -- IncludeIf_TX_Enabled
    TX_AUX_USER_DATA_READ    : Out Std_Logic;                                                                                                                                          -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_ENABLE     : In  Std_Logic;                                                                                                                                          -- IncludeIf_TX_Enabled
    -- Bi-Phase output                                                                                                                                                                 -- IncludeIf_TX_Enabled
    DIGITAL_AUDIO_OUT        : Out Std_Logic                                                                                                                                           -- IncludeIf_TX_Enabled
);                                                                                                                                                                                     -- IncludeIf_TX_Enabled
End;                                                                                                                                                                                   -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
Architecture RTL Of ReplaceWith_Designator_DIGITAL_AUDIO_TRANSMITTER Is                                                                                                                -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Type TBlockState Is (sBlockIdle,                                                                                                                                                   -- IncludeIf_TX_Enabled
                         sBlockStart,                                                                                                                                                  -- IncludeIf_TX_Enabled
                         sBlockFrameLeft,                                                                                                                                              -- IncludeIf_TX_Enabled
                         sBlockFrameRight);                                                                                                                                            -- IncludeIf_TX_Enabled
    Type TFrameState Is (sFrameIdle,                                                                                                                                                   -- IncludeIf_TX_Enabled
                         sFramePreamble,                                                                                                                                               -- IncludeIf_TX_Enabled
                         sFrameAudio,                                                                                                                                                  -- IncludeIf_TX_Enabled
                         sFrameValidity,                                                                                                                                               -- IncludeIf_TX_Enabled
                         sFrameUserData,                                                                                                                                               -- IncludeIf_TX_Enabled
                         sFrameChannelStatus,                                                                                                                                          -- IncludeIf_TX_Enabled
                         sFrameParity);                                                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- Preambles that mark start of block or frame.                                                                                                                                    -- IncludeIf_TX_Enabled
    -- Bit reversed, no bi-phase encoding!                    -- reverse     -- normal                                                                                                 -- IncludeIf_TX_Enabled
    Constant cPREAMBLE_BLOCK_0 : Std_Logic_Vector(7 Downto 0) := "00010111"; -- 11101000                                                                                               -- IncludeIf_TX_Enabled
    Constant cPREAMBLE_BLOCK_1 : Std_Logic_Vector(7 Downto 0) := "11101000"; -- 00010111                                                                                               -- IncludeIf_TX_Enabled
    Constant cPREAMBLE_CHA_0   : Std_Logic_Vector(7 Downto 0) := "01000111"; -- 11100010                                                                                               -- IncludeIf_TX_Enabled
    Constant cPREAMBLE_CHA_1   : Std_Logic_Vector(7 Downto 0) := "10111000"; -- 00011101                                                                                               -- IncludeIf_TX_Enabled
    Constant cPREAMBLE_CHB_0   : Std_Logic_Vector(7 Downto 0) := "00100111"; -- 11100100                                                                                               -- IncludeIf_TX_Enabled
    Constant cPREAMBLE_CHB_1   : Std_Logic_Vector(7 Downto 0) := "11011000"; -- 00011011                                                                                               -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Constant cPreambleStart : Integer := 7;                                                                                                                                            -- IncludeIf_TX_Enabled
    Constant cPreambleEnd   : Integer := 0;                                                                                                                                            -- IncludeIf_TX_Enabled
    Constant cAudioDataMsb  : Integer := 31;                                                                                                                                           -- IncludeIf_TX_Enabled
    Constant cAudioDataLsb  : Integer := 8;                                                                                                                                            -- IncludeIf_TX_Enabled
    Constant cValidityBit   : Integer := 32;                                                                                                                                           -- IncludeIf_TX_Enabled
    Constant cUserData      : Integer := 33;                                                                                                                                           -- IncludeIf_TX_Enabled
    Constant cChannelStatus : Integer := 34;                                                                                                                                           -- IncludeIf_TX_Enabled
    Constant cParityBit     : Integer := 35;                                                                                                                                           -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Constant cFrameData_DV  : Integer := 27;                                                                                                                                           -- IncludeIf_TX_Enabled
    Constant cFrameData_UD  : Integer := 26;                                                                                                                                           -- IncludeIf_TX_Enabled
    Constant cFrameData_CS  : Integer := 25;                                                                                                                                           -- IncludeIf_TX_Enabled
    Constant cFrameData_P   : Integer := 24;                                                                                                                                           -- IncludeIf_TX_Enabled
    Constant cFrameData_Ch  : Integer := 30;                                                                                                                                           -- IncludeIf_TX_Enabled
    Constant cFrameData_B   : Integer := 31;                                                                                                                                           -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Constant cFrameCount   : Std_Logic_Vector(7 Downto 0) := x"C0";                                                                                                                    -- IncludeIf_TX_Enabled
    Constant cFrameCount_8 : Std_Logic_Vector(7 Downto 0) := x"08";                                                                                                                    -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal BlockState       : TBlockState;                                                                                                                                             -- IncludeIf_TX_Enabled
    Signal BlockState_Next  : TBlockState;                                                                                                                                             -- IncludeIf_TX_Enabled
    Signal FrameState       : TFrameState;                                                                                                                                             -- IncludeIf_TX_Enabled
    Signal FrameState_Next  : TFrameState;                                                                                                                                             -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal ChannelLeftFrame         : Std_Logic_Vector(35 Downto 0);                                                                                                                   -- IncludeIf_TX_Enabled
    Signal ChannelRightFrame        : Std_Logic_Vector(35 Downto 0);                                                                                                                   -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDone                : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal NextBlock                : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameStart               : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal ChannelData              : Std_Logic_Vector(31 Downto 0);                                                                                                                   -- IncludeIf_TX_Enabled
    Signal ChannelLeftValidityBit   : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal ChannelLeftUserDataBit   : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal ChannelLeftChannelStatus : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal ChannelLeftParityBit     : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal GetLeftChannel           : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal BiPhaseBitCounter        : Std_Logic_Vector(7 Downto 0);                                                                                                                    -- IncludeIf_TX_Enabled
    Signal BiPhaseOutputEnabled     : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal BiPhaseEncode            : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDataLoadBlock       : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDataLoadRight       : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDataLoadLeft        : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDataLoadBlock_FF0   : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDataLoadBlock_FF1   : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDataLoadLeft_FF0    : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDataLoadLeft_FF1    : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDataLoadRight_FF0   : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameDataLoadRight_FF1   : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal DoLoadBlock              : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal DoLoadLeft               : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal DoLoadRight              : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal ReadFifoData             : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal CurrentFrame             : Std_Logic_Vector(35 Downto 0);                                                                                                                   -- IncludeIf_TX_Enabled
    Signal BitCounter               : Std_Logic_Vector( 7 Downto 0);                                                                                                                   -- IncludeIf_TX_Enabled
    Signal BiPhaseCounter           : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal BiPhaseShiftReg          : Std_Logic_Vector(27 Downto 0);                                                                                                                   -- IncludeIf_TX_Enabled
    Signal Output                   : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal FrameCounter             : Std_Logic_Vector( 7 Downto 0);                                                                                                                   -- IncludeIf_TX_Enabled
    Signal CurrentPreamble          : Std_Logic_Vector( 7 Downto 0);                                                                                                                   -- IncludeIf_TX_Enabled
    Signal PreambleShiftReg         : Std_Logic_Vector( 6 Downto 0);                                                                                                                   -- IncludeIf_TX_Enabled
    Signal DoFifoRead               : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal SkippedLeft              : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal SkippedRight             : Std_Logic;                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal RepeatedSamples          : Std_Logic_Vector(7 Downto 0);                                                                                                                    -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal PreambleNotFramed        : Std_Logic_Vector(7 Downto 0);                                                                                                                    -- IncludeIf_TX_Enabled
    Signal PreambleFramed           : Std_Logic_Vector(7 Downto 0);                                                                                                                    -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Signal GetNewSubFrame         : Std_Logic;                                                                                                                                         -- IncludeIf_TX_Enabled
    Signal GetNewDataFF           : Std_Logic;                                                                                                                                         -- IncludeIf_TX_Enabled
    Signal FrameStartFramed       : Std_Logic;                                                                                                                                         -- IncludeIf_TX_Enabled
    Signal UserChannelData        : Std_Logic;                                                                                                                                         -- IncludeIf_TX_Enabled
    Signal UserChannelStatus      : Std_Logic;                                                                                                                                         -- IncludeIf_TX_Enabled
    Signal UserChannelDataLeft    : Std_Logic_Vector(15 Downto 0);                                                                                                                     -- IncludeIf_TX_Enabled
    Signal UserChannelDataRight   : Std_Logic_Vector(15 Downto 0);                                                                                                                     -- IncludeIf_TX_Enabled
    Signal UserChannelStatusLeft  : Std_Logic_Vector(15 Downto 0);                                                                                                                     -- IncludeIf_TX_Enabled
    Signal UserChannelStatusRight : Std_Logic_Vector(15 Downto 0);                                                                                                                     -- IncludeIf_TX_Enabled
    Signal UserBit_CS_Left        : Std_Logic;                                                                                                                                         -- IncludeIf_TX_Enabled
    Signal UserBit_CS_Right       : Std_Logic;                                                                                                                                         -- IncludeIf_TX_Enabled
    Signal UserBit_CD_Left        : Std_Logic;                                                                                                                                         -- IncludeIf_TX_Enabled
    Signal UserBit_CD_Right       : Std_Logic;                                                                                                                                         -- IncludeIf_TX_Enabled
    Signal UserBitCounter         : Std_Logic_Vector(3 Downto 0);                                                                                                                      -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    Function GetParityBit(AAudioData     : Std_Logic_Vector;                                                                                                                           -- IncludeIf_TX_Enabled
                          AValidityBit   : Std_Logic;                                                                                                                                  -- IncludeIf_TX_Enabled
                          AUserData      : Std_Logic;                                                                                                                                  -- IncludeIf_TX_Enabled
                          AChannelStatus : Std_Logic) Return Std_Logic Is                                                                                                              -- IncludeIf_TX_Enabled
         Variable ParityVar : Std_Logic;                                                                                                                                               -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        ParityVar := AChannelStatus;                                                                                                                                                   -- IncludeIf_TX_Enabled
        ParityVar := ParityVar Xor AUserData;                                                                                                                                          -- IncludeIf_TX_Enabled
        ParityVar := ParityVar Xor AValidityBit;                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
        For I In AAudioData'Range Loop                                                                                                                                                 -- IncludeIf_TX_Enabled
            ParityVar := ParityVar Xor AAudioData(I);                                                                                                                                  -- IncludeIf_TX_Enabled
        End Loop;                                                                                                                                                                      -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
        Return ParityVar;                                                                                                                                                              -- IncludeIf_TX_Enabled
    End Function;                                                                                                                                                                      -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
Begin                                                                                                                                                                                  -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    -- SPDIF Block Controller                                                                                                                                                          -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    Process(BlockState,                                                                                                                                                                -- IncludeIf_TX_Enabled
            TX_ENABLE,                                                                                                                                                                 -- IncludeIf_TX_Enabled
            TX_FRAME_ENABLE,                                                                                                                                                           -- IncludeIf_TX_Enabled
            FrameDone,                                                                                                                                                                 -- IncludeIf_TX_Enabled
            NextBlock)                                                                                                                                                                 -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        BlockState_Next <= BlockState;                                                                                                                                                 -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
        FrameDataLoadBlock <= '0';                                                                                                                                                     -- IncludeIf_TX_Enabled
        FrameDataLoadRight <= '0';                                                                                                                                                     -- IncludeIf_TX_Enabled
        FrameDataLoadLeft  <= '0';                                                                                                                                                     -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
        Case BlockState Is                                                                                                                                                             -- IncludeIf_TX_Enabled
             When sBlockIdle =>                                                                                                                                                        -- IncludeIf_TX_Enabled
                  If TX_ENABLE = '1' And TX_FRAME_ENABLE='1' Then                                                                                                                      -- IncludeIf_TX_Enabled
                    BlockState_Next    <= sBlockStart;                                                                                                                                 -- IncludeIf_TX_Enabled
                    FrameDataLoadBlock <= '1';                                                                                                                                         -- IncludeIf_TX_Enabled
                  End If;                                                                                                                                                              -- IncludeIf_TX_Enabled
             When sBlockStart =>                                                                                                                                                       -- IncludeIf_TX_Enabled
                  If FrameDone='1' Then                                                                                                                                                -- IncludeIf_TX_Enabled
                    BlockState_Next    <= sBlockFrameRight;                                                                                                                            -- IncludeIf_TX_Enabled
                    FrameDataLoadRight <= '1';                                                                                                                                         -- IncludeIf_TX_Enabled
                  End If;                                                                                                                                                              -- IncludeIf_TX_Enabled
             When sBlockFrameLeft =>                                                                                                                                                   -- IncludeIf_TX_Enabled
                  If FrameDone='1' Then                                                                                                                                                -- IncludeIf_TX_Enabled
                    BlockState_Next    <= sBlockFrameRight;                                                                                                                            -- IncludeIf_TX_Enabled
                    FrameDataLoadRight <= '1';                                                                                                                                         -- IncludeIf_TX_Enabled
                  End If;                                                                                                                                                              -- IncludeIf_TX_Enabled
             When sBlockFrameRight =>                                               -- RAF: add proper 192-bit counters                                                                -- IncludeIf_TX_Enabled
                  If FrameDone='1' Then                                                                                                                                                -- IncludeIf_TX_Enabled
                      If NextBlock='1' Then                                                                                                                                            -- IncludeIf_TX_Enabled
                          BlockState_Next    <= sBlockStart;                                                                                                                           -- IncludeIf_TX_Enabled
                          FrameDataLoadBlock <= '1';                                                                                                                                   -- IncludeIf_TX_Enabled
                      Else                                                                                                                                                             -- IncludeIf_TX_Enabled
                          BlockState_Next   <= sBlockFrameLeft;                                                                                                                        -- IncludeIf_TX_Enabled
                          FrameDataLoadLeft <= '1';                                                                                                                                    -- IncludeIf_TX_Enabled
                      End If;                                                                                                                                                          -- IncludeIf_TX_Enabled
                  End If;                                                                                                                                                              -- IncludeIf_TX_Enabled
             When Others =>                                                                                                                                                            -- IncludeIf_TX_Enabled
                  BlockState_Next <= sBlockIdle;                                                                                                                                       -- IncludeIf_TX_Enabled
        End Case;                                                                                                                                                                      -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    DoFifoRead <= DoLoadBlock Or DoLoadLeft Or DoLoadRight;                                                                                                                            -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    Process(CLK_BASE)                                                                                                                                                                  -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        If Rising_Edge(CLK_BASE) Then                                                                                                                                                  -- IncludeIf_TX_Enabled
            If TX_RST='1' Then                                                                                                                                                         -- IncludeIf_TX_Enabled
                FrameDataLoadBlock_FF0 <= '0';                                                                                                                                         -- IncludeIf_TX_Enabled
                FrameDataLoadBlock_FF1 <= '0';                                                                                                                                         -- IncludeIf_TX_Enabled
                FrameDataLoadLeft_FF0  <= '0';                                                                                                                                         -- IncludeIf_TX_Enabled
                FrameDataLoadLeft_FF1  <= '0';                                                                                                                                         -- IncludeIf_TX_Enabled
                FrameDataLoadRight_FF0 <= '0';                                                                                                                                         -- IncludeIf_TX_Enabled
                FrameDataLoadRight_FF1 <= '0';                                                                                                                                         -- IncludeIf_TX_Enabled
                ReadFifoData           <= '0';                                                                                                                                         -- IncludeIf_TX_Enabled
                SkippedLeft <= '0';                                                                                                                                                    -- IncludeIf_TX_Enabled
                SkippedRight <= '0';                                                                                                                                                   -- IncludeIf_TX_Enabled
            Else                                                                                                                                                                       -- IncludeIf_TX_Enabled
                FrameDataLoadBlock_FF0 <= FrameDataLoadBlock;                                                                                                                          -- IncludeIf_TX_Enabled
                FrameDataLoadBlock_FF1 <= FrameDataLoadBlock_FF0;                                                                                                                      -- IncludeIf_TX_Enabled
                FrameDataLoadLeft_FF0  <= FrameDataLoadLeft;                                                                                                                           -- IncludeIf_TX_Enabled
                FrameDataLoadLeft_FF1  <= FrameDataLoadLeft_FF0;                                                                                                                       -- IncludeIf_TX_Enabled
                FrameDataLoadRight_FF0 <= FrameDataLoadRight;                                                                                                                          -- IncludeIf_TX_Enabled
                FrameDataLoadRight_FF1 <= FrameDataLoadRight_FF0;                                                                                                                      -- IncludeIf_TX_Enabled
            End If;                                                                                                                                                                    -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
    DoLoadBlock <= FrameDataLoadBlock_FF0 And Not FrameDataLoadBlock_FF1;                                                                                                              -- IncludeIf_TX_Enabled
    DoLoadLeft  <= FrameDataLoadLeft_FF0  And Not FrameDataLoadLeft_FF1;                                                                                                               -- IncludeIf_TX_Enabled
    DoLoadRight <= FrameDataLoadRight_FF0 And Not FrameDataLoadRight_FF1;                                                                                                              -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    FrameStartFramed  <= FrameDataLoadBlock Or FrameDataLoadLeft Or FrameDataLoadRight;                                                                                                -- IncludeIf_TX_Enabled
    FrameStart <= FrameStartFramed When (TX_ENABLE='1' And TX_FRAME_ENABLE='1') Else                                                                                                   -- IncludeIf_TX_Enabled
                  '1'              When (TX_ENABLE='1' ANd TX_FRAME_ENABLE='0') Else                                                                                                   -- IncludeIf_TX_Enabled
                  '0';                                                                                                                                                                 -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Process(CLK_BASE)                                                                                                                                                                  -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        If Rising_Edge(CLK_BASE) Then                                                                                                                                                  -- IncludeIf_TX_Enabled
            If TX_RST='1' Then                                                                                                                                                         -- IncludeIf_TX_Enabled
                FrameCounter <= (Others=>'0');                                                                                                                                         -- IncludeIf_TX_Enabled
                NextBlock <= '0';                                                                                                                                                      -- IncludeIf_TX_Enabled
            Else                                                                                                                                                                       -- IncludeIf_TX_Enabled
                If FrameDataLoadBlock ='1'  Then                                                                                                                                       -- IncludeIf_TX_Enabled
                    FrameCounter <= (Others=>'0');                                                                                                                                     -- IncludeIf_TX_Enabled
                Else                                                                                                                                                                   -- IncludeIf_TX_Enabled
                    --NextBlock <= '0';                                                                                                                                                -- IncludeIf_TX_Enabled
                    If DoLoadRight='1' Then                                                                                                                                            -- IncludeIf_TX_Enabled
                        FrameCounter <= FrameCounter + 1;                                                                                                                              -- IncludeIf_TX_Enabled
                    Else                                                                                                                                                               -- IncludeIf_TX_Enabled
                        NextBlock <= '0';                                                                                                                                              -- IncludeIf_TX_Enabled
                    End If;                                                                                                                                                            -- IncludeIf_TX_Enabled
                    If FrameCounter = cFrameCount Then -- 191                                                                                                                          -- IncludeIf_TX_Enabled
                        NextBlock <= '1';                                                                                                                                              -- IncludeIf_TX_Enabled
                    End If;                                                                                                                                                            -- IncludeIf_TX_Enabled
                End If;                                                                                                                                                                -- IncludeIf_TX_Enabled
            End If;                                                                                                                                                                    -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    -- Synchronous part for all state machines, trigered on bit time.                                                                                                                  -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    Process(CLK_BASE)                                                                                                                                                                  -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        If Rising_Edge(CLK_BASE) Then                                                                                                                                                  -- IncludeIf_TX_Enabled
            If TX_RST='1' Then                                                                                                                                                         -- IncludeIf_TX_Enabled
                BlockState  <= sBlockIdle;                                                                                                                                             -- IncludeIf_TX_Enabled
            Else                                                                                                                                                                       -- IncludeIf_TX_Enabled
                If CLK_BASE_EN='1' Then                                                                                                                                                -- IncludeIf_TX_Enabled
                    BlockState  <= BlockState_Next;                                                                                                                                    -- IncludeIf_TX_Enabled
                End If;                                                                                                                                                                -- IncludeIf_TX_Enabled
            End If;                                                                                                                                                                    -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    TX_AUX_CHANNEL_DATA_READ <= '1' When (((DoLoadLeft='1') Or (DoLoadBlock='1')) And (UserBitCounter=x"F") And (TX_AUX_BUFFER_ENABLE='1')) Else '0';                                                         -- IncludeIf_TX_Enabled
    TX_AUX_USER_DATA_READ    <= '1' When (((DoLoadLeft='1') Or (DoLoadBlock='1')) And (UserBitCounter=x"F") And (TX_AUX_BUFFER_ENABLE='1')) Else '0';                                                         -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    UserChannelDataLeft    <= TX_AUX_USER_DATA(31 Downto 16);                                                                                                                       -- IncludeIf_TX_Enabled
    UserChannelDataRight   <= TX_AUX_USER_DATA(15 Downto  0);                                                                                                                       -- IncludeIf_TX_Enabled
    UserChannelStatusLeft  <= TX_AUX_CHANNEL_DATA(31 Downto 16);                                                                                                                          -- IncludeIf_TX_Enabled
    UserChannelStatusRight <= TX_AUX_CHANNEL_DATA(15 Downto  0);                                                                                                                          -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- Handle user provided channel status and user data bits                                                                                                                          -- IncludeIf_TX_Enabled
    Process(CLK_BASE)                                                                                                                                                                  -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        If Rising_Edge(CLK_BASE) Then                                                                                                                                                  -- IncludeIf_TX_Enabled
            If TX_RST='1' Then                                                                                                                                                         -- IncludeIf_TX_Enabled
                UserBitCounter      <= (Others=>'0');                                                                                                                                  -- IncludeIf_TX_Enabled
            Else                                                                                                                                                                       -- IncludeIf_TX_Enabled
                If CLK_BASE_EN='1' Then                                                                                                                                                -- IncludeIf_TX_Enabled
                    If TX_AUX_BUFFER_ENABLE='1' Then                                                                                                                                   -- IncludeIf_TX_Enabled
                        If FrameDataLoadBlock='1' Then                                                                                                                                 -- IncludeIf_TX_Enabled
                            UserBitCounter <= (Others=>'0');                                                                                                                           -- IncludeIf_TX_Enabled
                        Else                                                                                                                                                           -- IncludeIf_TX_Enabled
                            If FrameDataLoadLeft='1' Then                                                                                                                              -- IncludeIf_TX_Enabled
                                UserBitCounter <= UserBitCounter + 1;                                                                                                                  -- IncludeIf_TX_Enabled
                            End If;                                                                                                                                                    -- IncludeIf_TX_Enabled
                        End If;                                                                                                                                                        -- IncludeIf_TX_Enabled
                    End If;                                                                                                                                                            -- IncludeIf_TX_Enabled
                End If;                                                                                                                                                                -- IncludeIf_TX_Enabled
            End If;                                                                                                                                                                    -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Process(UserBitCounter,                                                                                                                                                            -- IncludeIf_TX_Enabled
            UserChannelStatusLeft,                                                                                                                                                     -- IncludeIf_TX_Enabled
            UserChannelStatusRight,                                                                                                                                                    -- IncludeIf_TX_Enabled
            UserChannelDataLeft,                                                                                                                                                       -- IncludeIf_TX_Enabled
            UserChannelDataRight)                                                                                                                                                      -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        Case UserBitCounter Is                                                                                                                                                         -- IncludeIf_TX_Enabled
            When x"0" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(0);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(0);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(0);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(0);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"1" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(1);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(1);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(1);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(1);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"2" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(2);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(2);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(2);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(2);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"3" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(3);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(3);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(3);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(3);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"4" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(4);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(4);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(4);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(4);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"5" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(5);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(5);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(5);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(5);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"6" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(6);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(6);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(6);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(6);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"7" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(7);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(7);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(7);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(7);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"8" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(8);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(8);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(8);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(8);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"9" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(9);                                                                                                                          -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(9);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(9);                                                                                                                            -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(9);                                                                                                                           -- IncludeIf_TX_Enabled
            When x"A" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(10);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(10);                                                                                                                        -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(10);                                                                                                                           -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(10);                                                                                                                          -- IncludeIf_TX_Enabled
            When x"B" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(11);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(11);                                                                                                                        -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(11);                                                                                                                           -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(11);                                                                                                                          -- IncludeIf_TX_Enabled
            When x"C" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(12);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(12);                                                                                                                        -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(12);                                                                                                                           -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(12);                                                                                                                          -- IncludeIf_TX_Enabled
            When x"D" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(13);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(13);                                                                                                                        -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(13);                                                                                                                           -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(13);                                                                                                                          -- IncludeIf_TX_Enabled
            When x"E" =>                                                                                                                                                               -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(14);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(14);                                                                                                                        -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(14);                                                                                                                           -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(14);                                                                                                                          -- IncludeIf_TX_Enabled
            When Others => --x"F"                                                                                                                                                      -- IncludeIf_TX_Enabled
                UserBit_CS_Left  <= UserChannelStatusLeft(15);                                                                                                                         -- IncludeIf_TX_Enabled
                UserBit_CS_Right <= UserChannelStatusRight(15);                                                                                                                        -- IncludeIf_TX_Enabled
                UserBit_CD_Left  <= UserChannelDataLeft(15);                                                                                                                           -- IncludeIf_TX_Enabled
                UserBit_CD_Right <= UserChannelDataRight(15);                                                                                                                          -- IncludeIf_TX_Enabled
        End Case;                                                                                                                                                                      -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    Process(BlockState,                                                                                                                                                                -- IncludeIf_TX_Enabled
            UserBit_CD_Left,                                                                                                                                                           -- IncludeIf_TX_Enabled
            UserBit_CD_Right,                                                                                                                                                         -- IncludeIf_TX_Enabled
            UserBit_CS_Left,                                                                                                                                                           -- IncludeIf_TX_Enabled
            UserBit_CS_Right)                                                                                                                                                          -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        UserChannelData   <= UserBit_CD_Left;                                                                                                                                          -- IncludeIf_TX_Enabled
        UserChannelStatus <= UserBit_CS_Left;                                                                                                                                          -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
        If BlockState=sBlockFrameRight Then                                                                                                                                            -- IncludeIf_TX_Enabled
            UserChannelData   <= UserBit_CD_Right;                                                                                                                                     -- IncludeIf_TX_Enabled
            UserChannelStatus <= UserBit_CS_Right;                                                                                                                                     -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- Fetch current frame data                                                                                                                                                        -- IncludeIf_TX_Enabled
    Process(TX_AUX_BUFFER_ENABLE,                                                                                                                                                      -- IncludeIf_TX_Enabled
            TX_FIFO_DATA,                                                                                                                                                              -- IncludeIf_TX_Enabled
            UserChannelData,                                                                                                                                                           -- IncludeIf_TX_Enabled
            UserChannelStatus)                                                                                                                                                         -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        ChannelData <= TX_FIFO_DATA;                                                                                                                                                   -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
        -- Use User provided user data and channel status bits                                                                                                                         -- IncludeIf_TX_Enabled
        If TX_AUX_BUFFER_ENABLE='1' Then                                                                                                                                               -- IncludeIf_TX_Enabled
            ChannelData(cFrameData_UD) <= UserChannelData;                                                                                                                             -- IncludeIf_TX_Enabled
            ChannelData(cFrameData_CS) <= UserChannelStatus;                                                                                                                           -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled

    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    Process(Output, BlockState, FrameCounter)                                                                                                                                          -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        If Output='0' Then                                                                                                                                                             -- IncludeIf_TX_Enabled
            If BlockState=sBlockFrameRight Then                                                                                                                                        -- IncludeIf_TX_Enabled
                If FrameCounter=x"00"  Then                                                                                                                                            -- IncludeIf_TX_Enabled
                    PreambleFramed <= cPREAMBLE_BLOCK_0;                                                                                                                               -- IncludeIf_TX_Enabled
                Else                                                                                                                                                                   -- IncludeIf_TX_Enabled
                    PreambleFramed <= cPREAMBLE_CHA_0;                                                                                                                                 -- IncludeIf_TX_Enabled
                End If;                                                                                                                                                                -- IncludeIf_TX_Enabled
            Else                                                                                                                                                                       -- IncludeIf_TX_Enabled
                PreambleFramed <= cPREAMBLE_CHB_0;                                                                                                                                     -- IncludeIf_TX_Enabled
            End If;                                                                                                                                                                    -- IncludeIf_TX_Enabled
        Else                                                                                                                                                                           -- IncludeIf_TX_Enabled
            If BlockState=sBlockFrameRight Then                                                                                                                                        -- IncludeIf_TX_Enabled
                If FrameCounter=x"00"  Then                                                                                                                                            -- IncludeIf_TX_Enabled
                    PreambleFramed <= cPREAMBLE_BLOCK_1;                                                                                                                               -- IncludeIf_TX_Enabled
                Else                                                                                                                                                                   -- IncludeIf_TX_Enabled
                    PreambleFramed <= cPREAMBLE_CHA_1;                                                                                                                                 -- IncludeIf_TX_Enabled
                End If;                                                                                                                                                                -- IncludeIf_TX_Enabled
            Else                                                                                                                                                                       -- IncludeIf_TX_Enabled
                PreambleFramed <= cPREAMBLE_CHB_1;                                                                                                                                     -- IncludeIf_TX_Enabled
            End If;                                                                                                                                                                    -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    Process(TX_FRAME_ENABLE, Output, ChannelData, CurrentPreamble)                                                                                                                     -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
        If TX_FRAME_ENABLE='1' Then                                                                                                                                                    -- IncludeIf_TX_Enabled
            PreambleNotFramed <= (Others=>'0');                                                                                                                                        -- IncludeIf_TX_Enabled
        Else -- Framing from software                                                                                                                                                  -- IncludeIf_TX_Enabled
            If Output='0' Then                                                                                                                                                         -- IncludeIf_TX_Enabled
                   If ChannelData(cFrameData_B)  = '1' Then PreambleNotFramed <= cPREAMBLE_BLOCK_0;                                                                                    -- IncludeIf_TX_Enabled
                ElsIf ChannelData(cFrameData_Ch) = '1' Then PreambleNotFramed <= cPREAMBLE_CHB_0;                                                                                      -- IncludeIf_TX_Enabled
                Else                                        PreambleNotFramed <= cPREAMBLE_CHA_0;                                                                                      -- IncludeIf_TX_Enabled
                End If;                                                                                                                                                                -- IncludeIf_TX_Enabled
            Else                                                                                                                                                                       -- IncludeIf_TX_Enabled
                   If ChannelData(cFrameData_B)  = '1' Then PreambleNotFramed <= cPREAMBLE_BLOCK_1;                                                                                    -- IncludeIf_TX_Enabled
                ElsIf ChannelData(cFrameData_Ch) = '1' Then PreambleNotFramed <= cPREAMBLE_CHB_1;                                                                                      -- IncludeIf_TX_Enabled
                Else                                        PreambleNotFramed <= cPREAMBLE_CHA_1;                                                                                      -- IncludeIf_TX_Enabled
                End If;                                                                                                                                                                -- IncludeIf_TX_Enabled
            End If;                                                                                                                                                                    -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -----------------------------                                                                                                                                                   -- IncludeIf_TX_Enabled
    Process(TX_FRAME_ENABLE, TX_PARITY_ENABLE, PreambleFramed, PreambleNotFramed, ChannelData)                                                                                         -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        CurrentFrame    <=  ChannelData(cFrameData_P) & ChannelData(cFrameData_CS) & ChannelData(cFrameData_UD) & ChannelData(cFrameData_DV) & ChannelData(23 Downto 0) & x"00";       -- IncludeIf_TX_Enabled
        If TX_PARITY_ENABLE = '1' Then                                                                                                                                                 -- IncludeIf_TX_Enabled
            CurrentFrame(35) <= GetParityBit(ChannelData(23 Downto 0), ChannelData(cFrameData_DV), ChannelData(cFrameData_UD), ChannelData(cFrameData_CS));                            -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
        If TX_FRAME_ENABLE='1' Then                                                                                                                                                    -- IncludeIf_TX_Enabled
            CurrentPreamble <= PreambleFramed;                                                                                                                                         -- IncludeIf_TX_Enabled
        Else                                                                                                                                                                           -- IncludeIf_TX_Enabled
            CurrentPreamble <= PreambleNotFramed;                                                                                                                                      -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
    TX_FIFO_RD     <= DoFifoRead When TX_FRAME_ENABLE='1' Else GetNewSubFrame;                                                                                                         -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    --  Bi-Phase coding                                                                                                                                                                -- IncludeIf_TX_Enabled
    --                                                                                                                                                                                 -- IncludeIf_TX_Enabled
    --  Previous    Current     Current  Next                                                                                                                                          -- IncludeIf_TX_Enabled
    --  Output      Real Value  Output   Output                                                                                                                                        -- IncludeIf_TX_Enabled
    --    0            0           1       1                                                                                                                                           -- IncludeIf_TX_Enabled
    --    0            1           1       0                                                                                                                                           -- IncludeIf_TX_Enabled
    --    1            0           0       0                                                                                                                                           -- IncludeIf_TX_Enabled
    --    1            1           0       1                                                                                                                                           -- IncludeIf_TX_Enabled
    --                                                                                                                                                                                 -- IncludeIf_TX_Enabled
    --   Where:                                                                                                                                                                        -- IncludeIf_TX_Enabled
    --          Previous Output    - SPDIF Out value                                                                                                                                   -- IncludeIf_TX_Enabled
    --          Current Real Value - what we want to encode                                                                                                                            -- IncludeIf_TX_Enabled
    --          Current Output     - what we should pop on the line                                                                                                                    -- IncludeIf_TX_Enabled
    --          Next Output        - what we should pop on the line in bit time 2 (for current real value)                                                                             -- IncludeIf_TX_Enabled
    --                                                                                                                                                                                 -- IncludeIf_TX_Enabled
    --  Hence:                                                                                                                                                                         -- IncludeIf_TX_Enabled
    --          Current Output = Not (Previous Output)                                                                                                                                 -- IncludeIf_TX_Enabled
    --          Next Output    = (Current Real Value) Xor (Current Output)                                                                                                             -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
    Process(CLK_BASE)                                                                                                                                                                  -- IncludeIf_TX_Enabled
    Begin                                                                                                                                                                              -- IncludeIf_TX_Enabled
        If Rising_Edge(CLK_BASE) Then                                                                                                                                                  -- IncludeIf_TX_Enabled
            If TX_RST='1' Then                                                                                                                                                         -- IncludeIf_TX_Enabled
                -- reset values.                                                                                                                                                       -- IncludeIf_TX_Enabled
                FrameState       <= sFrameIdle;                                                                                                                                        -- IncludeIf_TX_Enabled
                BitCounter       <= (Others=>'0');                                                                                                                                     -- IncludeIf_TX_Enabled
                BiPhaseCounter   <= '0';                                                                                                                                               -- IncludeIf_TX_Enabled
                BiPhaseShiftReg  <= (Others=>'0');                                                                                                                                     -- IncludeIf_TX_Enabled
                PreambleShiftReg <= (Others=>'0');                                                                                                                                     -- IncludeIf_TX_Enabled
                FrameDone        <= '0';                                                                                                                                               -- IncludeIf_TX_Enabled
                Output           <= '0';                                                                                                                                               -- IncludeIf_TX_Enabled
                GetNewDataFF     <= '0';                                                                                                                                               -- IncludeIf_TX_Enabled
            Else                                                                                                                                                                       -- IncludeIf_TX_Enabled
                GetNewDataFF     <= FrameDone;                                                                                                                                         -- IncludeIf_TX_Enabled
                If CLK_BASE_EN='1' Then                                                                                                                                                -- IncludeIf_TX_Enabled
                    FrameDone <= '0';                                                                                                                                                  -- IncludeIf_TX_Enabled
                    Case FrameState Is                                                                                                                                                 -- IncludeIf_TX_Enabled
                        When sFrameIdle =>                                                                                                                                             -- IncludeIf_TX_Enabled
                             If FrameStart='1' Then                                                                                                                                    -- IncludeIf_TX_Enabled
                                FrameState      <= sFramePreamble;                                                                                                                     -- IncludeIf_TX_Enabled
                                BitCounter      <= (Others=>'0');                                                                                                                      -- IncludeIf_TX_Enabled
                             End If;                                                                                                                                                   -- IncludeIf_TX_Enabled
                        When sFramePreamble =>                                                                                                                                         -- IncludeIf_TX_Enabled
                             BiPhaseShiftReg <= CurrentFrame(35 Downto 8);                                                                                                             -- IncludeIf_TX_Enabled
                             BiPhaseCounter  <= '0';                                                                                                                                   -- IncludeIf_TX_Enabled
                             Case BitCounter Is                                                                                                                                        -- IncludeIf_TX_Enabled
                                When x"00"  => Output           <= CurrentPreamble(0);                                                                                                 -- IncludeIf_TX_Enabled
                                               PreambleShiftReg <= CurrentPreamble(7 Downto 1);                                                                                        -- IncludeIf_TX_Enabled
                                When x"01" | x"02" | x"03" | x"04" | x"05" | x"06" =>                                                                                                  -- IncludeIf_TX_Enabled
                                               Output           <= PreambleShiftReg(0);                                                                                                -- IncludeIf_TX_Enabled
                                               PreambleShiftReg <= '0' & PreambleShiftReg(6 Downto 1);                                                                                 -- IncludeIf_TX_Enabled
                                When x"07"  => Output     <= PreambleShiftReg(0);                                                                                                      -- IncludeIf_TX_Enabled
                                               FrameState <= sFrameAudio;                                                                                                              -- IncludeIf_TX_Enabled
                                When Others => Null;                                                                                                                                   -- IncludeIf_TX_Enabled
                             End Case;                                                                                                                                                 -- IncludeIf_TX_Enabled
                             BitCounter <= BitCounter + 1;                                                                                                                             -- IncludeIf_TX_Enabled
                        When sFrameAudio =>                                                                                                                                            -- IncludeIf_TX_Enabled
                             BiPhaseCounter <= Not BiPhaseCounter;                                                                                                                     -- IncludeIf_TX_Enabled
                             If BiPhaseCounter = '0' Then                                                                                                                              -- IncludeIf_TX_Enabled
                                 Output <= Not Output;                                                                                                                                 -- IncludeIf_TX_Enabled
                             Else                                                                                                                                                      -- IncludeIf_TX_Enabled
                                 Output          <= BiPhaseShiftReg(0) Xor Output;                                                                                                     -- IncludeIf_TX_Enabled
                                 BiPhaseShiftReg <= '0' & BiPhaseShiftReg(27 Downto 1);                                                                                                -- IncludeIf_TX_Enabled
                             End If;                                                                                                                                                   -- IncludeIf_TX_Enabled
                             BitCounter <= BitCounter + 1;                                                                                                                             -- IncludeIf_TX_Enabled
                             If BitCounter = x"3F" Then                          --63, last bit time                                                                                   -- IncludeIf_TX_Enabled
                                FrameDone      <= '1';                                                                                                                                 -- IncludeIf_TX_Enabled
                                FrameState     <= sFramePreamble;                                                                                                                      -- IncludeIf_TX_Enabled
                                BitCounter     <= (Others=>'0');                                                                                                                       -- IncludeIf_TX_Enabled
                             End If;                                                                                                                                                   -- IncludeIf_TX_Enabled
                        When Others =>                                                                                                                                                 -- IncludeIf_TX_Enabled
                             FrameState <= sFrameIdle;                                                                                                                                 -- IncludeIf_TX_Enabled
                    End Case;                                                                                                                                                          -- IncludeIf_TX_Enabled
                End If;                                                                                                                                                                -- IncludeIf_TX_Enabled
            End If;                                                                                                                                                                    -- IncludeIf_TX_Enabled
        End If;                                                                                                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                                                       -- IncludeIf_TX_Enabled
    DIGITAL_AUDIO_OUT <= Output;                                                                                                                                                       -- IncludeIf_TX_Enabled
    GetNewSubFrame    <= Not GetNewDataFF And FrameDone;                                                                                                                               -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
End RTL;                                                                                                                                                                               -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled

-- ----------------------------------------------------------------------------                                                                                 -- IncludeIf_TX_Enabled
Library IEEE;                                                                                                                                                   -- IncludeIf_TX_Enabled
Use     IEEE.Std_Logic_1164.All;                                                                                                                                -- IncludeIf_TX_Enabled
Use     IEEE.Std_Logic_Unsigned.All;                                                                                                                            -- IncludeIf_TX_Enabled
Use     IEEE.Numeric_Std.All;                                                                                                                                   -- IncludeIf_TX_Enabled
-- ----------------------------------------------------------------------------                                                                                 -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
--------------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
entity ReplaceWith_Designator_DIGITAL_AUDIO_TX_FIFO is                                                                                                          -- IncludeIf_TX_Enabled
   Generic (                                                                                                                                                    -- IncludeIf_TX_Enabled
       gFifoAddressWidth     : Integer := ReplaceWith_TxFifo_FreeSlotsWidth;                                                                          -- IncludeIf_TX_Enabled
       gFifoDepth            : Integer := ReplaceWith_TxFifo_Depth;                                                                                              -- IncludeIf_TX_Enabled
       gFifoAlmostFullValue  : Integer := ReplaceWith_TxFifo_AlmostFullValue;                                                                                 -- IncludeIf_TX_Enabled
       gFifoAlmostEmptyValue : Integer := ReplaceWith_TxFifo_AlmostEmptyValue;                                                                               -- IncludeIf_TX_Enabled
       gFifoDataWidth        : Integer := 32                                                                                                                    -- IncludeIf_TX_Enabled
   );                                                                                                                                                           -- IncludeIf_TX_Enabled
port (                                                                                                                                                          -- IncludeIf_TX_Enabled
    RD_RST          : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    WR_RST          : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    WR_EN           : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    WR_DATA         : in  std_logic_vector(gFifoDataWidth - 1 downto 0);                                                                                        -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    RD_EN           : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    RD_DATA         : out std_logic_vector(gFifoDataWidth - 1 downto 0);                                                                                        -- IncludeIf_TX_Enabled

    WATERMARK       : In  Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                                     -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    WR_FREE_SLOTS   : Out Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                                     -- IncludeIf_TX_Enabled
    WR_ALMOST_FULL  : out std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    WR_FULL         : out std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    RD_DATA_COUNT   : Out Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                                     -- IncludeIf_TX_Enabled
    RD_ALMOST_EMPTY : out std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    RD_EMPTY        : out std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    RD_CLK          : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    WR_CLK          : in  std_logic                                                                                                                             -- IncludeIf_TX_Enabled
);                                                                                                                                                              -- IncludeIf_TX_Enabled
end;                                                                                                                                                            -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
--------------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
architecture rtl of ReplaceWith_Designator_DIGITAL_AUDIO_TX_FIFO is                                                                                             -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    Component ReplaceWith_Designator_TX_BUFFER Is                                                                                                 -- IncludeIf_TX_Enabled
        Port(                                                                                                                                                   -- IncludeIf_TX_Enabled
            CLKA  : In  Std_Logic;                                                                                                                              -- IncludeIf_TX_Enabled
            CLKB  : In  Std_Logic;                                                                                                                              -- IncludeIf_TX_Enabled
            WEA   : In  Std_Logic;                                                                                                                              -- IncludeIf_TX_Enabled
            WEB   : In  Std_Logic;                                                                                                                              -- IncludeIf_TX_Enabled
            DINA  : In  Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                                          -- IncludeIf_TX_Enabled
            DINB  : In  Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                                          -- IncludeIf_TX_Enabled
            DOUTA : Out Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                                          -- IncludeIf_TX_Enabled
            DOUTB : Out Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                                          -- IncludeIf_TX_Enabled
            ADDRA : In  Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                                       -- IncludeIf_TX_Enabled
            ADDRB : In  Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0)                                                                                        -- IncludeIf_TX_Enabled
        );                                                                                                                                                      -- IncludeIf_TX_Enabled
    End Component;                                                                                                                                              -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    ----------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    function bin2gray ( bin : in std_logic_vector ) return std_logic_vector is                                                                                  -- IncludeIf_TX_Enabled
        variable bin_low : std_logic_vector(gFifoAddressWidth - 2 downto 0);                                                                                    -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        for n in 0 to gFifoAddressWidth - 2 loop                                                                                                                -- IncludeIf_TX_Enabled
            bin_low(n) := bin(n+1) xor bin(n);                                                                                                                  -- IncludeIf_TX_Enabled
        end loop;                                                                                                                                               -- IncludeIf_TX_Enabled
        return  bin(gFifoAddressWidth - 1) & bin_low;                                                                                                           -- IncludeIf_TX_Enabled
    end function;                                                                                                                                               -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    ----------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    function gray2bin (gray : in std_logic_vector ) return std_logic_vector is                                                                                  -- IncludeIf_TX_Enabled
        variable bin: std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                                         -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        bin(gFifoAddressWidth - 1) := gray(gFifoAddressWidth - 1);                                                                                              -- IncludeIf_TX_Enabled
        for n in gFifoAddressWidth - 1 downto 1 loop                                                                                                            -- IncludeIf_TX_Enabled
            bin(n-1) := bin(n) xor gray(n-1);                                                                                                                   -- IncludeIf_TX_Enabled
        end loop;                                                                                                                                               -- IncludeIf_TX_Enabled
        return bin;                                                                                                                                             -- IncludeIf_TX_Enabled
    end function;                                                                                                                                               -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    ----------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    signal Readpointer              : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
    signal WritePointer             : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal ReadPointer_Gray         : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
    signal WritePointer_Gray        : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal WR_FULL_Reg              : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
    signal RD_EMPTY_Reg             : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    Signal AlmostFull               : Std_Logic;                                                                                                                -- IncludeIf_TX_Enabled
    Signal AlmostEmpty              : Std_Logic;                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_ReadPointer_Gray    : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
    signal Sync_ReadPointer_Gray0   : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_WritePointer_Gray   : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
    signal Sync_WritePointer_Gray0  : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_WR_RST              : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_WR_RST0             : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_RD_RST              : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_RD_RST0             : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal ReadRst                  : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
    signal WriteRst                 : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_WR_EN               : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_WR_EN0              : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_RD_EN               : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
    signal Sync_RD_EN0              : std_logic;                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    signal ReadCount                : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
    signal WriteCount               : std_logic_vector(gFifoAddressWidth - 1 downto 0);                                                                         -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    Signal FifoDoWrite              : Std_Logic;                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    Signal Signal_GND               : Std_Logic;                                                                                                                -- IncludeIf_TX_Enabled
    Signal Signal_GND_Bus           : Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                            -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
begin                                                                                                                                                           -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    -- Syncronize resets                                                                                                                                        -- IncludeIf_TX_Enabled
    process(RD_CLK)                                                                                                                                             -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if rising_edge(RD_CLK) then                                                                                                                             -- IncludeIf_TX_Enabled
            Sync_WR_RST0 <= WR_RST;                                                                                                                             -- IncludeIf_TX_Enabled
            Sync_WR_RST  <= Sync_WR_RST0;                                                                                                                       -- IncludeIf_TX_Enabled
            ReadRst      <= RD_RST or Sync_WR_RST;                                                                                                              -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    process(WR_CLK)                                                                                                                                             -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if rising_edge(WR_CLK) then                                                                                                                             -- IncludeIf_TX_Enabled
            Sync_RD_RST0 <= RD_RST;                                                                                                                             -- IncludeIf_TX_Enabled
            Sync_RD_RST  <= Sync_RD_RST0;                                                                                                                       -- IncludeIf_TX_Enabled
            WriteRst     <= WR_RST or Sync_RD_RST;                                                                                                              -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    -- Read and Write pointers                                                                                                                                  -- IncludeIf_TX_Enabled
    process(RD_CLK)                                                                                                                                             -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if rising_edge(RD_CLK) then                                                                                                                             -- IncludeIf_TX_Enabled
            if ReadRst='1' then                                                                                                                                 -- IncludeIf_TX_Enabled
                ReadPointer      <= (others=>'0');                                                                                                              -- IncludeIf_TX_Enabled
                ReadPointer_Gray <= (others=>'0');                                                                                                              -- IncludeIf_TX_Enabled
            else                                                                                                                                                -- IncludeIf_TX_Enabled
                if RD_EN='1' and RD_EMPTY_Reg='0' then                                                                                                          -- IncludeIf_TX_Enabled
                    ReadPointer_Gray <= bin2gray(ReadPointer+1);                                                                                                -- IncludeIf_TX_Enabled
                    ReadPointer      <= ReadPointer + 1;                                                                                                        -- IncludeIf_TX_Enabled
                end if;                                                                                                                                         -- IncludeIf_TX_Enabled
            end if;                                                                                                                                             -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    process(WR_CLK)                                                                                                                                             -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if rising_edge(WR_CLK) then                                                                                                                             -- IncludeIf_TX_Enabled
            if WriteRst='1' then                                                                                                                                -- IncludeIf_TX_Enabled
                WritePointer      <= (others=>'0');                                                                                                             -- IncludeIf_TX_Enabled
                WritePointer_Gray <= (others=>'0');                                                                                                             -- IncludeIf_TX_Enabled
            else                                                                                                                                                -- IncludeIf_TX_Enabled
                if WR_EN='1' and WR_FULL_Reg='0' then                                                                                                           -- IncludeIf_TX_Enabled
                    WritePointer_Gray <= bin2gray(WritePointer+1);                                                                                              -- IncludeIf_TX_Enabled
                    WritePointer <= WritePointer + 1;                                                                                                           -- IncludeIf_TX_Enabled
                end if;                                                                                                                                         -- IncludeIf_TX_Enabled
            end if;                                                                                                                                             -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    -- Resyncronize pointers between clock domains (R to W)                                                                                                     -- IncludeIf_TX_Enabled
    process(WR_CLK)                                                                                                                                             -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if rising_edge(WR_CLK) then                                                                                                                             -- IncludeIf_TX_Enabled
            if WriteRst='1' then                                                                                                                                -- IncludeIf_TX_Enabled
                Sync_ReadPointer_Gray0 <= (others=>'0');                                                                                                        -- IncludeIf_TX_Enabled
                Sync_ReadPointer_Gray  <= (others=>'0');                                                                                                        -- IncludeIf_TX_Enabled
            else                                                                                                                                                -- IncludeIf_TX_Enabled
                Sync_ReadPointer_Gray0 <= ReadPointer_Gray;                                                                                                     -- IncludeIf_TX_Enabled
                Sync_ReadPointer_Gray  <= Sync_ReadPointer_Gray0;                                                                                               -- IncludeIf_TX_Enabled
            end if;                                                                                                                                             -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    WR_ALMOST_FULL  <= '1' when bin2gray(WritePointer + 1 + WATERMARK) = Sync_ReadPointer_Gray  else '0';                                            -- IncludeIf_TX_Enabled
    RD_ALMOST_EMPTY <= '1' when bin2gray(ReadPointer  + WATERMARK)    = Sync_WritePointer_Gray else '0';                                            -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    process(Sync_WritePointer_Gray, Sync_ReadPointer_Gray)                                                                                                      -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if (gray2bin(Sync_WritePointer_Gray) >= gray2bin(Sync_ReadPointer_Gray)) then                                                                           -- IncludeIf_TX_Enabled
           WR_FREE_SLOTS <= (((2**gFifoAddressWidth)-1)-(gray2bin(Sync_WritePointer_Gray)-gray2bin(Sync_ReadPointer_Gray)));                                    -- IncludeIf_TX_Enabled
        else                                                                                                                                                    -- IncludeIf_TX_Enabled
           WR_FREE_SLOTS <= (((2**gFifoAddressWidth)-1)-(((2**gFifoAddressWidth)-gray2bin(Sync_ReadPointer_Gray))+gray2bin(Sync_WritePointer_Gray)));           -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    process(Sync_WritePointer_Gray, Sync_ReadPointer_Gray)                                                                                                      -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if (gray2bin(Sync_WritePointer_Gray) >= gray2bin(Sync_ReadPointer_Gray)) then                                                                           -- IncludeIf_TX_Enabled
           RD_DATA_COUNT <= (gray2bin(Sync_WritePointer_Gray)-gray2bin(Sync_ReadPointer_Gray));                                                                 -- IncludeIf_TX_Enabled
        else                                                                                                                                                    -- IncludeIf_TX_Enabled
           RD_DATA_COUNT <= (((2**gFifoAddressWidth)-gray2bin(Sync_ReadPointer_Gray))+gray2bin(Sync_WritePointer_Gray));                                        -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    process(WR_CLK)                                                                                                                                             -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if rising_edge(WR_CLK) then                                                                                                                             -- IncludeIf_TX_Enabled
            if WriteRst='1' then                                                                                                                                -- IncludeIf_TX_Enabled
                WR_FULL_Reg <= '0';                                                                                                                             -- IncludeIf_TX_Enabled
            else                                                                                                                                                -- IncludeIf_TX_Enabled
                WR_FULL_Reg <= '0';                                                                                                                             -- IncludeIf_TX_Enabled
                if WR_EN='1' then                                                                                                                               -- IncludeIf_TX_Enabled
                    if bin2gray(WritePointer+2) = Sync_ReadPointer_Gray then                                                                                    -- IncludeIf_TX_Enabled
                        WR_FULL_Reg <= '1';                                                                                                                     -- IncludeIf_TX_Enabled
                    end if;                                                                                                                                     -- IncludeIf_TX_Enabled
                else                                                                                                                                            -- IncludeIf_TX_Enabled
                    if bin2gray(WritePointer+1) = Sync_ReadPointer_Gray then                                                                                    -- IncludeIf_TX_Enabled
                        WR_FULL_Reg <= '1';                                                                                                                     -- IncludeIf_TX_Enabled
                    end if;                                                                                                                                     -- IncludeIf_TX_Enabled
               end if;                                                                                                                                          -- IncludeIf_TX_Enabled
            end if;                                                                                                                                             -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    WR_FULL <= WR_FULL_Reg;                                                                                                                                     -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    -- Resyncronize pointers between clock domains (W to R)                                                                                                     -- IncludeIf_TX_Enabled
    process(RD_CLK)                                                                                                                                             -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if rising_edge(RD_CLK) then                                                                                                                             -- IncludeIf_TX_Enabled
            if ReadRst='1' then                                                                                                                                 -- IncludeIf_TX_Enabled
                Sync_WritePointer_Gray0 <= (others=>'0');                                                                                                       -- IncludeIf_TX_Enabled
                Sync_WritePointer_Gray  <= (others=>'0');                                                                                                       -- IncludeIf_TX_Enabled
            else                                                                                                                                                -- IncludeIf_TX_Enabled
                Sync_WritePointer_Gray0 <= WritePointer_Gray;                                                                                                   -- IncludeIf_TX_Enabled
                Sync_WritePointer_Gray  <= Sync_WritePointer_Gray0;                                                                                             -- IncludeIf_TX_Enabled
            end if;                                                                                                                                             -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    process(RD_CLK)                                                                                                                                             -- IncludeIf_TX_Enabled
    begin                                                                                                                                                       -- IncludeIf_TX_Enabled
        if rising_edge(RD_CLK) then                                                                                                                             -- IncludeIf_TX_Enabled
            if ReadRst='1' then                                                                                                                                 -- IncludeIf_TX_Enabled
                RD_EMPTY_Reg <= '1';                                                                                                                            -- IncludeIf_TX_Enabled
            else                                                                                                                                                -- IncludeIf_TX_Enabled
                RD_EMPTY_Reg <= '0';                                                                                                                            -- IncludeIf_TX_Enabled
                if RD_EN='1' then                                                                                                                               -- IncludeIf_TX_Enabled
                    if bin2gray(ReadPointer-2) = Sync_WritePointer_Gray then                                                                                    -- IncludeIf_TX_Enabled
                        RD_EMPTY_Reg <= '1';                                                                                                                    -- IncludeIf_TX_Enabled
                    end if;                                                                                                                                     -- IncludeIf_TX_Enabled
                else                                                                                                                                            -- IncludeIf_TX_Enabled
                    if bin2gray(ReadPointer) = Sync_WritePointer_Gray then                                                                                      -- IncludeIf_TX_Enabled
                        RD_EMPTY_Reg <= '1';                                                                                                                    -- IncludeIf_TX_Enabled
                   end if;                                                                                                                                      -- IncludeIf_TX_Enabled
               end if;                                                                                                                                          -- IncludeIf_TX_Enabled
            end if;                                                                                                                                             -- IncludeIf_TX_Enabled
        end if;                                                                                                                                                 -- IncludeIf_TX_Enabled
    end process;                                                                                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    RD_EMPTY <= RD_EMPTY_Reg;                                                                                                                                   -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    U_ReplaceWith_Designator_TX_BUFFER : ReplaceWith_Designator_TX_BUFFER Port Map (                                                               -- IncludeIf_TX_Enabled
        CLKA   => WR_CLK,                                                                                                                                       -- IncludeIf_TX_Enabled
        CLKB   => RD_CLK,                                                                                                                                       -- IncludeIf_TX_Enabled
        WEA    => FifoDoWrite,                                                                                                                                  -- IncludeIf_TX_Enabled
        WEB    => Signal_GND,                                                                                                                                   -- IncludeIf_TX_Enabled
        DINA   => WR_DATA,                                                                                                                                      -- IncludeIf_TX_Enabled
        DINB   => Signal_GND_Bus,                                                                                                                               -- IncludeIf_TX_Enabled
        DOUTA  => Open,                                                                                                                                         -- IncludeIf_TX_Enabled
        DOUTB  => RD_DATA,                                                                                                                                      -- IncludeIf_TX_Enabled
        ADDRA  => WritePointer,                                                                                                                                 -- IncludeIf_TX_Enabled
        ADDRB  => ReadPointer                                                                                                                                   -- IncludeIf_TX_Enabled
    );                                                                                                                                                          -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    Signal_GND <= '0';                                                                                                                                          -- IncludeIf_TX_Enabled
    Signal_GND_Bus <= (Others=>'0');                                                                                                                            -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
    -- ------------------------------------------------------------------------                                                                                 -- IncludeIf_TX_Enabled
    FifoDoWrite <= '1' When (WR_EN='1' And WR_FULL_Reg='0') Else '0';                                                                                           -- IncludeIf_TX_Enabled
    -- ------------------------------------------------------------------------                                                                                 -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
end rtl;                                                                                                                                                        -- IncludeIf_TX_Enabled


-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
Library IEEE;                                                                                                                                     -- IncludeIf_TX_Enabled
Use     IEEE.Std_Logic_1164.All;                                                                                                                  -- IncludeIf_TX_Enabled
Use     IEEE.Std_Logic_Unsigned.All;                                                                                                              -- IncludeIf_TX_Enabled
Use     IEEE.Std_Logic_Arith.All;                                                                                                                 -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
                                                                                                                                                  -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
Entity ReplaceWith_Designator_DIGITAL_AUDIO_CLOCK_GENERATOR Is                                                                                    -- IncludeIf_TX_Enabled
Generic (                                                                                                                                         -- IncludeIf_TX_Enabled
    gClkPrescalerWidth : Integer := 8                                                                                                             -- IncludeIf_TX_Enabled
);                                                                                                                                                -- IncludeIf_TX_Enabled
Port (                                                                                                                                            -- IncludeIf_TX_Enabled
    CLK_BASE                   : In  Std_Logic;                                                                                                   -- IncludeIf_TX_Enabled
    CLK_PRESCALER              : In  Std_Logic_Vector(gClkPrescalerWidth - 1 Downto 0);                                                           -- IncludeIf_TX_Enabled
    CLK_PRESCALER_ENABLE       : In  Std_Logic;                                                                                                   -- IncludeIf_TX_Enabled
    DIGITAL_AUDIO_CLOCK_ENABLE : Out Std_Logic                                                                                                    -- IncludeIf_TX_Enabled
);                                                                                                                                                -- IncludeIf_TX_Enabled
End;                                                                                                                                              -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
                                                                                                                                                  -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
Architecture RTL Of ReplaceWith_Designator_DIGITAL_AUDIO_CLOCK_GENERATOR Is                                                                       -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
                                                                                                                                                  -- IncludeIf_TX_Enabled
    Constant cPrescalerZero  : Std_Logic_Vector(gClkPrescalerWidth - 1 Downto 0) := Conv_Std_Logic_Vector(0, gClkPrescalerWidth);                 -- IncludeIf_TX_Enabled
    Signal Prescaler         : Std_Logic_Vector(gClkPrescalerWidth - 1 Downto 0);                                                                 -- IncludeIf_TX_Enabled
    Signal PrescalerIsZero   : Std_Logic;                                                                                                         -- IncludeIf_TX_Enabled
    Signal ClockEnable       : Std_Logic;                                                                                                         -- IncludeIf_TX_Enabled
    Signal ClockRecovered    : Std_Logic_Vector(7 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
                                                                                                                                                  -- IncludeIf_TX_Enabled
    SIgnal LatchBitCounter   : Std_Logic_Vector(6 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
    Signal DecrementDetected : Std_Logic_Vector(6 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
    Signal IncrementDetected : Std_Logic_Vector(6 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
    Signal LatchDecValue     : Std_Logic_Vector(6 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
    Signal LatchIncValue     : Std_Logic_Vector(6 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
    Signal NEW_PRESCALER     : Std_Logic_Vector(6 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
    Signal NewPrescalerValue : Std_Logic_Vector(6 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
                                                                                                                                                  -- IncludeIf_TX_Enabled
    Signal ClockNewInc       : Std_Logic_Vector(7 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
    Signal ClockNewDec       : Std_Logic_Vector(7 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
    Signal ClockRecoveredInc : Std_Logic_Vector(7 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
    Signal ClockRecoveredDec : Std_Logic_Vector(7 Downto 0);                                                                                      -- IncludeIf_TX_Enabled
                                                                                                                                                  -- IncludeIf_TX_Enabled
    Signal SlowDown      : Std_Logic;                                                                                                             -- IncludeIf_TX_Enabled
    Signal SpeedUp       : Std_Logic;                                                                                                             -- IncludeIf_TX_Enabled
    Signal FastPrescaler : Std_Logic_Vector(7 Downto 0);                                                                                          -- IncludeIf_TX_Enabled
    Signal SlowPrescaler : Std_Logic_Vector(7 Downto 0);                                                                                          -- IncludeIf_TX_Enabled
                                                                                                                                                  -- IncludeIf_TX_Enabled
                                                                                                                                                  -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
Begin                                                                                                                                             -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
    -- Generate Digital Audio Clock Enable                                                                                                        -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
    Process(CLK_BASE)                                                                                                                             -- IncludeIf_TX_Enabled
    Begin                                                                                                                                         -- IncludeIf_TX_Enabled
        If Rising_Edge(CLK_BASE) Then                                                                                                             -- IncludeIf_TX_Enabled
            If PrescalerIsZero='1' Then                                                                                                           -- IncludeIf_TX_Enabled
                Prescaler <= CLK_PRESCALER;                                                                                                       -- IncludeIf_TX_Enabled
                ClockEnable <= '1';                                                                                                               -- IncludeIf_TX_Enabled
            Else                                                                                                                                  -- IncludeIf_TX_Enabled
                Prescaler   <= Prescaler - 1;                                                                                                     -- IncludeIf_TX_Enabled
                ClockEnable <= '0';                                                                                                               -- IncludeIf_TX_Enabled
            End If;                                                                                                                               -- IncludeIf_TX_Enabled
        End If;                                                                                                                                   -- IncludeIf_TX_Enabled
    End Process;                                                                                                                                  -- IncludeIf_TX_Enabled
    PrescalerIsZero            <= '1'         When Prescaler = cPrescalerZero Else '0';                                                           -- IncludeIf_TX_Enabled
    DIGITAL_AUDIO_CLOCK_ENABLE <= ClockEnable When CLK_PRESCALER_ENABLE='1'   Else '0';                                                           -- IncludeIf_TX_Enabled
    -- -------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
End RTL;                                                                                                                                          -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
                                                                                                                                                  -- IncludeIf_TX_Enabled


-- ----------------------------------------------------------------------------
Library IEEE;
Use     IEEE.Std_Logic_1164.All;
Use     IEEE.Std_Logic_Unsigned.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_Designator_DIGITAL_AUDIO_AUX_BUFFER Is
Generic(
    gMemoryDepth : Integer := 12
);
Port (
    RD_CLK    : In  Std_Logic;
    RD_RST    : In  Std_Logic;
    RD_DATA   : Out Std_Logic_Vector(31 Downto 0);
    RD_ENABLE : In  Std_Logic;

    WR_CLK    : In  Std_Logic;
    WR_RST    : In  Std_Logic;
    WR_DATA   : In  Std_Logic_Vector(31 Downto 0);
    WR_ENABLE : In  Std_Logic
);
End;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_Designator_DIGITAL_AUDIO_AUX_BUFFER Is
-- ----------------------------------------------------------------------------
    Type TMemory Is Array (0 To gMemoryDepth - 1) Of Std_Logic_Vector(31 Downto 0);
    Signal Memory : TMemory;
    Signal WritePointer : Integer Range 0 To gMemoryDepth - 1;
    Signal ReadPointer  : Integer Range 0 To gMemoryDepth - 1;
--    attribute syn_ramstyle : string;
--    attribute syn_ramstyle of Memory : signal is "distributed";

-- ----------------------------------------------------------------------------
Begin
-- ----------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    -- Write Side
    -- ------------------------------------------------------------------------
    Process(WR_CLK)
    Begin
        If Rising_Edge(WR_CLK) Then
            If WR_RST='1' Then
                WritePointer <= 0;
            Else
                If WR_ENABLE='1' Then
                    If WritePointer=11 Then
                        WritePointer <= 0;
                    Else
                    WritePointer <= WritePointer + 1;
                    End If;
                    Memory(WritePointer) <= WR_DATA;
                End If;
            End If;
        End If;
    End Process;
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    -- Read Side
    -- ------------------------------------------------------------------------
    Process(RD_CLK)
    Begin
        If Rising_Edge(RD_CLK) Then
            If RD_RST='1' Then
                ReadPointer <= 0;
            Else
                If RD_ENABLE='1' Then
                    If ReadPointer=11 Then
                        ReadPointer <= 0;
                    Else
                    ReadPointer <= ReadPointer + 1;
                    End If;
                    RD_DATA <= Memory(ReadPointer);
                End If;
            End If;
        End If;
    End Process;
    -- ------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------



-- ----------------------------------------------------------------------------
Library IEEE;
Use     IEEE.Std_Logic_1164.All;
Use     IEEE.Std_Logic_Arith.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_Designator_DIGITAL_AUDIO_WISHBONE Is
Generic (
    gRxFifo_DataCountWidth : Integer := ReplaceWith_RxFifo_DataCountWidth;
    gTxFifo_FreeSlotsWidth : Integer := ReplaceWith_TxFifo_FreeSlotsWidth;
    gRxCoreRevision        : Integer := ReplaceWith_RxCoreRevision;
    gTxCoreRevision        : Integer := ReplaceWith_TxCoreRevision;
    gWbAdrWidth            : Integer := 5
);
Port (

    -- Receiver Interface                                                                           -- IncludeIf_RX_Enabled
    RX_FIFO_CLK                     : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_DATA                    : In  Std_Logic_Vector(31 Downto 0);                            -- IncludeIf_RX_Enabled
    RX_FIFO_READ                    : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_EMPTY                   : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_FULL                    : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_ALMOST_FULL             : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_DATA_COUNT              : In  Std_Logic_Vector(gRxFifo_DataCountWidth - 1 Downto 0);    -- IncludeIf_RX_Enabled
    RX_FIFO_WATERMARK               : Out Std_Logic_Vector(gRxFifo_DataCountWidth - 1 Downto 0);    -- IncludeIf_RX_Enabled
    RX_ENABLE                       : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_RST                          : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_RST                     : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_PE                           : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_SOB                          : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_NO_LOCK                      : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FLAG_PARITY_ERROR            : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FLAG_BLOCK_START             : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_CHANNEL_DATA      : In  Std_Logic_Vector(31 Downto 0);                            -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_CHANNEL_DATA_READ : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_USER_DATA         : In  Std_Logic_Vector(31 Downto 0);                            -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_USER_DATA_READ    : Out Std_Logic;                                                -- IncludeIf_RX_Enabled


    -- Transmitter Interface                                                                        -- IncludeIf_TX_Enabled
    TX_RST               : Out Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_FIFO_CLK          : Out Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_FIFO_RST          : Out Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_FIFO_DATA         : Out Std_Logic_Vector(31 Downto 0);                                       -- IncludeIf_TX_Enabled
    TX_FIFO_WRITE        : Out Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_FIFO_EMPTY        : In  Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_FIFO_ALMOST_EMPTY : In  Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_FIFO_FULL         : In  Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_FIFO_FREE_SLOTS   : In  Std_Logic_Vector(gTxFifo_FreeSlotsWidth - 1 Downto 0);               -- IncludeIf_TX_Enabled
    TX_FIFO_WATERMARK    : Out Std_Logic_Vector(gTxFifo_FreeSlotsWidth - 1 Downto 0);               -- IncludeIf_TX_Enabled
    TX_ENABLE            : Out Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_PRESCALER         : Out Std_Logic_Vector(7 Downto 0);                                        -- IncludeIf_TX_Enabled
    TX_PRESCALER_ENABLE  : Out Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_FRAME_ENABLE      : Out Std_Logic;                                                           -- IncludeIf_TX_Enabled
    TX_PARITY_ENABLE     : Out Std_Logic;                                                           -- IncludeIf_TX_Enabled

    TX_AUX_BUFFER_CHANNEL_DATA       : Out Std_Logic_Vector(31 Downto 0);                           -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_CHANNEL_DATA_WRITE : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USER_DATA          : Out Std_Logic_Vector(31 Downto 0);                           -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USER_DATA_WRITE    : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USE                : Out Std_Logic;                                               -- IncludeIf_TX_Enabled


    -- Wishbone Interface
    INT_O : Out Std_Logic;
    STB_I : In  Std_Logic;
    CYC_I : In  Std_Logic;
    ADR_I : In  Std_Logic_Vector(5 - 1 Downto 0);
    DAT_I : In  Std_Logic_Vector(31 Downto 0);
    DAT_O : Out Std_Logic_Vector(31 Downto 0);
    WE_I  : In  Std_Logic;
    ACK_O : Out Std_Logic;
    CLK_I : In  Std_Logic;
    RST_I : In  Std_Logic
);
End;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_Designator_DIGITAL_AUDIO_WISHBONE Is
-- ----------------------------------------------------------------------------

    Constant cREG_ADR_CORE_VERSION  : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(0, gWbAdrWidth);
    Constant cRX_VERSION : Std_Logic_Vector(15 Downto 0) := Conv_Std_Logic_Vector(1, 16);
    Constant cTX_VERSION : Std_Logic_Vector(15 Downto 0) := Conv_Std_Logic_Vector(1, 16);


    Constant cREG_ADR_RX_CONFIG         : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(1, gWbAdrWidth);   -- IncludeIf_RX_Enabled
    Constant cREG_ADR_RX_STATUS         : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(2, gWbAdrWidth);   -- IncludeIf_RX_Enabled
    Constant cREG_ADR_RX_DATA           : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(3, gWbAdrWidth);   -- IncludeIf_RX_Enabled
    Constant cREG_ADR_RX_DATA_COUNT     : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(4, gWbAdrWidth);   -- IncludeIf_RX_Enabled
    Constant cREG_ADR_RX_FIFO_WATERMARK : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(5, gWbAdrWidth);   -- IncludeIf_RX_Enabled
    Constant cREG_ADR_RX_CHANNEL_STATUS : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(6, gWbAdrWidth);   -- IncludeIf_RX_Enabled
    Constant cREG_ADR_RX_USER_DATA      : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(7, gWbAdrWidth);   -- IncludeIf_RX_Enabled

    Constant cREG_ADR_TX_CONFIG          : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(8, gWbAdrWidth);   -- IncludeIf_TX_Enabled
    Constant cREG_ADR_TX_STATUS          : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(9, gWbAdrWidth);   -- IncludeIf_TX_Enabled
    Constant cREG_ADR_TX_DATA            : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(10, gWbAdrWidth);   -- IncludeIf_TX_Enabled
    Constant cREG_ADR_TX_DATA_SLOTS      : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(11, gWbAdrWidth);   -- IncludeIf_TX_Enabled
    Constant cREG_ADR_TX_PRESCALER       : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(12, gWbAdrWidth);   -- IncludeIf_TX_Enabled
    Constant cREG_ADR_TX_FIFO_WATERMARK  : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(13, gWbAdrWidth);   -- IncludeIf_TX_Enabled
    Constant cREG_ADR_TX_CHANNEL_STATUS  : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(14, gWbAdrWidth);   -- IncludeIf_TX_Enabled
    Constant cREG_ADR_TX_USER_DATA       : Std_Logic_Vector(gWbAdrWidth - 1 Downto 0) := Conv_Std_Logic_Vector(15, gWbAdrWidth);   -- IncludeIf_TX_Enabled

    Constant cRX_FIFO_SIZE                 : Std_Logic_Vector(15 Downto 0) := Conv_Std_Logic_Vector(ReplaceWith_RxFifoSize, 16); -- IncludeIf_RX_Enabled
    Constant cFlag_RX_ENABLE               : Integer := 31;                                                      -- IncludeIf_RX_Enabled
    Constant cFlag_RX_IE                   : Integer := 30;                                                      -- IncludeIf_RX_Enabled
    Constant cFlag_RX_RST                  : Integer := 29;                                                      -- IncludeIf_RX_Enabled
    Constant cFlag_RX_FIFO_RST             : Integer := 28;                                                      -- IncludeIf_RX_Enabled
    Constant cFlag_RX_IE_BLOCK_START       : Integer := 7;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_IE_PARITY_ERROR      : Integer := 6;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_IE_SYNC_ERROR        : Integer := 4;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_IE_FIFO_FULL         : Integer := 1;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_IE_FIFO_ALMOST_FULL  : Integer := 0;                                                       -- IncludeIf_RX_Enabled

                                                                                                                 -- IncludeIf_RX_Enabled
    Constant cFlag_RX_FIFO_FULL            : Integer := 9;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_FIFO_ALMOST_FULL     : Integer := 8;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_INT_BLOCK_START      : Integer := 7;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_INT_PARITY_ERROR     : Integer := 6;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_FIFO_EMPTY           : Integer := 5;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_INT_SYNC_ERROR       : Integer := 4;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_INT_FIFO_FULL        : Integer := 1;                                                       -- IncludeIf_RX_Enabled
    Constant cFlag_RX_INT_FIFO_ALMOST_FULL : Integer := 0;                                                       -- IncludeIf_RX_Enabled
                                                                                                                 -- IncludeIf_RX_Enabled
    Signal Reg_RX_CONFIG                   : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal Reg_RX_STATUS_RST               : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal Reg_RX_STATUS_INT               : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal Reg_RX_DATA                     : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal Reg_RX_DATA_COUNT               : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal Reg_RX_FIFO_WATERMARK           : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal Reg_RX_CHANNEL_STATUS           : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal Reg_RX_USER_DATA                : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
                                                                                                                 -- IncludeIf_RX_Enabled
    Alias Flag_RX_ENABLE                   : Std_Logic Is Reg_RX_CONFIG(cFlag_RX_ENABLE);                        -- IncludeIf_RX_Enabled
    Alias Flag_RX_IE                       : Std_Logic Is Reg_RX_CONFIG(cFlag_RX_IE);                            -- IncludeIf_RX_Enabled
    Alias Flag_RX_RST                      : Std_Logic Is Reg_RX_CONFIG(cFlag_RX_RST);                           -- IncludeIf_RX_Enabled
    Alias Flag_RX_FIFO_RST                 : Std_Logic Is Reg_RX_CONFIG(cFlag_RX_FIFO_RST);                      -- IncludeIf_RX_Enabled
    Alias Flag_RX_BLOCK_START              : Std_Logic Is Reg_RX_CONFIG(cFlag_RX_IE_BLOCK_START);                -- IncludeIf_RX_Enabled
    Alias Flag_RX_IE_PARITY_ERROR          : Std_Logic Is Reg_RX_CONFIG(cFlag_RX_IE_PARITY_ERROR);               -- IncludeIf_RX_Enabled
    Alias Flag_RX_IE_SYNC_ERROR            : Std_Logic Is Reg_RX_CONFIG(cFlag_RX_IE_SYNC_ERROR);                 -- IncludeIf_RX_Enabled
    Alias Flag_RX_IE_FIFO_FULL             : Std_Logic Is Reg_RX_CONFIG(cFlag_RX_IE_FIFO_FULL);                  -- IncludeIf_RX_Enabled
    Alias Flag_RX_IE_FIFO_ALMOST_FULL      : Std_Logic Is Reg_RX_CONFIG(cFlag_RX_IE_FIFO_ALMOST_FULL);           -- IncludeIf_RX_Enabled
                                                                                                                 -- IncludeIf_RX_Enabled
    Signal RxConfig                        : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal RxStatus                        : Std_Logic_Vector(15 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal RxSyncError                     : Std_Logic;                                                          -- IncludeIf_RX_Enabled
    Signal RxFifoDataCount                 : Std_Logic_Vector(31 Downto 0);                                      -- IncludeIf_RX_Enabled
    Signal RxInterruptSig                  : Std_Logic;
    Signal RxFifoEmptySignal               : Std_Logic;                                                          -- IncludeIf_RX_Enabled
    Signal RxFifoFullSignal                : Std_Logic;                                                          -- IncludeIf_RX_Enabled
    Signal RxFifoAlmostFullSignal          : Std_Logic;                                                          -- IncludeIf_RX_Enabled
    Signal RxStatusFlags                   : Std_Logic_Vector(15 Downto 0);                                      -- IncludeIf_RX_Enabled


    Constant cTX_FIFO_SIZE                 : Std_Logic_Vector(15 Downto 0) := Conv_Std_Logic_Vector(ReplaceWith_TxFifoSize, 16); -- IncludeIf_TX_Enabled
    Constant cFlag_TX_ENABLE                : Integer := 31;                                                     -- IncludeIf_TX_Enabled
    Constant cFlag_TX_IE                    : Integer := 30;                                                     -- IncludeIf_TX_Enabled
    Constant cFlag_TX_RST                   : Integer := 29;                                                     -- IncludeIf_TX_Enabled
    Constant cFlag_TX_FIFO_RST              : Integer := 28;                                                     -- IncludeIf_TX_Enabled
    Constant cFlag_TX_PRESCALER_ENABLE      : Integer := 27;                                                     -- IncludeIf_TX_Enabled
    Constant cFlag_TX_FRAME_ENABLE          : Integer := 26;                                                     -- IncludeIf_TX_Enabled
    Constant cFlag_TX_PARITY_ENABLE         : Integer := 25;                                                     -- IncludeIf_TX_Enabled
    Constant cFlag_TX_USE_USER_DATA         : Integer := 24;                                                     -- IncludeIf_TX_Enabled
    Constant cFlag_TX_IE_FIFO_EMPTY         : Integer := 1;                                                      -- IncludeIf_TX_Enabled
    Constant cFlag_TX_IE_FIFO_ALMOST_EMPTY  : Integer := 0;                                                      -- IncludeIf_TX_Enabled
                                                                                                                 -- IncludeIf_TX_Enabled
    Constant cFlag_TX_FIFO_EMPTY            : Integer := 4;                                                      -- IncludeIf_TX_Enabled
    Constant cFlag_TX_FIFO_ALMOST_EMPTY     : Integer := 3;                                                      -- IncludeIf_TX_Enabled
    Constant cFlag_TX_FIFO_FULL             : Integer := 2;                                                      -- IncludeIf_TX_Enabled
    Constant cFlag_TX_INT_FIFO_EMPTY        : Integer := 1;                                                      -- IncludeIf_TX_Enabled
    Constant cFlag_TX_INT_FIFO_ALMOST_EMPTY : Integer := 0;                                                      -- IncludeIf_TX_Enabled
                                                                                                                 -- IncludeIf_TX_Enabled
    Signal Reg_TX_CONFIG                    : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal Reg_TX_STATUS_RST                : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal Reg_TX_STATUS_INT                : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal Reg_TX_DATA                      : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal Reg_TX_DATA_SLOTS                : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal Reg_TX_PRESCALER                 : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal Reg_TX_FIFO_WATERMARK            : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal Reg_TX_CHANNEL_STATUS            : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal Reg_TX_USER_DATA                 : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
                                                                                                                 -- IncludeIf_TX_Enabled
    Alias Flag_TX_ENABLE                    : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_ENABLE);                       -- IncludeIf_TX_Enabled
    Alias Flag_TX_IE                        : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_IE);                           -- IncludeIf_TX_Enabled
    Alias Flag_TX_RST                       : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_RST);                          -- IncludeIf_TX_Enabled
    Alias Flag_TX_FIFO_RST                  : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_FIFO_RST);                     -- IncludeIf_TX_Enabled
    Alias Flag_TX_PRESCALER_ENABLE          : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_PRESCALER_ENABLE);             -- IncludeIf_TX_Enabled
    Alias Flag_TX_FRAME_ENABLE              : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_FRAME_ENABLE);                 -- IncludeIf_TX_Enabled
    Alias Flag_TX_PARITY_ENABLE             : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_PARITY_ENABLE);                -- IncludeIf_TX_Enabled
    Alias Flag_TX_IE_FIFO_EMPTY             : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_IE_FIFO_EMPTY);                -- IncludeIf_TX_Enabled
    Alias Flag_TX_IE_FIFO_ALMOST_EMPTY      : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_IE_FIFO_ALMOST_EMPTY);         -- IncludeIf_TX_Enabled
    Alias Flag_TX_USE_USER_DATA             : Std_Logic Is Reg_TX_CONFIG(cFlag_TX_USE_USER_DATA);                -- IncludeIf_TX_Enabled
                                                                                                                 -- IncludeIf_TX_Enabled
    Signal TxFifoFullSignal        : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
    Signal TxFifoAlmostEmptySignal : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
    Signal TxFifoEmptySignal       : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
                                                                                                                 -- IncludeIf_TX_Enabled
                                                                                                                 -- IncludeIf_TX_Enabled
    Signal TxConfig                         : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal TxStatus                         : Std_Logic_Vector(15 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal TxStatusFlags                    : Std_Logic_Vector(15 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal TxFifoSlots                      : Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_TX_Enabled
    Signal TxInterruptSig                   : Std_Logic;

    Signal Reg_CORE_VERSION : Std_Logic_Vector(31 Downto 0);

    Signal WishboneRequest  : Std_Logic;
    Signal WishboneWrite    : Std_Logic;
    Signal WishboneRead     : Std_Logic;
    Signal TxInterrupt      : Std_Logic_Vector(15 Downto 0);
    Signal RxInterrupt      : Std_Logic_Vector(15 Downto 0);
-- ----------------------------------------------------------------------------
Begin
-- ----------------------------------------------------------------------------
    Reg_CORE_VERSION <= cRX_VERSION & cTX_VERSION;
    -- ------------------------------------------------------------------------
    WishboneRequest <= STB_I And CYC_I;
    WishboneRead    <= WishboneRequest And Not WE_I;
    WishboneWrite   <= WishboneRequest And     WE_I;
    ACK_O           <= WishboneRequest;
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    -- Wishbone Write
    -- ------------------------------------------------------------------------
    Process(CLK_I)
    Begin
        If Rising_Edge(CLK_I) Then
            If RST_I='1' Then
                Reg_RX_CONFIG         <= (Others=>'0');                                 -- IncludeIf_RX_Enabled
                Reg_RX_STATUS_RST     <= (Others=>'0');                                 -- IncludeIf_RX_Enabled
                Reg_RX_FIFO_WATERMARK <= (Others=>'0');                                 -- IncludeIf_RX_Enabled
                Reg_TX_CONFIG         <= (Others=>'0');                                 -- IncludeIf_TX_Enabled
                Reg_TX_STATUS_RST     <= (Others=>'0');                                 -- IncludeIf_TX_Enabled
                Reg_TX_DATA           <= (Others=>'0');                                 -- IncludeIf_TX_Enabled
                Reg_TX_PRESCALER      <= (Others=>'0');                                 -- IncludeIf_TX_Enabled
                Reg_TX_FIFO_WATERMARK <= (Others=>'0');                                 -- IncludeIf_TX_Enabled
            Else
                If WishboneWrite='1' Then
                    Case ADR_I Is
                        When cREG_ADR_RX_CONFIG         => Reg_RX_CONFIG         <= DAT_I;   -- IncludeIf_RX_Enabled
                        When cREG_ADR_RX_STATUS         => Reg_RX_STATUS_RST     <= DAT_I;   -- IncludeIf_RX_Enabled
                        When cREG_ADR_RX_FIFO_WATERMARK => Reg_RX_FIFO_WATERMARK <= DAT_I;   -- IncludeIf_RX_Enabled
                        When cREG_ADR_TX_CONFIG         => Reg_TX_CONFIG         <= DAT_I;   -- IncludeIf_TX_Enabled
                        When cREG_ADR_TX_STATUS         => Reg_TX_STATUS_RST     <= DAT_I;   -- IncludeIf_TX_Enabled
                        When cREG_ADR_TX_DATA           => Reg_TX_DATA           <= DAT_I;   -- IncludeIf_TX_Enabled
                        When cREG_ADR_TX_PRESCALER      => Reg_TX_PRESCALER      <= DAT_I;   -- IncludeIf_TX_Enabled
                        When cREG_ADR_TX_FIFO_WATERMARK => Reg_TX_FIFO_WATERMARK <= DAT_I;   -- IncludeIf_TX_Enabled
                        When Others                     => Null;
                    End Case;
                Else
                    If RxStatus(cFlag_RX_INT_BLOCK_START)       = '0' Then Reg_RX_STATUS_RST(cFlag_RX_INT_BLOCK_START)       <= '0'; End If;   -- IncludeIf_RX_Enabled
                    If RxStatus(cFlag_RX_INT_PARITY_ERROR)      = '0' Then Reg_RX_STATUS_RST(cFlag_RX_INT_PARITY_ERROR)      <= '0'; End If;   -- IncludeIf_RX_Enabled
                    If RxStatus(cFlag_RX_INT_SYNC_ERROR)        = '0' Then Reg_RX_STATUS_RST(cFlag_RX_INT_SYNC_ERROR)        <= '0'; End If;   -- IncludeIf_RX_Enabled
                    If RxStatus(cFlag_RX_INT_FIFO_FULL)         = '0' Then Reg_RX_STATUS_RST(cFlag_RX_INT_FIFO_FULL)         <= '0'; End If;   -- IncludeIf_RX_Enabled
                    If RxStatus(cFlag_RX_INT_FIFO_ALMOST_FULL)  = '0' Then Reg_RX_STATUS_RST(cFlag_RX_INT_FIFO_ALMOST_FULL)  <= '0'; End If;   -- IncludeIf_RX_Enabled

                    If TxStatus(cFlag_TX_INT_FIFO_EMPTY)        = '0' Then Reg_TX_STATUS_RST(cFlag_TX_INT_FIFO_EMPTY)        <= '0'; End If;   -- IncludeIf_TX_Enabled
                    If TxStatus(cFlag_TX_INT_FIFO_ALMOST_EMPTY) = '0' Then Reg_TX_STATUS_RST(cFlag_TX_INT_FIFO_ALMOST_EMPTY) <= '0'; End If;   -- IncludeIf_TX_Enabled
                End If;
            End If;
        End If;
    End Process;
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    -- Wishbone Read
    -- ------------------------------------------------------------------------
    Process (Reg_CORE_VERSION,
            -- Receiver                 -- IncludeIf_RX_Enabled
            RxConfig,                   -- IncludeIf_RX_Enabled
            RxStatusFlags,                   -- IncludeIf_RX_Enabled
            RX_FIFO_DATA,               -- IncludeIf_RX_Enabled
            RxFifoDataCount,            -- IncludeIf_RX_Enabled
            Reg_RX_FIFO_WATERMARK,      -- IncludeIf_RX_Enabled
            RX_AUX_BUFFER_CHANNEL_DATA, -- IncludeIf_RX_Enabled
            RX_AUX_BUFFER_USER_DATA,    -- IncludeIf_RX_Enabled
            -- Transmitter
            TxConfig,                   -- IncludeIf_TX_Enabled
            TxStatusFlags,                   -- IncludeIf_TX_Enabled
            TxFifoSlots,                -- IncludeIf_TX_Enabled
            Reg_TX_PRESCALER,           -- IncludeIf_TX_Enabled
            Reg_TX_FIFO_WATERMARK,      -- IncludeIf_TX_Enabled
            ADR_I)
    Begin
        Case ADR_I Is
            When cREG_ADR_CORE_VERSION      => DAT_O <= Reg_CORE_VERSION;
            When cREG_ADR_RX_CONFIG         => DAT_O <= RxConfig;                                       -- IncludeIf_RX_Enabled
            When cREG_ADR_RX_STATUS         => DAT_O <= cRX_FIFO_SIZE & RxStatusFlags;                       -- IncludeIf_RX_Enabled
            When cREG_ADR_RX_DATA           => DAT_O <= RX_FIFO_DATA;                                   -- IncludeIf_RX_Enabled
            When cREG_ADR_RX_DATA_COUNT     => DAT_O <= RxFifoDataCount;                                -- IncludeIf_RX_Enabled
            When cREG_ADR_RX_FIFO_WATERMARK => DAT_O <= x"0000" & Reg_RX_FIFO_WATERMARK(15 Downto 0);   -- IncludeIf_RX_Enabled
            When cREG_ADR_RX_CHANNEL_STATUS => DAT_O <= RX_AUX_BUFFER_CHANNEL_DATA;                     -- IncludeIf_RX_Enabled
            When cREG_ADR_RX_USER_DATA      => DAT_O <= RX_AUX_BUFFER_USER_DATA;                        -- IncludeIf_RX_Enabled
            When cREG_ADR_TX_CONFIG         => DAT_O <= TxConfig;                                       -- IncludeIf_TX_Enabled
            When cREG_ADR_TX_STATUS         => DAT_O <= cTX_FIFO_SIZE & TxStatusFlags;                       -- IncludeIf_TX_Enabled
            When cREG_ADR_TX_DATA_SLOTS     => DAT_O <= TxFifoSlots;                                    -- IncludeIf_TX_Enabled
            When cREG_ADR_TX_PRESCALER      => DAT_O <= x"000000" & Reg_TX_PRESCALER(7 Downto 0);       -- IncludeIf_TX_Enabled
            When cREG_ADR_TX_FIFO_WATERMARK => DAT_O <= x"0000" & Reg_TX_FIFO_WATERMARK(15 Downto 0);   -- IncludeIf_TX_Enabled
            When Others                     => DAT_O <= (Others=>'0');
        End Case;
    End Process;
    -- ------------------------------------------------------------------------
                                                                                                    -- IncludeIf_TX_Enabled
    TxConfig <= (cFlag_TX_ENABLE               => Flag_TX_ENABLE,                                   -- IncludeIf_TX_Enabled
                 cFlag_TX_IE                   => Flag_TX_IE,                                       -- IncludeIf_TX_Enabled
                 cFlag_TX_RST                  => Flag_TX_RST,                                      -- IncludeIf_TX_Enabled
                 cFlag_TX_FIFO_RST             => Flag_TX_FIFO_RST,                                 -- IncludeIf_TX_Enabled
                 cFlag_TX_PRESCALER_ENABLE     => Flag_TX_PRESCALER_ENABLE,                         -- IncludeIf_TX_Enabled
                 cFlag_TX_FRAME_ENABLE         => Flag_TX_FRAME_ENABLE,                             -- IncludeIf_TX_Enabled
                 cFlag_TX_PARITY_ENABLE        => Flag_TX_PARITY_ENABLE,                            -- IncludeIf_TX_Enabled
                 cFlag_TX_IE_FIFO_EMPTY        => Flag_TX_IE_FIFO_EMPTY,                            -- IncludeIf_TX_Enabled
                 cFlag_TX_IE_FIFO_ALMOST_EMPTY => Flag_TX_IE_FIFO_ALMOST_EMPTY,                     -- IncludeIf_TX_Enabled
                 cFlag_TX_USE_USER_DATA        => Flag_TX_USE_USER_DATA,                            -- IncludeIf_TX_Enabled
                 Others                        => '0');                                             -- IncludeIf_TX_Enabled
                                                                                                    -- IncludeIf_TX_Enabled
                                                                                                    -- IncludeIf_TX_Enabled
    TxFifoSlots <= ReplaceWith_TxFifoFreeSlotsPad & TX_FIFO_FREE_SLOTS;                             -- IncludeIf_TX_Enabled
                                                                                                    -- IncludeIf_TX_Enabled
    -- Transmitter Interface                                                                        -- IncludeIf_TX_Enabled
    TX_FIFO_WATERMARK   <= Reg_TX_FIFO_WATERMARK(gTxFifo_FreeSlotsWidth - 1 Downto 0);              -- IncludeIf_TX_Enabled
    TX_RST              <= Flag_TX_RST Or RST_I;                                                    -- IncludeIf_TX_Enabled
    TX_FIFO_CLK         <= CLK_I;                                                                   -- IncludeIf_TX_Enabled
    TX_FIFO_RST         <= Flag_TX_FIFO_RST Or Flag_TX_RST Or RST_I;                                -- IncludeIf_TX_Enabled
    TX_FIFO_DATA        <= DAT_I;                                                                   -- IncludeIf_TX_Enabled
    TX_FIFO_WRITE       <= '1' When (WishboneWrite='1' And ADR_I=cREG_ADR_TX_DATA) Else '0';        -- IncludeIf_TX_Enabled
    TX_ENABLE           <= Flag_TX_ENABLE;                                                          -- IncludeIf_TX_Enabled
    TX_PRESCALER        <= Reg_TX_PRESCALER(7 Downto 0);                                            -- IncludeIf_TX_Enabled
    TX_PRESCALER_ENABLE <= Flag_TX_PRESCALER_ENABLE;                                                -- IncludeIf_TX_Enabled
    TX_FRAME_ENABLE     <= Flag_TX_FRAME_ENABLE;                                                    -- IncludeIf_TX_Enabled
    TX_PARITY_ENABLE    <= Flag_TX_PARITY_ENABLE;                                                   -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USE   <= Flag_TX_USE_USER_DATA;                                                   -- IncludeIf_TX_Enabled
    TxInterruptSig      <= (TxStatus(cFlag_TX_INT_FIFO_ALMOST_EMPTY) Or TxStatus(cFlag_TX_INT_FIFO_EMPTY)) And Flag_TX_IE; --IncludeIf_TX_Enabled
    TxInterruptSig         <= '0';                                                                     -- IncludeIf_TX_Disabled
                                                                                                       -- IncludeIf_TX_Enabled
    GenerateTxIntControl : For I In TxStatus'Low To TxStatus'High Generate                             -- IncludeIf_TX_Enabled
    Begin                                                                                              -- IncludeIf_TX_Enabled
        Process(CLK_I)                                                                                 -- IncludeIf_TX_Enabled
            Variable PreviousValue : Std_Logic_Vector(TxStatus'High Downto TxStatus'Low);              -- IncludeIf_TX_Enabled
        Begin                                                                                          -- IncludeIf_TX_Enabled
            If Rising_Edge(CLK_I) Then                                                                 -- IncludeIf_TX_Enabled
                If RST_I='1' Or Flag_TX_RST='1' Then                                                   -- IncludeIf_TX_Enabled
                    TxStatus(I)   <= '0';                                                              -- IncludeIf_TX_Enabled
                    PreviousValue := (Others=>'0');                                                    -- IncludeIf_TX_Enabled
                Else                                                                                   -- IncludeIf_TX_Enabled
                    If Reg_TX_STATUS_RST(I)='1' Then                                                   -- IncludeIf_TX_Enabled
                        TxStatus(I) <= '0';                                                            -- IncludeIf_TX_Enabled
                        PreviousValue(I) := '0';                                                       -- IncludeIf_TX_Enabled
                    Else                                                                               -- IncludeIf_TX_Enabled
                        If (((TxInterrupt(I) = '1') And (PreviousValue(I)='0'))) And Flag_TX_IE='1' And Flag_TX_ENABLE='1' Then                    -- IncludeIf_TX_Enabled
                            TxStatus(I) <= Reg_TX_CONFIG(I);                                           -- IncludeIf_TX_Enabled
                        End If;                                                                        -- IncludeIf_TX_Enabled
                        PreviousValue(I) := TxInterrupt(I);                                            -- IncludeIf_TX_Enabled
                    End If;                                                                            -- IncludeIf_TX_Enabled
                End If;                                                                                -- IncludeIf_TX_Enabled
            End If;                                                                                    -- IncludeIf_TX_Enabled
        End Process;                                                                                   -- IncludeIf_TX_Enabled
    End Generate;                                                                                      -- IncludeIf_TX_Enabled
                                                                                                        -- IncludeIf_TX_Enabled
    Process(CLK_I)                                                                                      -- IncludeIf_TX_Enabled
    Begin                                                                                               -- IncludeIf_TX_Enabled
         If Rising_Edge(CLK_I) Then                                                                     -- IncludeIf_TX_Enabled
            If RST_I='1' Or Flag_TX_RST='1' Then                                                        -- IncludeIf_TX_Enabled
               TxFifoFullSignal        <= '0';                                                          -- IncludeIf_TX_Enabled
               TxFifoAlmostEmptySignal <= '0';                                                          -- IncludeIf_TX_Enabled
               TxFifoEmptySignal       <= '0';                                                          -- IncludeIf_TX_Enabled
            Else                                                                                        -- IncludeIf_TX_Enabled
                TxFifoFullSignal        <= TX_FIFO_FULL;                                                -- IncludeIf_TX_Enabled
                TxFifoAlmostEmptySignal <= TX_FIFO_ALMOST_EMPTY;                                        -- IncludeIf_TX_Enabled
                TxFifoEmptySignal       <= TX_FIFO_EMPTY;                                               -- IncludeIf_TX_Enabled
            End If;                                                                                     -- IncludeIf_TX_Enabled
         End If;                                                                                        -- IncludeIf_TX_Enabled
    End Process;                                                                                        -- IncludeIf_TX_Enabled
    TxStatusFlags <= TxStatus(TxStatus'High Downto 5) & TxFifoAlmostEmptySignal & TxFifoEmptySignal & TxFifoFullSignal & TxStatus(1 Downto 0);  -- IncludeIf_TX_Enabled
    TxInterrupt <= (cFlag_TX_INT_FIFO_ALMOST_EMPTY => TX_FIFO_ALMOST_EMPTY,                            -- IncludeIf_TX_Enabled
                    cFlag_TX_INT_FIFO_EMPTY        => TX_FIFO_EMPTY,                                   -- IncludeIf_TX_Enabled
                    Others=>'0');                                                                      -- IncludeIf_TX_Enabled



    TX_AUX_BUFFER_CHANNEL_DATA       <= DAT_I;                                                                    -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USER_DATA          <= DAT_I;                                                                    -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_CHANNEL_DATA_WRITE <= '1' When (WishboneWrite='1' And ADR_I=cREG_ADR_TX_CHANNEL_STATUS) Else '0'; -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USER_DATA_WRITE    <= '1' When (WishboneWrite='1' And ADR_I=cREG_ADR_TX_USER_DATA) Else '0';    -- IncludeIf_TX_Enabled


    RX_AUX_BUFFER_CHANNEL_DATA_READ <= '1' When (WishboneRead='1' And ADR_I=cREG_ADR_RX_CHANNEL_STATUS) Else '0'; -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_USER_DATA_READ    <= '1' When (WishboneRead='1' And ADR_I=cREG_ADR_RX_USER_DATA)      Else '0'; -- IncludeIf_RX_Enabled
                                                                                                                  -- IncludeIf_RX_Enabled
    GenerateRxIntControl : For I In RxStatus'Low To RxStatus'High Generate                                        -- IncludeIf_RX_Enabled
    Begin                                                                                                         -- IncludeIf_RX_Enabled
        Process(CLK_I)                                                                                            -- IncludeIf_RX_Enabled
            Variable PreviousValue : Std_Logic_Vector(RxStatus'High Downto RxStatus'Low);                         -- IncludeIf_RX_Enabled
        Begin                                                                                                     -- IncludeIf_RX_Enabled
            If Rising_Edge(CLK_I) Then                                                                            -- IncludeIf_RX_Enabled
                If RST_I='1' Or Flag_RX_RST='1' Or Flag_RX_ENABLE='0' Then                                        -- IncludeIf_RX_Enabled
                    RxStatus(I) <= '0';                                                                           -- IncludeIf_RX_Enabled
                Else                                                                                              -- IncludeIf_RX_Enabled
                    If Reg_RX_STATUS_RST(I)='1' Then                                                              -- IncludeIf_RX_Enabled
                        RxStatus(I)     <= '0';                                                                   -- IncludeIf_RX_Enabled
                        PreviousValue(I) := '0';                                                                  -- IncludeIf_RX_Enabled
                    Else                                                                                          -- IncludeIf_RX_Enabled
                        If (((RxInterrupt(I) = '1') And (PreviousValue(I)='0'))) And Flag_RX_IE='1' And Flag_RX_ENABLE='1' THen          -- IncludeIf_RX_Enabled
                            RxStatus(I) <= Reg_RX_CONFIG(I);                                                      -- IncludeIf_RX_Enabled
                        End If;                                                                                   -- IncludeIf_RX_Enabled
                        PreviousValue(I) := RxInterrupt(I);                                                       -- IncludeIf_RX_Enabled
                    End If;                                                                                       -- IncludeIf_RX_Enabled
                End If;                                                                                           -- IncludeIf_RX_Enabled
            End If;                                                                                               -- IncludeIf_RX_Enabled
        End Process;                                                                                              -- IncludeIf_RX_Enabled
    End Generate;                                                                                                 -- IncludeIf_RX_Enabled
                                                                                                                  -- IncludeIf_RX_Enabled
    Process(CLK_I)                                                                                                -- IncludeIf_RX_Enabled
    Begin                                                                                                         -- IncludeIf_RX_Enabled
         If Rising_Edge(CLK_I) Then                                                                               -- IncludeIf_RX_Enabled
            If RST_I='1' Or Flag_RX_RST='1' Then                                                                  -- IncludeIf_RX_Enabled
               RxFifoEmptySignal <= '0';                                                                          -- IncludeIf_RX_Enabled
               RxFifoFullSignal  <= '0';                                                                          -- IncludeIf_RX_Enabled
               RxFifoAlmostFullSignal <= '0';                                                                     -- IncludeIf_RX_Enabled
            Else                                                                                                  -- IncludeIf_RX_Enabled
                RxFifoEmptySignal      <= RX_FIFO_EMPTY;                                                          -- IncludeIf_RX_Enabled
                RxFifoFullSignal       <= RX_FIFO_FULL;                                                           -- IncludeIf_RX_Enabled
                RxFifoAlmostFullSignal <= RX_FIFO_ALMOST_FULL;                                                    -- IncludeIf_RX_Enabled
            End If;                                                                                               -- IncludeIf_RX_Enabled
         End If;                                                                                                  -- IncludeIf_RX_Enabled
    End Process;                                                                                                  -- IncludeIf_RX_Enabled
                                                                                                                  -- IncludeIf_RX_Enabled

    RxStatusFlags <= RxStatus(15 Downto 10) & RxFifoFullSignal & RxFifoAlmostFullSignal & RxStatus(7 Downto 6) & RxFifoEmptySignal & RxStatus(4 Downto 0) ; -- IncludeIf_RX_Enabled
                                                                                                                  -- IncludeIf_RX_Enabled
    RxInterrupt <= ( cFlag_RX_INT_FIFO_FULL        => RX_FIFO_FULL,                                               -- IncludeIf_RX_Enabled
                     cFlag_RX_INT_FIFO_ALMOST_FULL => RX_FIFO_ALMOST_FULL,                                        -- IncludeIf_RX_Enabled
                     cFlag_RX_FIFO_EMPTY           => RX_FIFO_EMPTY,                                              -- IncludeIf_RX_Enabled
                     cFlag_RX_INT_SYNC_ERROR       => RxSyncError,                                                -- IncludeIf_RX_Enabled
                     cFlag_RX_INT_PARITY_ERROR     => RX_FLAG_PARITY_ERROR,                                       -- IncludeIf_RX_Enabled
                     cFlag_RX_INT_BLOCK_START      => RX_FLAG_BLOCK_START,                                        -- IncludeIf_RX_Enabled
                     Others=>'0' );                                                                               -- IncludeIf_RX_Enabled
                                                                                                                  -- IncludeIf_RX_Enabled
    RxInterruptSig <= ( RxStatus(cFlag_RX_INT_FIFO_FULL)        Or                                                  -- IncludeIf_RX_Enabled
                      RxStatus(cFlag_RX_INT_FIFO_ALMOST_FULL) Or                                                  -- IncludeIf_RX_Enabled
                      RxStatus(cFlag_RX_INT_SYNC_ERROR)       Or                                                  -- IncludeIf_RX_Enabled
                      RxStatus(cFlag_RX_INT_PARITY_ERROR)     Or                                                  -- IncludeIf_RX_Enabled
                      RxStatus(cFlag_RX_INT_BLOCK_START))     And Flag_RX_IE;                                     -- IncludeIf_RX_Enabled
    RxInterruptSig         <= '0';                                                                     -- IncludeIf_RX_Disabled
                                                                                                                  -- IncludeIf_RX_Enabled
                                                                                                    -- IncludeIf_RX_Enabled
    RxConfig <= (cFlag_RX_ENABLE              => Flag_RX_ENABLE,                                    -- IncludeIf_RX_Enabled
                 cFlag_RX_IE                  => Flag_RX_IE,                                        -- IncludeIf_RX_Enabled
                 cFlag_RX_RST                 => Flag_RX_RST,                                       -- IncludeIf_RX_Enabled
                 cFlag_RX_FIFO_RST            => Flag_RX_FIFO_RST,                                  -- IncludeIf_RX_Enabled
                 cFlag_RX_IE_SYNC_ERROR       => Flag_RX_IE_SYNC_ERROR,                             -- IncludeIf_RX_Enabled
                 cFlag_RX_IE_FIFO_FULL        => Flag_RX_IE_FIFO_FULL,                              -- IncludeIf_RX_Enabled
                 cFlag_RX_IE_FIFO_ALMOST_FULL => Flag_RX_IE_FIFO_ALMOST_FULL,                       -- IncludeIf_RX_Enabled
                 Others=>'0');                                                                      -- IncludeIf_RX_Enabled
    RxSyncError     <= '0';                                                                         -- IncludeIf_RX_Enabled
    RxFifoDataCount <= ReplaceWith_RxFifoDataCountPad & RX_FIFO_DATA_COUNT;                         -- IncludeIf_RX_Enabled
                                                                                                    -- IncludeIf_RX_Enabled
    RX_FIFO_CLK       <= CLK_I;                                                                          -- IncludeIf_RX_Enabled
    RX_FIFO_WATERMARK <= Reg_RX_FIFO_WATERMARK(gRxFifo_DataCountWidth - 1 Downto 0);                -- IncludeIf_RX_Enabled
    RX_FIFO_READ      <= '1' When (WishboneRead='1' And ADR_I=cREG_ADR_RX_DATA) Else '0';                -- IncludeIf_RX_Enabled
    RX_ENABLE         <= Flag_RX_ENABLE;                                                                 -- IncludeIf_RX_Enabled
    RX_RST            <= Flag_RX_RST Or RST_I;                                                           -- IncludeIf_RX_Enabled
    RX_FIFO_RST       <= Flag_RX_RST Or Flag_RX_FIFO_RST Or RST_I;                                       -- IncludeIf_RX_Enabled
                                                                                                    -- IncludeIf_RX_Enabled


    INT_O <= RxInterruptSig Or TxInterruptSig;

End RTL;

-- -----------------------------------------------------------------------------
-- Main
-- -----------------------------------------------------------------------------
Library IEEE;
Use     IEEE.Std_Logic_1164.All;

Entity ReplaceWith_EntityName Is
Port (
    SPDIF_IN  : In  Std_Logic;   -- IncludeIf_RX_Enabled
    SPDIF_OUT : Out Std_Logic;   -- IncludeIf_TX_Enabled

    INT_O : Out Std_Logic;
    STB_I : In  Std_Logic;
    CYC_I : In  Std_Logic;
    ADR_I : In  Std_Logic_Vector(4 Downto 0);
    DAT_I : In  Std_Logic_Vector(31 Downto 0);
    DAT_O : Out Std_Logic_Vector(31 Downto 0);
    WE_I  : In  Std_Logic;
    ACK_O : Out Std_Logic;
    CLK_I : In  Std_Logic;
    CLK_BASE : In Std_Logic;
    RST_I : In  Std_Logic
);
End;

Architecture RTL Of ReplaceWith_EntityName Is

-- -----------------------------------------------------------------------------
-- -----------------------------------------------------------------------------                                                                  -- IncludeIf_TX_Enabled
Component ReplaceWith_Designator_DIGITAL_AUDIO_CLOCK_GENERATOR Is                                                                                 -- IncludeIf_TX_Enabled
Generic (                                                                                                                                         -- IncludeIf_TX_Enabled
    gClkPrescalerWidth : Integer := 8                                                                                                             -- IncludeIf_TX_Enabled
);                                                                                                                                                -- IncludeIf_TX_Enabled
Port (                                                                                                                                            -- IncludeIf_TX_Enabled
    CLK_BASE                   : In  Std_Logic;                                                                                                   -- IncludeIf_TX_Enabled
    CLK_PRESCALER              : In  Std_Logic_Vector(gClkPrescalerWidth - 1 Downto 0);                                                           -- IncludeIf_TX_Enabled
    CLK_PRESCALER_ENABLE       : In  Std_Logic;                                                                                                   -- IncludeIf_TX_Enabled
    DIGITAL_AUDIO_CLOCK_ENABLE : Out Std_Logic                                                                                                    -- IncludeIf_TX_Enabled
);                                                                                                                                                -- IncludeIf_TX_Enabled
End Component;                                                                                                                                              -- IncludeIf_TX_Enabled

-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
Component ReplaceWith_Designator_DIGITAL_AUDIO_DATA_ASSEMBLY_LINE Is                                                                                                                          -- IncludeIf_RX_Enabled
Generic (                                                                                                                                                                                  -- IncludeIf_RX_Enabled
    gRxFifoFreeSlotsWidth : Integer := ReplaceWith_RxFifo_DataCountWidth  --RAF: TODO                                                                                                    -- IncludeIf_RX_Enabled
--    gRxFifoFreeSlotsWidth : Integer := 10                                                                                                                                                  -- IncludeIf_RX_Enabled
);                                                                                                                                                                                         -- IncludeIf_RX_Enabled
Port (                                                                                                                                                                                     -- IncludeIf_RX_Enabled
     CLK_I : In Std_Logic;                                                                                                                                                                 -- IncludeIf_RX_Enabled
     RST_I : In Std_Logic;                                                                                                                                                                 -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
     RX_ENABLE             : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_BLOCK_START        : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FRAME_START        : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_CHANNELA_IS_ACTIVE : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_CHANNELB_IS_ACTIVE : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_AUDIO_DATA         : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_PARITY_BIT_VALID   : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_AUDIO_DATA_VALID   : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_AUDIO_END          : Out Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_USER_VALID         : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_STATUS_VALID       : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_VALIDITY_BIT       : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FLAG_PARITY_ERROR  : Out Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FLAG_BLOCK_START   : Out Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
     -- Aux Bits Buffer --TODO                                                                                                                                                             -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_CHANNELA_STATUS_DATA : Out Std_Logic_Vector(15 Downto 0);                                                                                                               -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_CHANNELB_STATUS_DATA : Out Std_Logic_Vector(15 Downto 0);                                                                                                               -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_USER_DATA_A          : Out Std_Logic_Vector(15 Downto 0);                                                                                                               -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_USER_DATA_B          : Out Std_Logic_Vector(15 Downto 0);                                                                                                               -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_WRITE_DATA           : Out Std_Logic;                                                                                                                                   -- IncludeIf_RX_Enabled
                                                                                                                                                                                           -- IncludeIf_RX_Enabled
     -- Audio Buffer Interface                                                                                                                                                             -- IncludeIf_RX_Enabled
     RX_FIFO_DATA          : Out Std_Logic_Vector(31 Downto 0);                                                                                                                            -- IncludeIf_RX_Enabled
     RX_FIFO_WRITE         : Out Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FIFO_FULL          : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FIFO_ALMOST_FULL   : In  Std_Logic;                                                                                                                                                -- IncludeIf_RX_Enabled
     RX_FIFO_FREE_SLOTS    : In  Std_Logic_Vector(gRxFifoFreeSlotsWidth - 1 Downto 0)                                                                                                      -- IncludeIf_RX_Enabled
);                                                                                                                                                                                         -- IncludeIf_RX_Enabled
End Component;                                                                                                                                                                                       -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                                           -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
Component ReplaceWith_Designator_DIGITAL_AUDIO_PHASE_DETECTOR Is                                                                                                                  -- IncludeIf_RX_Enabled
Generic (                                                                                                                                                                      -- IncludeIf_RX_Enabled
     gPulseWidthCounterWidth : Integer := 7;                                                                                                                                   -- IncludeIf_RX_Enabled
     gBitTimeCounterWidth    : Integer := 7                                                                                                                                    -- IncludeIf_RX_Enabled
);                                                                                                                                                                             -- IncludeIf_RX_Enabled
Port (                                                                                                                                                                         -- IncludeIf_RX_Enabled
     CLK_I                           : In  Std_Logic;                      -- Wishbone Clock                                                                                   -- IncludeIf_RX_Enabled
     RST_I                           : In  Std_Logic;                      -- Wishbone Reset                                                                                   -- IncludeIf_RX_Enabled
                                                                                                                                                                               -- IncludeIf_RX_Enabled
     DIGITAL_AUDIO_IN                : In  Std_Logic;                      -- SPDIF Input                                                                                      -- IncludeIf_RX_Enabled
     RX_ENABLE                       : In  Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_AUDIO_TIME_END         : In  Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_LOCKED                       : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_DATA                   : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_BLOCK_START            : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_START                  : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNELA_ACTIVE        : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNELB_ACTIVE        : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_AUDIO_ENABLE           : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_DATA_VALIDITY_ENABLE   : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_USER_DATA_ENABLE       : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNEL_STATUS_ENABLE  : Out Std_Logic;                                                                                                                          -- IncludeIf_RX_Enabled
     RX_FRAME_PARITY_ENABLE          : Out Std_Logic                                                                                                                           -- IncludeIf_RX_Enabled
);                                                                                                                                                                             -- IncludeIf_RX_Enabled
End Component;                                                                                                                                                                           -- IncludeIf_RX_Enabled
-- -----------------------------------------------------------------------------                                                                                               -- IncludeIf_RX_Enabled
-- ----------------------------------------------------------------------------                                                                      -- IncludeIf_RX_Enabled
Component ReplaceWith_Designator_DIGITAL_AUDIO_RX_FIFO Is                                                                                               -- IncludeIf_RX_Enabled
   -- ------------------------------------------------------------------------                                                                       -- IncludeIf_RX_Enabled
   Generic (                                                                                                                                         -- IncludeIf_RX_Enabled
       gFifoAddressWidth     : Integer := ReplaceWith_RxFifo_DataCountWidth;  --RAF: TODO                                                              -- IncludeIf_RX_Enabled
       gFifoDepth            : Integer := ReplaceWith_RxFifo_Depth;                                                                                    -- IncludeIf_RX_Enabled
       gFifoAlmostFullValue  : Integer := ReplaceWith_RxFifo_AlmostFullValue;                                                                       -- IncludeIf_RX_Enabled
       gFifoAlmostEmptyValue : Integer := ReplaceWith_RxFifo_AlmostEmptyValue;                                                                     -- IncludeIf_RX_Enabled
       gFifoDataWidth        : Integer := 32                                                                                                         -- IncludeIf_RX_Enabled
   );                                                                                                                                                -- IncludeIf_RX_Enabled
   Port (                                                                                                                                            -- IncludeIf_RX_Enabled
        RD_EMPTY        : Out Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_ALMOST_EMPTY : Out Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_DATA_COUNT   : Out Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
        WR_FULL         : Out Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_ALMOST_FULL  : Out Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_FREE_SLOTS   : Out Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                      -- IncludeIf_RX_Enabled

        WATERMARK       : In  Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                      -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
        RD_CLK          : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_RST          : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_EN           : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        RD_DATA         : Out Std_Logic_Vector(gFifoDataWidth - 1 Downto 0);                                                                         -- IncludeIf_RX_Enabled
                                                                                                                                                     -- IncludeIf_RX_Enabled
        WR_CLK          : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_RST          : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_EN           : In  Std_Logic;                                                                                                             -- IncludeIf_RX_Enabled
        WR_DATA         : In  Std_Logic_Vector(gFifoDataWidth - 1 Downto 0)                                                                          -- IncludeIf_RX_Enabled
   );                                                                                                                                                -- IncludeIf_RX_Enabled
   -- ------------------------------------------------------------------------                                                                       -- IncludeIf_RX_Enabled
End Component;                                                                                                                                                 -- IncludeIf_RX_Enabled

-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled
Component ReplaceWith_Designator_DIGITAL_AUDIO_TRANSMITTER Is                                                                                                                             -- IncludeIf_TX_Enabled
Generic (                                                                                                                                                                              -- IncludeIf_TX_Enabled
    gTxFifoDataCountWidht : Integer := ReplaceWith_TxFifo_FreeSlotsWidth                                                                                                                                              -- IncludeIf_TX_Enabled
);                                                                                                                                                                                     -- IncludeIf_TX_Enabled
Port (                                                                                                                                                                                 -- IncludeIf_TX_Enabled
    -- Transmitter control                                                                                                                                                             -- IncludeIf_TX_Enabled
    TX_RST             : In  Std_Logic;                                                                                                                                                -- IncludeIf_TX_Enabled
    TX_ENABLE          : In  Std_Logic;                                                                                                                                                -- IncludeIf_TX_Enabled
    CLK_BASE           : In  Std_Logic;  -- Base Audio Clock. multiple of bit rate                                                                                                     -- IncludeIf_TX_Enabled
    CLK_BASE_EN        : In  Std_Logic;  -- Prescaled Audio Clock Enable.                                                                                                              -- IncludeIf_TX_Enabled
    TX_FRAME_ENABLE    : In  Std_Logic;  -- Enable Hardware Framing                                                                                                                    -- IncludeIf_TX_Enabled
    TX_PARITY_ENABLE   : In  Std_Logic;  -- Enable Hardware Parity Generation                                                                                                          -- IncludeIf_TX_Enabled
                                                                                                                                                                                       -- IncludeIf_TX_Enabled
    -- Data Buffer                                                                                                                                                                     -- IncludeIf_TX_Enabled
    TX_FIFO_DATA       : In  Std_Logic_Vector(31 Downto 0);                                                                                                                            -- IncludeIf_TX_Enabled
    TX_FIFO_RD         : Out Std_Logic;                                                                                                                                                -- IncludeIf_TX_Enabled
    TX_FIFO_EMPTY      : In  Std_Logic;                                                                                                                                                -- IncludeIf_TX_Enabled
    TX_FIFO_DATA_COUNT : In  Std_Logic_Vector(gTxFifoDataCountWidht - 1 Downto 0);                                                                                                     -- IncludeIf_TX_Enabled
    TX_AUX_CHANNEL_DATA      : In Std_Logic_Vector(31 Downto 0);                                                                                                                       -- IncludeIf_TX_Enabled
    TX_AUX_CHANNEL_DATA_READ : Out Std_Logic;                                                                                                                                          -- IncludeIf_TX_Enabled
    TX_AUX_USER_DATA         : In  Std_Logic_Vector(31 Downto 0);                                                                                                                      -- IncludeIf_TX_Enabled
    TX_AUX_USER_DATA_READ    : Out Std_Logic;                                                                                                                                          -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_ENABLE     : In  Std_Logic;                                                                                                                                          -- IncludeIf_TX_Enabled
    -- Bi-Phase output                                                                                                                                                                 -- IncludeIf_TX_Enabled
    DIGITAL_AUDIO_OUT  : Out Std_Logic                                                                                                                                                 -- IncludeIf_TX_Enabled
);                                                                                                                                                                                     -- IncludeIf_TX_Enabled
End Component;                                                                                                                                                                                   -- IncludeIf_TX_Enabled
-- -----------------------------------------------------------------------------                                                                                                       -- IncludeIf_TX_Enabled

--------------------------------------------------------------------------------                                                                                -- IncludeIf_TX_Enabled
Component ReplaceWith_Designator_DIGITAL_AUDIO_TX_FIFO is                                                                                                          -- IncludeIf_TX_Enabled
   Generic (                                                                                                                                                    -- IncludeIf_TX_Enabled
       gFifoAddressWidth     : Integer := ReplaceWith_TxFifo_FreeSlotsWidth;                                                                                    -- IncludeIf_TX_Enabled
       gFifoDepth            : Integer := ReplaceWith_TxFifo_Depth;                                                                                               -- IncludeIf_TX_Enabled
       gFifoAlmostFullValue  : Integer := ReplaceWith_TxFifo_AlmostFullValue;                                                                                  -- IncludeIf_TX_Enabled
       gFifoAlmostEmptyValue : Integer := ReplaceWith_TxFifo_AlmostEmptyValue;                                                                                -- IncludeIf_TX_Enabled
       gFifoDataWidth        : Integer := 32                                                                                                                    -- IncludeIf_TX_Enabled
   );                                                                                                                                                           -- IncludeIf_TX_Enabled
port (                                                                                                                                                          -- IncludeIf_TX_Enabled
    RD_RST          : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    WR_RST          : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    WR_EN           : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    WR_DATA         : in  std_logic_vector(gFifoDataWidth - 1 downto 0);                                                                                        -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    RD_EN           : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    RD_DATA         : out std_logic_vector(gFifoDataWidth - 1 downto 0);                                                                                        -- IncludeIf_TX_Enabled

    WATERMARK       : in  Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                                     -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    WR_FREE_SLOTS   : Out Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                                     -- IncludeIf_TX_Enabled
    WR_ALMOST_FULL  : out std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    WR_FULL         : out std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    RD_DATA_COUNT   : Out Std_Logic_Vector(gFifoAddressWidth - 1 Downto 0);                                                                                     -- IncludeIf_TX_Enabled
    RD_ALMOST_EMPTY : out std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    RD_EMPTY        : out std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
                                                                                                                                                                -- IncludeIf_TX_Enabled
    RD_CLK          : in  std_logic;                                                                                                                            -- IncludeIf_TX_Enabled
    WR_CLK          : in  std_logic                                                                                                                             -- IncludeIf_TX_Enabled
);                                                                                                                                                              -- IncludeIf_TX_Enabled
end Component;                                                                                                                                                            -- IncludeIf_TX_Enabled


-- ----------------------------------------------------------------------------
Component ReplaceWith_Designator_DIGITAL_AUDIO_AUX_BUFFER Is
Generic(
    gMemoryDepth : Integer := 12
);
Port (
    RD_CLK    : In  Std_Logic;
    RD_RST    : In  Std_Logic;
    RD_DATA   : Out Std_Logic_Vector(31 Downto 0);
    RD_ENABLE : In  Std_Logic;

    WR_CLK    : In  Std_Logic;
    WR_RST    : In  Std_Logic;
    WR_DATA   : In  Std_Logic_Vector(31 Downto 0);
    WR_ENABLE : In  Std_Logic
);
End Component;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Component ReplaceWith_Designator_DIGITAL_AUDIO_WISHBONE Is
Generic (
    gRxFifo_DataCountWidth : Integer := ReplaceWith_RxFifo_DataCountWidth;     --RAF: TODO
    gTxFifo_FreeSlotsWidth : Integer := ReplaceWith_TxFifo_FreeSlotsWidth;     --RAF: TODO
    gRxCoreRevision        : Integer := ReplaceWith_RxCoreRevision;
    gTxCoreRevision        : Integer := ReplaceWith_TxCoreRevision;
    gWbAdrWidth            : Integer := 5
);
Port (

    -- Receiver Interface                                                                -- IncludeIf_RX_Enabled
    RX_FIFO_CLK          : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_DATA         : In  Std_Logic_Vector(31 Downto 0);                            -- IncludeIf_RX_Enabled
    RX_FIFO_READ         : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_EMPTY        : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_FULL         : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_ALMOST_FULL  : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_DATA_COUNT   : In  Std_Logic_Vector(gRxFifo_DataCountWidth - 1 Downto 0);    -- IncludeIf_RX_Enabled
    RX_FIFO_WATERMARK    : Out Std_Logic_Vector(gRxFifo_DataCountWidth - 1 Downto 0);    -- IncludeIf_RX_Enabled
    RX_ENABLE            : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_RST               : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FIFO_RST          : Out Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_PE                : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_SOB               : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_NO_LOCK           : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FLAG_PARITY_ERROR : In  Std_Logic;                                                -- IncludeIf_RX_Enabled
    RX_FLAG_BLOCK_START  : In  Std_Logic;                                                -- IncludeIf_RX_Enabled

    RX_AUX_BUFFER_CHANNEL_DATA      : In  Std_Logic_Vector(31 Downto 0);                 -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_CHANNEL_DATA_READ : Out Std_Logic;                                     -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_USER_DATA         : In  Std_Logic_Vector(31 Downto 0);                 -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_USER_DATA_READ    : Out Std_Logic;                                     -- IncludeIf_RX_Enabled


    -- Transmitter Interface                                                            -- IncludeIf_TX_Enabled
    TX_RST               : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_FIFO_CLK          : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_FIFO_RST          : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_FIFO_DATA         : Out Std_Logic_Vector(31 Downto 0);                           -- IncludeIf_TX_Enabled
    TX_FIFO_WRITE        : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_FIFO_EMPTY        : In  Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_FIFO_ALMOST_EMPTY : In  Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_FIFO_FULL         : In  Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_FIFO_FREE_SLOTS   : In  Std_Logic_Vector(gTxFifo_FreeSlotsWidth - 1 Downto 0);   -- IncludeIf_TX_Enabled
    TX_FIFO_WATERMARK    : Out Std_Logic_Vector(gTxFifo_FreeSlotsWidth - 1 Downto 0);   -- IncludeIf_TX_Enabled
    TX_ENABLE            : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_PRESCALER         : Out Std_Logic_Vector(7 Downto 0);                            -- IncludeIf_TX_Enabled
    TX_PRESCALER_ENABLE  : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_FRAME_ENABLE      : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_PARITY_ENABLE     : Out Std_Logic;                                               -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_CHANNEL_DATA       : Out Std_Logic_Vector(31 Downto 0);               -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_CHANNEL_DATA_WRITE : Out Std_Logic;                                   -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USER_DATA          : Out Std_Logic_Vector(31 Downto 0);               -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USER_DATA_WRITE    : Out Std_Logic;                                   -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USE                : Out Std_Logic;                                   -- IncludeIf_TX_Enabled

    -- Wishbone Interface
    INT_O : Out Std_Logic;
    STB_I : In  Std_Logic;
    CYC_I : In  Std_Logic;
    ADR_I : In  Std_Logic_Vector(gWbAdrWidth - 1 Downto 0);
    DAT_I : In  Std_Logic_Vector(31 Downto 0);
    DAT_O : Out Std_Logic_Vector(31 Downto 0);
    WE_I  : In  Std_Logic;
    ACK_O : Out Std_Logic;
    CLK_I : In  Std_Logic;
    RST_I : In  Std_Logic
);
End Component;
-- ----------------------------------------------------------------------------

Signal Signal_Gnd : Std_Logic;
                                                                                                                    -- IncludeIf_RX_Enabled
Signal RxRst                       : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxEnable                    : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameStart                : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameData                 : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameBlockStart           : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameAudioEnable          : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameDVEnable             : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameUDEnable             : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameCSEnable             : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFramePEnable              : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameChannelAActive       : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameChannelBActive       : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFrameAudioEnd             : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFifoData                  : Std_Logic_Vector(31 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxFifoWrite                 : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFifoFull                  : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFifoAlmostFull            : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFifoFreeSlots             : Std_Logic_Vector(ReplaceWith_RxFifo_DataCountWidth - 1 Downto 0);              -- IncludeIf_RX_Enabled
Signal RxFifoReset                 : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFifoEmpty                 : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFifoAlmostEmtpy           : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFifoDataCount             : Std_Logic_Vector(ReplaceWith_RxFifo_DataCountWidth - 1 Downto 0);              -- IncludeIf_RX_Enabled
Signal RxFifoWatermark             : Std_Logic_Vector(ReplaceWith_RxFifo_DataCountWidth - 1 Downto 0);              -- IncludeIf_RX_Enabled
Signal RxFifoRead                  : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFifoReadData              : Std_Logic_Vector(31 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxFifoAlmostEmpty           : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFifoReadClk               : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxAuxBuffer_ChannelAStatus  : Std_Logic_Vector(15 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxAuxBuffer_ChannelBStatus  : Std_Logic_Vector(15 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxAuxBuffer_UserDataA       : Std_Logic_Vector(15 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxAuxBuffer_UserDataB       : Std_Logic_Vector(15 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxAuxBuffer_WriteEnable     : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxAuxBufferChannelData      : Std_Logic_Vector(31 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxAuxBufferUserData         : Std_Logic_Vector(31 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxFromAuxBufferChannelData  : Std_Logic_Vector(31 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxFromAuxBufferUserData     : Std_Logic_Vector(31 Downto 0);                                                 -- IncludeIf_RX_Enabled
Signal RxFromAuxBufferUserDataRead : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFromAuxBufferChannelRead  : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFlagParityError           : Std_Logic;                                                                     -- IncludeIf_RX_Enabled
Signal RxFlagBlockStart            : Std_Logic;                                                                     -- IncludeIf_RX_Enabled

Signal TxClockEnable                  : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxPrescalerEnable              : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxPrescaler                    : Std_Logic_Vector(7 Downto 0);                                               -- IncludeIf_TX_Enabled
Signal TxRst                          : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxEnable                       : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoData                     : Std_Logic_Vector(31 Downto 0);                                              -- IncludeIf_TX_Enabled
Signal TxFifoRead                     : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoDataCount                : Std_Logic_Vector(ReplaceWith_TxFifo_FreeSlotsWidth - 1 Downto 0);           -- IncludeIf_TX_Enabled
Signal TxFifoWatermark                : Std_Logic_Vector(ReplaceWith_TxFifo_FreeSlotsWidth - 1 Downto 0);           -- IncludeIf_TX_Enabled
Signal TxFrameEnable                  : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxParityEnable                 : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoReset                    : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoAlmostEmpty              : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoEmpty                    : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoClock                    : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoWrite                    : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoFull                     : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoAlmostFull               : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFifoFreeSlots                : Std_Logic_Vector(ReplaceWith_TxFifo_FreeSlotsWidth - 1 Downto 0);           -- IncludeIf_TX_Enabled
Signal TxFifoWriteData                : Std_Logic_Vector(31 Downto 0);                                              -- IncludeIf_TX_Enabled
Signal TxFromAuxBufferChannelData     : Std_Logic_Vector(31 Downto 0);                                              -- IncludeIf_TX_Enabled
Signal TxFromAuxBufferChannelDataRead : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxFromAuxBufferUserData        : Std_Logic_Vector(31 Downto 0);                                              -- IncludeIf_TX_Enabled
Signal TxFromAuxBufferUserDataRead    : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxToAuxBufferChannelData       : Std_Logic_Vector(31 Downto 0);                                              -- IncludeIf_TX_Enabled
Signal TxToAuxBufferChannelDataWrite  : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxToAuxBufferUserData          : Std_Logic_Vector(31 Downto 0);                                              -- IncludeIf_TX_Enabled
Signal TxToAuxBufferUserDataWrite     : Std_Logic;                                                                  -- IncludeIf_TX_Enabled
Signal TxAuxBufferEnable              : Std_Logic;                                                                  -- IncludeIf_TX_Enabled


-- -----------------------------------------------------------------------------
-- Architecture Start
-- -----------------------------------------------------------------------------
Begin

-- -----------------------------------------------------------------------------                                                 -- IncludeIf_TX_Enabled
U_ReplaceWith_Designator_DIGITAL_AUDIO_CLOCK_GENERATOR : ReplaceWith_Designator_DIGITAL_AUDIO_CLOCK_GENERATOR                    -- IncludeIf_TX_Enabled
Port Map (                                                                                                                       -- IncludeIf_TX_Enabled
    CLK_BASE                   => CLK_BASE,                                                                                      -- IncludeIf_TX_Enabled
    CLK_PRESCALER              => TxPrescaler,                                                                                   -- IncludeIf_TX_Enabled
    CLK_PRESCALER_ENABLE       => TxPrescalerEnable,                                                                             -- IncludeIf_TX_Enabled
    DIGITAL_AUDIO_CLOCK_ENABLE => TxClockEnable                                                                                  -- IncludeIf_TX_Enabled
);                                                                                                                               -- IncludeIf_TX_Enabled

U_ReplaceWith_Designator_DIGITAL_AUDIO_DATA_ASSEMBLY_LINE : ReplaceWith_Designator_DIGITAL_AUDIO_DATA_ASSEMBLY_LINE              -- IncludeIf_RX_Enabled
Port Map (                                                                                                                       -- IncludeIf_RX_Enabled
     CLK_I                              => CLK_I,                                                                                -- IncludeIf_RX_Enabled
     RST_I                              => RxRst,                                                                                -- IncludeIf_RX_Enabled
     RX_ENABLE                          => RxEnable,                                                                             -- IncludeIf_RX_Enabled
     RX_BLOCK_START                     => RxFrameBlockStart,                                                                    -- IncludeIf_RX_Enabled
     RX_FRAME_START                     => RxFrameStart,                                                                         -- IncludeIf_RX_Enabled
     RX_CHANNELA_IS_ACTIVE              => RxFrameChannelAActive,                                                                -- IncludeIf_RX_Enabled
     RX_CHANNELB_IS_ACTIVE              => RxFrameChannelBActive,                                                                -- IncludeIf_RX_Enabled
     RX_AUDIO_DATA                      => RxFrameData,                                                                          -- IncludeIf_RX_Enabled
     RX_PARITY_BIT_VALID                => RxFramePEnable,                                                                       -- IncludeIf_RX_Enabled
     RX_AUDIO_DATA_VALID                => RxFrameAudioEnable,                                                                   -- IncludeIf_RX_Enabled
     RX_AUDIO_END                       => RxFrameAudioEnd,                                                                      -- IncludeIf_RX_Enabled
     RX_USER_VALID                      => RxFrameUDEnable,                                                                      -- IncludeIf_RX_Enabled
     RX_STATUS_VALID                    => RxFrameCSEnable,                                                                      -- IncludeIf_RX_Enabled
     RX_VALIDITY_BIT                    => RxFrameDVEnable,                                                                      -- IncludeIf_RX_Enabled
     RX_FLAG_PARITY_ERROR               => RxFlagParityError,                                                                    -- IncludeIf_RX_Enabled
     RX_FLAG_BLOCK_START                => RxFlagBlockStart,                                                                     -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_CHANNELA_STATUS_DATA => RxAuxBuffer_ChannelAStatus,                                                           -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_CHANNELB_STATUS_DATA => RxAuxBuffer_ChannelBStatus,                                                           -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_USER_DATA_A          => RxAuxBuffer_UserDataA,                                                                -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_USER_DATA_B          => RxAuxBuffer_UserDataB,                                                                -- IncludeIf_RX_Enabled
     RX_AUX_BUFFER_WRITE_DATA           => RxAuxBuffer_WriteEnable,                                                              -- IncludeIf_RX_Enabled
     RX_FIFO_DATA                       => RxFifoData,                                                                           -- IncludeIf_RX_Enabled
     RX_FIFO_WRITE                      => RxFifoWrite,                                                                          -- IncludeIf_RX_Enabled
     RX_FIFO_FULL                       => RxFifoFull,                                                                           -- IncludeIf_RX_Enabled
     RX_FIFO_ALMOST_FULL                => RxFifoAlmostFull,                                                                     -- IncludeIf_RX_Enabled
     RX_FIFO_FREE_SLOTS                 => RxFifoFreeSlots                                                                       -- IncludeIf_RX_Enabled
);                                                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                 -- IncludeIf_RX_Enabled
                                                                                                                                 -- IncludeIf_RX_Enabled
RxAuxBufferChannelData <= RxAuxBuffer_ChannelAStatus & RxAuxBuffer_ChannelBStatus;                                               -- IncludeIf_RX_Enabled
RxAuxBufferUserData    <= RxAuxBuffer_UserDataA & RxAuxBuffer_UserDataB;                                                         -- IncludeIf_RX_Enabled
                                                                                                                                 -- IncludeIf_RX_Enabled
                                                                                                                                 -- IncludeIf_RX_Enabled
U_ReplaceWith_Designator_DIGITAL_AUDIO_RX_AUX_BUFFER_CHANNELSTATUS : ReplaceWith_Designator_DIGITAL_AUDIO_AUX_BUFFER             -- IncludeIf_RX_Enabled
Port Map (                                                                                                                       -- IncludeIf_RX_Enabled
    RD_CLK    => CLK_I,                                                                                                          -- IncludeIf_RX_Enabled
    RD_RST    => RxRst,                                                                                                          -- IncludeIf_RX_Enabled
    RD_DATA   => RxFromAuxBufferChannelData,                                                                                     -- IncludeIf_RX_Enabled
    RD_ENABLE => RxFromAuxBufferChannelRead,                                                                                     -- IncludeIf_RX_Enabled
                                                                                                                                 -- IncludeIf_RX_Enabled
    WR_CLK    => CLK_I,                                                                                                          -- IncludeIf_RX_Enabled
    WR_RST    => RxRst,                                                                                                          -- IncludeIf_RX_Enabled
    WR_DATA   => RxAuxBufferChannelData,                                                                                         -- IncludeIf_RX_Enabled
    WR_ENABLE => RxAuxBuffer_WriteEnable                                                                                         -- IncludeIf_RX_Enabled
);                                                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                 -- IncludeIf_RX_Enabled
U_ReplaceWith_Designator_DIGITAL_AUDIO_RX_AUX_BUFFER_USERDATA : ReplaceWith_Designator_DIGITAL_AUDIO_AUX_BUFFER                  -- IncludeIf_RX_Enabled
Port Map (                                                                                                                       -- IncludeIf_RX_Enabled
    RD_CLK    => CLK_I,                                                                                                          -- IncludeIf_RX_Enabled
    RD_RST    => RxRst,                                                                                                          -- IncludeIf_RX_Enabled
    RD_DATA   => RxFromAuxBufferUserData,                                                                                        -- IncludeIf_RX_Enabled
    RD_ENABLE => RxFromAuxBufferUserDataRead,                                                                                    -- IncludeIf_RX_Enabled
                                                                                                                                 -- IncludeIf_RX_Enabled
    WR_CLK    => CLK_I,                                                                                                          -- IncludeIf_RX_Enabled
    WR_RST    => RxRst,                                                                                                          -- IncludeIf_RX_Enabled
    WR_DATA   => RxAuxBufferUserData,                                                                                            -- IncludeIf_RX_Enabled
    WR_ENABLE => RxAuxBuffer_WriteEnable                                                                                         -- IncludeIf_RX_Enabled
);                                                                                                                               -- IncludeIf_RX_Enabled
                                                                                                                                 -- IncludeIf_RX_Enabled
                                                                                                                                 -- IncludeIf_RX_Enabled
U_ReplaceWith_Designator_DIGITAL_AUDIO_PHASE_DETECTOR : ReplaceWith_Designator_DIGITAL_AUDIO_PHASE_DETECTOR                      -- IncludeIf_RX_Enabled
Port Map (                                                                                                                       -- IncludeIf_RX_Enabled
     CLK_I                           => CLK_I,                                                                                   -- IncludeIf_RX_Enabled
     RST_I                           => RxRst,                                                                                   -- IncludeIf_RX_Enabled
     DIGITAL_AUDIO_IN                => SPDIF_IN,                                                                                -- IncludeIf_RX_Enabled
     RX_ENABLE                       => RxEnable,                                                                                -- IncludeIf_RX_Enabled
     RX_FRAME_AUDIO_TIME_END         => RxFrameAudioEnd,                                                                         -- IncludeIf_RX_Enabled
     RX_LOCKED                       => Open,                                                                                    -- IncludeIf_RX_Enabled
     RX_FRAME_DATA                   => RxFrameData,                                                                             -- IncludeIf_RX_Enabled
     RX_FRAME_BLOCK_START            => RxFrameBlockStart,                                                                       -- IncludeIf_RX_Enabled
     RX_FRAME_START                  => RxFrameStart,                                                                            -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNELA_ACTIVE        => RxFrameChannelAActive,                                                                   -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNELB_ACTIVE        => RxFrameChannelBActive,                                                                   -- IncludeIf_RX_Enabled
     RX_FRAME_AUDIO_ENABLE           => RxFrameAudioEnable,                                                                      -- IncludeIf_RX_Enabled
     RX_FRAME_DATA_VALIDITY_ENABLE   => RxFrameDVEnable,                                                                         -- IncludeIf_RX_Enabled
     RX_FRAME_USER_DATA_ENABLE       => RxFrameUDEnable,                                                                         -- IncludeIf_RX_Enabled
     RX_FRAME_CHANNEL_STATUS_ENABLE  => RxFrameCSEnable,                                                                         -- IncludeIf_RX_Enabled
     RX_FRAME_PARITY_ENABLE          => RxFramePEnable                                                                           -- IncludeIf_RX_Enabled
);                                                                                                                               -- IncludeIf_RX_Enabled


U_ReplaceWith_Designator_DIGITAL_AUDIO_RX_FIFO : ReplaceWith_Designator_DIGITAL_AUDIO_RX_FIFO                                    -- IncludeIf_RX_Enabled
   Port Map (                                                                                                                    -- IncludeIf_RX_Enabled
        RD_EMPTY        => RxFifoEmpty,                                                                                          -- IncludeIf_RX_Enabled
        RD_ALMOST_EMPTY => RxFifoAlmostEmpty,                                                                                    -- IncludeIf_RX_Enabled
        RD_DATA_COUNT   => RxFifoDataCount,                                                                                      -- IncludeIf_RX_Enabled
        WR_FULL         => RxFifoFull,                                                                                           -- IncludeIf_RX_Enabled
        WR_ALMOST_FULL  => RxFifoAlmostFull,                                                                                     -- IncludeIf_RX_Enabled
        WR_FREE_SLOTS   => RxFifoFreeSlots,                                                                                      -- IncludeIf_RX_Enabled
        RD_CLK          => RxFifoReadClk,                                                                                        -- IncludeIf_RX_Enabled
        RD_RST          => RxFifoReset,                                                                                          -- IncludeIf_RX_Enabled
        RD_EN           => RxFifoRead,                                                                                           -- IncludeIf_RX_Enabled
        RD_DATA         => RxFifoReadData,                                                                                       -- IncludeIf_RX_Enabled
        WATERMARK       => RxFifoWatermark,                                                                                      -- IncludeIf_RX_Enabled
        WR_CLK          => CLK_I,                                                                                                -- IncludeIf_RX_Enabled
        WR_RST          => RxFifoReset,                                                                                          -- IncludeIf_RX_Enabled
        WR_EN           => RxFifoWrite,                                                                                          -- IncludeIf_RX_Enabled
        WR_DATA         => RxFifoData                                                                                            -- IncludeIf_RX_Enabled
   );                                                                                                                            -- IncludeIf_RX_Enabled
   -- ------------------------------------------------------------------------                                                   -- IncludeIf_RX_Enabled

U_ReplaceWith_Designator_DIGITAL_AUDIO_TRANSMITTER : ReplaceWith_Designator_DIGITAL_AUDIO_TRANSMITTER                            -- IncludeIf_TX_Enabled
Port Map (                                                                                                                       -- IncludeIf_TX_Enabled
    TX_RST             => TxRst,                                                                                                 -- IncludeIf_TX_Enabled
    TX_ENABLE          => TxEnable,                                                                                              -- IncludeIf_TX_Enabled
    CLK_BASE           => CLK_BASE,                                                                                              -- IncludeIf_TX_Enabled
    CLK_BASE_EN        => TxClockEnable,                                                                                         -- IncludeIf_TX_Enabled
    TX_FRAME_ENABLE    => TxFrameEnable,                                                                                         -- IncludeIf_TX_Enabled
    TX_PARITY_ENABLE   => TxParityEnable,                                                                                        -- IncludeIf_TX_Enabled
    TX_FIFO_DATA       => TxFifoData,                                                                                            -- IncludeIf_TX_Enabled
    TX_FIFO_RD         => TxFifoRead,                                                                                            -- IncludeIf_TX_Enabled
    TX_FIFO_EMPTY      => TxFifoEmpty,                                                                                           -- IncludeIf_TX_Enabled
    TX_FIFO_DATA_COUNT => TxFifoDataCount,                                                                                       -- IncludeIf_TX_Enabled
    TX_AUX_CHANNEL_DATA      => TxFromAuxBufferChannelData,                                                                      -- IncludeIf_TX_Enabled
    TX_AUX_CHANNEL_DATA_READ => TxFromAuxBufferChannelDataRead,                                                                  -- IncludeIf_TX_Enabled
    TX_AUX_USER_DATA         => TxFromAuxBufferUserData,                                                                         -- IncludeIf_TX_Enabled
    TX_AUX_USER_DATA_READ    => TxFromAuxBufferUserDataRead,                                                                     -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_ENABLE     => TxAuxBufferEnable,                                                                               -- IncludeIf_TX_Enabled
    DIGITAL_AUDIO_OUT  => SPDIF_OUT                                                                                              -- IncludeIf_TX_Enabled
);                                                                                                                               -- IncludeIf_TX_Enabled


U_ReplaceWith_Designator_DIGITAL_AUDIO_TX_FIFO : ReplaceWith_Designator_DIGITAL_AUDIO_TX_FIFO                                    -- IncludeIf_TX_Enabled
port Map (                                                                                                                       -- IncludeIf_TX_Enabled
    RD_RST          => TxFifoReset,                                                                                              -- IncludeIf_TX_Enabled
    WR_RST          => TxFifoReset,                                                                                              -- IncludeIf_TX_Enabled
    WR_EN           => TxFifoWrite,                                                                                              -- IncludeIf_TX_Enabled
    WR_DATA         => TxFifoWriteData,                                                                                          -- IncludeIf_TX_Enabled
    RD_EN           => TxFifoRead,                                                                                               -- IncludeIf_TX_Enabled
    RD_DATA         => TxFifoData,                                                                                               -- IncludeIf_TX_Enabled
    WATERMARK       => TxFifoWatermark,                                                                                          -- IncludeIf_TX_Enabled
    WR_FREE_SLOTS   => TxFifoFreeSlots,                                                                                          -- IncludeIf_TX_Enabled
    WR_ALMOST_FULL  => TxFifoAlmostFull,                                                                                         -- IncludeIf_TX_Enabled
    WR_FULL         => TxFifoFull,                                                                                               -- IncludeIf_TX_Enabled
    RD_DATA_COUNT   => TxFifoDataCount,                                                                                          -- IncludeIf_TX_Enabled
    RD_ALMOST_EMPTY => TxFifoAlmostEmpty,                                                                                        -- IncludeIf_TX_Enabled
    RD_EMPTY        => TxFifoEmpty,                                                                                              -- IncludeIf_TX_Enabled
    RD_CLK          => CLK_BASE,                                                                                                 -- IncludeIf_TX_Enabled
    WR_CLK          => TxFifoClock                                                                                               -- IncludeIf_TX_Enabled
);                                                                                                                               -- IncludeIf_TX_Enabled

U_ReplaceWith_Designator_DIGITAL_AUDIO_TX_AUX_BUFFER_CHANNELSTATUS : ReplaceWith_Designator_DIGITAL_AUDIO_AUX_BUFFER             -- IncludeIf_TX_Enabled
Port Map (                                                                                                                       -- IncludeIf_TX_Enabled
    RD_CLK    => CLK_BASE,                                                                                                       -- IncludeIf_TX_Enabled
    RD_RST    => TxRst,                                                                                                          -- IncludeIf_TX_Enabled
    RD_DATA   => TxFromAuxBufferChannelData,                                                                                     -- IncludeIf_TX_Enabled
    RD_ENABLE => TxFromAuxBufferChannelDataRead,                                                                                 -- IncludeIf_TX_Enabled
                                                                                                                                 -- IncludeIf_TX_Enabled
    WR_CLK    => CLK_I,                                                                                                          -- IncludeIf_TX_Enabled
    WR_RST    => TxFifoReset,                                                                                                    -- IncludeIf_TX_Enabled
    WR_DATA   => TxToAuxBufferChannelData,                                                                                       -- IncludeIf_TX_Enabled
    WR_ENABLE => TxToAuxBufferChannelDataWrite                                                                                   -- IncludeIf_TX_Enabled
);                                                                                                                               -- IncludeIf_TX_Enabled
                                                                                                                                 -- IncludeIf_TX_Enabled
U_ReplaceWith_Designator_DIGITAL_AUDIO_TX_AUX_BUFFER_USERDATA : ReplaceWith_Designator_DIGITAL_AUDIO_AUX_BUFFER                  -- IncludeIf_TX_Enabled
Port Map (                                                                                                                       -- IncludeIf_TX_Enabled
    RD_CLK    => CLK_BASE,                                                                                                       -- IncludeIf_TX_Enabled
    RD_RST    => TxRst,                                                                                                          -- IncludeIf_TX_Enabled
    RD_DATA   => TxFromAuxBufferUserData,                                                                                        -- IncludeIf_TX_Enabled
    RD_ENABLE => TxFromAuxBufferUserDataRead,                                                                                    -- IncludeIf_TX_Enabled
                                                                                                                                 -- IncludeIf_TX_Enabled
    WR_CLK    => CLK_I,                                                                                                          -- IncludeIf_TX_Enabled
    WR_RST    => TxFifoReset,                                                                                                    -- IncludeIf_TX_Enabled
    WR_DATA   => TxToAuxBufferUserData,                                                                                          -- IncludeIf_TX_Enabled
    WR_ENABLE => TxToAuxBufferUserDataWrite                                                                                      -- IncludeIf_TX_Enabled
);                                                                                                                               -- IncludeIf_TX_Enabled
                                                                                                                                 -- IncludeIf_TX_Enabled
                                                                                                                                 -- IncludeIf_TX_Enabled


U_ReplaceWith_Designator_DIGITAL_AUDIO_WISHBONE : ReplaceWith_Designator_DIGITAL_AUDIO_WISHBONE
Port Map (

    RX_FIFO_CLK                     => RxFifoReadClk,                           -- IncludeIf_RX_Enabled
    RX_FIFO_DATA                    => RxFifoReadData,                          -- IncludeIf_RX_Enabled
    RX_FIFO_READ                    => RxFifoRead,                              -- IncludeIf_RX_Enabled
    RX_FIFO_EMPTY                   => RxFifoEmpty,                             -- IncludeIf_RX_Enabled
    RX_FIFO_FULL                    => RxFifoFull,                              -- IncludeIf_RX_Enabled
    RX_FIFO_ALMOST_FULL             => RxFifoAlmostFull,                        -- IncludeIf_RX_Enabled
    RX_FIFO_DATA_COUNT              => RxFifoDataCount,                         -- IncludeIf_RX_Enabled
    RX_FIFO_WATERMARK               => RxFifoWatermark,                         -- IncludeIf_RX_Enabled
    RX_ENABLE                       => RxEnable,                                -- IncludeIf_RX_Enabled
    RX_RST                          => RxRst,                                   -- IncludeIf_RX_Enabled
    RX_FIFO_RST                     => RxFifoReset,                             -- IncludeIf_RX_Enabled
    RX_PE                           => Signal_Gnd,                              -- IncludeIf_RX_Enabled
    RX_SOB                          => Signal_Gnd,                              -- IncludeIf_RX_Enabled
    RX_NO_LOCK                      => Signal_Gnd,                              -- IncludeIf_RX_Enabled
    RX_FLAG_PARITY_ERROR            => RxFlagParityError,                       -- IncludeIf_RX_Enabled
    RX_FLAG_BLOCK_START             => RxFlagBlockStart,                        -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_CHANNEL_DATA      => RxFromAuxBufferChannelData,              -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_CHANNEL_DATA_READ => RxFromAuxBufferChannelRead,              -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_USER_DATA         => RxFromAuxBufferUserData,                 -- IncludeIf_RX_Enabled
    RX_AUX_BUFFER_USER_DATA_READ    => RxFromAuxBufferUserDataRead,             -- IncludeIf_RX_Enabled


    TX_RST                           => TxRst,                                  -- IncludeIf_TX_Enabled
    TX_FIFO_CLK                      => TxFifoClock,                            -- IncludeIf_TX_Enabled
    TX_FIFO_RST                      => TxFifoReset,                            -- IncludeIf_TX_Enabled
    TX_FIFO_DATA                     => TxFifoWriteData,                        -- IncludeIf_TX_Enabled
    TX_FIFO_WRITE                    => TxFifoWrite,                            -- IncludeIf_TX_Enabled
    TX_FIFO_EMPTY                    => TxFifoEmpty,                            -- IncludeIf_TX_Enabled
    TX_FIFO_ALMOST_EMPTY             => TxFifoAlmostEmpty,                      -- IncludeIf_TX_Enabled
    TX_FIFO_FULL                     => TxFifoFull,                             -- IncludeIf_TX_Enabled
    TX_FIFO_FREE_SLOTS               => TxFifoFreeSlots,                        -- IncludeIf_TX_Enabled
    TX_FIFO_WATERMARK                => TxFifoWatermark,                        -- IncludeIf_TX_Enabled
    TX_ENABLE                        => TxEnable,                               -- IncludeIf_TX_Enabled
    TX_PRESCALER                     => TxPrescaler,                            -- IncludeIf_TX_Enabled
    TX_PRESCALER_ENABLE              => TxPrescalerEnable,                      -- IncludeIf_TX_Enabled
    TX_FRAME_ENABLE                  => TxFrameEnable,                          -- IncludeIf_TX_Enabled
    TX_PARITY_ENABLE                 => TxParityEnable,                         -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_CHANNEL_DATA       => TxToAuxBufferChannelData,               -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_CHANNEL_DATA_WRITE => TxToAuxBufferChannelDataWrite,          -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USER_DATA          => TxToAuxBufferUserData,                  -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USER_DATA_WRITE    => TxToAuxBufferUserDataWrite,             -- IncludeIf_TX_Enabled
    TX_AUX_BUFFER_USE                => TxAuxBufferEnable,                      -- IncludeIf_TX_Enabled

    INT_O                => INT_O,
    STB_I                => STB_I,
    CYC_I                => CYC_I,
    ADR_I                => ADR_I,
    DAT_I                => DAT_I,
    DAT_O                => DAT_O,
    WE_I                 => WE_I ,
    ACK_O                => ACK_O,
    CLK_I                => CLK_I,
    RST_I                => RST_I
);

Signal_Gnd <= '0';
End RTL;





