-- ----------------------------------------------------------------------------
Library IEEE;
Use     IEEE.Std_Logic_1164.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_EntityName Is
    Port (
        -- IO wishbone
        STB_I      : in  std_logic;
        CYC_I      : in  std_logic;
        ACK_O      : out std_logic;
        ADR_I      : in  std_logic_vector(3 downto 0);
        DAT_O      : out std_logic_vector(31 downto 0);
        DAT_I      : in  std_logic_vector(31 downto 0);
        WE_I       : in  std_logic;
        CLK_I      : in  std_logic;
        RST_I      : in  std_logic;
        INT_O      : out std_logic;

        -- scratch memory wishbone
        M2_STB_O   : out std_logic;                         --IncludeIf_ExternalScratchMemory
        M2_CYC_O   : out std_logic;                         --IncludeIf_ExternalScratchMemory
        M2_ACK_I   : in  std_logic;                         --IncludeIf_ExternalScratchMemory
        M2_ADR_O   : out std_logic_vector(31 downto 0);     --IncludeIf_ExternalScratchMemory
        M2_DAT_I   : in  std_logic_vector(31 downto 0);     --IncludeIf_ExternalScratchMemory
        M2_DAT_O   : out std_logic_vector(31 downto 0);     --IncludeIf_ExternalScratchMemory
        M2_SEL_O   : out std_logic_vector(3 downto 0);      --IncludeIf_ExternalScratchMemory
        M2_WE_O    : out std_logic;                         --IncludeIf_ExternalScratchMemory

        -- data memory wishbone
        M_STB_O    : out std_logic;
        M_CYC_O    : out std_logic;
        M_ACK_I    : in  std_logic;
        M_ADR_O    : out std_logic_vector(31 downto 0);
        M_DAT_I    : in  std_logic_vector(31 downto 0);
        M_DAT_O    : out std_logic_vector(31 downto 0);
        M_SEL_O    : out std_logic_vector(3 downto 0);
        M_WE_O     : out std_logic
    );
End ReplaceWith_EntityName;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_EntityName Is
-- ----------------------------------------------------------------------------
    Component WB_MP3DEC Is
    Port (
        -- IO wishbone
        STB_I      : in  std_logic;
        CYC_I      : in  std_logic;
        ACK_O      : out std_logic;
        ADR_I      : in  std_logic_vector(3 downto 0);
        DAT_O      : out std_logic_vector(31 downto 0);
        DAT_I      : in  std_logic_vector(31 downto 0);
        WE_I       : in  std_logic;
        CLK_I      : in  std_logic;
        RST_I      : in  std_logic;
        INT_O      : out std_logic;

        -- scratch memory wishbone
        M2_STB_O   : out std_logic;
        M2_CYC_O   : out std_logic;
        M2_ACK_I   : in  std_logic;
        M2_ADR_O   : out std_logic_vector(31 downto 0);
        M2_DAT_I   : in  std_logic_vector(31 downto 0);
        M2_DAT_O   : out std_logic_vector(31 downto 0);
        M2_SEL_O   : out std_logic_vector(3 downto 0);
        M2_WE_O    : out std_logic;

        -- data memory wishbone
        M_STB_O    : out std_logic;
        M_CYC_O    : out std_logic;
        M_ACK_I    : in  std_logic;
        M_ADR_O    : out std_logic_vector(31 downto 0);
        M_DAT_I    : in  std_logic_vector(31 downto 0);
        M_DAT_O    : out std_logic_vector(31 downto 0);
        M_SEL_O    : out std_logic_vector(3 downto 0);
        M_WE_O     : out std_logic
    );
    End Component;

    -- scratch memory internal connections
    signal M2_STB_O : std_logic;                      -- IncludeIf_InternalScratchMemory
    signal M2_CYC_O : std_logic;                      -- IncludeIf_InternalScratchMemory
    signal M2_ACK_I : std_logic;                      -- IncludeIf_InternalScratchMemory
    signal M2_ADR_O : std_logic_vector(31 downto 0);  -- IncludeIf_InternalScratchMemory
    signal M2_DAT_I : std_logic_vector(31 downto 0);  -- IncludeIf_InternalScratchMemory
    signal M2_DAT_O : std_logic_vector(31 downto 0);  -- IncludeIf_InternalScratchMemory
    signal M2_SEL_O : std_logic_vector(3 downto 0);   -- IncludeIf_InternalScratchMemory
    signal M2_WE_O  : std_logic;                      -- IncludeIf_InternalScratchMemory
    signal EN       : std_logic;                      -- IncludeIf_InternalScratchMemory
    signal WE       : std_logic;                      -- IncludeIf_InternalScratchMemory

    Component ReplaceWith_MemoryName Is                 -- IncludeIf_InternalScratchMemory
        Port(                                           -- IncludeIf_InternalScratchMemory
            CLK   : In  Std_Logic;                      -- IncludeIf_InternalScratchMemory
            EN    : In  Std_Logic;                      -- IncludeIf_InternalScratchMemory
            WE    : In  Std_Logic;                      -- IncludeIf_InternalScratchMemory
            DIN   : In  Std_Logic_Vector(31 Downto 0);  -- IncludeIf_InternalScratchMemory
            DOUT  : Out Std_Logic_Vector(31 Downto 0);  -- IncludeIf_InternalScratchMemory
            ADDR  : In  Std_Logic_Vector(12 Downto 0)   -- IncludeIf_InternalScratchMemory
        );                                              -- IncludeIf_InternalScratchMemory
    End Component;                                      -- IncludeIf_InternalScratchMemory

-- ----------------------------------------------------------------------------
Begin
-- ----------------------------------------------------------------------------

U_MP3DEC : WB_MP3DEC Port Map (
    STB_I    => STB_I,
    CYC_I    => CYC_I,
    ACK_O    => ACK_O,
    ADR_I    => ADR_I,
    DAT_O    => DAT_O,
    DAT_I    => DAT_I,
    WE_I     => WE_I,
    CLK_I    => CLK_I,
    RST_I    => RST_I,
    INT_O    => INT_O,

    M2_STB_O => M2_STB_O,
    M2_CYC_O => M2_CYC_O,
    M2_ACK_I => M2_ACK_I,
    M2_ADR_O => M2_ADR_O,
    M2_DAT_I => M2_DAT_I,
    M2_DAT_O => M2_DAT_O,
    M2_SEL_O => M2_SEL_O,
    M2_WE_O  => M2_WE_O,

    M_STB_O  => M_STB_O,
    M_CYC_O  => M_CYC_O,
    M_ACK_I  => M_ACK_I,
    M_ADR_O  => M_ADR_O,
    M_DAT_I  => M_DAT_I,
    M_DAT_O  => M_DAT_O,
    M_SEL_O  => M_SEL_O,
    M_WE_O   => M_WE_O
);

U_ScratchMemory : ReplaceWith_MemoryName Port Map (   -- IncludeIf_InternalScratchMemory
    CLK      => CLK_I,                                -- IncludeIf_InternalScratchMemory
    EN       => EN,                                   -- IncludeIf_InternalScratchMemory
    WE       => M2_WE_O,                              -- IncludeIf_InternalScratchMemory
    ADDR     => M2_ADR_O(14 downto 2),                -- IncludeIf_InternalScratchMemory
    DIN      => M2_DAT_O,                             -- IncludeIf_InternalScratchMemory
    DOUT     => M2_DAT_I                              -- IncludeIf_InternalScratchMemory
);                                                    -- IncludeIf_InternalScratchMemory

EN <= M2_STB_O and M2_CYC_O;                          -- IncludeIf_InternalScratchMemory

process (CLK_I)                                       -- IncludeIf_InternalScratchMemory
begin                                                 -- IncludeIf_InternalScratchMemory
    if rising_edge(CLK_I) then                        -- IncludeIf_InternalScratchMemory
        if M2_ACK_I = '1' then                        -- IncludeIf_InternalScratchMemory
            M2_ACK_I <= '0';                          -- IncludeIf_InternalScratchMemory
        else                                          -- IncludeIf_InternalScratchMemory
            M2_ACK_I <= EN;                           -- IncludeIf_InternalScratchMemory
        end if;                                       -- IncludeIf_InternalScratchMemory
    end if;                                           -- IncludeIf_InternalScratchMemory
end process;                                          -- IncludeIf_InternalScratchMemory

-- ----------------------------------------------------------------------------
End;
-- ----------------------------------------------------------------------------

