--------------------------------------------------------------------------------
-- SubModule File_Name
-- Created   26/06/2006 11:10:13 AM
--
--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.all;
Use IEEE.std_logic_unsigned.all;

Entity ReplaceWith_EntityName Is Port
   (
     USB_WR_N        : Out   Std_Logic;
     USB_RD_N        : Out   Std_Logic;
     USB_D           : Inout Std_Logic_vector(ReplaceWith_USBDataBusWidth-1 Downto 0);
     USB_RESET_N     : Out   Std_Logic;
     USB_READY       : In    Std_Logic;
     USB_INT_N       : In    Std_Logic;
     USB_SLOE        : Out   Std_Logic;
     USB_FIFOADR2    : Out   Std_Logic;
     USB_FIFOADR1    : Out   Std_Logic;
     USB_FIFOADR0    : Out   Std_Logic;
     USB_PKTEND      : Out   Std_Logic;
     USB_FLAGD_CS_N  : Inout Std_Logic;
     USB_FLAGA       : In    Std_Logic;
     USB_FLAGB       : In    Std_Logic;
     USB_FLAGC       : In    Std_Logic;
     USB_VBUS        : In    Std_Logic;
     USB_IFCLK       : Out   Std_Logic;

     STB_I           : In    Std_Logic;
     CYC_I           : In    Std_Logic;
     WE_I            : In    Std_Logic;
     ADR_I           : In    Std_Logic_Vector(4 DownTo 0);
     DAT_O           : Out   Std_Logic_Vector(15 Downto 0);
     DAT_I           : In    Std_Logic_Vector(15 DownTo 0);
     CLK_I           : In    Std_Logic;
     RST_I           : In    Std_Logic;
     ACK_O           : Out   Std_Logic;
     INT_O           : Out   Std_Logic_Vector(1 DownTo 0)
   );
End ReplaceWith_EntityName;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Architecture Structure Of ReplaceWith_EntityName Is
    ----------------------------------------------------------------------------
    Type State_Type is (cState_Idle,
                        cState_ReadStatus,
                        cState_WriteConfig,
                        cState_RDLow,
                        cState_RDHigh,
                        cState_PKEndLow,
                        cState_PKEndHigh,
                        cState_WRLow,
                        cState_WRHigh,
                        cState_Reset,
                        cState_AddressSetup_Write,
                        cState_AddressSetup_Read,
                        cState_AddressSetup_PKEnd);
    ----------------------------------------------------------------------------
    Signal State_Reg                   : State_Type;
    Signal State_Next                  : State_Type;
    ----------------------------------------------------------------------------
    Signal MasterIsReading             : Std_Logic;
    Signal MasterIsWriting             : Std_Logic;
    ----------------------------------------------------------------------------
    Signal AddressTypeIsStatus         : Std_Logic;
    Signal AddressTypeIsUSB            : Std_Logic;
    Signal AddressTypeIsConfig         : Std_Logic;
    Signal AddressTypeIsPacketEnd      : Std_Logic;
    Signal AddressTypeIsReset          : Std_Logic;
    ----------------------------------------------------------------------------
    Signal AddressIsResetCycles        : Std_Logic;
    Signal AddressIsStrobeLowCycles    : Std_Logic;
    Signal AddressIsStrobeHighCycles   : Std_Logic;
    Signal AddressIsWRHighCycles       : Std_Logic;
    Signal AddressIsAddressSetupCycles : Std_Logic;
    Signal AddressIsReadStatusCycles   : Std_Logic;
    Signal AddressIsCommand            : Std_Logic;
    ----------------------------------------------------------------------------
    Signal USBIsReady                  : Std_Logic;
    ----------------------------------------------------------------------------
    Signal TimerIsZero                 : Std_Logic;
    Signal Timer_Reg                   : Std_Logic_Vector(7 DownTo 0);
    Signal ResetCycles                 : Std_Logic_Vector(7 DownTo 0);
    Signal StrobeLowCycles             : Std_Logic_Vector(7 DownTo 0);
    Signal StrobeHighCycles            : Std_Logic_Vector(7 DownTo 0);
    Signal WRHighCycles                : Std_Logic_Vector(7 DownTo 0);
    Signal AddressSetupCycles          : Std_Logic_Vector(7 DownTo 0);
    Signal ReadStatusCycles            : Std_Logic_Vector(7 DownTo 0);
    ----------------------------------------------------------------------------
    Signal LatchResetCycles            : Std_Logic;
    Signal LatchStrobeLowCycles        : Std_Logic;
    Signal LatchStrobeHighCycles       : Std_Logic;
    Signal LatchWRHighCycles           : Std_Logic;
    Signal LatchAddressSetupCycles     : Std_Logic;
    Signal LatchReadStatusCycles       : Std_Logic;
    ----------------------------------------------------------------------------
    Signal LoadTimer_Reset             : Std_Logic;
    Signal LoadTimer_StrobeLow         : Std_Logic;
    Signal LoadTimer_StrobeHigh        : Std_Logic;
    Signal LoadTimer_WRHigh            : Std_Logic;
    Signal LoadTimer_AddressSetup      : Std_Logic;
    Signal LoadTimer_ReadStatus        : Std_Logic;
    ----------------------------------------------------------------------------
    Signal AcknowledgePulse            : Std_Logic;
    Signal AcknowledgePulse_Reg        : Std_Logic;
    ----------------------------------------------------------------------------
    Signal USBDataToMaster             : Std_Logic;
    Signal MasterDataToUSB             : Std_Logic;
    ----------------------------------------------------------------------------
    Signal CSLow                       : Std_Logic;
    Signal RDLow                       : Std_Logic;
    Signal WRLow                       : Std_Logic;
    Signal PKEndLow                    : Std_Logic;
    Signal ResetUSB                    : Std_Logic;
    ----------------------------------------------------------------------------
    Signal CS_N_Reg                    : Std_Logic;
    Signal RD_N_Reg                    : Std_Logic;
    Signal WR_N_Reg                    : Std_Logic;
    Signal PKEnd_N_Reg                 : Std_Logic;
    Signal Reset_N_Reg                 : Std_Logic;
    Signal SLOE_N_Reg                  : Std_Logic;
    ----------------------------------------------------------------------------
    Signal ADR_I_Reg                   : Std_Logic_Vector( 2 DownTo 0);
    Signal DAT_I_Reg                   : Std_Logic_Vector(15 DownTo 0);
    ----------------------------------------------------------------------------
    Signal INT_O_Reg                   : Std_Logic_Vector(1 DownTo 0);
    ----------------------------------------------------------------------------
    Constant cUSBDataBusWidth          : Integer := ReplaceWith_USBDataBusWidth;
    ----------------------------------------------------------------------------
    Constant cAddressType_USB          : Std_Logic_Vector(1 Downto 0) := "00";
    Constant cAddressType_Status       : Std_Logic_Vector(1 Downto 0) := "01";
    Constant cAddressType_Reset        : Std_Logic_Vector(1 Downto 0) := "01";
    Constant cAddressType_Config       : Std_Logic_Vector(1 Downto 0) := "10";
    Constant cAddressType_PacketEnd    : Std_Logic_Vector(1 Downto 0) := "11";
    ----------------------------------------------------------------------------
    Constant cAddress_ResetCycles        : Std_Logic_Vector(2 Downto 0) := "000";
    Constant cAddress_StrobeLowCycles    : Std_Logic_Vector(2 Downto 0) := "001";
    Constant cAddress_StrobeHighCycles   : Std_Logic_Vector(2 Downto 0) := "010";
    Constant cAddress_WRHighCycles       : Std_Logic_Vector(2 Downto 0) := "011";
    Constant cAddress_AddressSetupCycles : Std_Logic_Vector(2 Downto 0) := "100";
    Constant cAddress_ReadStatusCycles   : Std_Logic_Vector(2 Downto 0) := "101";
    Constant cAddress_Command            : Std_Logic_Vector(2 Downto 0) := "000";
    ----------------------------------------------------------------------------
Begin

    ----------------------------------------------------------------------------
    USB_WR_N       <= WR_N_Reg;
    USB_RD_N       <= RD_N_Reg;
    USB_RESET_N    <= Reset_N_Reg;
    USB_SLOE       <= SLOE_N_Reg;
    USB_FIFOADR2   <= ADR_I_Reg(2);
    USB_FIFOADR1   <= ADR_I_Reg(1);
    USB_FIFOADR0   <= ADR_I_Reg(0);
    USB_PKTEND     <= PKEnd_N_Reg;
    USB_FLAGD_CS_N <= CS_N_Reg;
    USB_IFCLK      <= '0';
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    ACK_O           <= AcknowledgePulse And Not AcknowledgePulse_Reg;
    INT_O           <= INT_O_Reg;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    MasterIsReading <= STB_I And CYC_I And Not WE_I;
    MasterIsWriting <= STB_I And CYC_I And     WE_I;
    USBIsReady      <= USB_READY;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    AddressTypeIsStatus         <= '1' When ADR_I(4 DownTo 3) = cAddressType_Status         Else '0';
    AddressTypeIsUSB            <= '1' When ADR_I(4 DownTo 3) = cAddressType_USB            Else '0';
    AddressTypeIsConfig         <= '1' When ADR_I(4 DownTo 3) = cAddressType_Config         Else '0';
    AddressTypeIsPacketEnd      <= '1' When ADR_I(4 DownTo 3) = cAddressType_PacketEnd      Else '0';
    AddressTypeIsReset          <= '1' When ADR_I(4 DownTo 3) = cAddressType_Reset          Else '0';
    AddressIsResetCycles        <= '1' When ADR_I(2 DownTo 0) = cAddress_ResetCycles        Else '0';
    AddressIsStrobeLowCycles    <= '1' When ADR_I(2 DownTo 0) = cAddress_StrobeLowCycles    Else '0';
    AddressIsStrobeHighCycles   <= '1' When ADR_I(2 DownTo 0) = cAddress_StrobeHighCycles   Else '0';
    AddressIsWRHighCycles       <= '1' When ADR_I(2 DownTo 0) = cAddress_WRHighCycles       Else '0';
    AddressIsAddressSetupCycles <= '1' When ADR_I(2 DownTo 0) = cAddress_AddressSetupCycles Else '0';
    AddressIsReadStatusCycles   <= '1' When ADR_I(2 DownTo 0) = cAddress_ReadStatusCycles   Else '0';
    AddressIsCommand            <= '1' When ADR_I(2 DownTo 0) = cAddress_Command            Else '0';
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    TimerIsZero <= '1' When Timer_Reg = "00000000" Else '0';
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(RST_I, CLK_I)
    Begin
        If RST_I = '1' Then
            WR_N_Reg    <= '1';
            RD_N_Reg    <= '1';
            Reset_N_Reg <= '1';
            PKEnd_N_Reg <= '1';
            SLOE_N_Reg  <= '1';
            CS_N_Reg    <= '1';
        ElsIf Rising_Edge(CLK_I) Then
            WR_N_Reg    <= Not WRLow;
            RD_N_Reg    <= Not RDLow;
            Reset_N_Reg <= Not ResetUSB;
            PKEnd_N_Reg <= Not PKEndLow;
            SLOE_N_Reg  <= Not USBDataToMaster;
            CS_N_Reg    <= Not CSLow;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(CLK_I, RST_I)
    Begin
        If RST_I = '1' Then
            ADR_I_Reg <= (Others => '0');
            DAT_I_Reg <= (Others => '0');
        ElsIf Rising_Edge(CLK_I) Then
            ADR_I_Reg <= ADR_I(2 DownTo 0);
            DAT_I_Reg <= DAT_I;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(CLK_I, RST_I)
    Begin
        If RST_I = '1' Then
            INT_O_Reg <= "00";
        ElsIf Rising_Edge(CLK_I) Then
            INT_O_Reg(0) <= Not USB_INT_N And     USB_Ready;
            INT_O_Reg(1) <= Not USB_INT_N And Not USB_Ready;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(SLOE_N_Reg, DAT_I_Reg, MasterDataToUSB)
    Begin
        USB_D <= (Others=>'Z');
        If MasterDataToUSB = '1' Then
            USB_D(ReplaceWith_USBDataBusWidth-1 DownTo 0) <= DAT_I_Reg(ReplaceWith_USBDataBusWidth-1 DownTo 0);
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
--    Process(USBDataToMaster, USB_READY, USB_FLAGC, USB_FLAGB, USB_FLAGA,
--            USB_D)
--    Begin
--        DAT_O <= x"000" & USB_READY & USB_FLAGC & USB_FLAGB & USB_FLAGA;
--        If USBDataToMaster = '1' Then
--            DAT_O <= USB_D;
--        End If;
--    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Generate16Bit:                                                                             -- IncludeIf_16bit
    If cUSBDataBusWidth=16 Generate                                                            -- IncludeIf_16bit
        Process(CLK_I)                                                                         -- IncludeIf_16bit
        Begin                                                                                  -- IncludeIf_16bit
            If Rising_Edge(CLK_I) Then                                                         -- IncludeIf_16bit
                If RST_I='1' Then                                                              -- IncludeIf_16bit
                    DAT_O <= (Others=>'0');                                                    -- IncludeIf_16bit
                Else                                                                           -- IncludeIf_16bit
                    If USBDataToMaster='1' Then                                                -- IncludeIf_16bit
                        DAT_O <= USB_D;                                                        -- IncludeIf_16bit
                    Else                                                                       -- IncludeIf_16bit
                        DAT_O <= x"000" & USB_READY & USB_FLAGC & USB_FLAGB & USB_FLAGA;       -- IncludeIf_16bit
                    End If;                                                                    -- IncludeIf_16bit
                End If;                                                                        -- IncludeIf_16bit
            End If;                                                                            -- IncludeIf_16bit
        End Process;                                                                           -- IncludeIf_16bit
    End Generate Generate16Bit;                                                                -- IncludeIf_16bit

    Generate8Bit:                                                                              -- IncludeIf_8bit
    If cUSBDataBusWidth=8 Generate                                                             -- IncludeIf_8bit
        Process(CLK_I)                                                                         -- IncludeIf_8bit
        Begin                                                                                  -- IncludeIf_8bit
            If Rising_Edge(CLK_I) Then                                                         -- IncludeIf_8bit
                If RST_I='1' Then                                                              -- IncludeIf_8bit
                    DAT_O <= (Others=>'0');                                                    -- IncludeIf_8bit
                Else                                                                           -- IncludeIf_8bit
                    If USBDataToMaster='1' Then                                                -- IncludeIf_8bit
                        DAT_O <= x"00" & USB_D;                                                -- IncludeIf_8bit
                    Else                                                                       -- IncludeIf_8bit
                        DAT_O <= x"000" & USB_READY & USB_FLAGC & USB_FLAGB & USB_FLAGA;       -- IncludeIf_8bit
                    End If;                                                                    -- IncludeIf_8bit
                End If;                                                                        -- IncludeIf_8bit
            End If;                                                                            -- IncludeIf_8bit
        End Process;                                                                           -- IncludeIf_8bit
    End Generate Generate8Bit;                                                                 -- IncludeIf_8bit
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(CLK_I, RST_I)
    Begin
        If RST_I = '1' Then
--            ResetCycles        <= x"1F"; -- 31+1 cycles = 1600 ns at 20MHz
--            StrobeLowCycles    <= x"00"; --  0+1 cycles =   50 ns at 20MHz
--            StrobeHighCycles   <= x"00"; --  0+1 cycles =   50 ns at 20MHz
--            WRHighCycles       <= x"01"; --  1+1 cycles =  100 ns at 20MHz
--            AddressSetupCycles <= x"00"; --  0+1 cycles =   50 ns at 20MHz
--            ReadStatusCycles   <= x"00"; --  0+1 cycles =   50 ns at 20MHz
            ResetCycles        <= x"1F"; -- 31+1 cycles = 1600 ns at 20MHz
            StrobeLowCycles    <= x"01"; --  0+1 cycles =   50 ns at 40MHz
            StrobeHighCycles   <= x"01"; --  0+1 cycles =   50 ns at 40MHz
            WRHighCycles       <= x"11"; --  1+1 cycles =  100 ns at 40MHz
            AddressSetupCycles <= x"01"; --  0+1 cycles =   50 ns at 40MHz
            ReadStatusCycles   <= x"01"; --  0+1 cycles =   50 ns at 40MHz
        ElsIf Rising_Edge(CLK_I) Then
            If LatchResetCycles        = '1' Then ResetCycles        <= DAT_I(7 DownTo 0); End If;
            If LatchStrobeLowCycles    = '1' Then StrobeLowCycles    <= DAT_I(7 DownTo 0); End If;
            If LatchStrobeHighCycles   = '1' Then StrobeHighCycles   <= DAT_I(7 DownTo 0); End If;
            If LatchWRHighCycles       = '1' Then WRHighCycles       <= DAT_I(7 DownTo 0); End If;
            If LatchAddressSetupCycles = '1' Then AddressSetupCycles <= DAT_I(7 DownTo 0); End If;
            If LatchReadStatusCycles   = '1' Then ReadStatusCycles   <= DAT_I(7 DownTo 0); End If;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(CLK_I, RST_I)
    Begin
        If RST_I = '1' Then
            Timer_Reg <= "00000000";
        ElsIf Rising_Edge(CLK_I) Then
            If    LoadTimer_Reset        = '1' Then Timer_Reg <= ResetCycles;
            ElsIf LoadTimer_StrobeLow    = '1' Then Timer_Reg <= StrobeLowCycles;
            ElsIf LoadTimer_StrobeHigh   = '1' Then Timer_Reg <= StrobeHighCycles;
            ElsIf LoadTimer_WRHigh       = '1' Then Timer_Reg <= WRHighCycles;
            ElsIf LoadTimer_AddressSetup = '1' Then Timer_Reg <= AddressSetupCycles;
            ElsIf LoadTimer_ReadStatus   = '1' Then Timer_Reg <= ReadStatusCycles;
            Else                                    Timer_Reg <= Timer_Reg - 1;
            End If;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(CLK_I, RST_I)
    Begin
        If RST_I = '1' Then
            AcknowledgePulse_Reg <= '0';
        Elsif Rising_Edge(CLK_I) Then
            AcknowledgePulse_Reg <= AcknowledgePulse;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(CLK_I, RST_I)
    Begin
        If RST_I = '1' Then
            State_Reg <= cState_Idle;
        Elsif Rising_Edge(CLK_I) Then
            State_Reg <= State_Next;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(State_Reg, MasterIsReading, MasterIsWriting, AddressTypeIsStatus,
            AddressTypeIsUSB, AddressTypeIsConfig, AddressTypeIsPacketEnd,
            AddressTypeIsReset, AddressIsResetCycles, AddressIsStrobeLowCycles,
            AddressIsWRHighCycles, AddressIsAddressSetupCycles, USBIsReady, TimerIsZero,
            AddressIsCommand, AddressIsStrobeHighCycles, AddressIsReadStatusCycles)
    Begin
        LatchResetCycles        <= '0';
        LatchStrobeLowCycles    <= '0';
        LatchStrobeHighCycles   <= '0';
        LatchWRHighCycles       <= '0';
        LatchAddressSetupCycles <= '0';
        LatchReadStatusCycles   <= '0';
        LoadTimer_Reset         <= '0';
        LoadTimer_StrobeLow     <= '0';
        LoadTimer_StrobeHigh    <= '0';
        LoadTimer_WRHigh        <= '0';
        LoadTimer_AddressSetup  <= '0';
        LoadTimer_ReadStatus    <= '0';
        AcknowledgePulse        <= '0';
        RDLow                   <= '0';
        WRLow                   <= '0';
        PKEndLow                <= '0';
        ResetUSB                <= '0';
        USBDataToMaster         <= '0';
        MasterDataToUSB         <= '0';
        CSLow                   <= '0';
        State_Next              <= State_Reg;
        Case State_Reg Is
         -----------------------------------------------------------------------
         When cState_Idle                => If MasterIsReading = '1' Then
                                                If AddressTypeIsStatus = '1' Then
                                                    LoadTimer_ReadStatus   <= '1';
                                                    State_Next             <= cState_ReadStatus;
                                                Elsif AddressTypeIsUSB = '1' Then
--                                                    CSLow                  <= '1';
                                                    LoadTimer_AddressSetup <= '1';
                                                    State_Next             <= cState_AddressSetup_Read;
                                                End If;
                                            Elsif MasterIsWriting = '1' Then
                                                If AddressTypeIsConfig = '1' Then
                                                    State_Next             <= cState_WriteConfig;
                                                Elsif AddressTypeIsUSB = '1' Then
                                                    If (AddressIsCommand = '1' And USBIsReady = '1') Or AddressIsCommand = '0' Then
--                                                        CSLow                  <= '1';
                                                        LoadTimer_AddressSetup <= '1';
                                                        State_Next             <= cState_AddressSetup_Write;
                                                    End If;
                                                ElsIf AddressTypeIsPacketEnd = '1' Then
--                                                    CSLow                  <= '1';
                                                    LoadTimer_AddressSetup <= '1';
                                                    State_Next             <= cState_AddressSetup_PKEnd;
                                                ElsIf AddressTypeIsReset = '1' Then
                                                    LoadTimer_Reset  <= '1';
                                                    State_Next       <= cState_Reset;
                                                End If;
                                            End If;
         -----------------------------------------------------------------------
         When cState_ReadStatus          => If TimerIsZero = '1' Then
                                                AcknowledgePulse <= '1';
                                                State_Next       <= cState_Idle;
                                            End If;
         -----------------------------------------------------------------------
         When cState_WriteConfig         => If AddressIsResetCycles           = '1' Then
                                                LatchResetCycles        <= '1';
                                            ElsIf AddressIsStrobeLowCycles    = '1' Then
                                                LatchStrobeLowCycles    <= '1';
                                            ElsIf AddressIsStrobeHighCycles   = '1' Then
                                                LatchStrobeHighCycles   <= '1';
                                            ElsIf AddressIsWRHighCycles       = '1' Then
                                                LatchWRHighCycles       <= '1';
                                            ElsIf AddressIsAddressSetupCycles = '1' Then
                                                LatchAddressSetupCycles <= '1';
                                            ElsIf AddressIsReadStatusCycles   = '1' Then
                                                LatchReadStatusCycles   <= '1';
                                            End If;
                                            AcknowledgePulse <= '1';
                                            State_Next       <= cState_Idle;
         -----------------------------------------------------------------------
         When cState_AddressSetup_Read   => USBDataToMaster  <= '1';
                                            CSLow            <= '1';
                                            If TimerIsZero = '1' Then
                                                LoadTimer_StrobeLow  <= '1';
--                                                RDLow                <= '1';
                                                State_Next           <= cState_RDLow;
                                            End If;
         -----------------------------------------------------------------------
         When cState_RDLow               => RDLow            <= '1';
                                            CSLow            <= '1';
                                            USBDataToMaster  <= '1';
                                            If TimerIsZero = '1' Then
                                                LoadTimer_StrobeHigh <= '1';
--                                                RDLow                <= '0';
                                                State_Next           <= cState_RDHigh;
                                            End If;
         -----------------------------------------------------------------------
         When cState_RDHigh              => USBDataToMaster  <= '1';    -- SL_OE
                                            CSLow            <= '1';    -- CS
                                            AcknowledgePulse <= '1';
                                            If TimerIsZero = '1' Then
                                                State_Next <= cState_Idle;
                                            End If;
         -----------------------------------------------------------------------
         When cState_AddressSetup_Write  => CSLow            <= '1';
                                            If TimerIsZero = '1' Then
                                                LoadTimer_StrobeLow <= '1';
--                                                WRLow               <= '1';
                                                State_Next          <= cState_WRLow;
                                            End If;
         -----------------------------------------------------------------------
         When cState_WRLow               => CSLow            <= '1';
                                            WRLow            <= '1';
                                            MasterDataToUSB  <= '1';
                                            If TimerIsZero = '1' Then
                                                LoadTimer_WRHigh <= '1';
--                                                WRLow            <= '0';
                                                State_Next       <= cState_WRHigh;
                                            End If;
         -----------------------------------------------------------------------
         When cState_WRHigh              => CSLow            <= '1';
                                            MasterDataToUSB  <= '1';
                                            If TimerIsZero = '1' Then
                                                AcknowledgePulse <= '1';
                                                State_Next       <= cState_Idle;
                                            End If;
         -----------------------------------------------------------------------
         When cState_AddressSetup_PKEnd  => CSLow            <= '1';
                                            If TimerIsZero = '1' Then
                                                LoadTimer_StrobeLow  <= '1';
                                                PKEndLow             <= '1';
                                                State_Next           <= cState_PKEndLow;
                                            End If;
         -----------------------------------------------------------------------
         When cState_PKEndLow            => CSLow            <= '1';
                                            PKEndLow <= '1';
                                            If TimerIsZero = '1' Then
                                                LoadTimer_StrobeHigh <= '1';
--                                                PKEndLow             <= '0';
                                                State_Next           <= cState_PKEndHigh;
                                            End If;
         -----------------------------------------------------------------------
         When cState_PKEndHigh           => CSLow            <= '1';
                                            AcknowledgePulse <= '1';
                                            If TimerIsZero = '1' Then
                                                State_Next <= cState_Idle;
                                            End If;
         -----------------------------------------------------------------------
         When cState_Reset               => ResetUSB         <= '1';
                                            AcknowledgePulse <= '1';
                                            If TimerIsZero = '1' Then
                                                State_Next <= cState_Idle;
                                            End If;
         -----------------------------------------------------------------------
         When Others                     => State_Next <= cState_Idle;
         -----------------------------------------------------------------------
        End Case;
    End Process;
--------------------------------------------------------------------------------
End Structure;
--------------------------------------------------------------------------------

