-- ----------------------------------------------------------------------------
Library IEEE;
    Use		IEEE.Std_Logic_1164.All;
    Use 	IEEE.Numeric_Std.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_EntityName Is
   -- ------------------------------------------------------------------------
   Port (
ReplaceWith_InputPortsDeclaration			
ReplaceWith_OutputPortDeclaration
      START : In Std_Logic;								-- IncludeIf_NonCombinatorial
	  CLK   : In Std_Logic;								-- IncludeIf_NonCombinatorial
      RST   : In Std_Logic								-- IncludeIf_NonCombinatorial
   );
   -- ------------------------------------------------------------------------
End;   
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_EntityName Is
-- ----------------------------------------------------------------------------
   
   Signal Signal_I0      : Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);
   Signal Signal_I1      : Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);
   Signal Signal_O       : Std_Logic_Vector((ReplaceWith_BusWidth * 2) - 1 Downto 0);
   Signal Signal_Product : Std_Logic_Vector((ReplaceWith_BusWidth * 2) - 1 Downto 0);

-- ----------------------------------------------------------------------------
Begin

   -- ------------------------------------------------------------------------
   DP : Process( CLK, RST )								    -- IncludeIf_NonCombinatorial
   DP : Process( Signal_Product )						  -- IncludeIf_Combinatorial
   Begin
      If RST = '1' Then									      -- IncludeIf_NonCombinatorial
         Signal_O <= (Others => '0');					-- IncludeIf_NonCombinatorial
      Elsif (CLK'Event) And (CLK = 'ReplaceWith_ClockEdge')  Then	-- IncludeIf_NonCombinatorial
	     If START = '1' Then							      -- IncludeIf_NonCombinatorial
		    Signal_O <= Signal_Product;	
		 End If;										              -- IncludeIf_NonCombinatorial
      End If;											            -- IncludeIf_NonCombinatorial
   End Process;
   -- ------------------------------------------------------------------------

ReplaceWith_SignalAssignments

   Signal_Product <= std_logic_vector(SIGNED(Signal_I0) * SIGNED(Signal_I1));

ReplaceWith_OutputAssignments

-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------