-- ----------------------------------------------------------------------------
Library IEEE;
    Use     IEEE.Std_Logic_1164.All;
    Use     IEEE.Std_Logic_Unsigned.All;
    Use     IEEE.Numeric_Std.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_EntityName Is
   -- ------------------------------------------------------------------------
   Port (
            BYTE_WEA : In Std_Logic_Vector(ReplaceWith_MemoryByteCount - 1 Downto 0);           -- IncludeIf_ByteWrites    
            BYTE_WEB : In Std_Logic_Vector(ReplaceWith_MemoryByteCount - 1 Downto 0);           -- IncludeIf_ByteWrites
            
            ENA   : In Std_Logic;                                                               -- IncludeIf_EnablePin
            ENB   : In Std_Logic;                                                               -- IncludeIf_EnablePin
            
            RSTA  : In Std_Logic;                                                               -- IncludeIf_ResetPin
            RSTB  : In Std_Logic;                                                               -- IncludeIf_ResetPin
                                                           
            
            CLKA  : In  Std_Logic;
            CLKB  : In  Std_Logic;
            WEA   : In  Std_Logic;                                                              -- IncludeIf_RAM
            WEB   : In  Std_Logic;                                                              -- IncludeIf_RAM
            DINA  : In  Std_Logic_Vector(ReplaceWith_MemoryWidth - 1 Downto 0);                 -- IncludeIf_RAM
            DINB  : In  Std_Logic_Vector(ReplaceWith_MemoryWidth - 1 Downto 0);                 -- IncludeIf_RAM
            DOUTA : Out Std_Logic_Vector(ReplaceWith_MemoryWidth - 1 Downto 0);
            DOUTB : Out Std_Logic_Vector(ReplaceWith_MemoryWidth - 1 Downto 0);
            ADDRA : In  Std_Logic_Vector(ReplaceWith_MemoryDepth - 1 Downto 0);
            ADDRB : In  Std_Logic_Vector(ReplaceWith_MemoryDepth - 1 Downto 0)
   );
   -- ------------------------------------------------------------------------
End;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_EntityName Is
-- ----------------------------------------------------------------------------
    -- ------------------------------------------------------------------------
    Component ReplaceWith_MemoryName Is
        Port(
            bytewea : In Std_Logic_Vector(ReplaceWith_MemoryByteCount - 1 Downto 0);            -- IncludeIf_ByteWrites    
            byteweb : In Std_Logic_Vector(ReplaceWith_MemoryByteCount - 1 Downto 0);            -- IncludeIf_ByteWrites
                                                           
            ena     : In Std_Logic;                                                             -- IncludeIf_EnablePin
            enb     : In Std_Logic;                                                             -- IncludeIf_EnablePin
                                                           
            rsta    : In Std_Logic;                                                             -- IncludeIf_ResetPin
            rstb    : In Std_Logic;                                                             -- IncludeIf_ResetPin
                                                           
            clka    : In  Std_Logic;
            clkb    : In  Std_Logic;
            
            wea     : In  Std_Logic;                                                            
            web     : In  Std_Logic;                                                            
                                                                                       
            dina    : In  Std_Logic_Vector(ReplaceWith_MemoryWidth - 1 Downto 0);               
            dinb    : In  Std_Logic_Vector(ReplaceWith_MemoryWidth - 1 Downto 0);               
            douta   : Out Std_Logic_Vector(ReplaceWith_MemoryWidth - 1 Downto 0);             
            doutb   : Out Std_Logic_Vector(ReplaceWith_MemoryWidth - 1 Downto 0);
            addra   : In  Std_Logic_Vector(ReplaceWith_MemoryDepth - 1 Downto 0);
            addrb   : In  Std_Logic_Vector(ReplaceWith_MemoryDepth - 1 Downto 0)
        );
    End Component;
    -- ------------------------------------------------------------------------
    
    Signal Signal_GND      : Std_Logic;                                                         -- IncludeIf_ROM
    Signal Signal_GND_Bus  : Std_Logic_Vector(ReplaceWith_MemoryWidth - 1 Downto 0);            -- IncludeIf_ROM

-- ----------------------------------------------------------------------------
Begin
-- ----------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    U_ReplaceWith_MemoryName : ReplaceWith_MemoryName Port Map (
        
        bytewea => BYTE_WEA,                                                                    -- IncludeIf_ByteWrites
        byteweb => BYTE_WEB,                                                                    -- IncludeIf_ByteWrites
                                                         
        ena     => ENA,                                                                         -- IncludeIf_EnablePin   
        enb     => ENB,                                                                         -- IncludeIf_EnablePin
                                                         
        rsta    => RSTA,                                                                        -- IncludeIf_ResetPin  
        rstb    => RSTB,                                                                        -- IncludeIf_ResetPin
                                                         
        clka    => CLKA,  
        clkb    => CLKB,
        
        wea     => WEA,                                                                         -- IncludeIf_RAM
        web     => WEB,                                                                         -- IncludeIf_RAM
                                                                                       
        dina    => DINA,                                                                        -- IncludeIf_RAM
        dinb    => DINB,                                                                        -- IncludeIf_RAM
        
        wea     => Signal_GND,                                                                  -- IncludeIf_ROM
        web     => Signal_GND,                                                                  -- IncludeIf_ROM
                                                                                       
        dina    => Signal_GND_Bus,                                                              -- IncludeIf_ROM
        dinb    => Signal_GND_Bus,                                                              -- IncludeIf_ROM

        
        douta   => DOUTA,                                                                
        doutb   => DOUTB,
        addra   => ADDRA,
        addrb   => ADDRB
    );  
    -- ------------------------------------------------------------------------
    
    Signal_GND      <= '0';                                                                     -- IncludeIf_ROM
    Signal_GND_Bus  <= (Others=>'0');                                                           -- IncludeIf_ROM


-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------

