-- ----------------------------------------------------------------------------
Library IEEE;
    Use		IEEE.Std_Logic_1164.All;
    Use 	IEEE.Numeric_Std.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_EntityName Is
   -- ------------------------------------------------------------------------
   Port (
      START : In Std_Logic; 
      DONE  : Out Std_Logic;
	  CLK   : In Std_Logic;
      RST   : In Std_Logic;
ReplaceWith_InputPortsDeclaration			
ReplaceWith_OutputPortsDeclaration			
   );
   -- ------------------------------------------------------------------------
End;   
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_EntityName Is
-- ----------------------------------------------------------------------------

   -- ------------------------------------------------------------------------
   Component Comp_ReplaceWith_EntityName Is
   Port(   
      N     : In Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);   -- Numerator
      D     : In Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);   -- Denominator
      Q     : Out Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);  -- IncludeIf_Quotient_Output
	  R     : Out Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);  -- IncludeIf_Remainder_Output
      START : In Std_Logic;
      DONE  : Out Std_Logic;
      CLK   : In std_logic;
      RST   : In Std_Logic
   );
   End Component;
   -- ------------------------------------------------------------------------
   

   Signal Signal_Q    : Std_Logic_Vector( ReplaceWith_BusWidth - 1 Downto 0 ) := (Others=>'0');	-- IncludeIf_Quotient_Output
   Signal Signal_R    : Std_Logic_Vector( ReplaceWith_BusWidth - 1 Downto 0 ) := (Others=>'0');	-- IncludeIf_Remainder_Output
   Signal Signal_QQ   : Std_Logic_Vector( ReplaceWith_BusWidth - 1 Downto 0 ) := (Others=>'0');	-- IncludeIf_Quotient_Output
   Signal Signal_RR   : Std_Logic_Vector( ReplaceWith_BusWidth - 1 Downto 0 ) := (Others=>'0');	-- IncludeIf_Remainder_Output
   Signal Signal_Rdy  : Std_Logic;
   Signal Signal_Done : Std_Logic;
   Signal Signal_N    : Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);
   Signal Signal_D    : Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);

-- ----------------------------------------------------------------------------
Begin

   -- ------------------------------------------------------------------------
   Inst_ReplaceWith_EntityName : Component Comp_ReplaceWith_EntityName
   Port Map(
      N => Signal_N,
	  D => Signal_D,
	  Q => Signal_Q,								-- IncludeIf_Quotient_Output
	  R => Signal_R,								-- IncludeIf_Remainder_Output
	  START => START,
	  DONE => Signal_Rdy,
	  CLK => CLK,
	  RST => RST
   );
   -- ------------------------------------------------------------------------

   -- ------------------------------------------------------------------------
   DP : Process( CLK, RST )
   Begin
      If RST = '1' Then
	     Signal_QQ <= (Others=>'0');				-- IncludeIf_Quotient_Output
		 Signal_RR <= (Others=>'0');				-- IncludeIf_Remainder_Output
		 Signal_Done <= '0';
	  Elsif ReplaceWith_ClockEdge( CLK ) Then
		Signal_Done <= Signal_Rdy;
	     If Signal_Rdy = '1' Then
		    Signal_QQ <= Signal_Q;					-- IncludeIf_Quotient_Output
			Signal_RR <= Signal_R;					-- IncludeIf_Remainder_Output
		 End If;
	  End If;
   End Process;	
   -- ------------------------------------------------------------------------
   
   Signal_N <= ReplaceWith_Numerator;
   Signal_D <= ReplaceWith_Denominator;
   
ReplaceWith_OutputPortsAssignments      
   Done <= Signal_Done;

-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Library IEEE;
    Use		IEEE.Std_Logic_1164.All;
    Use 	IEEE.Numeric_Std.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity Comp_ReplaceWith_EntityName Is
   -- ------------------------------------------------------------------------
   Port (
            N     : In Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);   -- Numerator
            D     : In Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);   -- Denominator
            Q     : Out Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);  -- IncludeIf_Quotient_Output
			R     : Out Std_Logic_Vector(ReplaceWith_BusWidth - 1 Downto 0);  -- IncludeIf_Remainder_Output
            START : In Std_Logic; 
            DONE  : Out Std_Logic;
			CLK   : In Std_Logic;
            RST   : In Std_Logic
   );
   -- ------------------------------------------------------------------------
End;   
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of Comp_ReplaceWith_EntityName Is
-- ----------------------------------------------------------------------------

   -- ------------------------------------------------------------------------
ReplaceWith_StateDeclarations
   -- ------------------------------------------------------------------------
   
ReplaceWith_SignalDeclarations

-- ----------------------------------------------------------------------------
Begin

   -- ------------------------------------------------------------------------
   SYNC : Process( CLK, RST )
   Begin
      If RST = '1' Then
         Signal_Current_State <= STATE_0;
	  Elsif ReplaceWith_ClockEdge( CLK ) Then
		 Signal_Current_State <= Signal_Next_State;
	  End If;
   End Process;
   -- ------------------------------------------------------------------------

   -- ------------------------------------------------------------------------
   FSM : Process( Signal_Current_State, Signal_Next_State, START )
   Begin
      Signal_Next_State <= Signal_Current_State;
	  Case Signal_Current_State Is
	  When STATE_0 =>
	     If START = '1' Then
		    Signal_Next_State <= STATE_1;			
		 End If;
ReplaceWith_StateTransitions
	     Signal_Next_State <= STATE_0;
      When Others =>
	     Null;
	  End Case;
   End Process;
   -- ------------------------------------------------------------------------

   -- ------------------------------------------------------------------------
   DP : Process( CLK, RST )
   Begin
      If RST = '1' Then	  
ReplaceWith_SignalResets
      Elsif ReplaceWith_ClockEdge( CLK ) Then
	     If Signal_Current_State = STATE_0 Then
		    If START = '1' Then			
ReplaceWith_SignalInitialisations			   			   
			End If;
			DONE <= '0';			
ReplaceWith_SignalCalculations
            DONE <= '1';
         End If;
	  End If;
   End Process;
   -- ------------------------------------------------------------------------

ReplaceWith_SignalAssignments
ReplaceWith_QuotientAssignment
ReplaceWith_RemainderAssignment

-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------
