-- ----------------------------------------------------------------------------
Library IEEE;
    Use		IEEE.Std_Logic_1164.All;
    Use 	IEEE.Numeric_Std.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_EntityName Is
   -- ------------------------------------------------------------------------
   Port (
            START : In Std_Logic; 
            DONE  : Out Std_Logic;
			CLK   : In Std_Logic;
            RST   : In Std_Logic;
ReplaceWith_InputPortsDeclaration			
ReplaceWith_OutputPortsDeclaration			
   );
   -- ------------------------------------------------------------------------
End;   
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_EntityName Is
-- ----------------------------------------------------------------------------

   -- ------------------------------------------------------------------------
ReplaceWith_StateDeclarations
   -- ------------------------------------------------------------------------
   
   -- ------------------------------------------------------------------------
ReplaceWith_SignalDeclarations
   -- ------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Begin

   -- ------------------------------------------------------------------------
   SYNC : Process( CLK, RST )
   Begin
      If RST = '1' Then
         Signal_Current_State <= STATE_0;
	  Elsif ReplaceWith_ClockEdge( CLK ) Then
		 Signal_Current_State <= Signal_Next_State;
	  End If;
   End Process;
   -- ------------------------------------------------------------------------

   -- ------------------------------------------------------------------------
   FSM : Process( Signal_Current_State, Signal_Next_State, START )
   Begin
      Signal_Next_State <= Signal_Current_State;
	  Case Signal_Current_State Is
	  When STATE_0 =>
	     If START = '1' Then
		    Signal_Next_State <= STATE_1;			
		 End If;
ReplaceWith_StateTransitions
	     Signal_Next_State <= STATE_0;
      When Others =>
	     Null;
	  End Case;
   End Process;
   -- ------------------------------------------------------------------------

   -- ------------------------------------------------------------------------
   DP : Process( CLK, RST )
   Begin
      If RST = '1' Then
ReplaceWith_SignalResets
      Elsif ReplaceWith_ClockEdge( CLK ) Then
	     If Signal_Current_State = STATE_0 Then
		    If START = '1' Then
ReplaceWith_SignalInitialisations			   
			End If;
			DONE <= '0';
ReplaceWith_SignalCalculations
            DONE <= '1';
         End If;
	  End If;
   End Process;

ReplaceWith_SignalAssignments
ReplaceWith_QuotientAssignment
ReplaceWith_RemainderAssignment

-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------
