-- ----------------------------------------------------------------------------
Library IEEE;
    Use		IEEE.Std_Logic_1164.All;
    Use 	IEEE.Numeric_Std.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_EntityName Is
   -- ------------------------------------------------------------------------
   Port (
ReplaceWith_InputPortsDeclaration			
			O   : Out Std_Logic;
			NO  : Out Std_Logic;				-- IncludeIf_Both_Outputs
			CLK : In Std_Logic;
            RST : In Std_Logic
    );
   -- ------------------------------------------------------------------------
End;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_EntityName Is
-- ----------------------------------------------------------------------------
   -- ------------------------------------------------------------------------
   -- from non-standard ieee.std_logic_misc.all:
   Function And_Reduce(arg: Std_Logic_Vector) Return ux01 Is
   Variable result: Std_Logic;
   Begin
   result := '1';
   For i In arg'Range Loop
       result := result and arg(i);
   End Loop;
       Return result;
   End;
   -- ------------------------------------------------------------------------

   Signal Signal_Old  : Std_Logic_Vector(ReplaceWith_BarrierWidth - 1 Downto 0);
   Signal Signal_NewV : Std_Logic_Vector(ReplaceWith_BarrierWidth - 1 Downto 0);
   Signal Signal_Fire : Std_Logic;

   
-- ----------------------------------------------------------------------------
Begin
-- ----------------------------------------------------------------------------

   -- ------------------------------------------------------------------------
   DP : Process( CLK, RST )
   Begin
      If RST = '1' Then
         Signal_Old <= (Others => '0');
      Elsif ReplaceWith_ClockEdge( CLK ) Then
         If Signal_Fire = '1' Then
            Signal_Old <= (Others => '0');
         Else
            Signal_Old <= Signal_NewV;
         End If;
      End If;
   End Process;
   -- ------------------------------------------------------------------------

   Signal_NewV <= ReplaceWith_SignalNewVAssignment;
   Signal_Fire <= and_reduce(Signal_NewV);
   O           <= Signal_Fire;
   NO          <= Not Signal_Fire;			-- IncludeIf_Both_Outputs

-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------
