-- ----------------------------------------------------------------------------
-- Xilinx: DCM
-- ----------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
entity ReplaceWith_EntityName is
    port (
           CLKA   : out   std_logic;                    -- IncludeIf_CLKA
           CLKB   : out   std_logic;                    -- IncludeIf_CLKB
           CLKC   : out   std_logic;                    -- IncludeIf_CLKC
           CLKD   : out   std_logic;                    -- IncludeIf_CLKD
           CLKE   : out   std_logic;                    -- IncludeIf_CLKE
           CLKF   : out   std_logic;                    -- IncludeIf_CLKF
           CLKG   : out   std_logic;                    -- IncludeIf_CLKG
           CLKH   : out   std_logic;                    -- IncludeIf_CLKH
           CLKI   : out   std_logic;                    -- IncludeIf_CLKI
                                                        
           LOCKED : out   std_logic;                   
           CLK    : in    std_logic;
           RST    : in    std_logic
    );
end;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
architecture RTL of ReplaceWith_EntityName is
    signal CLKFB_IN     : std_logic;
    signal CLK0_BUF     : std_logic;
    signal GND_BIT      : std_logic;
    
    
    signal CLKA_BUF   : std_logic;                      -- IncludeIf_CLKA
    signal CLKB_BUF   : std_logic;                      -- IncludeIf_CLKB
    signal CLKC_BUF   : std_logic;                      -- IncludeIf_CLKC
    signal CLKD_BUF   : std_logic;                      -- IncludeIf_CLKD
    signal CLKE_BUF   : std_logic;                      -- IncludeIf_CLKE
    signal CLKF_BUF   : std_logic;                      -- IncludeIf_CLKF
    signal CLKG_BUF   : std_logic;                      -- IncludeIf_CLKG
    signal CLKH_BUF   : std_logic;                      -- IncludeIf_CLKH
    signal CLKI_BUF   : std_logic;                      -- IncludeIf_CLKI
                                                    

    component BUFG
        port (
            O : out std_ulogic;
            I : in std_ulogic
        );
    end component;

    component DCM
	  generic (
		 CLKDV_DIVIDE 			: real 			:= 2.0;
		 CLKFX_DIVIDE 			: integer 		:= 1;
		 CLKFX_MULTIPLY 		: integer 		:= 4;
		 CLKIN_DIVIDE_BY_2 		: boolean 		:= FALSE;
		 CLKIN_PERIOD 			: real 			:= 10.0;
		 CLKOUT_PHASE_SHIFT 	: string 		:= "NONE";
		 CLK_FEEDBACK 			: string 		:= "1X";
		 DESKEW_ADJUST 			: string 		:= "SYSTEM_SYNCHRONOUS";
		 DFS_FREQUENCY_MODE 	: string 		:= "LOW";
		 DLL_FREQUENCY_MODE 	: string 		:= "LOW";
		 DUTY_CYCLE_CORRECTION 	: boolean 		:= TRUE;
		 FACTORY_JF 			: bit_vector 	:= X"C080";
		 PHASE_SHIFT 			: integer 		:= 0;
		 STARTUP_WAIT 			: boolean 		:= false
	  );
	  port (
		 CLK0 		: out std_ulogic := '0';
		 CLK180 	: out std_ulogic := '0';
		 CLK270 	: out std_ulogic := '0';
		 CLK2X 		: out std_ulogic := '0';
		 CLK2X180 	: out std_ulogic := '0';
		 CLK90 		: out std_ulogic := '0';
		 CLKDV 		: out std_ulogic := '0';
		 CLKFX 		: out std_ulogic := '0';
		 CLKFX180 	: out std_ulogic := '0';
	

		 LOCKED 	: out std_ulogic := '0';
		 PSDONE 	: out std_ulogic := '0';
		 STATUS 	: out std_logic_vector(7 downto 0) := "00000000";
		 CLKFB 		: in std_ulogic  := '0';
		 CLKIN 		: in std_ulogic  := '0';
		 DSSEN 		: in std_ulogic  := '0';
		 PSCLK 		: in std_ulogic  := '0';
		 PSEN 		: in std_ulogic  := '0';
		 PSINCDEC 	: in std_ulogic  := '0';
		 RST 		: in std_ulogic  := '0'
	  );
	end component;

begin
    GND_BIT 				<= '0';

    -- This allows reuse of CLK0                                        -- IncludeIf_CLK0_MAP
    ReplaceWith_CLK0_MAP <= CLKFB_IN;                                   -- IncludeIf_CLK0_MAP

    CLKA_BUFG_INST : BUFG port map (I => CLKA_BUF, O => CLKA);          -- IncludeIf_CLKA
    CLKB_BUFG_INST : BUFG port map (I => CLKB_BUF, O => CLKB);          -- IncludeIf_CLKB
    CLKC_BUFG_INST : BUFG port map (I => CLKC_BUF, O => CLKC);          -- IncludeIf_CLKC
    CLKD_BUFG_INST : BUFG port map (I => CLKD_BUF, O => CLKD);          -- IncludeIf_CLKD
    CLKE_BUFG_INST : BUFG port map (I => CLKE_BUF, O => CLKE);          -- IncludeIf_CLKE
    CLKF_BUFG_INST : BUFG port map (I => CLKF_BUF, O => CLKF);          -- IncludeIf_CLKF
    CLKG_BUFG_INST : BUFG port map (I => CLKG_BUF, O => CLKG);          -- IncludeIf_CLKG
    CLKH_BUFG_INST : BUFG port map (I => CLKH_BUF, O => CLKH);          -- IncludeIf_CLKH
    CLKI_BUFG_INST : BUFG port map (I => CLKI_BUF, O => CLKI);          -- IncludeIf_CLKI
                                                                                    
    CLK0_BUFG_INST : BUFG port map (I => CLK0_BUF, O => CLKFB_IN);

    DCM_INST : DCM
    generic map( CLK_FEEDBACK            => "1X",
                 CLKDV_DIVIDE            => ReplaceWith_CLKDV_DIVIDE,   
                 CLKFX_DIVIDE            => ReplaceWith_CLKFX_DIVIDE,   
                 CLKFX_MULTIPLY          => ReplaceWith_CLKFX_MULTIPLY, 
                 CLKIN_PERIOD            => ReplaceWith_CLKIN_PERIOD,   
                 CLKIN_DIVIDE_BY_2       => FALSE,
                 CLKOUT_PHASE_SHIFT      => "NONE",
                 DESKEW_ADJUST           => "SYSTEM_SYNCHRONOUS",
                 DFS_FREQUENCY_MODE      => "LOW",
                 DLL_FREQUENCY_MODE      => "LOW",
                 DUTY_CYCLE_CORRECTION   => TRUE,
                 FACTORY_JF 			 => x"C080",
                 PHASE_SHIFT             => 0,
                 STARTUP_WAIT            => FALSE
            )

      port map (
                PSCLK				=> GND_BIT,
                PSEN				=> GND_BIT,
                PSINCDEC			=> GND_BIT,				
				
                CLKFB    => CLKFB_IN,
                CLKIN    => CLK,
                RST      => RST,
                LOCKED   => LOCKED,

                CLK0     => CLK0_BUF,

                CLKDV    => ReplaceWith_CLKDV_MAP,
                CLKFX    => ReplaceWith_CLKFX_MAP,
                CLKFX180 => ReplaceWith_CLKFX180_MAP,
                CLK2X    => ReplaceWith_CLK2X_MAP,
                CLK2X180 => ReplaceWith_CLK2X180_MAP,
                CLK90    => ReplaceWith_CLK90_MAP,
                CLK180   => ReplaceWith_CLK180_MAP,
                CLK270   => ReplaceWith_CLK270_MAP
           );

end RTL;
-- ----------------------------------------------------------------------------

