-- ----------------------------------------------------------------------------
-- Lattice: EPLLD (ECP2 / ECP2M)
-- ----------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

-- ----------------------------------------------------------------------------
entity ReplaceWith_EntityName is
    port (
           CLKA   : out   std_logic;                    -- IncludeIf_CLKA
           CLKB   : out   std_logic;                    -- IncludeIf_CLKB
           CLKC   : out   std_logic;                    -- IncludeIf_CLKC
                                                     
           LOCKED : out   std_logic;                   
           CLK    : in    std_logic;
           RST    : in    std_logic
    );
    attribute dont_touch : string;
    attribute dont_touch of ReplaceWith_EntityName : entity is "true";
end;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
architecture RTL of ReplaceWith_EntityName is

    signal GND_BIT  : std_logic;
    signal CLKOP_t  : std_logic;
    signal CLK_t    : std_logic;

    component EPLLD
        port (  CLKI    : in std_logic;
                CLKFB   : in std_logic;
                RST     : in std_logic;
                RSTK    : in std_logic;
                DPAMODE : in std_logic;
                DRPAI3  : in std_logic;
                DRPAI2  : in std_logic;
                DRPAI1  : in std_logic;
                DRPAI0  : in std_logic;
                DFPAI3  : in std_logic;
                DFPAI2  : in std_logic;
                DFPAI1  : in std_logic;
                DFPAI0  : in std_logic;
                CLKOP   : out std_logic;
                CLKOS   : out std_logic;
                CLKOK   : out std_logic;
                LOCK    : out std_logic;
                CLKINTFB: out std_logic
                );
    end component;
    
    attribute DELAY_CNTL                            : string;
    attribute FDEL                                  : string;
    attribute DUTY                                  : string;
    attribute PHASEADJ                              : string;
    attribute FB_MODE                               : string;
    attribute FREQUENCY_PIN_CLKOS                   : string;
    attribute FREQUENCY_PIN_CLKOP                   : string;
    attribute FREQUENCY_PIN_CLKI                    : string;
    attribute FREQUENCY_PIN_CLKOK                   : string;
    attribute CLKOK_DIV                             : string;
    attribute CLKOP_DIV                             : string;
    attribute CLKFB_DIV                             : string;
    attribute CLKI_DIV                              : string;
    attribute FIN                                   : string;
    attribute DELAY_CNTL of EHXPLLB_INST            : label is "STATIC";
    attribute FDEL of EHXPLLB_INST                  : label is "0";
    attribute DUTY of EHXPLLB_INST                  : label is "4";
    attribute PHASEADJ of EHXPLLB_INST              : label is "ReplaceWith_CLKOS_PHASE";
    attribute FB_MODE of EHXPLLB_INST               : label is "CLOCKTREE";
    attribute FREQUENCY_PIN_CLKOS of EHXPLLB_INST   : label is "ReplaceWith_CLKOS_FREQ";
    attribute FREQUENCY_PIN_CLKOP of EHXPLLB_INST   : label is "ReplaceWith_CLKOP_FREQ";
    attribute FREQUENCY_PIN_CLKI of EHXPLLB_INST    : label is "ReplaceWith_CLKI_FREQ";
    attribute FREQUENCY_PIN_CLKOK of EHXPLLB_INST   : label is "ReplaceWith_CLKOK_FREQ";
    attribute CLKOK_DIV of EHXPLLB_INST             : label is "ReplaceWith_CLKOK_DIVIDE";
    attribute CLKOP_DIV of EHXPLLB_INST             : label is "ReplaceWith_VCO_MULTIPLY";
    attribute CLKFB_DIV of EHXPLLB_INST             : label is "ReplaceWith_CLKOP_MULTIPLY";
    attribute CLKI_DIV of EHXPLLB_INST              : label is "ReplaceWith_CLKOP_DIVIDE";
    attribute FIN of EHXPLLB_INST                   : label is "ReplaceWith_CLKI_FREQ";
    attribute syn_keep                              : boolean;
    attribute syn_noprune                           : boolean;
    attribute syn_noprune of RTL                    : architecture is true;
                                           
begin
    
    GND_BIT <= '0';
    
    ReplaceWith_CLKOP_MAP <= CLKOP_t;                                   -- IncludeIf_CLKOP_MAP
    CLK_t <= CLK;
    
    EHXPLLB_INST: EPLLD
        port map (  CLKI     => CLK_t,
                    CLKFB    => CLKOP_t,
                    RST      => RST,
                    RSTK     => GND_BIT,
                    DPAMODE  => GND_BIT,
                    DRPAI3   => GND_BIT,
                    DRPAI2   => GND_BIT,
                    DRPAI1   => GND_BIT,
                    DRPAI0   => GND_BIT,
                    DFPAI3   => GND_BIT,
                    DFPAI2   => GND_BIT,
                    DFPAI1   => GND_BIT,
                    DFPAI0   => GND_BIT,
                    CLKOP    => CLKOP_t,
                    CLKOS    => ReplaceWith_CLKOK_MAP,
                    CLKOK    => ReplaceWith_CLKOK_MAP,
                    LOCK     => LOCKED,
                    CLKINTFB => open);


    
end RTL;
-- ----------------------------------------------------------------------------


