-- ----------------------------------------------------------------------------
-- Altera: ALTPLL
-- ----------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.all;

--LIBRARY altera_mf;
--USE altera_mf.all;

-- ----------------------------------------------------------------------------
entity ReplaceWith_EntityName is
    port (
			CLKA   : out   std_logic;                    -- IncludeIf_CLKA
			CLKB   : out   std_logic;                    -- IncludeIf_CLKB
			CLKC   : out   std_logic;                    -- IncludeIf_CLKC
			CLKD   : out   std_logic;                    -- IncludeIf_CLKD
			CLKE   : out   std_logic;                    -- IncludeIf_CLKE
			
			CLKF   : out   std_logic;                    -- IncludeIf_CLKF
			CLKG   : out   std_logic;                    -- IncludeIf_CLKG
			CLKH   : out   std_logic;                    -- IncludeIf_CLKH
			CLKI   : out   std_logic;                    -- IncludeIf_CLKI
			CLKJ   : out   std_logic;                    -- IncludeIf_CLKJ
                                          
			LOCKED : out   std_logic;                   
			CLK    : in    std_logic := '0';
			RST    : in    std_logic := '0'
    );
end;
-- ----------------------------------------------------------------------------


ARCHITECTURE RTL OF ReplaceWith_EntityName IS

	SIGNAL sub_wire0		: STD_LOGIC_VECTOR (9 DOWNTO 0);
	SIGNAL sub_wire1		: STD_LOGIC ;
	SIGNAL sub_wire2		: STD_LOGIC ;
	SIGNAL sub_wire3		: STD_LOGIC ;
	SIGNAL sub_wire4		: STD_LOGIC ;
	SIGNAL sub_wire5		: STD_LOGIC ;
	SIGNAL sub_wire6		: STD_LOGIC ;
	SIGNAL sub_wire7		: STD_LOGIC ;
	SIGNAL sub_wire8		: STD_LOGIC ;
	SIGNAL sub_wire9		: STD_LOGIC ;
	SIGNAL sub_wire10		: STD_LOGIC ;
	SIGNAL sub_wire11		: STD_LOGIC ;
	SIGNAL sub_wire12		: STD_LOGIC ;
	SIGNAL sub_wire13		: STD_LOGIC_VECTOR (1 DOWNTO 0);
	SIGNAL sub_wire14_bv	: BIT_VECTOR (0 DOWNTO 0);
	SIGNAL sub_wire14		: STD_LOGIC_VECTOR (0 DOWNTO 0);



	COMPONENT altpll
	GENERIC (
		bandwidth_type			: STRING;
			
		clk0_divide_by			: NATURAL;								-- IncludeIf_CLKA
		clk0_duty_cycle			: NATURAL;                              -- IncludeIf_CLKA
		clk0_multiply_by		: NATURAL;                              -- IncludeIf_CLKA
		clk0_phase_shift		: STRING;                               -- IncludeIf_CLKA
		                                                                
		clk1_divide_by			: NATURAL;                              -- IncludeIf_CLKB
		clk1_duty_cycle			: NATURAL;                              -- IncludeIf_CLKB
		clk1_multiply_by		: NATURAL;                              -- IncludeIf_CLKB
		clk1_phase_shift		: STRING;                               -- IncludeIf_CLKB
		                                                                
		clk2_divide_by			: NATURAL;                              -- IncludeIf_CLKC
		clk2_duty_cycle			: NATURAL;                              -- IncludeIf_CLKC
		clk2_multiply_by		: NATURAL;                              -- IncludeIf_CLKC
		clk2_phase_shift		: STRING;                               -- IncludeIf_CLKC
		                                                                
		clk3_divide_by			: NATURAL;                              -- IncludeIf_CLKD
		clk3_duty_cycle			: NATURAL;                              -- IncludeIf_CLKD
		clk3_multiply_by		: NATURAL;                              -- IncludeIf_CLKD
		clk3_phase_shift		: STRING;                               -- IncludeIf_CLKD
		                                                                
		clk4_divide_by			: NATURAL;                              -- IncludeIf_CLKE
		clk4_duty_cycle			: NATURAL;                              -- IncludeIf_CLKE
		clk4_multiply_by		: NATURAL;                              -- IncludeIf_CLKE
		clk4_phase_shift		: STRING;                               -- IncludeIf_CLKE
		                                                                
		clk5_divide_by			: NATURAL;                              -- IncludeIf_CLKF
		clk5_duty_cycle			: NATURAL;                              -- IncludeIf_CLKF
		clk5_multiply_by		: NATURAL;                              -- IncludeIf_CLKF
		clk5_phase_shift		: STRING;                               -- IncludeIf_CLKF
		                                                                
		clk6_divide_by			: NATURAL;                              -- IncludeIf_CLKG
		clk6_duty_cycle			: NATURAL;                              -- IncludeIf_CLKG
		clk6_multiply_by		: NATURAL;                              -- IncludeIf_CLKG
		clk6_phase_shift		: STRING;                               -- IncludeIf_CLKG
		                                                                
		clk7_divide_by			: NATURAL;                              -- IncludeIf_CLKH
		clk7_duty_cycle			: NATURAL;                              -- IncludeIf_CLKH
		clk7_multiply_by		: NATURAL;                              -- IncludeIf_CLKH
		clk7_phase_shift		: STRING;                               -- IncludeIf_CLKH
		                                                                
		clk8_divide_by			: NATURAL;                              -- IncludeIf_CLKI
		clk8_duty_cycle			: NATURAL;                              -- IncludeIf_CLKI
		clk8_multiply_by		: NATURAL;                              -- IncludeIf_CLKI
		clk8_phase_shift		: STRING;                               -- IncludeIf_CLKI
		                                                                
		clk9_divide_by			: NATURAL;                              -- IncludeIf_CLKJ
		clk9_duty_cycle			: NATURAL;                              -- IncludeIf_CLKJ
		clk9_multiply_by		: NATURAL;                              -- IncludeIf_CLKJ
		clk9_phase_shift		: STRING;                               -- IncludeIf_CLKJ
		                                                         
		compensate_clock		: STRING;
		inclk0_input_frequency	: NATURAL;
		intended_device_family	: STRING;
		lpm_hint				: STRING;
		lpm_type				: STRING;
		operation_mode			: STRING;
		pll_type				: STRING;
		port_activeclock		: STRING;
		port_areset				: STRING;
		port_clkbad0			: STRING;
		port_clkbad1			: STRING;
		port_clkloss			: STRING;
		port_clkswitch			: STRING;
		port_configupdate		: STRING;
		port_fbin				: STRING;
		port_inclk0				: STRING;
		port_inclk1				: STRING;
		port_locked				: STRING;
		port_pfdena				: STRING;
		port_phasecounterselect	: STRING;
		port_phasedone			: STRING;
		port_phasestep			: STRING;
		port_phaseupdown		: STRING;
		port_pllena				: STRING;
		port_scanaclr			: STRING;
		port_scanclk			: STRING;
		port_scanclkena			: STRING;
		port_scandata			: STRING;
		port_scandataout		: STRING;
		port_scandone			: STRING;
		port_scanread			: STRING;
		port_scanwrite			: STRING;
		port_clk0				: STRING;								-- IncludeIf_CLKA
		port_clk1				: STRING;                               -- IncludeIf_CLKB
		port_clk2				: STRING;                               -- IncludeIf_CLKC
		port_clk3				: STRING;                               -- IncludeIf_CLKD
		port_clk4				: STRING;                               -- IncludeIf_CLKE
		port_clk5				: STRING;                               -- IncludeIf_CLKF
		port_clk6				: STRING;                               -- IncludeIf_CLKG
		port_clk7				: STRING;                               -- IncludeIf_CLKH
		port_clk8				: STRING;                               -- IncludeIf_CLKI
		port_clk9				: STRING;                               -- IncludeIf_CLKJ
		port_clkena0			: STRING;                            
		port_clkena1			: STRING;
		port_clkena2			: STRING;
		port_clkena3			: STRING;
		port_clkena4			: STRING;
		port_clkena5			: STRING;
		self_reset_on_loss_lock	: STRING;
		using_fbmimicbidir_port : STRING;
		width_clock				: NATURAL
	);
	PORT (
			inclk	: IN STD_LOGIC_VECTOR (1 DOWNTO 0);
			locked	: OUT STD_LOGIC ;
			areset	: IN STD_LOGIC ;
			clk		: OUT STD_LOGIC_VECTOR (9 DOWNTO 0)
	);
	END COMPONENT;

BEGIN
	sub_wire14_bv(0 DOWNTO 0) <= "0";
	sub_wire14    <= To_stdlogicvector(sub_wire14_bv);
	
	sub_wire1    <= sub_wire0(0);										-- IncludeIf_CLKA		
	sub_wire2    <= sub_wire0(1);                                       -- IncludeIf_CLKB
	sub_wire3    <= sub_wire0(2);                                       -- IncludeIf_CLKC
	sub_wire4    <= sub_wire0(3);                                       -- IncludeIf_CLKD
	sub_wire5    <= sub_wire0(4);                                       -- IncludeIf_CLKE
	sub_wire6    <= sub_wire0(5);                                       -- IncludeIf_CLKF
	sub_wire7    <= sub_wire0(6);                                       -- IncludeIf_CLKG
	sub_wire8    <= sub_wire0(7);                                       -- IncludeIf_CLKH
	sub_wire9    <= sub_wire0(8);                                       -- IncludeIf_CLKI
	sub_wire10   <= sub_wire0(9);                                       -- IncludeIf_CLKJ
                                                            
	CLKA    	 <= sub_wire1;											-- IncludeIf_CLKA                
	CLKB    	 <= sub_wire2;                                          -- IncludeIf_CLKB
	CLKC    	 <= sub_wire3;                                          -- IncludeIf_CLKC
	CLKD    	 <= sub_wire4;                                          -- IncludeIf_CLKD
	CLKE    	 <= sub_wire5;                                          -- IncludeIf_CLKE
	CLKF    	 <= sub_wire6;                                          -- IncludeIf_CLKF	
	CLKG    	 <= sub_wire7;                                          -- IncludeIf_CLKG
	CLKH    	 <= sub_wire8;                                          -- IncludeIf_CLKH
	CLKI    	 <= sub_wire9;                                          -- IncludeIf_CLKI
	CLKJ    	 <= sub_wire10;                                         -- IncludeIf_CLKJ
	
	locked		 <= sub_wire11;
	sub_wire12   <= CLK;
	sub_wire13   <= sub_wire14(0 DOWNTO 0) & sub_wire12;
	
	altpll_component : altpll
	GENERIC MAP (
		clk0_divide_by         => ReplaceWith_C0_DIVIDE,				-- IncludeIf_CLKA
		clk0_duty_cycle        => 50,                                	-- IncludeIf_CLKA
		clk0_multiply_by       => ReplaceWith_C0_MULTIPLY,        		-- IncludeIf_CLKA
		clk0_phase_shift       => "ReplaceWith_C0_PHASE",       		-- IncludeIf_CLKA
		                                                         
		clk1_divide_by         => ReplaceWith_C1_DIVIDE,				-- IncludeIf_CLKB
		clk1_duty_cycle        => 50,	                             	-- IncludeIf_CLKB
		clk1_multiply_by       => ReplaceWith_C1_MULTIPLY        		-- IncludeIf_CLKB
		clk1_phase_shift       => "ReplaceWith_C1_PHASE",        		-- IncludeIf_CLKB
		                                                          
		clk2_divide_by         => ReplaceWith_C2_DIVIDE,				-- IncludeIf_CLKC
		clk2_duty_cycle        => 50,                                	-- IncludeIf_CLKC
		clk2_multiply_by       => ReplaceWith_C2_MULTIPLY,        		-- IncludeIf_CLKC
		clk2_phase_shift       => "ReplaceWith_C2_PHASE",         		-- IncludeIf_CLKC
		
		clk3_divide_by         => ReplaceWith_C3_DIVIDE,				-- IncludeIf_CLKD
		clk3_duty_cycle        => 50,                                	-- IncludeIf_CLKD
		clk3_multiply_by       => ReplaceWith_C3_MULTIPLY,        		-- IncludeIf_CLKD
		clk3_phase_shift       => "ReplaceWith_C3_PHASE",        		-- IncludeIf_CLKD
		
		clk4_divide_by         => ReplaceWith_C4_DIVIDE,				-- IncludeIf_CLKE
		clk4_duty_cycle        => 50,                                	-- IncludeIf_CLKE
		clk4_multiply_by       => ReplaceWith_C4_MULTIPLY,       		-- IncludeIf_CLKE
		clk4_phase_shift       => "ReplaceWith_C4_PHASE",        		-- IncludeIf_CLKE
		
		clk5_divide_by         => ReplaceWith_C5_DIVIDE,				-- IncludeIf_CLKF
		clk5_duty_cycle        => 50,                                	-- IncludeIf_CLKF
		clk5_multiply_by       => ReplaceWith_C5_MULTIPLY,        		-- IncludeIf_CLKF
		clk5_phase_shift       => "ReplaceWith_C5_PHASE",        		-- IncludeIf_CLKF
		
		clk6_divide_by         => ReplaceWith_C6_DIVIDE,				-- IncludeIf_CLKG
		clk6_duty_cycle        => 50,                                	-- IncludeIf_CLKG
		clk6_multiply_by       => ReplaceWith_C6_MULTIPLY,        		-- IncludeIf_CLKG
		clk6_phase_shift       => "ReplaceWith_C6_PHASE",         		-- IncludeIf_CLKG
		
		clk7_divide_by         => ReplaceWith_C7_DIVIDE,				-- IncludeIf_CLKH
		clk7_duty_cycle        => 50,                                	-- IncludeIf_CLKH
		clk7_multiply_by       => ReplaceWith_C7_MULTIPLY,       		-- IncludeIf_CLKH
		clk7_phase_shift       => "ReplaceWith_C7_PHASE",        		-- IncludeIf_CLKH
		
		clk8_divide_by         => ReplaceWith_C8_DIVIDE,				-- IncludeIf_CLKI
		clk8_duty_cycle        => 50,                                	-- IncludeIf_CLKI
		clk8_multiply_by       => ReplaceWith_C8_MULTIPLY,         		-- IncludeIf_CLKI
		clk8_phase_shift       => "ReplaceWith_C8_PHASE",,        		-- IncludeIf_CLKI
		
		clk9_divide_by         => ReplaceWith_C9_DIVIDE,				-- IncludeIf_CLKJ
		clk9_duty_cycle        => 50,                                	-- IncludeIf_CLKJ
		clk9_multiply_by       => ReplaceWith_C9_MULTIPLY,        		-- IncludeIf_CLKJ
		clk9_phase_shift       => "ReplaceWith_C9_PHASE",        		-- IncludeIf_CLKJ
		
		
		bandwidth_type 			=> "AUTO",
		compensate_clock       	=> "CLK0",
		inclk0_input_frequency 	=> ReplaceWith_CLKIN_PERIOD, --20000,
		intended_device_family 	=> "ReplaceWith_DEVICE_FAMILY",
		lpm_hint 			   	=> "CBX_MODULE_PREFIX=ReplaceWith_EntityName",
		lpm_type 			   	=> "altpll",
		operation_mode 		   	=> "NORMAL",
		pll_type 			   	=> "AUTO",
		port_activeclock 	   	=> "PORT_UNUSED",
		port_areset 		   	=> "PORT_USED",
		port_clkbad0           	=> "PORT_UNUSED",
		port_clkbad1           	=> "PORT_UNUSED",
		port_clkloss           	=> "PORT_UNUSED",
		port_clkswitch         	=> "PORT_UNUSED",
		port_configupdate      	=> "PORT_UNUSED",
		port_fbin              	=> "PORT_UNUSED",
		port_inclk0            	=> "PORT_USED",
		port_inclk1            	=> "PORT_UNUSED",
		port_locked            	=> "PORT_USED",
		port_pfdena            	=> "PORT_UNUSED",
		port_phasecounterselect	=> "PORT_UNUSED",
		port_phasedone         	=> "PORT_UNUSED",
		port_phasestep         	=> "PORT_UNUSED",
		port_phaseupdown       	=> "PORT_UNUSED",
		port_pllena            	=> "PORT_UNUSED",
		port_scanaclr          	=> "PORT_UNUSED",
		port_scanclk           	=> "PORT_UNUSED",
		port_scanclkena        	=> "PORT_UNUSED",
		port_scandata          	=> "PORT_UNUSED",
		port_scandataout       	=> "PORT_UNUSED",
		port_scandone          	=> "PORT_UNUSED",
		port_scanread          	=> "PORT_UNUSED",
		port_scanwrite         	=> "PORT_UNUSED",
		port_clk0              	=> "ReplaceWith_CLKA",					-- IncludeIf_CLKA
		port_clk1              	=> "ReplaceWith_CLKB",                	-- IncludeIf_CLKB
		port_clk2              	=> "ReplaceWith_CLKC",                	-- IncludeIf_CLKC
		port_clk3              	=> "ReplaceWith_CLKD",                	-- IncludeIf_CLKD
		port_clk4              	=> "ReplaceWith_CLKE",                	-- IncludeIf_CLKE
		port_clk5              	=> "ReplaceWith_CLKF",                	-- IncludeIf_CLKF
		port_clk6              	=> "ReplaceWith_CLKG",                	-- IncludeIf_CLKG
		port_clk7              	=> "ReplaceWith_CLKH",                	-- IncludeIf_CLKH
		port_clk8              	=> "ReplaceWith_CLKI",                	-- IncludeIf_CLKI
		port_clk9              	=> "ReplaceWith_CLKJ",	               	-- IncludeIf_CLKJ
		port_clkena0           	=> "PORT_UNUSED",                     
		port_clkena1           	=> "PORT_UNUSED",
		port_clkena2           	=> "PORT_UNUSED",
		port_clkena3           	=> "PORT_UNUSED",
		port_clkena4           	=> "PORT_UNUSED",
		port_clkena5           	=> "PORT_UNUSED",

		self_reset_on_loss_lock => "OFF",
		using_fbmimicbidir_port => "OFF",
		width_clock 			=> 10
	)
	PORT MAP (
		inclk 	=> sub_wire13,
		areset 	=> RST,
		clk 	=> sub_wire0,
		locked 	=> sub_wire11
	);



END RTL;
