-- ----------------------------------------------------------------------------
-- Actel: PLL
-- ----------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.ALL;
Use ieee.std_logic_unsigned.ALL;
use ieee.numeric_std.ALL;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
entity ReplaceWith_EntityName is
    port (
           CLKA   : out   std_logic;                       -- IncludeIf_GLA_MAP
           CLKB   : out   std_logic;                       -- IncludeIf_GLB_MAP
           CLKC   : out   std_logic;                       -- IncludeIf_GLC_MAP

           LOCKED : out   std_logic;
           CLK    : in    std_logic;
           RST    : in    std_logic
    );
end;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
architecture RTL of ReplaceWith_EntityName is
                                     
    signal VCC_BIT      : std_logic;
    signal GND_BIT      : std_logic;
    signal RST_N        : std_logic;
    signal CLK_GBUF     : std_logic;

    signal U_SIG        : std_logic_vector( 4 downto 0 );
    signal V_SIG        : std_logic_vector( 4 downto 0 );
    signal W_SIG        : std_logic_vector( 4 downto 0 );
    signal N_SIG        : std_logic_vector( 6 downto 0 );
    signal M_SIG        : std_logic_vector( 6 downto 0 );
    signal VCOSEL_SIG   : std_logic_vector( 2 downto 0 );
    signal GLAMUX_SIG   : std_logic_vector( 2 downto 0 );
    signal GLBMUX_SIG   : std_logic_vector( 2 downto 0 );
    signal GLCMUX_SIG   : std_logic_vector( 2 downto 0 );

    component VCC
        port (
            Y : out std_logic
        );
    end component;

    component GND
        port (
            Y : out std_logic
        );
    end component;

    component INV
        port (
            A : in std_logic := 'U';
            Y : out std_logic
        );
    end component;

    component PLLINT
        port (
            A : in std_logic := 'U';
            Y : out std_logic
        );
    end component;

    component PLL
        generic (
            VCOFREQUENCY : real := 0.0
        );
        port (
            CLKA      : in std_logic := 'U';
            EXTFB     : in std_logic := 'U';
            POWERDOWN : in std_logic := 'U';
            GLA       : out std_logic;
            LOCK      : out std_logic;
            GLB       : out std_logic;
            YB        : out std_logic;
            GLC       : out std_logic;
            YC        : out std_logic;
            OADIV0    : in std_logic := 'U';
            OADIV1    : in std_logic := 'U';
            OADIV2    : in std_logic := 'U';
            OADIV3    : in std_logic := 'U';
            OADIV4    : in std_logic := 'U';
            OAMUX0    : in std_logic := 'U';
            OAMUX1    : in std_logic := 'U';
            OAMUX2    : in std_logic := 'U';
            DLYGLA0   : in std_logic := 'U';
            DLYGLA1   : in std_logic := 'U';
            DLYGLA2   : in std_logic := 'U';
            DLYGLA3   : in std_logic := 'U';
            DLYGLA4   : in std_logic := 'U';
            OBDIV0    : in std_logic := 'U';
            OBDIV1    : in std_logic := 'U';
            OBDIV2    : in std_logic := 'U';
            OBDIV3    : in std_logic := 'U';
            OBDIV4    : in std_logic := 'U';
            OBMUX0    : in std_logic := 'U';
            OBMUX1    : in std_logic := 'U';
            OBMUX2    : in std_logic := 'U';
            DLYYB0    : in std_logic := 'U';
            DLYYB1    : in std_logic := 'U';
            DLYYB2    : in std_logic := 'U';
            DLYYB3    : in std_logic := 'U';
            DLYYB4    : in std_logic := 'U';
            DLYGLB0   : in std_logic := 'U';
            DLYGLB1   : in std_logic := 'U';
            DLYGLB2   : in std_logic := 'U';
            DLYGLB3   : in std_logic := 'U';
            DLYGLB4   : in std_logic := 'U';
            OCDIV0    : in std_logic := 'U';
            OCDIV1    : in std_logic := 'U';
            OCDIV2    : in std_logic := 'U';
            OCDIV3    : in std_logic := 'U';
            OCDIV4    : in std_logic := 'U';
            OCMUX0    : in std_logic := 'U';
            OCMUX1    : in std_logic := 'U';
            OCMUX2    : in std_logic := 'U';
            DLYYC0    : in std_logic := 'U';
            DLYYC1    : in std_logic := 'U';
            DLYYC2    : in std_logic := 'U';
            DLYYC3    : in std_logic := 'U';
            DLYYC4    : in std_logic := 'U';
            DLYGLC0   : in std_logic := 'U';
            DLYGLC1   : in std_logic := 'U';
            DLYGLC2   : in std_logic := 'U';
            DLYGLC3   : in std_logic := 'U';
            DLYGLC4   : in std_logic := 'U';
            FINDIV0   : in std_logic := 'U';
            FINDIV1   : in std_logic := 'U';
            FINDIV2   : in std_logic := 'U';
            FINDIV3   : in std_logic := 'U';
            FINDIV4   : in std_logic := 'U';
            FINDIV5   : in std_logic := 'U';
            FINDIV6   : in std_logic := 'U';
            FBDIV0    : in std_logic := 'U';
            FBDIV1    : in std_logic := 'U';
            FBDIV2    : in std_logic := 'U';
            FBDIV3    : in std_logic := 'U';
            FBDIV4    : in std_logic := 'U';
            FBDIV5    : in std_logic := 'U';
            FBDIV6    : in std_logic := 'U';
            FBDLY0    : in std_logic := 'U';
            FBDLY1    : in std_logic := 'U';
            FBDLY2    : in std_logic := 'U';
            FBDLY3    : in std_logic := 'U';
            FBDLY4    : in std_logic := 'U';
            FBSEL0    : in std_logic := 'U';
            FBSEL1    : in std_logic := 'U';
            XDLYSEL   : in std_logic := 'U';
            VCOSEL0   : in std_logic := 'U';
            VCOSEL1   : in std_logic := 'U';
            VCOSEL2   : in std_logic := 'U'
        ) ;
    end component;

begin

    VCC_INST : VCC
        port map (
            Y => VCC_BIT
        );

    GND_INST : GND
        port map (
            Y => GND_BIT
        );

    INV_IST : INV
        port map (
            A => RST,
            Y => RST_N
        );

    PLLINT_INST : PLLINT
        port map (
            A => CLK,
            Y => CLK_GBUF
        );

    PLL_INST : PLL
        generic map (
            VCOFREQUENCY => ReplaceWith_VCO_FRQ
        )
        port map (
            CLKA      => CLK_GBUF,
            EXTFB     => GND_BIT,
            POWERDOWN => RST_N,
            GLA       => ReplaceWith_GLA_MAP,
            LOCK      => LOCKED,
            GLB       => ReplaceWith_GLB_MAP,
            YB        => OPEN ,
            GLC       => ReplaceWith_GLC_MAP,
            YC        => OPEN ,

            OADIV0    => U_SIG(0),
            OADIV1    => U_SIG(1),
            OADIV2    => U_SIG(2),       -- 5-BIT OUTPUT DIVIDER (/U)
            OADIV3    => U_SIG(3),
            OADIV4    => U_SIG(4),

            OAMUX0    => GLAMUX_SIG(0),
            OAMUX1    => GLAMUX_SIG(1),  -- 3-BIT POST-PLL MUXA (BEFORE DIVIDER /U)
            OAMUX2    => GLAMUX_SIG(2),

            DLYGLA0   => GND_BIT,
            DLYGLA1   => GND_BIT,
            DLYGLA2   => GND_BIT,        -- DELAY ON GLOBAL A
            DLYGLA3   => GND_BIT,
            DLYGLA4   => GND_BIT,

            OBDIV0    => V_SIG(0),
            OBDIV1    => V_SIG(1),
            OBDIV2    => V_SIG(2),       -- 5-BIT OUTPUT DIVIDER (/V)
            OBDIV3    => V_SIG(3),
            OBDIV4    => V_SIG(4),

            OBMUX0    => GLBMUX_SIG(0),
            OBMUX1    => GLBMUX_SIG(1),  -- 3-BIT POST-PLL MUXB (BEFORE DIVIDER /V)
            OBMUX2    => GLBMUX_SIG(2),

            DLYYB0    => GND_BIT,
            DLYYB1    => GND_BIT,
            DLYYB2    => GND_BIT,
            DLYYB3    => GND_BIT,
            DLYYB4    => GND_BIT,

            DLYGLB0   => GND_BIT,
            DLYGLB1   => GND_BIT,
            DLYGLB2   => GND_BIT,        -- DELAY ON GLOBAL B
            DLYGLB3   => GND_BIT,
            DLYGLB4   => GND_BIT,

            OCDIV0    => W_SIG(0),
            OCDIV1    => W_SIG(1),
            OCDIV2    => W_SIG(2),       -- 5-BIT OUTPUT DIVIDER (/W)
            OCDIV3    => W_SIG(3),
            OCDIV4    => W_SIG(4),

            OCMUX0    => GLCMUX_SIG(0),
            OCMUX1    => GLCMUX_SIG(1),  -- 3-BIT POST-PLL MUXC (BEFORE DIVIDER /W)
            OCMUX2    => GLCMUX_SIG(2),

            DLYYC0    => GND_BIT,
            DLYYC1    => GND_BIT,
            DLYYC2    => GND_BIT,
            DLYYC3    => GND_BIT,
            DLYYC4    => GND_BIT,

            DLYGLC0   => GND_BIT,
            DLYGLC1   => GND_BIT,
            DLYGLC2   => GND_BIT,        -- DELAY ON GLOBAL C
            DLYGLC3   => GND_BIT,
            DLYGLC4   => GND_BIT,

            FINDIV0   => N_SIG(0),
            FINDIV1   => N_SIG(1),
            FINDIV2   => N_SIG(2),
            FINDIV3   => N_SIG(3),       -- 7-BIT INPUT DIVIDER (/N)
            FINDIV4   => N_SIG(4),
            FINDIV5   => N_SIG(5),
            FINDIV6   => N_SIG(6),

            FBDIV0    => M_SIG(0),
            FBDIV1    => M_SIG(1),
            FBDIV2    => M_SIG(2),
            FBDIV3    => M_SIG(3),       -- 7-BIT FEEDBACK DIVIDER (/M)
            FBDIV4    => M_SIG(4),
            FBDIV5    => M_SIG(5),
            FBDIV6    => M_SIG(6),                   

            FBDLY0    => GND_BIT,
            FBDLY1    => GND_BIT,
            FBDLY2    => GND_BIT,        -- FEEDBACK DELAY
            FBDLY3    => GND_BIT,
            FBDLY4    => GND_BIT,

            FBSEL0    => VCC_BIT,        -- 2-BIT PLL FEEDBACK MUX
            FBSEL1    => GND_BIT,

            XDLYSEL   => GND_BIT,        -- 1-BIT PLL FEEDBACK MUX

            VCOSEL0   => VCOSEL_SIG(0),
            VCOSEL1   => VCOSEL_SIG(1),  -- 3-BIT VCO GEAR CONTROL (4 FREQUENCY RANGES)
            VCOSEL2   => VCOSEL_SIG(2)
        );

    N_SIG      <= std_logic_vector(to_unsigned(ReplaceWith_VCO_DIV-1, 7));
    M_SIG      <= std_logic_vector(to_unsigned(ReplaceWith_VCO_MUL-1, 7));
    U_SIG      <= std_logic_vector(to_unsigned(ReplaceWith_GLA_DIV-1, 5));      -- m/(n*u)
    V_SIG      <= std_logic_vector(to_unsigned(ReplaceWith_GLB_DIV-1, 5));      -- m/(n*v)
    W_SIG      <= std_logic_vector(to_unsigned(ReplaceWith_GLC_DIV-1, 5));      -- m/(n*w)

    GLAMUX_SIG <= std_logic_vector(to_unsigned(ReplaceWith_GLA_PHS, 3));
    GLBMUX_SIG <= std_logic_vector(to_unsigned(ReplaceWith_GLB_PHS, 3));
    GLCMUX_SIG <= std_logic_vector(to_unsigned(ReplaceWith_GLC_PHS, 3));

    VCOSEL_SIG(0)          <= GND_BIT;
    VCOSEL_SIG(2 downto 1) <= std_logic_vector(to_unsigned(ReplaceWith_VCO_SEL, 2));

end RTL;
-- ----------------------------------------------------------------------------

