#
# Framework general makefile
#
# Always included from the embedded project's makefile.
# Note that 'SWPLATFORM' is defined in the embedded project's makefile.
# 

# Path definitions

SSASROOT     = $(SWPLATFORM) 
PLTFROOT     = $(SSASROOT)\platform
SERROOT      = $(SSASROOT)\services

SSASOUT      = frameout
SSASOUTDIR   = $(OUTDIR)\$(SSASOUT)

SSASCFG      = framecfg
SSASCFGDIR   = $(OUTDIR)\$(SSASCFG)

# compiler and assembler

CC  = $(PRODDIR)\c$(TARGET)\bin\cc$(TARGET)
ASM = $(PRODDIR)\c$(TARGET)\bin\as$(TARGET)


# 
# rules
#

# we need at least a dummy object
SSASOBJ =
SSASOBJ += "$(SSASOUTDIR)\dummy.obj"
"$(SSASOUTDIR)\dummy.obj.opt" : $(MAKEFILE)
    @argfile "$(SSASOUTDIR)\dummy.obj.opt" $(OPT_ARCH) $(OPT_CPU) $(OPT_CC_SSAS_LITE) $(OPT_CC)

"$(SSASOUTDIR)\dummy.obj" : "$(SSASROOT)\make\src\dummy.c" "$(SSASOUTDIR)\dummy.obj.opt"
    @echo Building Software Platform
    "$(CC)" -c "$(SSASROOT)\make\src\dummy.c"  -o "$@" -f "$(SSASOUTDIR)\dummy.obj.opt"

# include project specific generated makefile
MAKEFILE += "$(SSASOUTDIR)\__framework.makefile"
include "$(SSASOUTDIR)\__framework.makefile"

# add a ssas cstart 
SSASOBJ += "$(SSASOUTDIR)\cstart.obj"
"$(SSASOUTDIR)\cstart.obj.opt" : $(MAKEFILE)
    @argfile "$(SSASOUTDIR)\cstart.obj.opt" $(OPT_ARCH) $(OPT_CPU) $(OPT_CC_SSAS_LITE) $(OPT_CC)

"$(SSASOUTDIR)\cstart.obj" : "$(SSASOUTDIR)\cstart.obj.opt"
    @cmd /C if exist "$(SSASROOT)\make\src\c$(TARGET)\cstart.asm" "$(CC)" -c "$(SSASROOT)\make\src\c$(TARGET)\cstart.asm" -o "$@" -f "$(SSASOUTDIR)\cstart.obj.opt"
    @cmd /C if exist "$(SSASROOT)\make\src\c$(TARGET)\cstart.c"   "$(CC)" -c "$(SSASROOT)\make\src\c$(TARGET)\cstart.c" -o "$@" -f "$(SSASOUTDIR)\cstart.obj.opt"

# add a ssas exit to avoid dbg _exit call
SSASOBJ += "$(SSASOUTDIR)\exit.obj"
"$(SSASOUTDIR)\exit.obj.opt" : $(MAKEFILE)
    @argfile "$(SSASOUTDIR)\exit.obj.opt" $(OPT_ARCH) $(OPT_CPU) $(OPT_CC_SSAS_LITE) $(OPT_CC)

"$(SSASOUTDIR)\exit.obj" : "$(SSASOUTDIR)\exit.obj.opt" 
    @cmd /C if exist "$(SSASROOT)\make\src\c$(TARGET)\exit.c"     "$(CC)" -c "$(SSASROOT)\make\src\c$(TARGET)\exit.c" -o "$@" -f "$(SSASOUTDIR)\exit.obj.opt"

# build final software platform library
"$(SSASOUTDIR)\__framework.lib.opt" : $(MAKEFILE)
    @argfile "$(SSASOUTDIR)\__framework.lib.opt" $(SSASOBJ)

"$(SSASOUTDIR)\__framework.lib": $(SSASOBJ) "$(SSASOUTDIR)\__framework.lib.opt"
    "$(PRODDIR)\bin\tlb" -n -r "$@" -f "$(SSASOUTDIR)\__framework.lib.opt"
    @echo Software platform built
