<?xml version="1.0"?>
<tool_chain>
    <doil_version>1.1</doil_version>
    <name>Global Options</name>
    <abbrev>GlobalOpts</abbrev> 
    <include_only/>
    <global_scripts>
        Procedure AddMemConstraint;
        begin
            DXP.AddToolDependency(DXP.OutDir + DXP.ProjectName + '_mem.lsl','LK');
            DXP.AddToolDependency(DXP.OutDir + DXP.ProjectName + '.lsl','LK');  
            DXP.AddToolCmdOption('-d"' + DXP.OutDir + DXP.ProjectName + '_mem.lsl"');
        end;
        Function projQualifierFileName : string;
        Begin
           Result := DXP.OutDir + DXP.ProjectName + '.qua'
        End;
   </global_scripts>
    <options>
        <global/>
        <group id="BuildOptions">
            <global/>
            <caption>Build Options</caption>
            <choices id="CheckOpts">
                <default state="StopAfterError,SilentMode"/>
                <choice id="KeepTmpFiles">
                    <caption>Keep temporary files that are generated during a compile</caption>
                    <tool_tip>Temporary files are the intermediate results of a compile. They appear in the output directory.<br/>
Select this option to track hard to find errors.</tool_tip>
                </choice>
                <choice id="StopAfterError">
                    <caption>Stop build process on error</caption>
                    <tool_tip>The build process can be stopped when an error is encountered in the compile, assemble or link phase.<br/>
Clear this option to finish the build process regardless of errors. The resulting file may not be usable.</tool_tip>
                </choice>
                <choice id="SilentMode">
                    <caption>Silent mode</caption>
                    <tool_tip>Do not print commands before execution.</tool_tip>
                </choice>
                <choice id="AbsolutePathNames">
                    <caption>Use absolute path names in generated makefile</caption>
                    <tool_tip>By default the path names are relative to the project directory.<br/>
Select this option to make the makefile more readable.</tool_tip>
                </choice>
            </choices>
            <choices id="UseMakeOptions_Choice">
                <choice id="UseMakeOptions">
                    <caption>Use additional make options</caption>
                    <tool_tip>Some options of the make utility are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                </choice>
            </choices>
            <text id="MakeOptions">
                <generate_option if="UseMakeOptions.Selected"/>
                <caption>    Additional make options</caption>
                <tool_tip>Some options of the make utility are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                <default state=""/>                
            </text>
            <choices id="UserMakefile_Choice">
                <choice id="UserMakefile">
                    <caption>Use user-defined makefile</caption>
                    <tool_tip>Select this option to use your own makefile instead of the generated makefile.<br/>
This can be useful when you have an existing project makefile, for example for migration to Altium Designer,<br/>
or if you want to add extra functionality Altium Designer has no support for.<br/>
In that case it is best to start with a copy of the generated makefile.</tool_tip>
                </choice>
            </choices>
            <text id="UserMakefileName">
                <generate_option if="UserMakefile.Selected"/>
                <caption>    User-defined makefile</caption>
                <tool_tip>Specify the name of your makefile.</tool_tip>
                <button on_click="DXP.FileOpenDialog(UserMakefileName);"/>
            </text>
            <subgroup>
                <caption>Directories</caption>
                <text id="BinDir">                    
                    <caption>Executable files path</caption>
                    <tool_tip>Indicates to Altium Designer where to look for the TASKING tools (compiler, assembler, linker, ...).<br/>
Specify one or more directories, separated by a semicolon (;).<br/>
Use the macro $(PRODDIR) to specify the TASKING product directory.<br/>
If your installation of Altium Designer is in C:\Program Files\Altium Designer<br/>
then $(PRODDIR) equals C:\Program Files\Altium Designer\System\Tasking.</tool_tip>
                    <button on_click="DXP.PathListDialog(BinDir);"/>
                </text>
                <text id="IncDir">
                    <caption>Include files path</caption>
                    <tool_tip>Indicates to Altium Designer where to look for the include files (*.h).<br/>
Specify one or more directories, separated by a semicolon (;).<br/>
Use the macro $(PRODDIR) to specify the TASKING product directory.<br/>
If your installation of Altium Designer is in C:\Program Files\Altium Designer<br/>
then $(PRODDIR) equals C:\Program Files\Altium Designer\System\Tasking.</tool_tip>
                    <button on_click="DXP.PathListDialog(IncDir);"/>
                </text>
                <text id="LibDir">
                    <caption>Library files path</caption>
                    <tool_tip>Indicates to Altium Designer where to look for the libraries (*.lib).<br/>
Specify one or more directories, separated by a semicolon (;).<br/>
Use the macro $(PRODDIR) to specify the TASKING product directory.<br/>
If your installation of Altium Designer is in C:\Program Files\Altium Designer<br/>
then $(PRODDIR) equals C:\Program Files\Altium Designer\System\Tasking.</tool_tip>
                    <button on_click="DXP.PathListDialog(LibDir);"/>
                </text>
                <text id="LibSearchDir">
                    <caption>Library source files path</caption>
                    <tool_tip>Indicates to the debugger in Altium Designer where to look for the source files of libraries.<br/>
Specify one or more directories, separated by a semicolon (;).<br/>
Use the macro $(PRODDIR) to specify the TASKING product directory.<br/>
If your installation of Altium Designer is in C:\Program Files\Altium Designer<br/>
then $(PRODDIR) equals C:\Program Files\Altium Designer\System\Tasking.</tool_tip>
                    <defaultState_script>
                        '$(PRODDIR)\c' + getTarget + '\lib\src'
                    </defaultState_script>
                    <button on_click="DXP.PathListDialog(LibSearchDir);"/>
                </text>
                <text id="DebugSearchDirs">
                    <caption>Debug search path</caption>
                    <tool_tip>Indicates to the debugger in Altium Designer where to look for the source files
 in addition to the project's folder and library source files folder.<br/>
Specify one or more directories, separated by a semicolon (;).<br/>
Use the macro $(PRODDIR) to specify the TASKING product directory.<br/>
Use the macro $(PROJDIR) to specify the directory where this project resides.</tool_tip>
                    <button on_click="DXP.PathListDialog(DebugSearchDirs);"/>
                </text>
                <text id="OutputDir">
                    <defaultState_script>
                        'Output'
                    </defaultState_script>
                    <caption>Output directory (instead of project directory)</caption>
                    <tool_tip>All files that are generated during a compile appear in this directory.<br/>
If this field is empty, all generated files appear in the project directory.</tool_tip>
                    <button on_click="DXP.DirectoryDialog(OutputDir);"/>
                </text>
                <text id="SwPlatformDir">
                    <caption>Software Platform search path</caption>
                    <tool_tip>Specify locations to look for Software Platform plugins.
Specify one or more directories, separated by a semicolon (;).<br/>
Use the macro $(SWPLATFORM) to specify the default software platform directory. 
If your installation of Altium Designer is in "C:\Program Files\Altium Designer" 
then $(SWPLATFORM) equals "C:\Program Files\Altium Designer\Library\Software Platform".
Use the macro $(PROJDIR) to specify locations relative to the embedded project directory.</tool_tip>
                    <button on_click="DXP.PathListDialog(SwPlatformDir);"/>
                </text>
                <choices id="SPBCheckOpts">
                    <default state="SwPlatformDefault"/>
                    <choice id="SwPlatformDefault">
                    <caption>Add default Software Platform location</caption>
                    <tool_tip>Add the default Software Platform location at the end of the search path.</tool_tip>
                    </choice>
                </choices>
               <choices id="SwPlatformDefaultVersion">
                   <single/>
                   <caption>Default Software Platform Version</caption>
                   <tool_tip>Determines which version of the software platform to use with this project, if "Add default Software Platform Location" is checked.</tool_tip>
                   <default state="Unknown"/>
                   <choice id="S09">
                       <caption>Summer 09</caption>
                   </choice>
                   <choice id="R10">
                       <caption>Release 10</caption>
                   </choice>
               </choices>
            </subgroup>
        </group>
    </options>    
</tool_chain>
