<?xml version="1.0"?>
<!--
    =============================
    2001-2004 Altium BV
    @(#)sdk.xml	1.151 10/08/27
    =============================
-->
<tool_chain>
    <doil_version>1.1</doil_version>
    <name>TASKING PowerPC</name>
    <abbrev>ppc</abbrev>
    <caption>TASKING PowerPC</caption>
    <bin_dir>cppc\bin</bin_dir>
    <obj_suffix>.obj</obj_suffix>
    <include>global.tcc</include>
    <file_filters>
        <file_filter caption="All files (*.*)" filter="*.*"/>
        <file_filter caption="C source file (*.c)" filter="*.c"/>
        <file_filter caption="C++ source file (*.cpp)" filter="*.cpp"/>
        <file_filter caption="Header file (*.h)" filter="*.h"/>
        <file_filter caption="Assembler file (*.asm,*.src,*.inc)" filter="*.asm;*.src;*.inc"/>
        <file_filter caption="Absolute file (*.abs)" filter="*.abs"/>
        <file_filter caption="Library (*.lib)" filter="*.lib"/>
        <file_filter caption="Object file (*.obj)" filter="*.obj"/>
        <file_filter caption="Linker script file (*.lsl)" filter="*.lsl"/>
        <file_filter caption="Debugger config file (*.cfg)" filter="*.cfg"/>
        <file_filter caption="Debugger command file (*.cmd)" filter="*.cmd"/>
        <file_filter caption="Debugger log file (*.log)" filter="*.log"/>
        <file_filter caption="Intel hex file (*.hex)" filter="*.hex"/>
        <file_filter caption="OIL configuration file (*.oil)" filter="*.oil"/>
        <file_filter caption="Software Platform Builder configuration file (*.swplatform)" filter="*.swplatform"/>
    </file_filters>
    <global_scripts>
        Function getTarget : string;
        Begin
           Result := 'ppc'
        End;
        Function projLslFileName : string;
        Begin
           Result := DXP.OutDir + DXP.ProjectName + '.lsl'
        End;
        Function projMemQualHeaderFileName : string;
        Begin
           Result := DXP.OutDir + DXP.ProjectName + '_mem.chc_h'
        End;
    </global_scripts>
    <options>
        <group id="GPProcessor">
            <caption>Processor</caption>
            <generate_option if="CPP_Nature.Selected OR C_Nature.Selected OR ASM_Nature.Selected"/>
            <tool_id id_ref="PROC"/>
            <global/>   
            <group id="PrProcessorDefinition">
                <caption>Processor Definition</caption>
                    <text id="Family">
                        <!-- Set by Altium Designer -->
                        <invisible/>
                        <default state="Legacy"/>
                    </text>
                    <text id="QualifierRedefinitions">
                        <invisible/>
                        <default state="SELECTED"/>
                        <generate_option if="AnsiSameText(ASP_Enable.State,'True')"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddBuildTarget(projMemQualHeaderFileName);
                                DXP.AddToolDependency(projMemQualHeaderFileName, 'CC');
                                DXP.AddToolCmdOption('-Wc--include-file="' + projMemQualHeaderFileName + '"');
                                DXP.SetPrjTargetExt('chc_h');
                            </selected>
                        </makefile_generator>
                    </text>
                <tool_id id_ref="PROC"/>
                <!-- for the oil file --> 
                <file_suffix_in_project id="HasOil"> 
                    <suffix>.oil</suffix>
                    <makefile_generator> 
                        <selected> 
                            OilLibFile := ChangeFileExt(HasOil.State,'.lib');
                            DXP.AddBuildTarget(DXP.OutDir + ExtractFileName(OilLibFile));
                            DXP.AddToolDependency('$(PROJ).rtos\osek.lib','TOC');
                            DXP.AddToolDependency('$(PROJ).rtos\osek.lib','LK');
                            DXP.WriteToFile(DXP.OutDir + 'xvwdll.ini','radm: osek_radm.dll');
                            DXP.WriteToFile(DXP.OutDir + 'xvwdll.ini','orti: ' + DXP.ProjectDir + '\orti.txt'); 
                        </selected>
                    </makefile_generator> 
                </file_suffix_in_project>
                <file_suffix_in_project id="HasAppStack"> 
                    <suffix>.swplatform</suffix>
                    <makefile_generator> 
                        <selected> 
                            AppStackLibFile := ChangeFileExt(HasAppStack.State,'.lib');
                            DXP.AddBuildTarget(DXP.OutDir + ExtractFileName(AppStackLibFile));
                            DXP.AddToolDependency('$(OUTDIR)\frameout\__framework.lib','LK');
                        </selected>
                    </makefile_generator> 
                </file_suffix_in_project>
                <choices id="Processor">
                    <single/>
                    <caption>Processor</caption>
                    <tool_tip>The selected device determines the processor for which the application is compiled and which options are available.</tool_tip>
                    <default state="Proc405"/>
                    <choice id="Proc405">
                        <caption>405</caption>
                        <generate_option if="AnsiSameText(Family.State,'Legacy') OR AnsiSameText(Processor.State, 'Proc405')"/>
                        <makefile_generator>
                            <selected>
                                Processor.Flag := '405';
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Proc440">
                        <caption>440</caption>
                        <generate_option if="AnsiSameText(Family.State,'Legacy') OR AnsiSameText(Processor.State, 'Proc440')"/>
                        <makefile_generator>
                            <selected>
                                Processor.Flag := '440';
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="HwCompCoreCompatibility">
                    <invisible/>
                    <default state="ppc"/>
                </text>
                <text id="HwCompEndianness">
                    <invisible/>
                    <default state="big"/>
                </text>
                <text id="OptCpu">
                    <default state="SELECTED"/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            OPT_CPU := '-C' + Processor.Flag + #13#10;
                        </selected>
                    </makefile_generator>
                </text>
                <text id="XvwdllCpu">
                    <default state="SELECTED"/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            DXP.WriteToFile(DXP.OutDir + 'xvwdll.ini','cpu_type: ' + Processor.Flag);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="OptArch">
                    <default state="SELECTED"/>
                    <invisible/>
                     <makefile_generator>
                        <selected>
                            OptArch.Flag := 'ppc';
                        </selected>
                    </makefile_generator>
                </text>
                <text id="CpuExtMem">
                    <default state="SELECTED"/>
                    <invisible/>
                </text>
            </group>
        </group>

        <text id="CPP_Nature">
            <invisible/>
            <default state="NOTSELECTED"/>
            <generate_option if="DXP.ProjContainsSuffix('.cpp')"/>
        </text>
        <group id="CPP Compiler">
            <caption>C++ Compiler</caption>
            <generate_option if="CPP_Nature.Selected"/>
            <tool_id id_ref="CPP"/>
            <group id="CppPreprocessing">
                <caption>Preprocessing</caption>
                <tool_id id_ref="CPP"/>
                <table_edit id="CppDefine">
                    <caption>User macro</caption>
                    <tool_tip>You can use a macro as a symbol in your C++ source, for example to create conditional C++ code.<br/>
With this option you can assign values to macros you use in your C++ source.<br/>
In the drop-down table, specify a macro name and a value. If you omit the value, the macro expands to 1.</tool_tip>
                    <column caption="Macro">
                        <text id="CppMacro">
                            <caption>Macro</caption>
                        </text>
                    </column>
                    <column caption="Value">
                        <text id="CppValue">
                            <caption>Value</caption>
                        </text>
                    </column>
                    <text id="CppDefine_Loop">
                        <invisible/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--define ' + CppMacro.State + '="' + CppValue.State + '"');
                            </selected>
                        </makefile_generator>
                    </text>
                </table_edit>
                <text id="CppSpecInc">
                    <caption>Include this file before source</caption>
                    <tool_tip>This file is included at the beginning of each C++ source file.<br/> 
This is the same as specifying #include 'file' at the beginning of each C++ source.<br/>
Specify the (full path and) file name to include a common include file for all C++ source files.</tool_tip>
                    <button on_click="DXP.FileOpenDialog(CppSpecInc)"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--include-file="' + CppSpecInc.State + '"');
                            DXP.AddToolDependency(CppSpecInc.State, 'CPP');
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_CppPrep">
                    <default state=""/>
                    <global/>
                    <choice id="CppPrep">
                        <caption>Store the C++ compiler preprocess output (&lt;file&gt;.pre)</caption>
                        <tool_tip>By default, the results of preprocessed files are deleted while compiling.<br/>
Select this option to store the results of the preprocessing phase in the output directory.<br/>
Preprocessed files have extension '.pre'.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToMakeFile('CPPPREPROCESS');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="CppSysIncDir">
                    <default state="SELECTED"/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(DXP.IncDir,';',' ','--include-directory "','"'));
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="CppLanguage">
                <caption>C++ Language</caption>
                <tool_id id_ref="CPP"/>
                <choices id="Choices_CppEmbeddedCpp">
                    <default state="CppEmbeddedCpp"/>
                    <choice id="CppEmbeddedCpp">
                        <caption>Comply to embedded C++ subset</caption>
                        <tool_tip>The "Embedded C++" subset does not support templates, exceptions, namespaces, new-style casts, RTTI, multiple inheritance, virtual base classes, and the mutable keyword. Select this option when you want the C++ compiler to give an error when you use any of them in your C++ source.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--embedded-c++');
                                DXP.AddToolCmdOption('--no-stdstlinc');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppIoStream">
                    <default state=""/>
                    <global/>
                    <choice id="CppIoStream">
                        <caption>Support for I/O streams</caption>
                        <tool_tip>As I/O streams require substantial resources they are disabled by default.<br/>
Select this option to enable I/O streams support in the C++ library. Enabling I/O streams will automatically enable exception handling.</tool_tip>
                        <generate_option if="NOT CppEmbeddedCpp.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--io-stream');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppExceptions">
                    <default state=""/>
                    <global/>
                    <choice id="CppExceptions">
                        <caption>Support for exception handling</caption>
                        <tool_tip>Select this option to enable support for exception handling. Enabling I/O streams will automatically enable exception handling.</tool_tip>
                        <generate_option if="NOT CppIoStream.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--exceptions');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppRtti">
                    <default state=""/>
                    <choice id="CppRtti">
                        <caption>Support for RTTI (run-time type information)</caption>
                        <tool_tip>Select this option to enable support for RTTI (run-time type information) features dynamic_cast and typeid.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--rtti');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppWcharT">
                    <default state=""/>
                    <choice id="CppWcharT">
                        <caption>Allow the 'wchar_t' keyword</caption>
                        <tool_tip>Select this option to enable recognition of wchar_t as a keyword.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--wchar_t-keyword');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Language extensions</caption>
                    <choices id="Choices_CppStrictAnsi">
                        <default state="CppStrictAnsi"/>
                        <choice id="CppStrictAnsi">
                            <caption>Allow Non-ANSI/ISO C++ features</caption>
                            <tool_tip>By default, non-ANSI/ISO C++ language extensions are allowed. Disable this option to put the C++ compiler in strict ANSI/ISO mode, which provides diagnostic messages when non-standard features are used, and disables features that conflict with ANSI/ISO C or C++.</tool_tip>
                            <makefile_generator>
                                <not_selected>
                                    DXP.AddToolCmdOption('--strict');
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                    <choices id="Choices_CppAnachronisms">
                        <default state=""/>
                        <choice id="CppAnachronisms">
                            <caption>Anachronisms</caption>
                            <tool_tip>Select this option to enable C++ anachronisms</tool_tip>
                            <generate_option if="CppStrictAnsi.Selected"/>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--anachronisms');
                                </selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                    <choices id="Choices_CppGnu">
                        <default state=""/>
                        <choice id="CppGnu">
                            <caption>Allow GNU C++ extensions</caption>
                            <tool_tip>Select this option to enable GNU C++ compiler language extensions</tool_tip>
                            <generate_option if="CppStrictAnsi.Selected"/>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--g++');
                                </selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
            </group>
            <group id="CppPrecompiled">
                <caption>Precompiled Headers</caption>
                <tool_id id_ref="CPP"/>
                <choices id="Choices_CppPch">
                    <default state=""/>
                    <choice id="CppPch">
                        <caption>Automatically use and/or create a precompiled header file</caption>
                        <tool_tip>Select this option to enable automatically precompiled header processing.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--pch');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="CppCreatePch">
                    <caption>Create precompiled header file</caption>
                    <tool_tip>Create a precompiled header file with the specified name.</tool_tip>
                    <generate_option if="NOT CppPch.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--create-pch="' + CppCreatePch.State + '"');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="CppUsePch">
                    <caption>Use precompiled header file</caption>
                    <tool_tip>Use a precompiled header file of the specified name.</tool_tip>
                    <generate_option if="NOT CppPch.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--use-pch="' + CppUsePch.State + '"');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="CppPchDir">
                    <caption>Precompiled header file directory</caption>
                    <tool_tip>Specify the directory in which to search for and/or create a precompiled header file.</tool_tip>
                    <button on_click="DXP.DirectoryDialog(CppPchDir)"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--pch-dir="' + CppPchDir.state + '"');
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="CppDiagnostics">
                <caption>Diagnostics</caption>
                <tool_id id_ref="CPP"/>
                <choices id="Choices_CppSupressCppWarnings">
                    <default state=""/>
                    <choice id="CppSupressCppWarnings">
                        <caption>Suppress all warnings</caption>
                        <tool_tip>During the compile process warnings can occur. By default, all warnings are reported.<br/>
Select this option to suppress the warning messages.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wcp--no-warnings');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppWarningsAsErrors">
                    <default state=""/>
                    <choice id="CppWarningsAsErrors">
                        <caption>Treat warnings as errors</caption>
                        <tool_tip>When warnings occur the compile process continues.<br/>
When errors occur the compile process stops.<br/>
Select this option to stop the compile process also when only warnings occur.</tool_tip>
                        <generate_option if="NOT CppSupressCppWarnings.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wcp--warnings-as-errors');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppSupressUseBeforeSetWarnings">
                    <default state=""/>
                    <choice id="CppSupressUseBeforeSetWarnings">
                        <caption>Suppress C++ compiler "used before set" warnings</caption>
                        <tool_tip>Select this option to suppress the "used before set" warning messages.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--no-use-before-set-warnings');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppRemarks">
                    <default state=""/>
                    <choice id="CppRemarks">
                        <caption>Issue remarks on C++ code</caption>
                        <tool_tip>Select this option to issue remarks, which are diagnostic messages even milder than warnings.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--remarks');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppTraceIncludes">
                    <default state=""/>
                    <choice id="CppTraceIncludes">
                        <caption>List all visited #included files</caption>
                        <tool_tip>Output a list of the names of files #included</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--trace-includes');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="CppMiscellaneous">
                <caption>Miscellaneous</caption>
                <tool_id id_ref="CPP"/>
                <choices id="Choices_CppVtbl">
                    <caption>Virtual function tables</caption>
                    <tool_tip>By default, the heuristic used by the C++ compiler decide the definition of virtual function tables</tool_tip>
                    <single/>
                    <default state="CppDefaultVtbl"/>
                    <choice id="CppDefaultVtbl">
                        <caption>Use C++ compiler heuristics</caption>
                    </choice>
                    <choice id="CppForceVtbl">
                        <caption>Force definition of virtual function tables</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--force-vtbl');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CppSuppressVtbl">
                        <caption>Suppress definition of virtual function tables</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--suppress-vtbl');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppInlining">
                    <default state="CppInlining"/>
                    <choice id="CppInlining">
                        <caption>Minimal inlining of function calls</caption>
                        <tool_tip>Select this option to disable the minimal inlining of function calls.</tool_tip>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('--no-inlining');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppImplicitInclude">
                    <default state=""/>
                    <choice id="CppImplicitInclude">
                        <caption>Implicit inclusion of source files for finding templates</caption>
                        <tool_tip>Select this option to enable implicit inclusion of source files as a method of finding definitions of template entities to be instantiated.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--implicit-include');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CppInstantiationMode">
                    <caption>Instantiation mode of external template entities</caption>
                    <tool_tip>By default, those templates entities that were used int the compilation are
                    instantiated. This will include all static data members for which there are template definitions.<br/>
Select 'used' to instantiate those template entities that were used in the compilation.<br/>
Select 'all' to instantiate all template entities declared of referenced in the compilation unit.<br/>
Select 'local' to instantiate simular as 'used' except that the functions are given internal linkage.</tool_tip>
                    <single/>
                    <default state="CppInstantiationModeUsed"/>
                    <choice id="CppInstantiationModeUsed">
                        <caption>Used</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--instantiate=used');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CppInstantiationModeAll">
                        <caption>All</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--instantiate=all');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CppInstantiationModeLocal">
                        <caption>Local</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--instantiate=local');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <cmdoptions id="CmdOptCPP" tool_id_ref="CPP"/>
                <text id="CppAdditional">
                    <multi/>
                    <caption>Additional C++ compiler options</caption>
                    <tool_tip>Some C++ compiler options are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( CppAdditional.State );
                        </selected>
                    </makefile_generator>
                </text>
            </group>
        </group>

        <text id="C_Nature">
            <invisible/>
            <default state="NOTSELECTED"/>
            <generate_option if="DXP.ProjContainsSuffix('.c')"/>
        </text>
        <group id="C Compiler">
            <caption>C Compiler</caption>
            <generate_option if="CPP_Nature.Selected OR C_Nature.Selected"/>
            <tool_id id_ref="CC"/>
            <group id="CcCodeGeneration">
                <caption>Code Generation</caption>
                <tool_id id_ref="CC"/>
                <subgroup>
                    <caption>Allocation</caption>
                    <choices id="Choices_CompSdataAllocation">
                        <default state="CompSdataAllocation"/>
                        <choice id="CompSdataAllocation">
                            <caption>Enable allocation in sdata</caption>
                            <tool_tip>By default, all global and static data objects smaller than or equal to the specified threshold are placed into the small data section (sdata) or small bss section (sbss). This results in smaller and faster code.<br/>
Clear this option to place all objects in normal data en bss sections.<br/>
You can overrule this for individual data objects in the C source with the keywords '__sdata' and '__no_sdata'.</tool_tip>
                            <!-- The cppc compiler does not know which objects are used from hardware,
                                 so it can't decide properly which objects to put in sdata. Therefore
                                 sdata generation should for now be disabled when using chc. -->
                            <freeze_state if="AnsiSameText(ASP_Enable.State,'True')" state="NOTSELECTED"/>
                            <makefile_generator>
                                <not_selected>
                                    DXP.AddToolCmdOption('--sdata=0');
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                    <text id="CompSdataThreshold">
                        <generate_option if="CompSdataAllocation.Selected"/>
                        <caption>    Allocation in sdata for objects smaller than threshold</caption>
                        <tool_tip>Specify a value (bytes).<br/>
All data objects smaller than or equal to the specified value, are placed into the small data section (sdata) or small bss section (sbss).<br/>
You can overrule this for individual data objects in the C source with the keywords '__sdata' and '__no_sdata'.</tool_tip>
                        <default state="4"/>
                        <makefile_generator>
                            <selected>
                                CompSdataThreshold.Flag := CompSdataThreshold.State;
                                DXP.AddToolCmdOption('--sdata=' + CompSdataThreshold.Flag);
                            </selected>
                        </makefile_generator>
                    </text>
                    <choices id="Choices_CompSdataExterns">
                        <default state="CompSdataExterns"/>
                        <choice id="CompSdataExterns">
                        <caption>    Assume external data objects will also be placed in sdata</caption>
                            <tool_tip>Use small data addressing for external data as well as for objects defined in the current module. This option requires that all modules are compiled with the same value of the --sdata option. You can overrule this for individual externs in the C source with the keyword '__no_sdata'.</tool_tip>
                            <generate_option if="CompSdataAllocation.Selected"/>
                            <!-- The C++ libraries are built with sdata=0 option, but the header files do not contain
                                 the __no_sdata qualifier, so all external data should be treated as __no_sdata. -->
                            <freeze_state if="CPP_Nature.Selected" state="NOTSELECTED"/>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--extern-sdata');
                                </selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <subgroup>
                    <caption>Others</caption>
                    <choices id="Choices_CompCallMode">
                        <single/>
                        <caption>Select call mode</caption>
                        <tool_tip>To address the memory, you can use two different call modes.<br/>
Select 'Use 32-bit absolute calls' to use the full address range.<br/>
Select 'Use 26-bit PC-relative calls' for smaller and faster code. Not the full address range can be addressed.</tool_tip>
                        <default state="CompCallRelMode"/>
                        <choice id="CompCallAbsMode">
                            <caption>Use 32-bit absolute calls</caption>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--call=f');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompCallRelMode">
                            <caption>Use 26-bit PC-relative calls</caption>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--call=n');
                                </selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <subgroup>
                    <text id="ASP_Enable">
                        <!-- Set by Altium Designer -->
                        <invisible/>
                        <default state="False"/>
                    </text>
                    <text id="ASP_Software_Enable">
                        <!-- Set by Altium Designer -->
                        <invisible/>
                        <default state="False"/>
                    </text>
                    <text id="CompQualifiers">
                        <caption>Qualifier file</caption>
                        <tool_tip>This file is a qualifier file that inserts qualifiers into the code during pre processing.</tool_tip>
                        <invisible/>
                        <default state="SELECTED"/>
                        <generate_option if="AnsiSameText(ASP_Software_Enable.State,'True')"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--qualifier-file="' + projQualifierFileName + '"');
                                DXP.AddToolDependency(projQualifierFileName, 'CC');
                            </selected>
                        </makefile_generator>
                    </text>
                </subgroup>
            </group>
            <group id="CcPreprocessing">
                <caption>Preprocessing</caption>
                <tool_id id_ref="CC"/>
                <table_edit id="CompDefine">
                    <caption>User macro</caption>
                    <tool_tip>You can use a macro as a symbol in your C source, for example to create conditional C code.<br/>
With this option you can assign values to macros you use in your C source.<br/>
In the drop-down table, specify a macro name and a value. If you omit the value, the macro expands to 1.</tool_tip>
                    <column caption="Macro">
                        <text id="CMacro">
                            <caption>Macro</caption>
                        </text>
                    </column>
                    <column caption="Value">
                        <text id="CValue">
                            <caption>Value</caption>
                        </text>
                    </column>
                    <text id="CompDefine_Loop">
                        <invisible/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc-D' + CMacro.State + '="' + CValue.State + '"');
                            </selected>
                        </makefile_generator>
                    </text>
                </table_edit>
                <text id="CompSpecInc">
                    <caption>Include this file before source</caption>
                    <tool_tip>This file is included at the beginning of each C source file.<br/> 
This is the same as specifying #include 'file' at the beginning of each C source.<br/>
Specify the (full path and) file name to include a common include file for all C source files.</tool_tip>
                    <button on_click="DXP.FileOpenDialog(CompSpecInc)"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wc-H"' + CompSpecInc.State + '"');
                            DXP.AddToolDependency(CompSpecInc.State, 'CC');
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_CompPrep">
                    <default state=""/>
                    <global/>
                    <choice id="CompPrep">
                        <caption>Store the C compiler preprocess output (&lt;file&gt;.pre)</caption>
                        <tool_tip>By default, the results of preprocessed files are deleted while compiling.<br/>
Select this option to store the results of the preprocessing phase in the output directory.<br/>
Preprocessed files have extension '.pre'.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToMakeFile('PREPROCESS');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="CompSysIncDir">
                    <default state="SELECTED"/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(DXP.IncDir,';',' ','-Wc-I"','"'));
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="CcOptimization">
                <caption>Optimization</caption>
                <tool_id id_ref="CC"/>
                <choices id="CompOptim">
                    <single/>
                    <caption>Optimization level</caption>
                    <tool_tip>Optimizing for speed and or code size is at the cost of debugging ease.<br/>
Select a predefined set of optimizations or select 'Custom optimization' to enable individual optimizations.<br/>
Select 'Full optimization' for the final application.</tool_tip>
                    <default state="CompOL2"/>
                    <choice id="CompOL0">
                        <caption>No optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-O0');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompOL1">
                        <caption>Few optimizations</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-O1');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompOL2">
                        <caption>Medium optimization (default)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-O2');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompOL3">
                        <caption>Full optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-O3');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompOLAdv">
                        <caption>Custom optimization</caption>
                    </choice>
                </choices>
                <choices id="CompTrade">
                    <single/>
                    <caption>Size/speed trade-off</caption>
                    <tool_tip>Determines how the individual optimizations work.<br/>
Select a trade-off to optimize for speed (at the cost of size) or vice versa.</tool_tip>
                    <default state="Trade00"/>
                    <choice id="Trade00">
                        <caption>Level 0 (fully optimize for speed)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=0');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Trade01">
                        <caption>Level 1</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=1');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Trade02">
                        <caption>Level 2</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=2');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Trade03">
                        <caption>Level 3</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=3');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Trade04">
                        <caption>Level 4 (fully optimize for size)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=4');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Custom optimization</caption>                    
                    <choices id="Choices_CompOLa">
                        <default state="CompOLa,CompOLb,CompOLc,CompOLe,CompOLf,CompOLg,CompOLi,CompOLp,CompOLs,CompOLy"/>
                        <choice id="CompOLa">
                            <caption>Coalescer</caption>
                            <tool_tip>Removes unnecessary MOVE instructions.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLa.Flag := 'a';
                                </selected>
                                <not_selected>
                                    CompOLa.Flag := 'A';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLb">
                            <caption>Interprocedural register optimization</caption>
                            <tool_tip>Improves register allocation by taking into account register usage during function calls.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLb.Flag := 'b';
                                </selected>
                                <not_selected>
                                    CompOLb.Flag := 'B';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLc">
                            <caption>Common subexpression elimination (CSE)</caption>
                            <tool_tip>Avoids recalculation of identical expressions.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLc.Flag := 'c';
                                </selected>
                                <not_selected>
                                    CompOLc.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLe">
                            <caption>Expression simplification</caption>
                            <tool_tip>Removes useless expressions introduced by macros or by the compiler (for example, multiplications by 1 or 0).</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLe.Flag := 'e';
                                </selected>
                                <not_selected>
                                    CompOLe.Flag := 'E';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLf">
                            <caption>Control flow simplification</caption>
                            <tool_tip>Simplifies the program flow by removing unnecessary code and reducing the number of jumps.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLf.Flag := 'f';
                                </selected>
                                <not_selected>
                                    CompOLf.Flag := 'F';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLg">
                            <caption>Generic assembly code optimizations</caption>
                            <tool_tip>A set of target independent optimizations that increase speed and decrease code size.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLg.Flag := 'g';
                                </selected>
                                <not_selected>
                                    CompOLg.Flag := 'G';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLi">
                            <caption>Automatic function inlining</caption>
                            <tool_tip>Small fuctions that are not too often called, are inlined to save function calls.<br/>
Below, you can refine this inline optimization.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLi.Flag := 'i';
                                </selected>
                                <not_selected>
                                    CompOLi.Flag := 'I';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLk">
                            <caption>Scheduler</caption>
                            <tool_tip>Rearranges assembly instructions.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLk.Flag := 'k';
                                </selected>
                                <not_selected>
                                    CompOLk.Flag := 'K';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLl">
                            <caption>Loop transformations</caption>
                            <tool_tip>Rearranges loop constructions to improve possibilities for 'Constant propagation' and 'Common subexpression elimination'.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLl.Flag := 'l';
                                </selected>
                                <not_selected>
                                    CompOLl.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLo">
                            <caption>Forward store</caption>
                            <tool_tip>Uses a temporary variable to cache multiple assignments (stores) to the same non-automatic variable.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLo.Flag := 'o';
                                </selected>
                                <not_selected>
                                    CompOLo.Flag := 'O';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLp">
                            <caption>Constant propagation</caption>
                            <tool_tip>Replaces variables with known values by those values.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLp.Flag := 'p';
                                </selected>
                                <not_selected>
                                    CompOLp.Flag := 'P';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLs">
                            <caption>Subscript strength reduction</caption>
                            <tool_tip>An array of pointers subscripted with a loop iterator variable, is replaced by the dereference of a pointer that is updated whenever the iterator is updated.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLs.Flag := 's';
                                </selected>
                                <not_selected>
                                    CompOLs.Flag := 'S';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLu">
                            <caption>Unroll small loops</caption>
                            <tool_tip>Reduces the number of branches: short loops are eliminated by replacing them with a number of copies.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLu.Flag := 'u';
                                </selected>
                                <not_selected>
                                    CompOLu.Flag := 'U';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompOLy">
                            <caption>Peephole optimizer (remove redundant code)</caption>
                            <tool_tip>Improves the generated assembly by replacing instruction sequences by equivalent but faster and/or shorter sequences, or by deleting unnecessary instructions.</tool_tip>
                            <generate_option if="CompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompOLy.Flag := 'y';
                                </selected>
                                <not_selected>
                                    CompOLy.Flag := 'Y';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <text id="CompOLAdv_Script"> 
                    <invisible/>
                    <generate_option if="CompOLAdv.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--optimize=' + CompOLa.Flag + CompOLb.Flag + CompOLc.Flag + CompOLe.Flag + CompOLf.Flag + CompOLg.Flag 
+ CompOLi.Flag
+ CompOLk.Flag
+ CompOLl.Flag + CompOLo.Flag + CompOLp.Flag + CompOLs.Flag
+ CompOLu.Flag
+ CompOLy.Flag );
                        </selected>
                    </makefile_generator>
                </text>
                <subgroup>
                    <caption>Refine inlining optimization</caption>
                    <choices id="Choices_CompOptimInline">
                    <default state=""/>
                        <choice id="CompOptimInline">
                            <caption>Always inline function calls</caption>
                            <tool_tip>With this option you instruct the compiler to inline calls to functions without the <pre>__noinline</pre> function<br/>
qualifier whenever possible.<br/>
                            </tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('-Wc--inline');
                                </selected>
                           </makefile_generator>
                        </choice>
                    </choices>
                    <text id="CompOptimIncrementInlining">
                        <caption>Maximum code size increment when inlining (in %)</caption>
                        <tool_tip>With this option you can specify the maximum size of functions that the compiler inlines as part of the optimization<br/>
process. The compiler always inlines all functions that are smaller than the specified <I>threshold</I>. The threshold is measured<br/>
in compiler internal units and the compiler uses this measure to decide which functions are small enough to inline.<br/>
This option only have effect when automatic function inlining is enabled.</tool_tip>
                        <default state=""/> 
                        <generate_option if="(CompOL3.Selected OR CompOLi.Selected) AND NOT CompOptimInline.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--inline-max-incr=' + CompOptimIncrementInlining.State );
                            </selected>
                        </makefile_generator>
                    </text>
                    <text id="CompOptimSizeInline">
                        <caption>Maximum size for functions to always inline</caption>
                        <tool_tip>After the compiler has inlined all functions that have the function qualifier <pre>inline</pre> and all functions that are smaller<br/>
than the specified threshold, the compiler looks whether it can inline more functions without increasing the code size<br/>
too much. With this option you can specify how much the code size is allowed to increase.<br/>
This option only have effect when automatic function inlining is enabled.</tool_tip>
                        <default state=""/> 
                        <generate_option if="(CompOL3.Selected OR CompOLi.Selected) AND NOT CompOptimInline.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--inline-max-size=' + CompOptimSizeInline.State );
                            </selected>
                        </makefile_generator>
                    </text>
                </subgroup>
            </group>
            <group id="CcLanguage">
                <caption>Language</caption> <tool_id id_ref="CC"/>
                <choices id="Choices_CompISO90">
                    <caption>ISO C standard</caption>
                    <tool_tip>The compiler checks the C source against the ISO standard and may generate warnings and errors.<br/>
Select the ISO standard against which the compiler should check the C source.</tool_tip>
                    <single/>
                    <default state="CompISO99"/>
                    <choice id="CompISO90">
                        <caption>ISO C 90</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--iso=90');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompISO99">
                        <caption>ISO C 99</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--iso=99');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CompUnsignedChars">
                    <default state=""/>
                    <choice id="CompUnsignedChars">
                        <caption>Treat 'char' variables as unsigned</caption>
                        <tool_tip>By default, 'char' is the same as specifying 'signed char'.<br/>
Select this option to treat 'char' by default as 'unsigned char'.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--uchar');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompSignedBitfields">
                        <caption>Treat 'int' bit-fields as signed</caption>
                        <tool_tip>By default, an 'int' bit-field is treated as 'unsigned int'. This offers the best performance.<br/>
Select this option to treat 'int' bit-fields by default as 'signed int'.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--signed-bitfields');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Language extensions</caption>
                    <choices id="Choices_CompLanguageCpp">
                        <default state="CompLanguageCpp,CompLanguageVolatile"/>
                        <choice id="CompLanguageGnu">
                            <caption>Allow GNU C extensions</caption>
                            <tool_tip>Select this option to enable GNU C compiler language extensions</tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--language=+gcc');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompLanguageCpp">
                            <caption>Allow C++ style comments in ISO C90 mode</caption>
                            <tool_tip>In ISO C99 mode C++ comments are always accepted.<br/>
Select this option to allow C++ style comments (//) in ISO C90 mode.</tool_tip>
                            <generate_option if="CompISO90.Selected"/>
                            <makefile_generator>
                                <not_selected>
                                    DXP.AddToolCmdOption('--language=-comments');
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompLanguageStrings">
                            <caption>Check assignment of string literal to non-const string pointer</caption>
                            <tool_tip>The compiler generates a warning when you assign a constant string to a non-constant string pointer.</tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--language=-strings');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompLanguageVolatile">
                            <caption>Allow optimization across volatile access</caption>
                            <tool_tip>When you disable this option, the compiler will block optimization when reading or writing a volatile object, by treating the<br/>
access as a call to an unknown function. This can be useful to prevent for example that code below the volatile<br/>
object is optimized away to somewhere above the volatile object.</tool_tip>
                            <makefile_generator>
                                <not_selected>
                                    DXP.AddToolCmdOption('--language=+volatile');
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
            </group>
            <group id="CcDebugInformation">
                <caption>Debug Information</caption>
                <tool_id id_ref="CC"/>
                <choices id="Choices_CompDebug">
                    <single/>
                    <caption>Generate symbolic debug information</caption>
                    <tool_tip>With debug information a debugger can display the original C source instead of disassembling the memory contents.<br/>
Select which debug information the compiler must generate.<br/>
Select 'No debug information' to reduce code size when your application is working fine.</tool_tip>
                    <default state="CompDebugDefault"/>
                    <choice id="CompDebugNone">
                        <caption>No debug information</caption>
                    </choice>
                    <choice id="CompDebugSmall">
                        <caption>Emit small set of debug information</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--debug-info=small');
                            </selected>
                        </makefile_generator>
                    </choice>
                         <choice id="CompDebugDefault">
                             <caption>Emit default symbolic debug information</caption>
                             <makefile_generator>
                                 <selected>
                                     DXP.AddToolCmdOption('-Wc--debug-info=default');
                                 </selected>
                             </makefile_generator>
                         </choice>
                    <choice id="CompDebugAll">
                        <caption>Emit full symbolic debug information</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--debug-info=all');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CompProfiling">
                    <default state=""/>
                    <choice id="CompProfiling">
                        <caption>Generate profiling information</caption>
                        <tool_tip>Profiling is the process of collecting statistical data about a running application.<br/>
With these data you can analyze which functions are called, how often they are called and what their execution time is.<br/>
Select this option to add profiling code to your application. Do not use this option with multi-threaded applications.<br/>
Below, select which profiling information must be gathered.</tool_tip>
                        <makefile_generator>
                            <selected>                  
                                ProfilerBat := '@"' + DXP.ProdDir + 'bin\proftool.exe" --xml ';
                                if CompProfC.Selected then
                                    ProfilerBat := ProfilerBat + '-g ';
                                ProfilerBat := ProfilerBat + '--elf ' + 
                                    DXP.ProjectName + '.abs "' + 
                                    DXP.ProjectDir + 'amon.prf" -o ProfileResult.xml' +
                                    ' &amp;&amp; del "' + DXP.ProjectDir + 'amon.prf"';
                                DXP.WriteToFile(DXP.OutDir + 'RunProfiler.bat',ProfilerBat);
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Custom profiling</caption>                    
                    <choices id="Choices_CompCustomProfiling">
                        <default state="CompProfF"/>
                        <choice id="CompProfB">
                            <caption>Block counters</caption>
                            <tool_tip>Performs basic block counting.<br/>
It counts the number of executions of the branches in an if statement, the iteration of a for loop, functions, and so on.</tool_tip>
                            <generate_option if="CompProfiling.Selected AND NOT CompProfC.Selected AND NOT CompProfT.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompProfB.Flag := 'b';
                                </selected>
                                <not_selected>
                                    CompProfB.Flag := 'B';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompProfC">
                            <caption>Call graph</caption>
                            <tool_tip>Reconstructs the run-time call graph.</tool_tip>
                            <generate_option if="CompProfiling.Selected AND NOT CompProfB.Selected"/> 
                            <!-- no library available for combination b&c so avoid the selection in the GUI -->
                            <makefile_generator>
                                <selected>
                                    CompProfC.Flag := 'c';
                                </selected>
                                <not_selected>
                                    CompProfC.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompProfF">
                            <caption>Function counters</caption>
                            <tool_tip>Performs function call counting. This is a subset of the basic Block counters.</tool_tip>
                            <generate_option if="CompProfiling.Selected AND NOT CompProfT.Selected"/>
                            <!-- Function counters and Function timers are mutually exclusive -->
                            <makefile_generator>
                                <selected>
                                    CompProfF.Flag := 'f';
                                </selected>
                                <not_selected>
                                    CompProfF.Flag := 'F';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompProfT">
                            <caption>Function timers</caption>
                            <tool_tip>Measures the time spent in a function.<br/>
This includes the time spent in all sub functions (callees).</tool_tip>
                            <generate_option if="CompProfiling.Selected AND NOT CompProfB.Selected AND NOT CompProfF.Selected"/>
                            <!-- no library available for combination b&t so avoid the selection in the GUI -->
                            <makefile_generator>
                                <selected>
                                    CompProfT.Flag := 'ti';
                                </selected>
                                <not_selected>
                                    CompProfT.Flag := 'TI';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <text id="CompProfiling_Script"> 
                    <invisible/>
                    <generate_option if="CompProfiling.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--profile=' + CompProfB.Flag + CompProfC.Flag + CompProfF.Flag + CompProfT.Flag);
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_CompRuntime">
                    <default state=""/>
                    <choice id="CompRuntime">
                        <caption>Run-time checks</caption>
                        <tool_tip>Run-time checks can be used to detect errors during program execution.<br/>
Some of these checks require additional code to be inserted in the original application code,<br/>
and may therefore slow down the program execution.<br/>
Do not use this option with multi-threaded applications.</tool_tip>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Custom run-time checks</caption>                    
                    <choices id="Choices_CompCustomRuntime">
                        <default state="CompRunB,CompRunC,CompRunM"/>
                        <choice id="CompRunB">
                            <caption>Bounds checking</caption>
                            <tool_tip>Every pointer update and dereference will be checked to detect out-of-bounds accesses, null pointers and uninitialized automatic pointer variables. This check will increase the code size and slow down the program considerably. In addition, some heap memory is allocated to store the bounds information. You may enable bounds checking for individual modules or even parts of modules only (see #pragma runtime).</tool_tip>
                            <generate_option if="CompRuntime.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompRunB.Flag := 'b';
                                </selected>
                                <not_selected>
                                    CompRunB.Flag := 'B';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompRunC">
                            <caption>Report unhandled case in a switch</caption>
                            <tool_tip>Report an unhandled case value in a switch without a default part.<br/>
This check will add one function call to every switch without a default part,<br/>
but it will have little impact on the excution speed.</tool_tip>
                            <generate_option if="CompRuntime.Selected"/> 
                            <makefile_generator>
                                <selected>
                                    CompRunC.Flag := 'c';
                                </selected>
                                <not_selected>
                                    CompRunC.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompRunM">
                            <caption>Malloc consistency checks</caption>
                            <tool_tip>This option enables the use of wrappers around the functions malloc/realloc/free<br/>
which will check for common dynamic memory allocation errors.</tool_tip>
                            <generate_option if="CompRuntime.Selected"/>
                            <makefile_generator>
                                <selected>
                                    CompRunM.Flag := 'm';
                                </selected>
                                <not_selected>
                                    CompRunM.Flag := 'M';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <text id="CompRuntime_Script"> 
                    <invisible/>
                    <generate_option if="CompRuntime.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--runtime=' + CompRunB.Flag + CompRunC.Flag + CompRunM.Flag
);
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="CcFloatingPoint">
                <caption>Floating-Point</caption>
                <tool_id id_ref="CC"/>
                <choices id="Choices_CompFloatSingle">
                    <global/>
                    <choice id="CompFloatSingle">
                        <caption>Use single precision floating-point only</caption>
                        <tool_tip>Treats variables of the type 'double' as 'float' which takes less space.<br/>
Select this option to increase execution speed and decrease code size in case you do not need double precision.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--no-double');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="CcDiagnostics">
                <caption>Diagnostics</caption>
                <tool_id id_ref="CC"/>
                <choices id="Choices_CompWarn">
                    <caption>Error reporting</caption>
                    <tool_tip>During the compile process warnings can occur. By default, all warnings are reported.<br/>
Select one of the suppress options to hide the warning messages that are of no importance to you.</tool_tip>
                    <single/>
                    <default state="CompWarn"/>
                    <choice id="CompWarn">
                        <caption>Report all warnings</caption>
                    </choice>
                    <choice id="CompNoWarn">
                        <caption>Suppress all warnings</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--no-warnings');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompSpecWarn">
                        <caption>Suppress specific warnings</caption>
                    </choice>
                </choices>
                <text id="CompWarnList">
                    <multi/>
                    <caption>    Specific warnings to suppress</caption>
                    <tool_tip>You can suppress specific warnings by specifing a comma-separated list of warning numbers or ranges.<br/>
For example: 126,135,144-149</tool_tip>
                    <generate_option if="CompSpecWarn.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(CompWarnList.State ,',',' ','-Wc-w'));                        
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_CompWarningsAsErrors">
                    <caption>Treat warnings as errors</caption>
                    <tool_tip>When warnings occur the compile process continues.<br/>
When errors occur the compile process stops.<br/>
Select this option to stop the compile process also when only warnings occur.</tool_tip>
                    <generate_option if="NOT CompNoWarn.Selected"/>
                    <single/>
                    <default state="CompWarningsAsErrorsNone"/>
                    <choice id="CompWarningsAsErrorsNone">
                        <caption>None</caption>
                    </choice>
                    <choice id="CompWarningsAsErrorsAll">
                        <caption>Treat all warnings as errors</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--warnings-as-errors');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompWarningsAsErrorsSpecific">
                        <caption>Treat specific warnings as errors</caption>
                    </choice>
                </choices>
                <text id="CompWarningsAsErrorsList">
                    <multi/>
                    <caption>    Specific warnings to treat as errors</caption>
                    <tool_tip>You can treat specific warnings as errors by specifing a comma-separated list of warning numbers or ranges.<br/>
For example: 126,135,144-149</tool_tip>
                    <generate_option if="CompWarningsAsErrorsSpecific.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(CompWarningsAsErrorsList.State ,',',' ','-Wc--warnings-as-errors='));
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_CompGlobalTypeChecking">
                    <default state=""/>
                    <choice id="CompGlobalTypeChecking">
                        <caption>Perform global type checking on C code</caption>
                        <tool_tip>The C compiler already performs type checking within each module.<br/>
Select this option to have the compiler generate additional information which will enable the linker to perform type checking between modules.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--global-type-checking');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="MISRAC">
                <caption>MISRA-C</caption>
                <tool_id id_ref="CC"/>
                <choices id="Choices_MISRACChecking">
                    <caption>MISRA-C checking</caption>
                    <tool_tip>The compiler can check the C source against MISRA-C rules.<br/>
Select against which MISRA-C rules the C source should be checked.<br/>
If you select 'Custom configuration', select or clear individual rules on the 'Custom configuration' page.</tool_tip>
                    <single/>
                    <default state="MISRACDisabled"/>
                    <choice id="MISRACDisabled">
                        <caption>Disabled</caption>
                    </choice>
                    <choice id="MISRACMisra">
                        <caption>Supported required rules only</caption>
                        <makefile_generator>
                            <selected>
                                if MISRAC1998.Selected then
                                    MISRACCustom.Flag := '1,5,7,8,9,11,14,16,17,19,20,21,24,26,29,30,31,32,33,34,35,37,38,39,42,43,45,46,50,52,53,54,56,57,58,59,61,62,64,65,68,69,70,71,72,73,74,75,76,77,78,79,80,83,84,87,88,89,90,91,94,95,96,98,99,100,103,104,105,106,107,108,109,110,111,112,113,114,115,118,119,120,121,122,123,124,125,126,127';
                                if MISRAC2004.Selected then
                                    MISRACCustom.Flag := '1.1,1.2,2.1,2.2,2.3,3.4,3.5,4.1,4.2,5.1,5.2,5.3,5.4,6.1,6.2,6.4,6.5,7.1,8.1,8.2,8.3,8.4,8.5,8.6,8.7,8.8,8.9,8.11,8.12,9.1,9.2,9.3,10.1,10.2,10.3,10.4,10.5,10.6,11.1,11.2,11.5,12.2,12.3,12.4,12.5,12.7,12.8,12.9,12.10,12.12,13.1,13.3,13.4,13.5,13.6,13.7,14.1,14.2,14.3,14.4,14.5,14.6,14.7,14.8,14.9,14.10,15.1,15.2,15.3,15.4,15.5,16.1,16.2,16.3,16.4,16.5,16.6,16.8,16.9,16.10,17.3,17.4,17.6,18.1,18.2,18.4,19.3,19.4,19.5,19.6,19.8,19.9,19.10,19.11,19.12,19.14,19.15,19.16,19.17,20.1,20.2,20.4,20.5,20.6,20.7,20.8,20.9,20.10,20.11,20.12';
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="MISRACAll">
                        <caption>Supported required and advisory rules</caption>
                        <makefile_generator>
                            <selected>
                                if MISRAC1998.Selected then
                                    MISRACCustom.Flag := '1,3,5,7,8,9,10,11,12,13,14,16,17,18,19,20,21,22,24,26,28,29,30,31,32,33,34,35,36,37,38,39,40,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,118,119,120,121,122,123,124,125,126,127';
                                if MISRAC2004.Selected then
                                    MISRACCustom.Flag := '1.1,1.2,2.1,2.2,2.3,2.4,3.4,3.5,4.1,4.2,5.1,5.2,5.3,5.4,5.5,5.6,5.7,6.1,6.2,6.3,6.4,6.5,7.1,8.1,8.2,8.3,8.4,8.5,8.6,8.7,8.8,8.9,8.11,8.12,9.1,9.2,9.3,10.1,10.2,10.3,10.4,10.5,10.6,11.1,11.2,11.3,11.4,11.5,12.1,12.2,12.3,12.4,12.5,12.6,12.7,12.8,12.9,12.10,12.11,12.12,12.13,13.1,13.2,13.3,13.4,13.5,13.6,13.7,14.1,14.2,14.3,14.4,14.5,14.6,14.7,14.8,14.9,14.10,15.1,15.2,15.3,15.4,15.5,16.1,16.2,16.3,16.4,16.5,16.6,16.7,16.8,16.9,16.10,17.3,17.4,17.5,17.6,18.1,18.2,18.4,19.1,19.2,19.3,19.4,19.5,19.6,19.7,19.8,19.9,19.10,19.11,19.12,19.13,19.14,19.15,19.16,19.17,20.1,20.2,20.4,20.5,20.6,20.7,20.8,20.9,20.10,20.11,20.12';
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="MISRACCustom">
                        <caption>Custom configuration</caption>
                    </choice>
                </choices>
                <choices id="Choices_MISRACVersion">
                    <caption>MISRA-C version</caption>
                    <tool_tip>select MISRA-C version: 1998 or 2004.</tool_tip>
                    <generate_option if="NOT MISRACDisabled.Selected"/>
                    <single/>
                    <default state="MISRAC2004"/>
                    <choice id="MISRAC2004">
                        <caption>2004</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--misrac-version=2004');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="MISRAC1998">
                        <caption>1998</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--misrac-version=1998');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_MISRACReport">
                    <default state="MISRACReport"/>
                    <choice id="MISRACReport">
                        <caption>Produce a MISRA-C report</caption>
                        <tool_tip>The MISRA-C Quality Assurance report lists the various modules in the project with the respective MISRA-C settings at the time of compilation.<br/>
Select this option to generate a report.<br/>
The report is stored in the ouput directory and named after your project with exension '.mcr'</tool_tip>
                        <generate_option if="NOT MISRACDisabled.Selected"/>
                    </choice>
                </choices>
                <text id="MISRACNotImplemented">
                    <invisible/>
                    <default state="NOTSELECTED"/>
                </text>
                <subgroup>
                    <caption>Diagnostics</caption>
                    <choices id="Choices_MISRACAWarnings">
                        <default state=""/>
                        <choice id="CompMISRACAdvisoryWarnings">
                            <caption>Turn advisory rule violation into warning</caption>
                            <tool_tip>Normally, if an advisory rule is violated, the compiler generates an error. As a consequence, no output files are generated.<br/>
Select this option to generate warnings instead of errors.</tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--misrac-advisory-warnings');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompMISRACRequiredWarnings">
                            <caption>Turn required rule violation into warning</caption>
                            <tool_tip>Normally, if a required rule is violated, the compiler generates an error. As a consequence, no output files are generated.<br/>
Select this option to generate warnings instead of errors.</tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--misrac-required-warnings');
                                </selected>
                             </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <group id="MISRAC1998Rules">
                    <caption>Custom Configuration 1998</caption>
                    <tool_id id_ref="CC"/>
                    <generate_option if="MISRACCustom.Selected AND MISRAC1998.Selected"/>
                    <subgroup>
                        <caption>Environment</caption>
                        <choices id="Choices_1998_Environment">
                            <default state="Choise_1998_1"/>
                            <choice id="Choise_1998_1">
                                <caption>1. [R] The code shall conform to standard C, without language extensions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_2">
                                <caption>2. [A] Other languages should only be used with an interface standard</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_3">
                                <caption>3. [A] Inline assembly is only allowed in dedicated C functions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_4">
                                <caption>4. [A] Provision should be made for appropriate run-time checking</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '4';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Character Sets</caption>
                        <choices id="Choices_1998_Character_Sets">
                            <default state="Choise_1998_5,Choise_1998_6,Choise_1998_7,Choise_1998_8"/>
                            <choice id="Choise_1998_5">
                                <caption>5. [R] Only use characters and escape sequences defined by ISO C</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_6">
                                <caption>6. [R] Character values shall be restricted to a subset of ISO 106460-1</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_7">
                                <caption>7. [R] Trigraphs shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_8">
                                <caption>8. [R] Multibyte characters and wide string literals shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Comments</caption>
                        <choices id="Choices_1998_Comments">
                            <default state="Choise_1998_9"/>
                            <choice id="Choise_1998_9">
                                <caption>9. [R] Comments shall not be nested</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_10">
                                <caption>10. [A] Sections of code should not be "commented out"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Identifiers</caption>
                        <choices id="Choices_1998_Identifiers">
                            <default state="Choise_1998_11"/>
                            <choice id="Choise_1998_11">
                                <caption>11. [R] Identifiers shall not rely on significance of more than 31 characters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_12">
                                <caption>12. [A] The same identifier shall not be used in multiple name spaces</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Types</caption>
                        <choices id="Choices_1998_Types">
                            <default state="Choise_1998_14,Choise_1998_16,Choise_1998_17"/>
                            <choice id="Choise_1998_13">
                                <caption>13. [A] Specific-length typedefs should be used instead of the basic types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_14">
                                <caption>14. [R] Use "unsigned char" or "signed char" instead of plain "char"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_15">
                                <caption>15. [A] Floating point implementations should comply with a standard</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_16">
                                <caption>16. [R] The bit representation of floating point numbers shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_17">
                                <caption>17. [R] "typedef" names shall not be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Constants</caption>
                        <choices id="Choices_1998_Constants">
                            <default state="Choise_1998_19"/>
                            <choice id="Choise_1998_18">
                                <caption>18. [A] Numeric constants should be suffixed to indicate type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_19">
                                <caption>19. [R] Octal constants (other than zero) shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Declarations and Definitions</caption>
                        <choices id="Choices_1998_Declarations_and_Definitions">
                            <default state="Choise_1998_20,Choise_1998_21,Choise_1998_24,Choise_1998_25,Choise_1998_26,Choise_1998_29"/>
                            <choice id="Choise_1998_20">
                                <caption>20. [R] All object and function identifiers shall be declared before use</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_21">
                                <caption>21. [R] Identifiers shall not hide identifiers in an outer scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '21';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_22">
                                <caption>22. [A] Declarations should be at function scope where possible</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '22';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_23">
                                <caption>23. [A] All declarations at file scope should be static where possible</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '23';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_24">
                                <caption>24. [R] Identifiers shall not have both internal and external linkage</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '24';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_25">
                                <caption>25. [R] Identifiers with external linkage shall have exactly one definition</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '25';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_26">
                                <caption>26. [R] Multiple declarations for objects or functions shall be compatible</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '26';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_27">
                                <caption>27. [A] External objects should not be declared in more than one file</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '27';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_28">
                                <caption>28. [A] The "register" storage class specifier should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '28';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_29">
                                <caption>29. [R] The use of a tag shall agree with its declaration</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '29';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Initialization</caption>
                        <choices id="Choices_1998_Initialization">
                            <default state="Choise_1998_30,Choise_1998_31,Choise_1998_32"/>
                            <choice id="Choise_1998_30">
                                <caption>30. [R] All automatics shall be initialized before being used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '30';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_31">
                                <caption>31. [R] Braces shall be used in the initialization of arrays and structures</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '31';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_32">
                                <caption>32. [R] Only the first, or all enumeration constants may be initialized</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '32';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Operators</caption>
                        <choices id="Choices_1998_Operators">
                            <default state="Choise_1998_33,Choise_1998_34,Choise_1998_35,Choise_1998_37,Choise_1998_38,Choise_1998_39,Choise_1998_42"/>
                            <choice id="Choise_1998_33">
                                <caption>33. [R] The right hand operand of &amp;&amp; or || shall not contain side effects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '33';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_34">
                                <caption>34. [R] The operands of a logical &amp;&amp; or || shall be primary expressions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '34';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_35">
                                <caption>35. [R] Assignment operators shall not be used in Boolean expressions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '35';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_36">
                                <caption>36. [A] Logical operators should not be confused with bitwise operators</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '36';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_37">
                                <caption>37. [R] Bitwise operations shall not be performed on signed integers</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '37';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_38">
                                <caption>38. [R] A shift count shall be between 0 and the operand width minus 1</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '38';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_39">
                                <caption>39. [R] The unary minus shall not be applied to an unsigned expression</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '39';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_40">
                                <caption>40. [A] "sizeof" should not be used on expressions with side effects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '40';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_41">
                                <caption>41. [A] The implementation of integer division should be documented</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '41';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_42">
                                <caption>42. [R] The comma operator shall only be used in a "for" condition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '42';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Conversions</caption>
                        <choices id="Choices_1998_Conversions">
                            <default state="Choise_1998_43,Choise_1998_45"/>
                            <choice id="Choise_1998_43">
                                <caption>43. [R] Don't use implicit conversions which may result in information loss</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '43';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_44">
                                <caption>44. [A] Redundant explicit casts should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '44';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_45">
                                <caption>45. [R] Type casting from any type to or from pointers shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '45';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Expressions</caption>
                        <choices id="Choices_1998_Expressions">
                            <default state="Choise_1998_46,Choise_1998_50"/>
                            <choice id="Choise_1998_46">
                                <caption>46. [R] The value of an expression shall be evaluation order independent</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '46';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_47">
                                <caption>47. [A] No dependence should be placed on operator precedence rules</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '47';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_48">
                                <caption>48. [A] Mixed arithmetic should use explicit casting</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '48';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_49">
                                <caption>49. [A] Tests of a (non-Boolean) value against 0 should be made explicit</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '49';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_50">
                                <caption>50. [R] F.P. variables shall not be tested for exact equality or inequality</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '50';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_51">
                                <caption>51. [A] Constant unsigned integer expressions should not wrap-around</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '51';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Control Flow</caption>
                        <choices id="Choices_1998_Control_Flow">
                            <default state="Choise_1998_52,Choise_1998_53,Choise_1998_54,Choise_1998_56,Choise_1998_57,Choise_1998_58,Choise_1998_59,Choise_1998_61,Choise_1998_62,Choise_1998_64,Choise_1998_65"/>
                            <choice id="Choise_1998_52">
                                <caption>52. [R] There shall be no unreachable code</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '52';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_53">
                                <caption>53. [R] All non-null statements shall have a side-effect</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '53';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_54">
                                <caption>54. [R] A null statement shall only occur on a line by itself</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '54';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_55">
                                <caption>55. [A] Labels should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '55';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_56">
                                <caption>56. [R] The "goto" statement shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '56';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_57">
                                <caption>57. [R] The "continue" statement shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '57';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_58">
                                <caption>58. [R] The "break" statement shall not be used (except in a "switch")</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '58';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_59">
                                <caption>59. [R] An "if" or loop body shall always be enclosed in braces</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '59';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_60">
                                <caption>60. [A] All "if", "else if" constructs should contain a final "else"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '60';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_61">
                                <caption>61. [R] Every non-empty "case" clause shall be terminated with a "break"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '61';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_62">
                                <caption>62. [R] All "switch" statements should contain a final "default" case</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '62';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_63">
                                <caption>63. [A] A "switch" expression should not represent a Boolean case</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '63';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_64">
                                <caption>64. [R] Every "switch" statement shall have at least one "case"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '64';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_65">
                                <caption>65. [R] Floating point variables shall not be used as loop counters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '65';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_66">
                                <caption>66. [A] A "for" should only contain expressions concerning loop control</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '66';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_67">
                                <caption>67. [A] Iterator variables should not be modified in a "for" loop</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '67';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Functions</caption>
                        <choices id="Choices_1998_Functions">
                            <default state="Choise_1998_68,Choise_1998_69,Choise_1998_70,Choise_1998_71,Choise_1998_72,Choise_1998_73,Choise_1998_74,Choise_1998_75,Choise_1998_76,Choise_1998_77,Choise_1998_78,Choise_1998_79,Choise_1998_80,Choise_1998_83,Choise_1998_84"/>
                            <choice id="Choise_1998_68">
                                <caption>68. [R] Functions shall always be declared at file scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '68';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_69">
                                <caption>69. [R] Functions with variable numbers of arguments shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '69';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_70">
                                <caption>70. [R] Functions shall not call themselves, either directly or indirectly</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '70';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_71">
                                <caption>71. [R] Function prototypes shall be visible at the definition and call</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '71';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_72">
                                <caption>72. [R] The function prototype of the declaration shall match the definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '72';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_73">
                                <caption>73. [R] Identifiers shall be given for all prototype parameters or for none</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '73';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_74">
                                <caption>74. [R] Parameter identifiers shall be identical for declaration/definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '74';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_75">
                                <caption>75. [R] Every function shall have an explicit return type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '75';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_76">
                                <caption>76. [R] Functions with no parameters shall have a "void" parameter list</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '76';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_77">
                                <caption>77. [R] An actual parameter type shall be compatible with the prototype</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '77';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_78">
                                <caption>78. [R] The number of actual parameters shall match the prototype</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '78';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_79">
                                <caption>79. [R] The values returned by "void" functions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '79';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_80">
                                <caption>80. [R] Void expressions shall not be passed as function parameters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '80';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_81">
                                <caption>81. [A] "const" should be used for reference parameters not modified</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '81';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_82">
                                <caption>82. [A] A function should have a single point of exit</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '82';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_83">
                                <caption>83. [R] Every exit point shall have a "return" of the declared return type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '83';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_84">
                                <caption>84. [R] For "void" functions, "return" shall not have an expression</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '84';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_85">
                                <caption>85. [A] Function calls with no parameters should have empty parentheses</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '85';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_86">
                                <caption>86. [A] If a function returns error information, it should be tested</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '86';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Pre-processing Directives</caption>
                        <choices id="Choices_1998_Pre_processing_Directives">
                            <default state="Choise_1998_87,Choise_1998_88,Choise_1998_89,Choise_1998_90,Choise_1998_91,Choise_1998_94,Choise_1998_95,Choise_1998_96,Choise_1998_98,Choise_1998_99,Choise_1998_100"/>
                            <choice id="Choise_1998_87">
                                <caption>87. [R] #include shall only be preceded by other directives or comments</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '87';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_88">
                                <caption>88. [R] Non-standard characters shall not occur in #include directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '88';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_89">
                                <caption>89. [R] #include shall be followed by either &lt;filename&gt; or "filename"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '89';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_90">
                                <caption>90. [R] Plain macros shall only be used for constants/qualifiers/specifiers</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '90';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_91">
                                <caption>91. [R] Macros shall not be #define'd and #undef'd within a block</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '91';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_92">
                                <caption>92. [A] #undef should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '92';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_93">
                                <caption>93. [A] A function should be used in preference to a function-like macro</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '93';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_94">
                                <caption>94. [R] A function-like macro shall not be used without all arguments</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '94';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_95">
                                <caption>95. [R] Macro arguments shall not contain pre-preprocessing directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '95';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_96">
                                <caption>96. [R] Macro definitions/parameters should be enclosed in parentheses</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '96';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_97">
                                <caption>97. [A] Don't use undefined identifiers in pre-processor directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '97';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_98">
                                <caption>98. [R] A macro definition shall contain at most one # or ## operator</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '98';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_99">
                                <caption>99. [R] All uses of the #pragma directive shall be documented</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '99';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_100">
                                <caption>100. [R] "defined" shall only be used in one of the two standard forms</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '100';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Pointers and Arrays</caption>
                        <choices id="Choices_1998_Pointers_and_Arrays">
                            <default state="Choise_1998_103,Choise_1998_104,Choise_1998_105,Choise_1998_106,Choise_1998_107"/>
                            <choice id="Choise_1998_101">
                                <caption>101. [A] Pointer arithmetic should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '101';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_102">
                                <caption>102. [A] No more than 2 levels of pointer indirection should be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '102';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_103">
                                <caption>103. [R] No relational operators between pointers to different objects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '103';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_104">
                                <caption>104. [R] Non-constant pointers to functions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '104';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_105">
                                <caption>105. [R] Functions assigned to the same pointer shall be of identical type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '105';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_106">
                                <caption>106. [R] Automatic address may not be assigned to a longer lived object</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '106';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_107">
                                <caption>107. [R] The null pointer shall not be de-referenced</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '107';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Structures and Unions</caption>
                        <choices id="Choices_1998_Structures_and_Unions">
                            <default state="Choise_1998_108,Choise_1998_109,Choise_1998_110,Choise_1998_111,Choise_1998_112,Choise_1998_113"/>
                            <choice id="Choise_1998_108">
                                <caption>108. [R] All struct/union members shall be fully specified</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '108';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_109">
                                <caption>109. [R] Overlapping variable storage shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '109';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_110">
                                <caption>110. [R] Unions shall not be used to access the sub-parts of larger types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '110';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_111">
                                <caption>111. [R] Bit fields shall have type "unsigned int" or "signed int"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '111';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_112">
                                <caption>112. [R] Bit fields of type "signed int" shall be at least 2 bits long</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '112';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_113">
                                <caption>113. [R] All struct/union members shall be named</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '113';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Standard Libraries</caption>
                        <choices id="Choices_1998_Standard_Libraries">
                            <default state="Choise_1998_114,Choise_1998_115,Choise_1998_116,Choise_1998_117,Choise_1998_118,Choise_1998_119,Choise_1998_120,Choise_1998_121,Choise_1998_122,Choise_1998_123,Choise_1998_124,Choise_1998_125,Choise_1998_126,Choise_1998_127"/>
                            <choice id="Choise_1998_114">
                                <caption>114. [R] Reserved and standard library names shall not be redefined</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '114';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_115">
                                <caption>115. [R] Standard library function names shall not be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '115';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_116">
                                <caption>116. [R] Production libraries shall comply with the MISRA-C restrictions</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '116';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_117">
                                <caption>117. [R] The validity of library function parameters shall be checked</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '117';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_118">
                                <caption>118. [R] Dynamic heap memory allocation shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '118';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_119">
                                <caption>119. [R] The error indicator "errno" shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '119';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_120">
                                <caption>120. [R] The macro "offsetof" shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '120';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_121">
                                <caption>121. [R] &lt;locale.h&gt; and the "setlocale" function shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '121';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_122">
                                <caption>122. [R] The setjmp and longjmp functions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '122';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_123">
                                <caption>123. [R] The signal handling facilities of &lt;signal.h&gt; shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '123';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_124">
                                <caption>124. [R] The &lt;stdio.h&gt; library shall not be used in production code</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '124';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_125">
                                <caption>125. [R] The functions atof/atoi/atol shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '125';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_126">
                                <caption>126. [R] The functions abort/exit/getenv/system shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '126';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_127">
                                <caption>127. [R] The time handling functions of library &lt;time.h&gt; shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '127';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                </group>
                <group id="MISRAC2004Rules">
                    <caption>Custom Configuration 2004</caption>
                    <tool_id id_ref="CC"/>
                    <generate_option if="MISRACCustom.Selected AND MISRAC2004.Selected"/>
                    <subgroup>
                        <caption>1. Environment</caption>
                        <choices id="Choices_2004_1_Environment">
                            <default state="Choise_2004_1_1,Choise_2004_1_2,Choise_2004_1_3,Choise_2004_1_4"/>
                            <choice id="Choise_2004_1_1">
                                <caption>1.1. [R] No language extensions shall be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_1_2">
                                <caption>1.2. [R] Don't rely on undefined or unspecified behavior</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_1_3">
                                <caption>1.3. [R] Multiple compilers/languages shall only be used if there is a common defined interface standard</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_1_4">
                                <caption>1.4. [R] The compiler/linker shall be checked to ensure that 31 character significance and case sensitivity are supported for external identifiers</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_1_5">
                                <caption>1.5. [A] Floating-point implementations should comply with a defined floating-point standard</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.5';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>2. Language extensions</caption>
                        <choices id="Choices_2004_2_Language_extensions">
                            <default state="Choise_2004_2_1,Choise_2004_2_2,Choise_2004_2_3"/>
                            <choice id="Choise_2004_2_1">
                                <caption>2.1. [R] Inline assembly shall be encapsulated and isolated</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_2_2">
                                <caption>2.2. [R] // Comments shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_2_3">
                                <caption>2.3. [R] Comments shall not be nested</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_2_4">
                                <caption>2.4. [A] Sections of code should not be commented out</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2.4';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>3. Documentation</caption>
                        <choices id="Choices_2004_3_Documentation">
                            <default state="Choise_2004_3_1,Choise_2004_3_2,Choise_2004_3_4,Choise_2004_3_5"/>
                            <choice id="Choise_2004_3_1">
                                <caption>3.1. [R] All usage of implementation-defined behavior shall be documented</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_2">
                                <caption>3.2. [R] The character set and the corresponding encoding shall be documented</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_3">
                                <caption>3.3. [A] The implementation of integer division in the chosen compiler should be determined, documented and taken into account</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_4">
                                <caption>3.4. [R] All uses of '#pragma' shall be documented and explained</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_5">
                                <caption>3.5. [R] Structures with bitfields should not contain other members</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_6">
                                <caption>3.6. [A] All libraries used shall be written to comply with the provisions of this document, and shall have been subject to appropriate validation</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.6';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>4. Character sets</caption>
                        <choices id="Choices_2004_4_Character_sets">
                            <default state="Choise_2004_4_1,Choise_2004_4_2"/>
                            <choice id="Choise_2004_4_1">
                                <caption>4.1. [R] Only use characters defined by the C standard</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '4.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_4_2">
                                <caption>4.2. [R] Trigraphs shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '4.2';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>5. Identifiers</caption>
                        <choices id="Choices_2004_5_Identifiers">
                            <default state="Choise_2004_5_1,Choise_2004_5_2,Choise_2004_5_3,Choise_2004_5_4"/>
                            <choice id="Choise_2004_5_1">
                                <caption>5.1. [R] Identifiers shall not rely on significance of more than 31 characters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_2">
                                <caption>5.2. [R] Identifiers shall not hide identifiers in an outer scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_3">
                                <caption>5.3. [R] Typedef names should not be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_4">
                                <caption>5.4. [R] A tag name shall be a unique identifier</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_5">
                                <caption>5.5. [A] No object or function identifier with static storage duration should be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_6">
                                <caption>5.6. [A] The same identifier shall not be used in multiple name spaces</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_7">
                                <caption>5.7. [A] No identifier name should be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.7';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>6. Types</caption>
                        <choices id="Choices_2004_6_Types">
                            <default state="Choise_2004_6_1,Choise_2004_6_2,Choise_2004_6_4,Choise_2004_6_5"/>
                            <choice id="Choise_2004_6_1">
                                <caption>6.1. [R] Plain 'char' shall be used only for character values</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_6_2">
                                <caption>6.2. [R] Signed and unsigned char type shall be used only for the storage and use of numeric values</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_6_3">
                                <caption>6.3. [A] Specific-length typedefs should be used instead of the basic types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_6_4">
                                <caption>6.4. [R] Bit fields shall have type 'unsigned int' or 'signed int'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_6_5">
                                <caption>6.5. [R] Bit fields of type 'signed int' shall be at least 2 bits long</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.5';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>7. Constants</caption>
                        <choices id="Choices_2004_7_Constants">
                            <default state="Choise_2004_7_1"/>
                            <choice id="Choise_2004_7_1">
                                <caption>7.1. [R] Octal constants (other than zero) shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '7.1';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>8. Declarations and definitions</caption>
                        <choices id="Choices_2004_8_Declarations_and_definitions">
                            <default state="Choise_2004_8_1,Choise_2004_8_2,Choise_2004_8_3,Choise_2004_8_4,Choise_2004_8_5,Choise_2004_8_6,Choise_2004_8_7,Choise_2004_8_8,Choise_2004_8_9,Choise_2004_8_10,Choise_2004_8_11,Choise_2004_8_12"/>
                            <choice id="Choise_2004_8_1">
                                <caption>8.1. [R] Function prototypes shall be visible at the definition and call</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_2">
                                <caption>8.2. [R] Every function shall have an explicit return type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_3">
                                <caption>8.3. [R] The function prototype of the declaration shall match the definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_4">
                                <caption>8.4. [R] Multiple declarations for objects or functions shall be compatible</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_5">
                                <caption>8.5. [R] There shall be no definitions of objects or functions in a header file</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_6">
                                <caption>8.6. [R] Functions shall always be declared at file scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_7">
                                <caption>8.7. [R] Objects accessed by a single function shall be defined at block scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_8">
                                <caption>8.8. [R] An external object or function shall be declared in one and only one file</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_9">
                                <caption>8.9. [R] An identifier with external linkage shall have exactly one external definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_10">
                                <caption>8.10. [R] All declarations and definitions of objects or functions at file scope shall have internal linkage unless external linkage is required</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.10';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_11">
                                <caption>8.11. [R] Identifiers shall not have both internal and external linkage</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_12">
                                <caption>8.12. [R] External array shall have a known size</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.12';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>9. Initialization</caption>
                        <choices id="Choices_2004_9_Initialization">
                            <default state="Choise_2004_9_1,Choise_2004_9_2,Choise_2004_9_3"/>
                            <choice id="Choise_2004_9_1">
                                <caption>9.1. [R] All automatics shall be initialized before being used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '9.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_9_2">
                                <caption>9.2. [R] Braces shall be used in the initialization of arrays and structures</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '9.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_9_3">
                                <caption>9.3. [R] Only the first, or all enumeration constants may be initialized</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '9.3';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>10. Arithmetic type conversions</caption>
                        <choices id="Choices_2004_10_Arithmetic_type_conversions">
                            <default state="Choise_2004_10_1,Choise_2004_10_2,Choise_2004_10_3,Choise_2004_10_4,Choise_2004_10_5,Choise_2004_10_6"/>
                            <choice id="Choise_2004_10_1">
                                <caption>10.1. [R] Restrict the use of implicit conversions for integer types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_2">
                                <caption>10.2. [R] Restrict the use of implicit conversions for floating types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_3">
                                <caption>10.3. [R] A complex integer expression may only be cast to a type of the same signedness that is no wider than the underlying type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_4">
                                <caption>10.4. [R] A complex floating expression may only be cast to a type that is no wider than the underlying type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_5">
                                <caption>10.5. [R] Don't use ~ or &lt;&lt; on small unsigned types without a cast</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_6">
                                <caption>10.6. [R] A 'U' suffix should be applied to all constants of unsigned type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.6';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>11. Pointer type conversions</caption>
                        <choices id="Choices_2004_11_Pointer_type_conversions">
                            <default state="Choise_2004_11_1,Choise_2004_11_2,Choise_2004_11_5"/>
                            <choice id="Choise_2004_11_1">
                                <caption>11.1. [R] A function pointer shall only be converted to/from an integral type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_11_2">
                                <caption>11.2. [R] An object pointer shall only be converted to/from an integral type, another object pointer, or void pointer</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_11_3">
                                <caption>11.3. [A] A pointer type should not be cast to/from an integral type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_11_4">
                                <caption>11.4. [A] An object pointer type should not be cast to/from a different object pointer type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_11_5">
                                <caption>11.5. [R] A cast shall not remove 'const' or 'volatile' qualifiers</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.5';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>12. Expressions</caption>
                        <choices id="Choices_2004_12_Expressions">
                            <default state="Choise_2004_12_2,Choise_2004_12_3,Choise_2004_12_4,Choise_2004_12_5,Choise_2004_12_7,Choise_2004_12_8,Choise_2004_12_9,Choise_2004_12_10,Choise_2004_12_12"/>
                            <choice id="Choise_2004_12_1">
                                <caption>12.1. [A] No dependency should be placed on operator precedence rules</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_2">
                                <caption>12.2. [R] The value of an expression shall be evaluation order independent</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_3">
                                <caption>12.3. [R] 'sizeof' should not be used on expressions with side effects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_4">
                                <caption>12.4. [R] The right hand side of &amp;&amp; or || shall not contain side effects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_5">
                                <caption>12.5. [R] The operands of a logical &amp;&amp; or || shall be primary expressions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_6">
                                <caption>12.6. [A] The operators &amp;&amp;, || and ! should be used exclusively for Boolean operands</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_7">
                                <caption>12.7. [R] Bitwise operations shall not be performed on signed operands</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_8">
                                <caption>12.8. [R] A shift count shall be between 0 and the operand width minus 1</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_9">
                                <caption>12.9. [R] The unary minus shall not be applied to an unsigned expression</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_10">
                                <caption>12.10. [R] The comma operator shall only be used in a 'for' condition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.10';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_11">
                                <caption>12.11. [A] Evaluation of unsigned expressions should not lead to wrap-around</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_12">
                                <caption>12.12. [R] The bit representations of floating point numbers shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.12';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_13">
                                <caption>12.13. [A] The ++ and -- operators should not be mixed with other operators</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.13';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>13. Control statement expressions</caption>
                        <choices id="Choices_2004_13_Control_statement_expressions">
                            <default state="Choise_2004_13_1,Choise_2004_13_3,Choise_2004_13_4,Choise_2004_13_5,Choise_2004_13_6,Choise_2004_13_7"/>
                            <choice id="Choise_2004_13_1">
                                <caption>13.1. [R] Assignment operators shall not be used in Boolean expressions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_2">
                                <caption>13.2. [A] Tests of a value against zero should be made explicit</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_3">
                                <caption>13.3. [R] F.P. variables shall not be tested for exact equality or inequality</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_4">
                                <caption>13.4. [R] Floating point variables shall not be used as loop counters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_5">
                                <caption>13.5. [R] Only loop control expressions should appear within a for statement</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_6">
                                <caption>13.6. [R] Iterator variables should not be modified in the loop</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_7">
                                <caption>13.7. [R] Boolean operations whose result is invariant shall not be permitted</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.7';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>14. Control flow</caption>
                        <choices id="Choices_2004_14_Control_flow">
                            <default state="Choise_2004_14_1,Choise_2004_14_2,Choise_2004_14_3,Choise_2004_14_4,Choise_2004_14_5,Choise_2004_14_6,Choise_2004_14_7,Choise_2004_14_8,Choise_2004_14_9,Choise_2004_14_10"/>
                            <choice id="Choise_2004_14_1">
                                <caption>14.1. [R] There shall be no unreachable code</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_2">
                                <caption>14.2. [R] All non-null statements shall have a side-effect</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_3">
                                <caption>14.3. [R] A null statement shall only occur on a line by itself</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_4">
                                <caption>14.4. [R] The 'goto' statement shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_5">
                                <caption>14.5. [R] The 'continue' statement shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_6">
                                <caption>14.6. [R] An iteration statement shall have at most one break statement</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_7">
                                <caption>14.7. [R] A function should have a single point of exit</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_8">
                                <caption>14.8. [R] The body of a 'switch' or loop shall be a compound statement</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_9">
                                <caption>14.9. [R] 'if'/'else' shall be followed by a compound statement, except for 'else' followed by 'if'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_10">
                                <caption>14.10. [R] All 'if', 'else if' constructs should contain a final 'else'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.10';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>15. Switch statement</caption>
                        <choices id="Choices_2004_15_Switch_statement">
                            <default state="Choise_2004_15_1,Choise_2004_15_2,Choise_2004_15_3,Choise_2004_15_4,Choise_2004_15_5"/>
                            <choice id="Choise_2004_15_1">
                                <caption>15.1. [R] A case label shall only be used in the outermost compound statement of a switch</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_15_2">
                                <caption>15.2. [R] Every non-empty 'case' clause shall be terminated with a 'break'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_15_3">
                                <caption>15.3. [R] All 'switch' statements should contain a final 'default' case</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_15_4">
                                <caption>15.4. [R] A 'switch' expression should not represent a Boolean case</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_15_5">
                                <caption>15.5. [R] Every 'switch' shall have at least one 'case'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.5';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>16. Functions</caption>
                        <choices id="Choices_2004_16_Functions">
                            <default state="Choise_2004_16_1,Choise_2004_16_2,Choise_2004_16_3,Choise_2004_16_4,Choise_2004_16_5,Choise_2004_16_6,Choise_2004_16_8,Choise_2004_16_9,Choise_2004_16_10"/>
                            <choice id="Choise_2004_16_1">
                                <caption>16.1. [R] Functions with variable number of arguments shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_2">
                                <caption>16.2. [R] Functions shall not call themselves</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_3">
                                <caption>16.3. [R] Identifiers shall be given for all prototype parameters or for none</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_4">
                                <caption>16.4. [R] Parameter identifiers shall be identical for declaration/definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_5">
                                <caption>16.5. [R] Functions with no parameters shall have a 'void' parameter list</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_6">
                                <caption>16.6. [R] The number of actual parameters shall match the prototype</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_7">
                                <caption>16.7. [A] 'const' should be used on pointer parameters whenever possible</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_8">
                                <caption>16.8. [R] Every exit point shall have a 'return' of the declared return type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_9">
                                <caption>16.9. [R] Function calls with no parameters should have empty parentheses</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_10">
                                <caption>16.10. [R] Error information returned by a function should be tested</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.10';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>17. Pointers and arrays</caption>
                        <choices id="Choices_2004_17_Pointers_and_arrays">
                            <default state="Choise_2004_17_1,Choise_2004_17_2,Choise_2004_17_3,Choise_2004_17_4,Choise_2004_17_6"/>
                            <choice id="Choise_2004_17_1">
                                <caption>17.1. [R] Pointer arithmetic shall only be applied to pointers that address an array or array element</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_2">
                                <caption>17.2. [R] Pointer subtraction shall only be applied to pointers that address elements of the same array</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_3">
                                <caption>17.3. [R] Relational operators shall not be applied to pointers to different objects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_4">
                                <caption>17.4. [R] Array indexing shall be the only allowed form of pointer arithmetic</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_5">
                                <caption>17.5. [A] No more than 2 levels of pointer indirection should be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_6">
                                <caption>17.6. [R] An automatic address may not be assigned to a longer lived object</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.6';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>18. Structures and unions</caption>
                        <choices id="Choices_2004_18_Structures_and_unions">
                            <default state="Choise_2004_18_1,Choise_2004_18_2,Choise_2004_18_3,Choise_2004_18_4"/>
                            <choice id="Choise_2004_18_1">
                                <caption>18.1. [R] All members of a struct or union shall be fully specified</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_18_2">
                                <caption>18.2. [R] An object shall not be assigned to an overlapping object</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_18_3">
                                <caption>18.3. [R] An area of memory shall not be reused for unrelated purposes</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_18_4">
                                <caption>18.4. [R] Unions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18.4';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>19. Preprocessing directives</caption>
                        <choices id="Choices_2004_19_Preprocessing_directives">
                            <default state="Choise_2004_19_3,Choise_2004_19_4,Choise_2004_19_5,Choise_2004_19_6,Choise_2004_19_8,Choise_2004_19_9,Choise_2004_19_10,Choise_2004_19_11,Choise_2004_19_12,Choise_2004_19_14,Choise_2004_19_15,Choise_2004_19_16,Choise_2004_19_17"/>
                            <choice id="Choise_2004_19_1">
                                <caption>19.1. [A] #include shall only be preceded by another directives or comments</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_2">
                                <caption>19.2. [A] Non-standard characters shall not occur in #include directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_3">
                                <caption>19.3. [R] #include shall be followed by either &lt;filename&gt; or "filename"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_4">
                                <caption>19.4. [R] Macros shall only be used for initializers/constants/expressions/qualifiers/specifiers/do-while(0)</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_5">
                                <caption>19.5. [R] Macros shall not be defined/undefined within a block</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_6">
                                <caption>19.6. [R] #undef should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_7">
                                <caption>19.7. [A] A function should be used in preference to a function-like macro</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_8">
                                <caption>19.8. [R] A function-like macro shall not be used without all arguments</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_9">
                                <caption>19.9. [R] Macro arguments shall not contain tokens that look like directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_10">
                                <caption>19.10. [R] A macro parameter shall be enclosed in parentheses</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.10';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_11">
                                <caption>19.11. [R] Don't use undefined identifiers in pre-processing directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_12">
                                <caption>19.12. [R] A macro definition shall contain at most one # or ## operator</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.12';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_13">
                                <caption>19.13. [A] The '#' and '##' preprocessor operators should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.13';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_14">
                                <caption>19.14. [R] 'defined' shall only be used in one of the two standard forms</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.14';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_15">
                                <caption>19.15. [R] The contents of a header file shall not be included twice</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.15';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_16">
                                <caption>19.16. [R] Preprocessing directives shall be syntactically meaningful even when excluded</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.16';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_17">
                                <caption>19.17. [R] #else/#elif/#endif shall reside in the same file as the corresponding #if/#ifdef/#ifndef</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.17';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>20. Standard libraries</caption>
                        <choices id="Choices_2004_20_Standard_libraries">
                            <default state="Choise_2004_20_1,Choise_2004_20_2,Choise_2004_20_3,Choise_2004_20_4,Choise_2004_20_5,Choise_2004_20_6,Choise_2004_20_7,Choise_2004_20_8,Choise_2004_20_9,Choise_2004_20_10,Choise_2004_20_11,Choise_2004_20_12"/>
                            <choice id="Choise_2004_20_1">
                                <caption>20.1. [R] Reserved and standard library names shall not be redefined</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_2">
                                <caption>20.2. [R] Standard library function names shall not be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_3">
                                <caption>20.3. [R] The validity of values passed to library functions shall be checked</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_4">
                                <caption>20.4. [R] Dynamic heap memory allocation shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_5">
                                <caption>20.5. [R] 'errno' should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_6">
                                <caption>20.6. [R] The macro 'offsetof()' shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_7">
                                <caption>20.7. [R] The 'setjmp' and 'longjmp' functions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_8">
                                <caption>20.8. [R] The signal handling facilities of &lt;signal.h&gt; shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_9">
                                <caption>20.9. [R] The &lt;stdio.h&gt; library shall not be used in production code</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_10">
                                <caption>20.10. [R] The functions atof/atoi/atol shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.10';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_11">
                                <caption>20.11. [R] The functions abort/exit/getenv/system shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_12">
                                <caption>20.12. [R] The time handling functions of library &lt;time.h&gt; shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.12';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>21. Run-time failures</caption>
                        <choices id="Choices_2004_21_Run_time_failures">
                            <default state="Choise_2004_21_1"/>
                            <choice id="Choise_2004_21_1">
                                <caption>21.1. [R] Minimization of run-time failures shall be ensured by the use of at least one of: (a) static analysis tools/techniques; (b) dynamic analysis tools/techniques; (c) explicit coding of checks to handle run-time faults.</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '21.1';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                </group>
                <text id="MISRACOptions">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                DXP.AddToolCmdOption('--misrac=' + MISRACCustom.Flag);
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="CERT">
                <caption>CERT C Secure Code Checking</caption>
                <tool_id id_ref="CC"/>
                <choices id="Choices_CERTChecking">
                    <caption>CERT C secure code checking</caption>
                    <tool_tip>This option enables one or more of the CERT C Secure Coding Standard checks.<br/>
If you select 'Custom configuration', select or clear individual rules on the 'Custom Configuration' page.</tool_tip>
                    <single/>
                    <default state="CERTDisabled"/>
                    <choice id="CERTDisabled">
                        <caption>Disabled</caption>
                    </choice>
                    <choice id="CERTRulesOnly">
                        <caption>Supported rules only</caption>
                        <makefile_generator>
                            <selected>
                                CERTCustom.Flag := 'DCL30,DCL31,DCL32,DCL35,EXP30,EXP32,EXP33,EXP34,EXP37,EXP38,INT30,INT34,INT35,FLP30,FLP35,FLP36,ARR34,ARR35,STR30,STR33,STR34,STR36,MEM30,MEM31,MEM32,MEM33,MEM34,MEM35,ENV32,SIG30,SIG32,MSC32';
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CERTRecommendationsAndRules">
                        <caption>Supported recommendatons and rules</caption>
                        <makefile_generator>
                            <selected>
                                CERTCustom.Flag := 'PRE01,PRE02,PRE10,PRE11,DCL30,DCL31,DCL32,DCL35,EXP01,EXP12,EXP30,EXP32,EXP33,EXP34,EXP37,EXP38,INT30,INT34,INT35,FLP30,FLP35,FLP36,ARR01,ARR34,ARR35,STR30,STR33,STR34,STR36,MEM00,MEM08,MEM30,MEM31,MEM32,MEM33,MEM34,MEM35,ENV32,SIG30,SIG32,MSC32';
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CERTCustom">
                        <caption>Custom configuration</caption>
                    </choice>
                </choices>
                <group id="CERTRules">
                    <caption>Custom Configuration</caption>
                    <tool_id id_ref="CC"/>
                    <generate_option if="CERTCustom.Selected"/>
                    <subgroup>
                        <caption>01. Preprocessor (PRE)</caption>
                        <choices id="Choices_CERT_01_Preprocessor_(PRE)">
                            <default state=""/>
                            <choice id="Choise_CERT_PRE01">
                                <caption>PRE01 [Rec] Use parentheses within macros around parameter names</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'PRE01';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_PRE02">
                                <caption>PRE02 [Rec] Macro replacement lists should be parenthesized</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'PRE02';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_PRE10">
                                <caption>PRE10 [Rec] Wrap multi-statement macros in a do-while loop</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'PRE10';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_PRE11">
                                <caption>PRE11 [Rec] Do not conclude a single statement macro definition with a semicolon</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'PRE11';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>02. Declarations and Initialization (DCL)</caption>
                        <choices id="Choices_CERT_02_Declarations_and_Initialization_(DCL)">
                            <default state="Choise_CERT_DCL30,Choise_CERT_DCL31,Choise_CERT_DCL32,Choise_CERT_DCL35"/>
                            <choice id="Choise_CERT_DCL30">
                                <caption>DCL30 [Rul] Declare objects with appropriate storage durations</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'DCL30';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_DCL31">
                                <caption>DCL31 [Rul] Declare identifiers before using them</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'DCL31';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_DCL32">
                                <caption>DCL32 [Rul] Guarantee that mutually visible identifiers are unique</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'DCL32';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_DCL35">
                                <caption>DCL35 [Rul] Do not invoke a function using a type that does not match the function definition</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'DCL35';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>03. Expressions (EXP)</caption>
                        <choices id="Choices_CERT_03_Expressions_(EXP)">
                            <default state="Choise_CERT_EXP30,Choise_CERT_EXP32,Choise_CERT_EXP33,Choise_CERT_EXP34,Choise_CERT_EXP37,Choise_CERT_EXP38"/>
                            <choice id="Choise_CERT_EXP01">
                                <caption>EXP01 [Rec] Do not take the size of a pointer to determine the size of the pointed-to type</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'EXP01';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_EXP12">
                                <caption>EXP12 [Rec] Do not ignore values returned by functions</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'EXP12';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_EXP30">
                                <caption>EXP30 [Rul] Do not depend on order of evaluation between sequence points</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'EXP30';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_EXP32">
                                <caption>EXP32 [Rul] Do not access a volatile object through a non-volatile reference</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'EXP32';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_EXP33">
                                <caption>EXP33 [Rul] Do not reference uninitialized memory</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'EXP33';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_EXP34">
                                <caption>EXP34 [Rul] Ensure a null pointer is not dereferenced</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'EXP34';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_EXP37">
                                <caption>EXP37 [Rul] Call functions with the arguments intended by the API</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'EXP37';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_EXP38">
                                <caption>EXP38 [Rul] Do not call offsetof() on bit-field members or invalid types</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'EXP38';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>04. Integers (INT)</caption>
                        <choices id="Choices_CERT_04_Integers_(INT)">
                            <default state="Choise_CERT_INT30,Choise_CERT_INT34,Choise_CERT_INT35"/>
                            <choice id="Choise_CERT_INT30">
                                <caption>INT30 [Rul] Ensure that unsigned integer operations do not wrap</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'INT30';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_INT34">
                                <caption>INT34 [Rul] Do not shift a negative number of bits or more bits than exist in the operand</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'INT34';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_INT35">
                                <caption>INT35 [Rul] Evaluate integer expressions in a larger size before comparing or assigning to that size</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'INT35';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>05. Floating Point (FLP)</caption>
                        <choices id="Choices_CERT_05_Floating_Point_(FLP)">
                            <default state="Choise_CERT_FLP30,Choise_CERT_FLP35,Choise_CERT_FLP36"/>
                            <choice id="Choise_CERT_FLP30">
                                <caption>FLP30 [Rul] Do not use floating point variables as loop counters</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'FLP30';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_FLP35">
                                <caption>FLP35 [Rul] Take granularity into account when comparing floating point values</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'FLP35';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_FLP36">
                                <caption>FLP36 [Rul] Beware of precision loss when converting integral types to floating point</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'FLP36';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>06. Arrays (ARR)</caption>
                        <choices id="Choices_CERT_06_Arrays_(ARR)">
                            <default state="Choise_CERT_ARR34,Choise_CERT_ARR35"/>
                            <choice id="Choise_CERT_ARR01">
                                <caption>ARR01 [Rec] Do not apply the sizeof operator to a pointer when taking the size of an array</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'ARR01';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_ARR34">
                                <caption>ARR34 [Rul] Ensure that array types in expressions are compatible</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'ARR34';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_ARR35">
                                <caption>ARR35 [Rul] Do not allow loops to iterate beyond the end of an array</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'ARR35';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>07. Characters and Strings (STR)</caption>
                        <choices id="Choices_CERT_07_Characters_and_Strings_(STR)">
                            <default state="Choise_CERT_STR30,Choise_CERT_STR33,Choise_CERT_STR34,Choise_CERT_STR36"/>
                            <choice id="Choise_CERT_STR30">
                                <caption>STR30 [Rul] Do not attempt to modify string literals</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'STR30';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_STR33">
                                <caption>STR33 [Rul] Size wide character strings correctly</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'STR33';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_STR34">
                                <caption>STR34 [Rul] Cast characters to unsigned types before converting to larger integer sizes</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'STR34';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_STR36">
                                <caption>STR36 [Rul] Do not specify the bound of a character array initialized with a string literal</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'STR36';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>08. Memory Management (MEM)</caption>
                        <choices id="Choices_CERT_08_Memory_Management_(MEM)">
                            <default state="Choise_CERT_MEM30,Choise_CERT_MEM31,Choise_CERT_MEM32,Choise_CERT_MEM33,Choise_CERT_MEM34,Choise_CERT_MEM35"/>
                            <choice id="Choise_CERT_MEM00">
                                <caption>MEM00 [Rec] Allocate and free memory in the same module, at the same level of abstraction</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'MEM00';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_MEM08">
                                <caption>MEM08 [Rec] Use realloc() only to resize dynamically allocated arrays</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'MEM08';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_MEM30">
                                <caption>MEM30 [Rul] Do not access freed memory</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'MEM30';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_MEM31">
                                <caption>MEM31 [Rul] Free dynamically allocated memory exactly once</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'MEM31';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_MEM32">
                                <caption>MEM32 [Rul] Detect and handle memory allocation errors</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'MEM32';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_MEM33">
                                <caption>MEM33 [Rul] Use the correct syntax for flexible array members</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'MEM33';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_MEM34">
                                <caption>MEM34 [Rul] Only free memory allocated dynamically</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'MEM34';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_MEM35">
                                <caption>MEM35 [Rul] Allocate sufficient memory for an object</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'MEM35';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>10. Environment (ENV)</caption>
                        <choices id="Choices_CERT_10_Environment_(ENV)">
                            <default state="Choise_CERT_ENV32"/>
                            <choice id="Choise_CERT_ENV32">
                                <caption>ENV32 [Rul] All atexit handlers must return normally</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'ENV32';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>11. Signals (SIG)</caption>
                        <choices id="Choices_CERT_11_Signals_(SIG)">
                            <default state="Choise_CERT_SIG30,Choise_CERT_SIG32"/>
                            <choice id="Choise_CERT_SIG30">
                                <caption>SIG30 [Rul] Call only asynchronous-safe functions within signal handlers</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'SIG30';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_CERT_SIG32">
                                <caption>SIG32 [Rul] Do not call longjmp() from inside a signal handler</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'SIG32';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>49. Miscellaneous (MSC)</caption>
                        <choices id="Choices_CERT_49_Miscellaneous_(MSC)">
                            <default state="Choise_CERT_MSC32"/>
                            <choice id="Choise_CERT_MSC32">
                                <caption>MSC32 [Rul] Ensure your random number generator is properly seeded</caption>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(CERTCustom.Flag,'') then
                                            CERTCustom.Flag := CERTCustom.Flag + ',';
                                        CERTCustom.Flag := CERTCustom.Flag + 'MSC32';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                </group>
                <text id="CERTOptions">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            if NOT AnsiSameText(CERTCustom.Flag,'') then
                                DXP.AddToolCmdOption('-Wc--cert=' + CERTCustom.Flag);
                        </selected>
                    </makefile_generator>
                </text>
            </group>

            <group id="CcMiscellaneous">
                <caption>Miscellaneous</caption>
                <tool_id id_ref="CC"/>
                <text id="CompKeepTmpFiles"> 
                    <invisible/>
                    <generate_option if="KeepTmpFiles.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-t');
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_CompFullSectionNames">
                    <default state="CompFullSectionNames"/>
                    <choice id="CompFullSectionNames">
                        <caption>Use extended section names</caption>
                        <tool_tip>This option mangles the module name (for code and data) and the function name (for code) in the output section names. This is needed in order to enable individual module and function selections under the Locate Options tab.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--rename-sections={module}.{cname}');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_MixedAsm">
                    <default state=""/>
                    <choice id="MixedAsm">
                        <caption>Merge C source code with assembly in output file (.src)</caption>
                        <tool_tip>Select this option to see the relation between the C source code and the generated assembly code.<br/>
This option only have effect when 'Keep temporary files' in the Build Options is enabled.</tool_tip>
                        <generate_option if="KeepTmpFiles.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wc--source');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <cmdoptions id="CmdOptCC" tool_id_ref="CC"/>
                <text id="CompAdditional">
                    <multi/>
                    <caption>Additional C compiler options</caption>
                    <tool_tip>Some compiler options are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( CompAdditional.State );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="CompAdditional_CHC">
                    <multi/>
                    <caption>Additional CHC compiler options</caption>
                    <tool_tip>Some CHC compiler options are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                    <generate_option if="AnsiSameText(ASP_Enable.State,'True')"/>
                </text>
                <text id="CompAdditional_HDLHC">
                    <multi/>
                    <caption>Additional CHC HDL generation options</caption>
                    <tool_tip>Here you can specify additional options for hdlhc,<br/>to influence the vhdl/verilog generation of CHC.</tool_tip>
                    <generate_option if="AnsiSameText(ASP_Enable.State,'True')"/>
                </text>
                <choices id="Choices_CompCHC_InitMemOnReset">
                    <choice id="HwCompInitMemOnReset">
                        <caption>Initialize ASP internal memories on reset</caption>
                        <tool_tip>Select this option to add copytables to the ASP internal memories.<br/>
These copytables are used to reinitialize the memories after a reset.</tool_tip>
                    <generate_option if="AnsiSameText(ASP_Enable.State,'True')"/>
                    </choice>
                </choices>
                <choices id="Choices_CompCHC_NoDefaultLibraries">
                    <choice id="HwCompNoDefaultLibraries">
                        <caption>Do not link CHC default libraries</caption>
                    </choice>
                </choices>
            </group>
        </group>

        <text id="ASM_Nature">
            <invisible/>
            <default state="SELECTED"/>
            <generate_option if="CPP_Nature.Selected OR C_Nature.Selected OR DXP.ProjContainsSuffix('.asm')"/>
        </text>
        <group id="Assembler">
            <caption>Assembler</caption>
            <generate_option if="ASM_Nature.Selected"/>
            <tool_id id_ref="AS"/>
            <group id="AsPreprocessing">
                <caption>Preprocessing</caption>
                <tool_id id_ref="AS"/>
                <table_edit id="AsmDefine">
                    <caption>User macro</caption>
                    <tool_tip>You can use a macro as a symbol in your assembly source, for example to create conditional assembly.<br/>
With this option you can assign values to macros you use in your assembly source.<br/>
In the drop-down table, specify a macro name and a value. If you omit the value, the macro expands to 1.</tool_tip>
                    <column caption="Macro">
                        <text id="AsmMacro">
                            <caption>Macro</caption>
                            <makefile_generator>
                                <selected>
                                    AsmMacro.Flag :=  AsmMacro.State ;
                                </selected>
                            </makefile_generator>
                        </text>
                    </column>
                    <column caption="Value">
                        <text id="AsmValue">
                            <caption>Value</caption>
                            <makefile_generator>
                                <selected>
                                    AsmValue.Flag := '="' + AsmValue.State + '"';
                                </selected>
                            </makefile_generator>
                        </text>
                    </column>
                    <text id="AsmDefine_Script">
                        <invisible/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-D' + AsmMacro.Flag + AsmValue.Flag );
                            </selected>
                        </makefile_generator>
                    </text>
                </table_edit>
                <text id="AsmSpecInc">
                    <caption>Include this file before source</caption>
                    <tool_tip>This file is included at the beginning of each assembly source file. <br/>
This is the same as specifying .INCLUDE 'file' at the beginning of each assembly source.<br/>
Specify the (full path and) file name to include a common include file for all assembly source files.</tool_tip>
                    <button on_click="DXP.FileOpenDialog(AsmSpecInc)"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wa-H"' + AsmSpecInc.State + '"');
                            DXP.AddToolDependency(AsmSpecInc.State, 'AS');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="AsmSysIncDir">
                    <default state="SELECTED"/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(DXP.IncDir,';',' ','-Wa-I"','"') );
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="AsDebugInformation">
                <caption>Debug Information</caption>
                <tool_id id_ref="AS"/>
                <choices id="Choices_Asmdebug1">
                    <caption>Debug information</caption>
                    <tool_tip>With debug information a debugger can display the original assembly source instead of disassembling the memory contents.<br/>
Select 'No debug information' to reduce code size if your application is working fine.<br/>
If you select 'Custom debug information' select one or more options below.</tool_tip>
                    <single/>
                    <default state="Asmdebug2"/>
                    <choice id="Asmdebug1">
                        <caption>No debug information</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-gAHLS');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmdebug2">
                        <caption>Automatic HLL or assembly level debug information</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-gs');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmdebug3">
                        <caption>Custom debug information</caption>
                    </choice>
                </choices>
                <choices id="Choices_Asmdebug3a">
                    <caption>Custom debug information</caption>
                    <tool_tip>Select 'Pass HLL debug information' if your source is a C file and you want to keep debug information generated by the C compiler.<br/>
Select 'Assembler source line information' to be able to debug an assembly source file.</tool_tip>
                    <single/>
                    <default state="Asmdebug3h"/>
                    <generate_option if="Asmdebug3.Selected"/>
                    <choice id="Asmdebug3a">
                        <caption>Assembler source line information</caption>
                        <makefile_generator>
                            <selected>
                                Asmdebug3a.Flag := 'a';
                            </selected>
                            <not_selected>
                                Asmdebug3a.Flag := 'A';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmdebug3h">
                        <caption>Pass HLL debug information</caption>
                        <generate_option if="1 AND Asmdebug3.Selected"/>
                        <makefile_generator>
                            <selected>
                                Asmdebug3h.Flag := 'h';
                            </selected>
                            <not_selected>
                                Asmdebug3h.Flag := 'H';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmdebug3None">
                        <caption>None of the above</caption>
                    </choice>
                </choices>
                <choices id="Choices_Asmdebug3l">
                    <default state=""/>
                    <choice id="Asmdebug3l">
                        <caption>Assembler local symbols information</caption>
                        <tool_tip>With this information you can see names of labels during debugging.<br/>
Select this option to add debug information about local symbols to the object file.</tool_tip>
                        <generate_option if="Asmdebug3.Selected"/>
                        <makefile_generator>
                            <selected>
                                Asmdebug3l.Flag := 'l';
                            </selected>
                            <not_selected>
                                Asmdebug3l.Flag := 'L';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="Asmdebug3_Script">
                    <invisible/>          
                    <default state="SELECTED"/>          
                    <generate_option if="Asmdebug3.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wa-g' + Asmdebug3a.Flag + Asmdebug3h.Flag + Asmdebug3l.Flag );
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="AsListFile">
                <caption>List File</caption>
                <tool_id id_ref="AS"/>
                <choices id="Choices_AsmList">
                    <default state=""/>
                    <choice id="AsmList">
                        <caption>Generate list file</caption>
                        <tool_tip>A list file shows the generated object code and the relative addresses.<br/>
Select this option to generate a list file with the same name as the source file but with extension .lst.<br/>
Additionally, specify below which information you want in the list file.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-l');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <subgroup>
                    <caption>List file format</caption>
                    <choices id="Choices_AsmListD">
                        <default state="AsmListD,AsmListI,AsmListL,AsmListN,AsmListQ,AsmListR,AsmListS,AsmListW,AsmListY"/>
                        <choice id="AsmOutputSectionSum">
                            <caption>Display section information</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('-Wa-tl');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListD">
                            <caption>Section directives (.SECTION)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListD.Flag := 'd';
                                </selected>
                                <not_selected>
                                    AsmListD.Flag := 'D';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListE">
                            <caption>Symbol definition directives (e.g. .EXTERN .CALLS)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListE.Flag := 'e';
                                </selected>
                                <not_selected>
                                    AsmListE.Flag := 'E';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListG">
                            <caption>Generic instruction expansion</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListG.Flag := 'g';
                                </selected>
                                <not_selected>
                                    AsmListG.Flag := 'G';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListI">
                            <caption>Generic instructions</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListI.Flag := 'i';
                                </selected>
                                <not_selected>
                                    AsmListI.Flag := 'I';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListL">
                            <caption>C preprocessor #line directives</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListL.Flag := 'l';
                                </selected>
                                <not_selected>
                                    AsmListL.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListM">
                            <caption>Macro/dup definitions (e.g. .MACRO)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListM.Flag := 'm';
                                </selected>
                                <not_selected>
                                    AsmListM.Flag := 'M';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListN">
                            <caption>Empty source lines (newline)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListN.Flag := 'n';
                                </selected>
                                <not_selected>
                                    AsmListN.Flag := 'N';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListP">
                            <caption>Conditional assembly (.IF, .ELSE, .ENDIF)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListP.Flag := 'p';
                                </selected>
                                <not_selected>
                                    AsmListP.Flag := 'P';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListQ">
                            <caption>Assembler equates and set directives (.EQU, .SET)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListQ.Flag := 'q';
                                </selected>
                                <not_selected>
                                    AsmListQ.Flag := 'Q';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListR">
                            <caption>Relocation characters ('r')</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListR.Flag := 'r';
                                </selected>
                                <not_selected>
                                    AsmListR.Flag := 'R';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListS">
                            <caption>HLL symbolic debug information (.SYMB)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListS.Flag := 's';
                                </selected>
                                <not_selected>
                                    AsmListS.Flag := 'S';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListV">
                            <caption>Assembler equates and set values</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListV.Flag := 'v';
                                </selected>
                                <not_selected>
                                    AsmListV.Flag := 'V';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListW">
                            <caption>Wrapped source lines</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListW.Flag := 'w';
                                </selected>
                                <not_selected>
                                    AsmListW.Flag := 'W';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListX">
                            <caption>Macro expansions</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListX.Flag := 'x';
                                </selected>
                                <not_selected>
                                    AsmListX.Flag := 'X';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListY">
                            <caption>Cycle counts</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListY.Flag := 'y';
                                </selected>
                                <not_selected>
                                    AsmListY.Flag := 'Y';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListZ">
                            <caption>Define expansions</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListZ.Flag := 'z';
                                </selected>
                                <not_selected>
                                    AsmListZ.Flag := 'Z';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                    <text id="AsmListControls">
                        <invisible/>
                        <generate_option if="AsmList.Selected"/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-L' + AsmListD.Flag + AsmListE.Flag + AsmListG.Flag + AsmListI.Flag + AsmListL.Flag + AsmListM.Flag + AsmListN.Flag + AsmListP.Flag + AsmListQ.Flag + AsmListR.Flag + AsmListS.Flag + AsmListV.Flag + AsmListW.Flag + AsmListX.Flag + AsmListY.Flag
+ AsmListZ.Flag
);
                            </selected>
                        </makefile_generator>
                    </text>
                </subgroup>
            </group>
            <group id="AsDiagnostics">
                <caption>Diagnostics</caption>
                <tool_id id_ref="AS"/>
                <choices id="Choices_AsmWarn">
                    <caption>Error reporting</caption>
                    <tool_tip>During the assembly process warnings can occur. By default, all warnings are reported.<br/>
Select one of the suppress options to hide the warning messages that are of no importance to you.</tool_tip>
                    <single/>
                    <default state="AsmWarn"/>
                    <choice id="AsmWarn">
                        <caption>Report all warnings</caption>
                    </choice>
                    <choice id="AsmNoWarn">
                        <caption>Suppress all warnings</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-w');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="AsmSpecWarn">
                        <caption>Suppress specific warnings</caption>
                    </choice>
                </choices>
                <text id="AsmWarnList">
                    <multi/>
                    <caption>    Specific warnings to suppress</caption>
                    <tool_tip>Specify one or more warnings to suppress, separated by commas.<br/>
For example: 10,20,130</tool_tip>
                    <generate_option if="AsmSpecWarn.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(AsmWarnList.State ,',',' ','-Wa-w') );
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_AsmWarningsAsErrors">
                    <default state=""/>
                    <choice id="AsmWarningsAsErrors">
                        <caption>Treat warnings as errors</caption>
                        <tool_tip>When warnings occur the assembly process continues.<br/>
When errors occur the assembly process stops.<br/>
Select this option to stop the assembly process also when only warnings occur.</tool_tip>
                        <generate_option if="NOT AsmNoWarn.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa--warnings-as-errors');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="AsMiscellaneous">
                <caption>Miscellaneous</caption>
                <tool_id id_ref="AS"/>
                <choices id="Choices_AsmCase">
                    <default state="AsmCase"/>
                    <choice id="AsmCase">
                        <caption>Assemble case sensitive (required for C language)</caption>
                        <tool_tip>All identifiers (for example, labels) will appear in the object file exactly as they appear in the source file.<br/>
Clear this option to convert all identifiers to upper case. For example, if you write your own assembly file.</tool_tip>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('-Wa--case-insensitive');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_Asmlabels1">
                    <caption>Labels are by default</caption>
                    <tool_tip>This option determines how to treat labels that are not specified explicitly as global or local.<br/>
Local labels are only known in the current module.<br/>
Select 'Global' to specify that the labels in the current module can be accessed from other modules.</tool_tip>
                    <single/>
                    <default state="Asmlabels1"/>
                    <choice id="Asmlabels1">
                        <caption>Local</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-il');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmlabel2">
                        <caption>Global</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-ig');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <cmdoptions id="CmdOptAS" tool_id_ref="AS"/>
                <text id="AsmAdditional">
                    <multi/>
                    <caption>Additional assembler options</caption>
                    <tool_tip>Some assembler options are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(AsmAdditional.State);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="AsmProfiling"> 
                    <invisible/>
                    <generate_option if="CompProfiling.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wa--emit-locals');
                        </selected>
                    </makefile_generator>
                </text>
            </group>
        </group>

        <group id="Linker">
            <caption>Linker</caption>
            <generate_option if="CPP_Nature.Selected OR C_Nature.Selected OR ASM_Nature.Selected"/>
            <global/>   
            <tool_id id_ref="LK"/>
            <group id="LkOutputFormat">
                <caption>Output Format</caption>
                <tool_id id_ref="LK"/>
                <text id="LkIeeeTargetExt">
                    <invisible/>
                    <freeze_state if="TRUE" state="abs"/>
                </text>
                <text id="LkCoreSelect">
                    <invisible/>
                    <generate_option if="AnsiSameText(ASP_Enable.State,'True')"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl--core=sw');
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_LkIeee">
                    <caption>Output format</caption>
                    <tool_tip>This option determines the resulting file of a compile.<br/>
By default, the resulting file is an application you can debug.<br/>
Select 'Library for TASKING Linker' if you want to build a library for use in other projects.</tool_tip>
                    <single/>
                    <default state="LkIeee"/>
                    <choice id="LkIeee">
                        <caption>Absolute file for debuggers (.abs)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.SetPrjTargetExt(LkIeeeTargetExt.state);
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkLib">
                        <caption>Library for TASKING Linker (.lib)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.SetPrjTargetExt('lib');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_LkIhex">
                    <default state="LkIhex"/>
                    <choice id="LkIhex">
                        <caption>Intel HEX records for EPROM programmers (.hex)</caption>
                        <tool_tip>To select this option you must set the output format to 'Absolute file for debuggers'.<br/>
Select this option to generate an additional output file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                    </choice>
                    <choice id="LkSrec">
                        <caption>Motorola S-records for EPROM programmers (.sre)</caption>
                        <tool_tip>To select this option you must set the output format to 'Absolute file for debuggers'.<br/>
Select this option to generate an additional output file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="LkIhex_Script">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="LkIhex.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl-c"' + DXP.OutDir + DXP.ProjectName + ':IHEX"');
                        </selected>
                    </makefile_generator>
                </text>

                <text id="LkSrec_Script">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="LkSrec.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl-c"' + DXP.OutDir + DXP.ProjectName + ':SREC"');
                        </selected>
                    </makefile_generator>
                </text>

                <text id="LkLslIncludes">
                    <invisible/>
                    <generate_option if="LkStdLsl.Selected AND AnsiSameText(ASP_Enable.State,'True')"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl-I"$(PRODDIR)\chc\include.lsl"');
                        </selected>
                    </makefile_generator>
                </text>

                <text id="LkMemoryUseConstraintFile">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="LkStdLsl.Selected"/>
                    <makefile_generator>
                        <selected>
                            AddMemConstraint;
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkGlobalTypeChecking">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="CompGlobalTypeChecking.Selected"/>
                    <makefile_generator>
                        <selected>
                                DXP.AddToolCmdOption('--global-type-checking');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkCppOptions">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="CPP_Nature.Selected"/>
                    <makefile_generator>
                        <selected>
                                DXP.AddToolCmdOption('--force-c++');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkIoStream">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="CPP_Nature.Selected AND CppIoStream.Selected"/>
                    <makefile_generator>
                        <selected>
                                DXP.AddToolCmdOption('--io-stream');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkExceptions">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="CPP_Nature.Selected AND CppExceptions.Selected"/>
                    <makefile_generator>
                        <selected>
                                DXP.AddToolCmdOption('--exceptions');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkFloatSingle">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="CompFloatSingle.Selected"/>
                    <makefile_generator>
                        <selected>
                                DXP.AddToolCmdOption('--no-double');
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="LkLibraries">
                <caption>Libraries</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LKCLibraries">
                    <default state="LKCLibraries,LKRescan"/>
                    <choice id="LKCLibraries">
                        <caption>Link default C libraries</caption>
                        <tool_tip>The default C libraries are the C library, floating-point library and run-time library.<br/>
Clear this option if you want to specify these libraries yourself.<br/>
You can do this in the 'Additional libraries to link in' field.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('--no-default-libraries');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LKRescan">
                        <caption>Rescan libraries to solve unresolved externals</caption>
                        <tool_tip>Normally the linker stops the rescanning when all symbols are resolved, or when no more symbols can be resolved.<br/>
Clear this option to tell the linker to scan only once. This is useful if you are building your own libraries, because libraries are most efficiently organized if the linker needs only one pass to resolve all symbols.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('--no-rescan');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="LkLibrariesList">
                    <caption>Additional libraries to link in</caption>
                    <tool_tip>Here you can specify your own libraries or other system libraries.<br/>
For example, when you have cleared the option 'Link default C libraries'.<br/>
Specify only the basename of libraries (without .lib), separated by spaces.</tool_tip>
                    <generate_option if="LkIeee.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(LkLibrariesList.State,',',' ','-l"','"') );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LKMISRACReport">
                    <invisible/>
                    <generate_option if="NOT LkLib.Selected AND MISRACReport.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--misra-c-report');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LKLibDir">
                    <invisible/>
                    <generate_option if="NOT LkLib.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(DXP.LibDir,';',' ','-Wl-L"','"') );
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="LkStackHeap">
                <caption>Stack/Heap</caption>
                <tool_id id_ref="LK"/>
        <subgroup>
        <caption>Stack</caption>

                <text id="LkStackSize">
                    <caption>Stack size (in bytes)</caption>
                    <tool_tip>Specify the amount of memory the linker should reserve for the stack. You can use the letters 'k' for kilobytes or 'M' for megabytes. Note that this does not include the stacks of threads created through the POSIX kernel interface. Those will be allocated either as static data by the user or dynamically on the heap. In that case the linker stack is only used at system init and exit and 2 kilobytes should be fine for most applications.</tool_tip>
                    <default state="32k"/>
                    <generate_option if="LkStdLsl.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolDependency(projLslFileName,'LK');
                            DXP.WriteToFile(projLslFileName,'#define __STACK' + #9#9#9 + LkStackSize.State);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkStackAddr">
                    <caption>Stack address</caption>
                    <tool_tip>Specify the address where the stack is located.</tool_tip>
                    <generate_option if="LkStdLsl.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolDependency(projLslFileName,'LK');
                            DXP.WriteToFile(projLslFileName,'#define __STACKADDR' + #9 + LkStackAddr.State);
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_LkExpandStackSize">
                    <choice id="LkExpandStackSize">
                        <caption>Expand stack if space left</caption>
                        <tool_tip>Select this option to use the gap between the stack and the next section for the stack also. The linker uses the specified stack size as a minimum size.<br/>
Clear this option if you want to have a fixed stack size. For example, to minimize the use of memory on an FPGA.</tool_tip>
                        <generate_option if="LkStdLsl.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolDependency(projLslFileName,'LK');
                                DXP.WriteToFile(projLslFileName,'#define __STACK_FIXED');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
        </subgroup>
        <subgroup>
                <caption>Heap</caption>
                <text id="LkHeapSize">
                    <caption>Heap size (in bytes)</caption>
                    <tool_tip>The heap is used for dynamic memory allocation. Specify the amount of memory the linker should reserve for the heap. You can use the letters 'k' for kilobytes or 'M' for megabytes. If the application does not use dynamic allocation the linker will automatically exclude the heap. Note that dynamic stacks of threads created through the POSIX kernel interface will be allocated on the heap.</tool_tip>
                    <default state="32k"/>
                    <generate_option if="LkStdLsl.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolDependency( projLslFileName,'LK');
                            DXP.WriteToFile( projLslFileName,'#define __HEAP' + #9#9#9 + LkHeapSize.State );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkHeapAddr">
                    <caption>Heap address</caption>
                    <tool_tip>Specify the address where the heap is located.</tool_tip>
                    <generate_option if="LkStdLsl.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolDependency( projLslFileName,'LK');
                            DXP.WriteToFile( projLslFileName,'#define __HEAPADDR' + #9 + LkHeapAddr.State );
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_LkExpandHeapSize">
                    <default state=""/>
                    <choice id="LkExpandHeapSize">
                        <caption>Expand heap if space left</caption>
                        <tool_tip>Select this option to use the gap between the heap and the next section for the heap also. The linker uses the specified heap size as a minimum size.<br/>
Clear this option if you want to have a fixed heap size. For example, to minimize the use of memory on an FPGA.</tool_tip>
                        <generate_option if="LkStdLsl.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolDependency( projLslFileName,'LK');
                                DXP.WriteToFile( projLslFileName,'#define __HEAP_FIXED');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
        </subgroup>

            </group>
            <group id="LkOptimization">
                <caption>Optimization</caption>
                <tool_id id_ref="LK"/>
                <choices id="LkOptim">
                    <single/>
                    <caption>Optimization level</caption>
                    <tool_tip>Select a predefined set of optimizations or select 'Custom optimization' to enable individual optimizations.<br/>
Select 'Full optimization' for the final application.</tool_tip>
                    <default state="LkOL1"/>
                    <generate_option if="NOT LkLib.Selected"/>
                    <choice id="LkOL0">
                        <caption>No optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl-O0');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkOL1">
                        <caption>Default optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl-O1');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkOL2">
                        <caption>Full optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl-O2');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkOLAdv">
                        <caption>Custom optimization</caption>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Custom optimization</caption>
                    <choices id="Choices_LkOc">
                        <default state="LkOc,LkOt"/>
                        <choice id="LkOc">
                            <caption>Delete un-referenced sections</caption>
                            <tool_tip>Removes sections that are never used from the output file.<br/>
This option is only useful when you compile without debug information, because debug information generally uses all sections.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOc.Flag := 'c';
                                </selected>
                                <not_selected>
                                    LkOc.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkOl">
                            <caption>Use first fit decreasing algorithm</caption>
                            <tool_tip>Puts small sections into gaps that were formed during the locate process.<br/>
This optimization only applies to unrestricted sections.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOl.Flag := 'l';
                                </selected>
                                <not_selected>
                                    LkOl.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                       <choice id="LkOt">
                            <caption>Copy table compression</caption>
                            <tool_tip>Compresses the size of the copy table when possible.<br/>
Smart restrictions are emitted to obtain large contiguous blocks of sections that can be copied/cleared in one copy table action instead of multiple little copy/clear actions.<br/>
This optimization reduces both memory usage and startup speed.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOt.Flag := 't';
                                </selected>
                                <not_selected>
                                    LkOt.Flag := 'T';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkOx">
                            <caption>Delete duplicate code</caption>
                            <tool_tip>Removes duplicate code from the output file.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOx.Flag := 'x';
                                </selected>
                                <not_selected>
                                    LkOx.Flag := 'X';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkOy">
                            <caption>Delete duplicate constant data</caption>
                            <tool_tip>Removes duplicate constant data from the output file.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOy.Flag := 'y';
                                </selected>
                                <not_selected>
                                    LkOy.Flag := 'Y';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <text id="LkOLAdv_Script">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="LkOLAdv.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl-O' + LkOc.Flag + LkOl.Flag + LkOt.Flag + LkOx.Flag + LkOy.Flag
);
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="LkMapFile">
                <caption>Map File</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LkMap">
                    <default state="LkMap"/>
                    <choice id="LkMap">
                        <caption>Generate a memory map file (.map)</caption>
                        <tool_tip>A map file shows how the linker has mapped the sections and symbols from the various object files to output sections.<br/>
Select this option to generate a map file with the same name as the project file but with extension .map.<br/>
Additionally, specify below which information you want in the map file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddGeneratedFile( DXP.OutDir + DXP.ProjectName + '.map'#13#10);
                                DXP.AddToolCmdOption('-Wl-M');
                            </selected>
                            <not_selected>
                                DXP.AddToolCmdOption('--no-map-file');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Map file format</caption>
                    <choices id="Choices_LkMapFileCallgraph">
                        <default state="LkMapFileCallgraph,LkMapFileProcessed,LkMapFileLink,LkMapFileLocate,LkMapFileMemory,LkMapFileOverlay,LkMapFileCrossRef,LkMapFileRules"/>
                        <choice id="LkMapFileCallgraph">
                            <caption>Call graph information</caption>
                            <tool_tip>Shows a schematic overview how functions call each other.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileCallgraph.Flag := 'c';
                                </selected>
                                <not_selected>
                                    LkMapFileCallgraph.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileRemoved">
                            <caption>Removed sections information</caption>
                            <tool_tip>Shows the sections which were removed from the absolute object file. For example, unreferenced sections.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileRemoved.Flag := 'd';
                                </selected>
                                <not_selected>
                                    LkMapFileRemoved.Flag := 'D';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileProcessed">
                            <caption>Processed files information</caption>
                            <tool_tip>Shows all files processed by the linker. This also includes object files extracted from libraries, and the symbol that led to the extraction.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileProcessed.Flag := 'f';
                                </selected>
                                <not_selected>
                                    LkMapFileProcessed.Flag := 'F';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileInvocation">
                            <caption>Invocation and tool information</caption>
                            <tool_tip>Shows information about the linker, its version header information, binary location and which options were used to call it.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileInvocation.Flag := 'i';
                                </selected>
                                <not_selected>
                                    LkMapFileInvocation.Flag := 'I';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileLink">
                            <caption>Link result information</caption>
                            <tool_tip>Shows per object file how the linker has mapped the sections from the various objects files to output sections.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileLink.Flag := 'k';
                                </selected>
                                <not_selected>
                                    LkMapFileLink.Flag := 'K';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileLocate">
                            <caption>Locate result information</caption>
                            <tool_tip>Shows the absolute position of each section in the output file and shows a list of all external symbols.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileLocate.Flag := 'l';
                                </selected>
                                <not_selected>
                                    LkMapFileLocate.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileMemory">
                            <caption>Memory usage information</caption>
                            <tool_tip>Shows the memory usage in totals and percentages for spaces and chips.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileMemory.Flag := 'm';
                                </selected>
                                <not_selected>
                                    LkMapFileMemory.Flag := 'M';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileNonAlloc">
                            <caption>Non alloc information</caption>
                            <tool_tip>Shows information about debug sections in non alloc space.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileNonAlloc.Flag := 'n';
                                </selected>
                                <not_selected>
                                    LkMapFileNonAlloc.Flag := 'N';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileOverlay">
                            <caption>Overlay information</caption>
                            <tool_tip>Shows the locate overlay information if you used overlay groups in the linker script file.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileOverlay.Flag := 'o';
                                </selected>
                                <not_selected>
                                    LkMapFileOverlay.Flag := 'O';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileStatics">
                            <caption>Module local symbols</caption>
                            <tool_tip>Shows for each local scope the name, address and space where the local symbol resides.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileStatics.Flag := 'q';
                                </selected>
                                <not_selected>
                                    LkMapFileStatics.Flag := 'Q';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileCrossRef">
                            <caption>Cross reference information</caption>
                            <tool_tip>Shows a list of all symbols and for each symbol the object files in which the symbol is referenced.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileCrossRef.Flag := 'r';
                                </selected>
                                <not_selected>
                                    LkMapFileCrossRef.Flag := 'R';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileLsl">
                            <caption>Processor and memory information</caption>
                            <tool_tip>Shows the name of the processor and core and shows names, sizes and mappings of spaces, buses and memory.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileLsl.Flag := 's';
                                </selected>
                                <not_selected>
                                    LkMapFileLsl.Flag := 'S';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileRules">
                            <caption>Locate rules</caption>
                            <tool_tip>Shows the rules the linker uses to locate sections. For example, this part lists which sections are absolute, contiguous or unrestricted.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileRules.Flag := 'u';
                                </selected>
                                <not_selected>
                                    LkMapFileRules.Flag := 'U';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <text id="LkMapFileCustom_Script">
                    <invisible/>
                    <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl-m' + LkMapFileCallgraph.Flag + LkMapFileProcessed.Flag + LkMapFileLink.Flag + LkMapFileLocate.Flag + LkMapFileMemory.Flag + LkMapFileOverlay.Flag + LkMapFileStatics.Flag + LkMapFileCrossRef.Flag + LkMapFileLsl.Flag + LkMapFileRules.Flag
+ LkMapFileRemoved.Flag
+ LkMapFileInvocation.Flag
+ LkMapFileNonAlloc.Flag
);
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="LkDiagnostics">
                <caption>Diagnostics</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LKWarn">
                    <caption>Error reporting</caption>
                    <generate_option if="NOT LkLib.Selected"/>
                    <tool_tip>During the link process warnings can occur. By default, all warnings are reported.<br/>
Select one of the suppress options to hide the warning messages that are of no importance to you.</tool_tip>
                    <single/>
                    <default state="LKSpecWarn"/>
                    <choice id="LKWarn">
                        <caption>Report all warnings</caption>
                    </choice>
                    <choice id="LKNoWarn">
                        <caption>Suppress all warnings</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl--no-warnings');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LKSpecWarn">
                        <caption>Suppress specific warnings</caption>
                    </choice>
                </choices>
                <text id="LKWarnList">
                    <default state="159"/>
                    <multi/>
                    <caption>    Specific warnings to suppress</caption>
                    <tool_tip>Specify one or more warnings to suppress, separated by commas.<br/>
For example: 126,135,144</tool_tip>
                    <generate_option if="LKSpecWarn.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(LKWarnList.State ,',',' ','-Wl-w') );
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_LKWarningsAsErrors">
                    <default state=""/>
                    <choice id="LKWarningsAsErrors">
                        <caption>Treat warnings as errors</caption>
                        <tool_tip>When warnings occur the link process continues.<br/>
When errors occur the link process stops.<br/>
Select this option to stop the link process also when only warnings occur.</tool_tip>
                        <generate_option if="NOT LKNoWarn.Selected AND NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl--warnings-as-errors');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="LkMiscellaneous">
                <caption>Miscellaneous</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LkNonRomable">
                    <!-- Set by Altium Designer Locate option frame -->
                    <invisible/>
                    <default state=""/>
                    <choice id="LkNonRomable">
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--non-romable');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkNonRomableUser"/>
                </choices>
                <choices id="Choices_LkIncludeDebug">
                    <default state="LkIncludeDebug,LkCase"/>
                    <choice id="LkIncludeDebug">
                        <caption>Include symbolic debug information</caption>
                        <tool_tip>Normally the linker passes debug information enabled by the compiler or assembler to the output file.<br/>
Clear this option to strip debug information from the output file. This can be useful to reduce the size of the output file or to allow more optimizations.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('--strip-debug');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkCase">
                        <caption>Link case sensitive (required for C language)</caption>
                        <tool_tip>All identifiers will appear in the object file exactly as they appear in the source file.<br/>
Clear this option to convert all identifiers to upper case. For example, if you write your own assembly file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('-Wl--case-insensitive');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkDumpLsl">
                        <caption>Dump processor and memory info from LSL file</caption>
                        <tool_tip>Select this option to dump the processor and memory information in a separate file with extension .ldf.<br/>
The same information is available in the map file when you select 'Processor and memory information' on the 'Map File' page.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--lsl-dump');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkUserLsl">
                        <caption>Use project specific LSL file</caption>
                        <tool_tip>Normally Altium Designer generates LSL files depending on your project settings.<br/>
Select this option to specify your own LSL file. Enter the name of your LSL file in the field below.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                    </choice>
                </choices>
                <text id="LkUserLslField">
                    <caption>    LSL file</caption>
                    <tool_tip>Enter the name of your LSL file to use with this project.</tool_tip>
                    <generate_option if="LkUserLsl.Selected"/>
                    <button on_click="DXP.FileOpenDialog(LkUserLslField)"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-d"' + LkUserLslField.State + '"');
                        </selected>
                    </makefile_generator>
                </text>
                <table_edit id="LkDefine">
                    <caption>User macro</caption>
                    <tool_tip>You can use a macro as a symbol in your LSL file, for example to create conditional parts.<br/>
With this option you can assign values to macros you use in your LSL file.<br/>
In the drop-down table, specify a macro name and a value. If you omit the value, the macro expands to 1.</tool_tip>
                    <generate_option if="NOT LkLib.Selected"/>
                    <column caption="Macro">
                        <text id="LkMacro">
                            <caption>Macro</caption>
                        </text>
                    </column>
                    <column caption="Value">
                        <text id="LkValue">
                            <caption>Value</caption>
                        </text>
                    </column>
                    <text id="LkDefine_Loop">
                        <invisible/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl-D' + LkMacro.State + '="' + LkValue.State + '"');
                            </selected>
                        </makefile_generator>
                    </text>
                </table_edit>
                <text id="LkDataObjectsList">
                    <caption>Import the following data object files</caption>
                    <tool_tip>Here you can add binary files containing raw data. Specify one or more file names, separated by a semicolon (;).<br/>
For example: world.bmp;"sound track 1.mp3"</tool_tip>
                    <generate_option if="LkIeee.Selected"/>
                    <button on_click="DXP.FileListDialog(LkDataObjectsList);"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(LkDataObjectsList.State,';',' ','-Wl--import-object="','"') );
			    DXP.AddToolDependency(DXP.SplitJoin(LkDataObjectsList.State,';',' ','"','"'),'LK');
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_LkPreventNullPtr">
                    <default state=""/>
                    <choice id="LkPreventNullPtr">
                        <caption>Reserve first byte of linear to prevent pointers to address 0</caption>
                        <tool_tip>Select this option to add a reserved section with the name 'no_null_ptr' to the LSL file.</tool_tip>
                        <generate_option if="LkStdLsl.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolDependency(projLslFileName,'LK');
                                DXP.WriteToFile(projLslFileName,'section_layout system:sw:linear {'#13#10 +
                                '    group (run_addr = 0x0, ordered, contiguous) reserved "no_null_ptr" (size=1);'#13#10 +
                                '}');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <cmdoptions id="CmdOptLK" tool_id_ref="LK"/>
                <text id="LkAdditional">
                    <multi/>
                    <caption>Additional linker options</caption>
                    <tool_tip>Some linker options are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                    <generate_option if="NOT LkLib.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(LkAdditional.State);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkStdLsl">
                    <invisible/>
                    <generate_option if="NOT LkLib.Selected AND NOT LkUserLsl.Selected"/>
                    <default state="SELECTED"/>
                </text>

                <text id="LkStdLslMemoryDefine">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="NOT LkLib.Selected AND NOT LkUserLsl.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolDependency(projLslFileName,'LK');
                            DXP.WriteToFile(projLslFileName,'#define __MEMORY');
                        </selected>
                    </makefile_generator>
                </text>

                <text id="LkLslSwArch">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolDependency(projLslFileName,'LK');
                            DXP.WriteToFile(projLslFileName,'#define __SW_ARCH' + #9#9 + 'PPC');
                            DXP.WriteToFile(projLslFileName,'#define __SW_LSL' + #9#9 + '"ppc.lsl"');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkLslHwArch">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="AnsiSameText(ASP_Enable.State,'True')"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolDependency(projLslFileName,'LK');
                            DXP.WriteToFile(projLslFileName,'#define __HW_ARCH' + #9#9 + 'TSKHC');
                            DXP.WriteToFile(projLslFileName,'#define __HW_LSL' + #9#9 + '"chc.lsl"');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkProfiling"> 
                    <invisible/>
                    <generate_option if="CompProfiling.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--profile=' + CompProfB.Flag + CompProfC.Flag + CompProfF.Flag + CompProfT.Flag);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkMapFileXML"> 
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddGeneratedFile( DXP.OutDir + DXP.ProjectName + '.mapxml'#13#10);
                            DXP.AddToolCmdOption('-Wl--map-file="' + DXP.OutDir + DXP.ProjectName + '.mapxml":XML');
                        </selected>
                    </makefile_generator>
                </text>
            </group>
        </group>
    </options>
    <global_tool_tips>
        <global_tool_tip id="TT_AsmList">To change this option, first select 'Generate list file'.</global_tool_tip>
    </global_tool_tips>
    <tool_definitions>
        <options>
            <macro name="OPT_CPU" value="OPT_CPU"/>
            <macro name="OPT_ARCH" value="OPT_ARCH"/>
            <macro name="OPT_CPP" value="DXP.GetToolCmdOption('CPP')"/>
            <macro name="OPT_CC" value="DXP.GetToolCmdOption('CC')"/>
            <macro name="OPT_AS" value="DXP.GetToolCmdOption('AS')"/>
            <macro name="OPT_LK" value="DXP.GetToolCmdOption('LK')"/>
            <macro name="OPT_MQ" value="'--lsl-include-directory='#34'$(PRODDIR)\cppc\include.lsl'#34"/>
        </options>
        <tool>
            <tool_id id="CPP"/>
            <suffix_src value=".cpp"/>
            <suffix_dest value=".src"/>
            <depend_method value="4"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_CC) $(OPT_CPP) %file"/>
            <action>
                <![CDATA[
ifdef CPPPREPROCESS
    @echo Preprocessing ${*F}.cpp
    %exe(ccppc.exe) -E$(PREPROCESSFLAGS) -o "$*.pre" -f %optfile
endif
    @echo C++ Compiling ${*F}.cpp
    %exe(ccppc.exe) -cs -o "$@" --dep-file="$*.d" --make-target="$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="CC"/>
            <suffix_src value=".c"/>
            <suffix_dest value=".src"/>
            <depend_method value="4"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_CC) %file"/>
            <action>
                <![CDATA[
ifdef PREPROCESS
    @echo Preprocessing ${*F}.c
    %exe(ccppc.exe) -E$(PREPROCESSFLAGS) -o "$*.pre" -f %optfile
endif
    @echo Compiling ${*F}.c
    %exe(ccppc.exe) -cs -o "$@" --dep-file="$*.d" --make-target="$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="AS"/>
            <suffix_src value=".src"/>
            <suffix_dest value=".obj"/>
            <depend_method value="2"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_AS) %file"/>
            <action>
                <![CDATA[
    @echo Assembling ${*F}.src
    %exe(ccppc.exe) -c -o "$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="AS"/>
            <suffix_src value=".asm"/>
            <suffix_dest value=".obj"/>
            <depend_method value="2"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_AS) %file"/>
            <action>
                <![CDATA[
    @echo Assembling ${*F}.asm
    %exe(ccppc.exe) -c -o "$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="AR"/>
            <suffix_src value=".obj"/>
            <suffix_dest value=".lib"/>
            <action>
                <![CDATA[
    @echo Creating library ${@F}
    %exe(..\..\bin\tlb.exe) -crv "$@" %file
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="LK"/>
            <suffix_src value=".obj"/>
            <suffix_dest value=".o"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_LK) %file $(EXT_LIBRARIES)"/>
            <action>
                <![CDATA[
    @echo Linking and Locating ${@F}
    %exe(ccppc.exe) -o "$@" --incremental -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="LK"/>
            <suffix_src value=".obj"/>
            <suffix_dest value=".abs"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_LK) %file $(EXT_LIBRARIES)"/>
            <action>
                <![CDATA[
    @echo Linking and Locating ${@F}
    %exe(ccppc.exe) -o "$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="LK"/>
            <suffix_src value=".abs"/>
            <suffix_dest value=".hex"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_LK) %file $(EXT_LIBRARIES)"/>
            <action>
                <![CDATA[ 
    @echo Linking and Locating ${@F}
    %exe(ccppc.exe) -o "$@":IHEX -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="MQ"/>
            <suffix_src value=".lsl"/>
            <suffix_dest value=".chc_h"/>
            <opt_action value="$(OPT_MQ)"/>
            <action>
                <![CDATA[
    @echo Redefining memory qualifiers 
    %exe(..\..\chc\bin\chc.exe) --lsl-file=%file --redefine-qualifiers="$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="TOC"/>
            <suffix_src value=".oil"/>
            <suffix_dest value=".lib"/>
            <action>
                <![CDATA[ 
"$(PROJ).rtos\osek.lib" : %file

OILFILE=%file
include "$(PRODDIR)\cppc\osek\osek.mk"
EXT_LIBRARIES += "$(PROJ).rtos\osek.lib"
                ]]>
            </action>
        </tool>
        <tool>
           <tool_id id="APPSTACK"/>
            <suffix_src value=".swplatform"/>
            <suffix_dest value=".lib"/>
            <action>
                <![CDATA[
"$(OUTDIR)\frameout\__framework.lib" : %file

TARGET=ppc
include "$(PRODDIR)\etc\swplatform.mak"
EXT_LIBRARIES += "$(OUTDIR)\frameout\__framework.lib"
                ]]>
            </action>
        </tool>
    </tool_definitions>
</tool_chain>
