/**************************************************************************
**                                                                        *
**  FILE        :  wscanf.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for wscanf() routine.                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int wscanf( const wchar_t* restrict format, ... )
{
        va_list         ap;
        int             items;
        struct _io      io;

        va_start( ap, format );
        io.fp = stdin;
        items = _dowscan( &io, format, ap );
        va_end( ap );
        return (ferror( stdin ) ? EOF : items);
}

#endif
