/**************************************************************************
**                                                                        *
**  FILE        :  vfwscanf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for vfwscanf() routine.                    *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int vfwscanf( FILE * restrict fp, const wchar_t * restrict format, va_list arg )
{
        int     items;
        
        items = _dowscan( (struct _io *)&fp, format, arg );
        return (ferror(fp) ? EOF : items);
}

#endif
