/**************************************************************************
**                                                                        *
**  FILE        :  sprintf.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for sprintf() routine.                     *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <limits.h>
#include <io.h>

int sprintf( char * restrict s, const char * restrict format, ... )
{
        va_list         ap;
        int             chars;
        struct _io      buf;

        va_start( ap, format );
        buf.fp = NULL;
        buf.ptr = s;
        buf.end = (char *)0 - 1;
        chars = _doprint( & buf, format, ap );
        va_end( ap );
        *buf.ptr = 0;
        return chars;
}
