/**************************************************************************
**                                                                        *
**  FILE        :  printf.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for printf() routine.                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <io.h>

int printf( const char * restrict format, ... )
{
        va_list         ap;
        int             chars;
        struct _io      io;

        io.fp = stdout;
        va_start( ap, format );
        chars = _doprint( &io, format, ap );
        va_end( ap );
        return (ferror(stdout) ? EOF : chars);
}
