/**************************************************************************
**                                                                        *
**  FILE        :  isinf.c                                                *
**                                                                        *
**  DESCRIPTION :  The isinf() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

/*****************************************************************************
|*
|* FUNCTION     : isinf
|*
|* PARAMETERS   :
|*
|*      double type variable to test
|*
|* RETURN VALUE :
|*
|*      zero if the variable is not +-infinity, else non-zero
|*
|* DESCRIPTION  :
|*
|*     IEEE-754-1985 Recommended function.
|*     Test the given variable on being an infinite (IEEE-754) value.
|*
*/
#ifndef __SINGLE_FP__
#pragma alias   _isinf          = _isinf_dpf
#pragma alias   _isinfl         = _isinf_dpf
static
int     _isinf_dpf( double d )
{
#if _IEEE_754_FORMAT
        double2longs_t  u;
        unsigned long   hi;
        unsigned long   lo;

        /* double type acts as double */
        u.d     = d;
        hi      = u.s.hi;
        lo      = u.s.lo;

        return GET_DOUBLE_EXPONENT( hi ) == DOUBLE_BIASED_INF_EXP &&
                GET_DOUBLE_HI_MANTISSA( hi ) == 0 && GET_DOUBLE_LO_MANTISSA( lo ) == 0;
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
}
#endif
