/**************************************************************************
**                                                                        *
**  FILE        :  hypot.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for hypot() routine                        *
**                 Computes the 'hypotenuse' for the given values         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifdef __SINGLE_FP__
#pragma alias   hypotl  = _hypot_spf
#pragma alias   hypot           = _hypot_spf
#endif
#pragma alias   hypotf  = _hypot_spf


/*
 * hypot(x,y)
 *
 * See NR p.176 for explanation.
 * See NR p.949 for original source.
 */ 
static
float
_hypot_spf( float x, float y )
{
        float ans,temp;
        x = fabsf(x);
        y = fabsf(y);
        if (x == 0.0f)
        {
                ans = y;
        }
        else if (y == 0.0f)
        {
                ans = x;
        }
        else if (x > y)
        {
                temp = y/x;
                ans = x*sqrtf(1.0f+temp*temp);
        }
        else
        {
                temp = x/y;
                ans = y*sqrtf(1.0f+temp*temp);
        }
        return ans;
}


