/**************************************************************************
**                                                                        *
**  FILE        :  dbg.c                                                  *
**                                                                        *
**  DESCRIPTION :  debugger calls for host filesystem access.             *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <dbg.h>

#include <unistd.h>

__no_sdata _dbg_request_t       _dbg_request;

#pragma extern  errno
#pragma alias   errno           = _dbg_request
extern  __no_sdata int errno;

#pragma weak _open
#pragma alias _open = _host_open
extern _err_t _host_open(const char *pathname, _open_flags_t flags)
{
        _dbg_request.nr = _DBG_OPEN;
        _dbg_request.u.open.pathname = pathname;
        _dbg_request.u.open.flags = flags;
        _dbg_trap();
        return _dbg_request.u.open_result;
}

#pragma weak _read
#pragma alias _read = _host_read
extern int _host_read(_fd_t fd, void *buffer, size_t nbytes)
{
        _dbg_request.nr = _DBG_READ;
        _dbg_request.u.read.fd = fd;
        _dbg_request.u.read.buffer = buffer;
        _dbg_request.u.read.nbytes = nbytes;
        _dbg_trap();
        return _dbg_request.u.read_result;
}

#pragma weak _write
#pragma alias _write = _host_write
extern int _host_write(_fd_t fd, const void *buffer, size_t nbytes)
{
        _dbg_request.nr = _DBG_WRITE;
        _dbg_request.u.write.fd = fd;
        _dbg_request.u.write.buffer = buffer;
        _dbg_request.u.write.nbytes = nbytes;
        _dbg_trap();
        return _dbg_request.u.write_result;
}

#pragma weak _lseek
#pragma alias _lseek = _host_lseek
extern long _host_lseek(_fd_t fd, long offset, _whence_t whence)
{
        _dbg_request.nr = _DBG_LSEEK;
        _dbg_request.u.lseek.fd = fd;
        _dbg_request.u.lseek.whence = whence;
        _dbg_request.u.lseek.offset = offset;
        _dbg_trap();
        return _dbg_request.u.lseek_result;
}

#pragma weak _close
#pragma alias _close = _host_close
extern _err_t _host_close(_fd_t fd)
{
        _dbg_request.nr = _DBG_CLOSE;
        _dbg_request.u.close.fd = fd;
        _dbg_trap();
        return _dbg_request.u.close_result;
}

extern int _argcv( const char *buf, size_t size )
{
        _dbg_request.nr = _DBG_ARGCV;
        _dbg_request.u.argcv.buf = buf;
        _dbg_request.u.argcv.size = size;
        _dbg_trap();
        return _dbg_request.u.argcv_result;
        
}
