        
        .section .text.cstart

        .extern _lc_ub_stack
        .extern _lc_ub_table
        .extern _SDA_BASE_
        .extern _SDA2_BASE_
        .extern _EXCEPTION_BASE_
        .extern .text.intvec_0
        .weak   .text.intvec_0
        .extern .text.intvec_1
        .weak   .text.intvec_1
        .extern .text.intvec_2
        .weak   .text.intvec_2
        .extern .text.intvec_3
        .weak   .text.intvec_3
        .extern .text.intvec_4
        .weak   .text.intvec_4
        .extern .text.intvec_5
        .weak   .text.intvec_5
        .extern .text.intvec_6
        .weak   .text.intvec_6
        .extern .text.intvec_7
        .weak   .text.intvec_7
        .extern .text.intvec_8
        .weak   .text.intvec_8
        .extern .text.intvec_9
        .weak   .text.intvec_9
        .extern .text.intvec_10
        .weak   .text.intvec_10
        .extern .text.intvec_11
        .weak   .text.intvec_11
        .extern .text.intvec_12
        .weak   .text.intvec_12
        .extern .text.intvec_13
        .weak   .text.intvec_13
        .extern .text.intvec_14
        .weak   .text.intvec_14
        .extern .text.intvec_15
        .weak   .text.intvec_15
    .if @defined('__POSIX__')
        .extern posix_main
    .else
        .extern main
    .endif
        .extern _Exit
        .extern exit
        .weak   exit
    .if @defined('__PROF_ENABLE__')
        .extern __prof_init
    .endif
        
        .global _START
        .global _START440
        
_START: 
_START440:      
        iccci   %r0,%r0
        dccci   %r0,%r0
        msync

        ;; initialize CCR0 and CCR1 registers
        ;; configure instruction and data cache regions
        ;; setup TLB entry
        
        ;; initialize the IVPR and the IVOR registers
        lis     %r3,@hi(_EXCEPTION_BASE_)       ; symbol defined in LSL file
        mtivpr  %r3
        li              %r0,0
        ori             %r3,%r0,@lo(.text.intvec_0)
        mtivor0         %r3
        ori             %r3,%r0,@lo(.text.intvec_1)
        mtivor1         %r3
        ori             %r3,%r0,@lo(.text.intvec_2)
        mtivor2         %r3
        ori             %r3,%r0,@lo(.text.intvec_3)
        mtivor3         %r3
        ori             %r3,%r0,@lo(.text.intvec_4)
        mtivor4         %r3
        ori             %r3,%r0,@lo(.text.intvec_5)
        mtivor5         %r3
        ori             %r3,%r0,@lo(.text.intvec_6)
        mtivor6         %r3
        ori             %r3,%r0,@lo(.text.intvec_7)
        mtivor7         %r3
        ori             %r3,%r0,@lo(.text.intvec_8)
        mtivor8         %r3
        ori             %r3,%r0,@lo(.text.intvec_9)
        mtivor9         %r3
        ori             %r3,%r0,@lo(.text.intvec_10)
        mtivor10        %r3
        ori             %r3,%r0,@lo(.text.intvec_11)
        mtivor11        %r3
        ori             %r3,%r0,@lo(.text.intvec_12)
        mtivor12        %r3
        ori             %r3,%r0,@lo(.text.intvec_13)
        mtivor13        %r3
        ori             %r3,%r0,@lo(.text.intvec_14)
        mtivor14        %r3
        ori             %r3,%r0,@lo(.text.intvec_15)
        mtivor15        %r3

        ;; configure debug facilities (DBSR,DBCR,DAC,IAC,DVC)
        ;; configure timer facilities (DEC,DECAR,TSR,TCR,TBH,TBL)
        ;; initialize the MSR to enable interrupts (zero at reset)

        ;; initialize the stack pointer
        lis     %r3,@ha(_lc_ub_stack)
        la      %r4,@lo(_lc_ub_stack)(%r3)
        addi    %r1,%r4,-8              ; create room for first stack frame
        li      %r0,0
        stw     %r0,0(%r1)              ; TOS is identified with zero

        ;; setup .sdata section
        lis     %r3,@ha(_SDA_BASE_)     ; symbol defined in LSL file
        la      %r13,@lo(_SDA_BASE_)(%r3)
        
        ;; setup .sdata2 section
        lis     %r3,@ha(_SDA2_BASE_)    ; symbol defined in LSL file
        la      %r2,@lo(_SDA2_BASE_)(%r3)
        
        ;; copy initialized sections from ROM to RAM
        lis     %r3,@ha(_lc_ub_table-4)
        la      %r3,@lo(_lc_ub_table-4)(%r3)
        li      %r0,0
cploop:
        lwzu    %r4,4(%r3)      ; load type
        lwzu    %r5,4(%r3)      ; dst address
        lwzu    %r6,4(%r3)      ; src address
        lwzu    %r7,4(%r3)      ; size

        mtctr   %r7             ; setup loop counter
        
        cmpwi   %cr0,%r4,1
        beq     %cr0,copy
        cmpwi   %cr0,%r4,2
        beq     %cr0,clear
        b       done

copy:
        lbz     %r8,0(%r6)
        stb     %r8,0(%r5)
        addi    %r5,%r5,1
        addi    %r6,%r6,1
        bdnz+   copy

        b       cploop

clear:
        stb     %r0,0(%r5)
        addi    %r5,%r5,1
        bdnz+   clear
        
        b       cploop
        
done:

_cptable_handled:       ;; Symbol may be used by debugger

    .if @defined('__PROF_ENABLE__')
        bl      __prof_init
    .endif

    .if @defined('__POSIX__')
        ;; call posix_main 
        bl      posix_main
    .else
        ;; call main with argv[0]==NULL & argc==0
        li      %r3,0
        li      %r4,0
        bl      main
    .endif

        ;; call exit using the return value from main()
        ;; Note. Calling exit will also run all functions
        ;; that were supplied through atexit().
        b       exit
                
        .endsec


        ;; The _clock() function is used by CrossView to simulate a timer tick register.
        ;; This function must have 'extern' scope, to allow the simulator to set a breakpoint.

        .section        .text
        .align  4
        .global _clock

_clock: .type   func

clk_loop:
        mftbu   %r0
        mftbl   %r4
        mftbu   %r3
        cmpw    %cr0,%r0,%r3
        bne     %cr0,clk_loop
        
        blr
        .size   _clock,$-_clock
        ; End of function
        .endsec ; End of section


        .end
