/**************************************************************************
**                                                                        *
**  FILE        :  copysign.c                                             *
**                                                                        *
**  DESCRIPTION :  The copysign() function.                               *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

/*****************************************************************************
|*
|* FUNCTION:           copysign
|*
|* AVAILABILITY:       EXTERNAL
|*
|* PARAMETERS:
|*
|*     Copy the sign of the second argument into that of the first argument
|*
|* RETURN VALUE:
|*
|*     The first argument with the sign of the second argument
|*
|* DESCRIPTION:
|*
|*     IEEE-754-1985 Recommended function.
|*     Copy the sign of the second argument to the value of the first argument
|*     and return that as result.
|*
|*     No need for error handling since it can not occur in this function.
*/
#if _IEEE_754_FORMAT
#ifndef __SINGLE_FP__
#pragma alias   copysign        = _copysign_dpf
#pragma alias   copysignl       = _copysign_dpf
static
double  _copysign_dpf( double d, double sign )
{
        double2longs_t  u_d;
        double2longs_t  u_sign;

        /* this assumes that the double internally has the *same* endianess as the long */
        u_d.d           = d;
        u_sign.d        = sign;
        u_d.s.hi        = COPY_DOUBLE_SIGN( u_sign.s.hi, u_d.s.hi );

        return u_d.d;
}
#endif
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
