/**************************************************************************
**                                                                        *
**  FILE        :  _strnccmp.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for _strncasecmp() routine                 *
**                 Compares two strings case insensitive.                 *
**                 Returns : < 0  -- s1<s2                                *
**                           = 0  -- s1=s2                                *
**                           > 0  -- s1>s2                                *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <string.h>
#include <ctype.h>

int
_strncasecmp( const char * s1, const char * s2, size_t n )
{
        unsigned char c1, c2;

        while ( n )
        {
                n--;
                c2 = (unsigned char) toupper((unsigned char) *s2++);
                c1 = (unsigned char) toupper((unsigned char) *s1++);
                if ( c1 == '\0' || c1 != c2 )
                {
                        return( (int)c1 - (int)c2 );
                }
        }
        return 0;
}
