/**************************************************************************
**                                                                        *
**  FILE        :  _fpclassifyg.c                                         *
**                                                                        *
**  DESCRIPTION :  Floating point classification.                         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

extern  int     _issubnormall(long double x);
extern  int     _fpclassifyl(long double x)
{
        if (isinf(x))
                return FP_INFINITE;
        if (isnan(x))
                return FP_NAN;
        if (_issubnormall(x))
                return FP_SUBNORMAL;
        if (x == 0.0l)
            return FP_ZERO;
        return FP_NORMAL;
}
