/**************************************************************************
**                                                                        *
**  FILE        :  _fpclassifyg.c                                         *
**                                                                        *
**  DESCRIPTION :  Floating point classification.                         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

extern  int     _issubnormalf(float x);
extern  int     _fpclassifyf(float x)
{
        if (isinf(x))
                return FP_INFINITE;
        if (isnan(x))
                return FP_NAN;
        if (_issubnormalf(x))
                return FP_SUBNORMAL;
        if (x == 0.0f)
            return FP_ZERO;
        return FP_NORMAL;
}
