/**************************************************************************
**                                                                        *
**  FILE        :  _doprint_simple.c                                      *
**                                                                        *
**  DESCRIPTION :  Common code for _doprint_simple()/_dowprin_simple().   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <io.h>

int DOPRINT( struct _io *fp, const char_t *fmt, va_list ap )
{
        int     count = 0;
        char_t  ch;
        char_t* p;

        while ( (ch = *fmt++) )
        {
                if ( ch == '%' )
                {
                        ch = *fmt++;
                        switch ( ch )
                        {
                        case 's':
                                p = va_arg( ap, char_t * );
                                while ( (ch = *p++) )
                                {
                                        FPUTC( (uchar_t) ch, fp );
                                        count++;
                                }
                                continue;
                        case 'c':
#if WIDE
                                ch = (char_t) btowc( va_arg( ap, int ) );
#else
                                ch = (char_t) va_arg( ap, int );
#endif
                                break;
                        default:
                                break;
                        }
                }
                FPUTC( (uchar_t) ch, fp );
                count++;
        }
        return count;
}
