/**************************************************************************
**                                                                        *
**  FILE        :  stdarg.h                                               *
**                                                                        *
**  DESCRIPTION :  Include file with prototypes and macros for usage with *
**                 variable argument lists                                *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _STDARG_H
#define _STDARG_H       1

typedef struct __va_list__
{
        unsigned char gpr;            /* index into the array of 8 GPRs stored in the
                                         register save area gpr=0 corresponds to r3,
                                         gpr=1 to r4, etc. */
        unsigned char fpr;            /* index into the array of 8 FPRs stored in the
                                         register save area fpr=0 corresponds to f1,
                                         fpr=1 to f2, etc. */
        char *overflow_arg_area;      /* location on stack that holds the next
                                         overflow argument */
        char *reg_save_area;          /* where r3:r10 and f1:f8, if saved are stored */
} va_list;

#define va_start(_ap,_lastarg)  (_ap) = *__va_start()

#pragma nomisrac 96,19.10       /* type cannot be enclosed in parenthesis */
#ifdef __BIG_ENDIAN__
#define va_arg(_ap,_type)       ((sizeof(_type)<sizeof(int))? \
                                 (_type)(*(int *) __va_arg(&(_ap), __typeid__(_type) )): \
                                 (*(_type*) __va_arg(&(_ap), __typeid__(_type) )))
#else
#define va_arg(_ap,_type)       (*(_type*) __va_arg(&(_ap), __typeid__(_type) ))
#endif
#pragma nomisrac restore

#define va_end(_ap)             ((void)0)
#define va_copy(dest,src)       ((dest) = (src))

#endif  /* _STDARG_H */
