/**************************************************************************
**                                                                        *
**  FILE        :  setjmp.h                                               *
**                                                                        *
**  DESCRIPTION :  Include file with prototypes for non-local jump        *
**                 functions                                              *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _SETJMP_H
#define _SETJMP_H       1

/* Byte offsets in jmp_buf array. */
#define __JB_R14        0                       /* R14 - 4 MAUs */
#define __JB_R15        4                       /* R15 - 4 MAUs */
#define __JB_R16        8                       /* R16 - 4 MAUs */
#define __JB_R17        12                      /* R17 - 4 MAUs */
#define __JB_R18        16                      /* R18 - 4 MAUs */
#define __JB_R19        20                      /* R19 - 4 MAUs */
#define __JB_R20        24                      /* R20 - 4 MAUs */
#define __JB_R21        28                      /* R21 - 4 MAUs */
#define __JB_R22        32                      /* R22 - 4 MAUs */
#define __JB_R23        36                      /* R23 - 4 MAUs */
#define __JB_R24        40                      /* R24 - 4 MAUs */
#define __JB_R25        44                      /* R25 - 4 MAUs */
#define __JB_R26        48                      /* R26 - 4 MAUs */
#define __JB_R27        52                      /* R27 - 4 MAUs */
#define __JB_R28        56                      /* R28 - 4 MAUs */
#define __JB_R29        60                      /* R29 - 4 MAUs */
#define __JB_R30        64                      /* R30 - 4 MAUs */
#define __JB_R31        68                      /* R31 - 4 MAUs */
#define __JB_SP         72                      /* SP  - 4 MAUs */
#define __JB_PC         76                      /* PC (return address) - 4 MAUs */

#define __JMPBUF_SIZ (80/4)

typedef int jmp_buf[__JMPBUF_SIZ];

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
int setjmp      ( jmp_buf );
void longjmp    ( jmp_buf, int );
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* _SETJMP_H */
