////////////////////////////////////////////////////////////////////////////
//
//  File        :  ppc.lsl
//
//  Version     :  @(#)ppc.lsl  1.23    09/04/09
//
//  Description :  LSL file for the PowerPC 405D5 core
//
//  Copyright 2003 Altium BV
//
////////////////////////////////////////////////////////////////////////////

#ifndef __STACK
#  define __STACK               32k
#endif
#ifndef __HEAP
#  define __HEAP                32k
#endif
#ifndef __START
#  define __START               0x00000000
#endif
#ifndef __SDA0_START
#define __SDA0_START            (4G - 32k)      /* small data area around 0 */
#endif
#ifndef __EXCEPTION_BASE
#define __EXCEPTION_BASE        __START
#endif

#define BOUNDS_GROUP_NAME       grp_bounds
#define BOUNDS_GROUP_SELECT     "bounds"

#define SDA_GROUP_NAME          sda
#define SDA_GROUP_SELECT        "(.sdata|.sdata.*|.sbss|.sbss.*)"
#define SDA2_GROUP_NAME         sda2
#define SDA2_GROUP_SELECT       "(.sdata2*|.PPC.EMB.sdata2*|.sbss2*|.PPC.EMB.sbss2*)"
#define SDA0_GROUP_NAME         sda0
#define SDA0_GROUP_SELECT       "(.PPC.EMB.sdata0*|.PPC.EMB.sbss0*)"


architecture PPC
{
        endianness
        {
                big;
//              little;
        }

        space linear
        {
                id = 1;
                mau = 8;
                map (size=4G, dest=bus:local_bus);

                copytable
                (
                        align = 4,
                        copy_unit = 1
                );

                start_address
                (
                        run_addr = __START,
#ifdef __PPC440__
                        symbol = "_START440"
#else
                        symbol = "_START405"
#endif
                );

                stack "stack"
                (
#ifdef __STACK_FIXED
                        fixed,
#endif
                        align = 4,
                        min_size = __STACK,
                        grows = high_to_low
                );

                heap "heap"
                (
#ifdef __HEAP_FIXED
                        fixed,
#endif
                        align = 4,
                        min_size=__HEAP
                );

                section_layout
                {
                        // define labels for bounds begin and end as used in C library
#ifndef BOUNDS_GROUP_REDEFINED
                        group BOUNDS_GROUP_NAME (ordered, contiguous)
                        {
                                select BOUNDS_GROUP_SELECT;
                        }
#endif
                        "_lc_ub_bounds" := addressof(group:BOUNDS_GROUP_NAME);
                        "_lc_ue_bounds" := addressof(group:BOUNDS_GROUP_NAME) + sizeof(group:BOUNDS_GROUP_NAME);

                        // interrupt service routines (if present)
                        "_EXCEPTION_BASE_" = __EXCEPTION_BASE;
#ifdef __PPC440__
                        group (ordered, contiguous, align = 16, run_addr = __EXCEPTION_BASE)
                        {
                                select ".text.intvec_*";
                        }
#else
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x100)
                        {
                                select ".text.intvec_0";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x200)
                        {
                                select ".text.intvec_1";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x300)
                        {
                                select ".text.intvec_2";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x400)
                        {
                                select ".text.intvec_3";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x500)
                        {
                                select ".text.intvec_4";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x600)
                        {
                                select ".text.intvec_5";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x700)
                        {
                                select ".text.intvec_6";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x800)
                        {
                                select ".text.intvec_7";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0xc00)
                        {
                                select ".text.intvec_8";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0xf20)
                        {
                                select ".text.intvec_9";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x1000)
                        {
                                select ".text.intvec_10";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x1010)
                        {
                                select ".text.intvec_11";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x1020)
                        {
                                select ".text.intvec_12";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x1100)
                        {
                                select ".text.intvec_13";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x1200)
                        {
                                select ".text.intvec_14";
                        }
                        group (ordered, run_addr = __EXCEPTION_BASE + 0x2000)
                        {
                                select ".text.intvec_15";
                        }
#endif
                        // quasi address spaces (relative to address in base register)
                        // note: linker has a problem when such a space wraps around 4G!
#ifndef SDA_GROUP_REDEFINED
#ifdef SDA_BASE
                        group SDA_GROUP_NAME (ordered, contiguous, run_addr = SDA_BASE - 32k)
#else
                        group SDA_GROUP_NAME (ordered, contiguous)
#endif
                        {
                                select SDA_GROUP_SELECT;
                        }
#endif
                        "_SDA_BASE_" = sizeof(group:SDA_GROUP_NAME) > 0 ? addressof(group:SDA_GROUP_NAME) + 32k : 0;

#ifndef SDA2_GROUP_REDEFINED
#ifdef SDA2_BASE
                        group SDA2_GROUP_NAME (ordered, contiguous, run_addr = SDA2_BASE - 32k)
#else
                        group SDA2_GROUP_NAME (ordered, contiguous)
#endif
                        {
                                select SDA2_GROUP_SELECT;
                        }
#endif
                        "_SDA2_BASE_" = sizeof(group:SDA2_GROUP_NAME) > 0 ? addressof(group:SDA2_GROUP_NAME) + 32k : 0;

#ifndef SDA0_GROUP_REDEFINED
                        group SDA0_GROUP_NAME (ordered, contiguous, run_addr = __SDA0_START)
                        {
                                select SDA0_GROUP_SELECT;
                        }
#endif
#ifdef __HEAPADDR
                        group ( ordered, run_addr=__HEAPADDR )
                        {
                                select "heap";
                        }
#endif
#ifdef __STACKADDR
                        group ( ordered, run_addr=__STACKADDR )
                        {
                                select "stack";
                        }
#endif
                }
        }

        bus local_bus
        {
                mau = 8;
                width = 32;
        }
}

#ifndef __MEMORY

#ifndef __XROMSTART
#define __XROMSTART     0
#endif
#ifndef __XROMSIZE
#define __XROMSIZE      256k
#endif
#ifndef __XRAMSTART
#define __XRAMSTART     (__XROMSTART + __XROMSIZE)
#endif
#ifndef __XRAMSIZE
#define __XRAMSIZE      256k
#endif

memory xrom
{
    mau = 8;
    type = rom;
    size = __XROMSIZE;
    map ( size = __XROMSIZE, dest_offset = __XROMSTART, dest=bus:PPC:local_bus);
}
memory xram
{
    mau = 8;
    type = ram;
    size = __XRAMSIZE;
    map ( size = __XRAMSIZE, dest_offset = __XRAMSTART, dest=bus:PPC:local_bus);
}
#endif /* __MEMORY */

