






# tcc.spec  --	specification file for the control program
# @(#)tcc.spec	1.113

TARGET	= user_func( get_target )
CPFE	= cp$(TARGET)
CFE	= c$(TARGET)
ASM	= as$(TARGET)
LLNG	= lk$(TARGET)

# output extensions
CPFE_OUT = ic
PRE_OUT	 = pre
DEP_OUT	 = d
MIL_OUT	 = mil
CFE_OUT	 = src
ASM_OUT	 = obj
ASM_LST	 = lst

LLNG_OUT = abs
LK_OUT	 = out
HEX_OUT	 = hex
SREC_OUT = sre

# input file handling
# Note: The Perennial testsuite uses *.C as extension for cpp files
%file	*.cc *.cpp *.cxx *.C
{
	# When --force-c is used, all C++ input files are handled as C files by the control program
	%if option(FORCE_C)
	{
		C_FILES = $(C_FILES) $(MATCH)
	}
	%else
	{
		CPLUS_FILES = $(CPLUS_FILES) $(MATCH)
		HAVE_CPLUS = 1
		%if $(TARGET) == "mb"
		{
			C_FLAGS = --integer-enumeration $(C_FLAGS)
		}
	}
}

%file	*.c
{
	# When --force-c++ is used, all C input files are handled as C++ files by the control program
	%if option(FORCE_CPLUS)
	{
		CPLUS_FILES = $(CPLUS_FILES) $(MATCH)
		HAVE_CPLUS = 1
		%if $(TARGET) == "mb"
		{
			C_FLAGS = --integer-enumeration $(C_FLAGS)
		}
	}
	%else
	{
		C_FILES = $(C_FILES) $(MATCH)
	}
}

%file	*.mil
{
	MIL_FILES = $(MIL_FILES) $(MATCH)
}

%file	*.ic
{
	# All .ic files are always compiled using the C compiler
	C_FILES = $(C_FILES) $(MATCH)
	%if !option(FORCE_C)
	{
		HAVE_CPLUS = 1
	}
}

%file	*.asm *.src
{
	ASM_FILES = $(ASM_FILES) $(MATCH)
}

%file	*.obj *.o *.out *.eln *.elb
{
	OBJ_FILES = $(OBJ_FILES) $(MATCH)
}

%file	*.lib *.a
{
	LIB_FILES = $(LIB_FILES) $(MATCH)
}

%file	*.lsl
{
	LSL_FLAGS = $(LSL_FLAGS) -d$(MATCH)
}

# handle options
%if option(ISO_MODE) == "99"
{
	C_FLAGS = -c99 $(C_FLAGS)
}
%elif option(ISO_MODE) == "90"
{
	C_FLAGS = -c90 $(C_FLAGS)
}

%option	SINGLE_FP
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) -F
	C_FLAGS = $(C_FLAGS) -F
}

%option STATIC
{
	STATIC_FLAGS = --static
}

%option REENTRANT
{
	REENTRANT = 1
}

%if !option(NO_MAPFILE)
{
	LLNG_FLAGS = $(LLNG_FLAGS) -M
}

%switch	option(MODEL)
{
	%case small s
	{
		MODEL = s
	}
	%case aux a
	{
		MODEL = a
	}
	%case large l
	{
		MODEL = l
	}
	%case medium m
	{
		MODEL = m
	}
	%default
	{
		%if !option(MODEL) && $(TARGET) == "51"
		{
			MODEL=s
		}
	}
}

# Handle '--use-hardware' option
%switch	$(TARGET)
	{
	# Default mb compiler: --use-hardware=MDBFps
	%case mb
	{
		%if option(USEMULTIPLY)
		{
			HARDWARE_FLAGS = $(HARDWARE_FLAGS)"m"
			LIB_MUL	       = "m"
		}
		%if option(USEDIVIDE)
		{
			HARDWARE_FLAGS = $(HARDWARE_FLAGS)"d"
			LIB_DIV	       = "d"
		}
		%if option(USEBARRELSHIFT)
		{
			HARDWARE_FLAGS = $(HARDWARE_FLAGS)"b"
			LIB_BS	       = "b"
		}
		%if option(USEFPU)
		{
			HARDWARE_FLAGS = $(HARDWARE_FLAGS)"f"
			LIB_FPU	       = "f"
		}
		%if option(USEMSR)
		{
			HARDWARE_FLAGS = $(HARDWARE_FLAGS)"s"
		}
		%if option(USEPCMP)
		{
			HARDWARE_FLAGS = $(HARDWARE_FLAGS)"p"
		}
		%if $(HARDWARE_FLAGS)
		{
		#	CPLUS_FLAGS	= $(CPLUS_FLAGS) --use-hardware=$(HARDWARE_FLAGS)
			C_FLAGS		= $(C_FLAGS)	 --use-hardware=$(HARDWARE_FLAGS)
			ASM_FLAGS	= $(ASM_FLAGS)	 --use-hardware=$(HARDWARE_FLAGS)
		}
	}
	# Default 3000 compiler: --use-hardware=md
	# TODO: Only works well if option is used as: --use-hardware=md, --use-hardware=MD 
	#	or if the --use-hardware is left out completely.
	# Problem: option(USEMULTIPLY) evaluates to true if it is used (so the count counts)
	# it is not checked if it is enabled or not! Kdb will investigate...
	%case 3000
	{
		%if option(USEHARDWARE) 
		{
			%if option(USEMULTIPLY)
			{
				LIB_MUL = "m"
			}
			%else
			{
				HARDWARE_FLAGS = $(HARDWARE_FLAGS)"M"
				LIB_MUL = ""
			}
			%if option(USEDIVIDE)
			{
				LIB_DIV = "d"
			}
			%else
			{
				HARDWARE_FLAGS = $(HARDWARE_FLAGS)"D"
				LIB_DIV = ""
			}
		}
		%else
		{
			LIB_MUL	       = "m"
			LIB_DIV	       = "d"
		}
		%if $(HARDWARE_FLAGS)
		{
		#	CPLUS_FLAGS	= $(CPLUS_FLAGS) --use-hardware=$(HARDWARE_FLAGS)
			C_FLAGS		= $(C_FLAGS)	 --use-hardware=$(HARDWARE_FLAGS)
			ASM_FLAGS	= $(ASM_FLAGS)	 --use-hardware=$(HARDWARE_FLAGS)
		}
	}
}

%if $(REENTRANT)
{
	C_FLAGS = $(C_FLAGS) --reentrant
}

%if $(MODEL)
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) -M$(MODEL)
	C_FLAGS = $(C_FLAGS) -M$(MODEL)
}


%option CPU
{
	CPU=$(MATCH)
}


%if option (CPU)
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) -C$(CPU)
	C_FLAGS = $(C_FLAGS) -C$(CPU)
	ASM_FLAGS = $(ASM_FLAGS) -C$(CPU)

	%if $(TARGET) == "ppc"
	{
		LLNG_FLAGS = $(LLNG_FLAGS) -C$(CPU)
	}

	%if $(TARGET) == "165x"
	{
		%switch $(CPU)
		{
			%case tsk165a
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__TSK165A
			}
			%case tsk165b
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__TSK165B
			}
			%case tsk165c
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__TSK165C
			}
			%case tsk165d
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__TSK165D
			}
		}
	}

	%if $(TARGET) == "pb"
	{
		%switch $(CPU)
		{
			%case pb1
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__PB1
			}
			%case pb1c
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__PB1C
			}
			%case pb2
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__PB2
			}
		}
	}

}

%option CHECK
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) --check
	C_FLAGS = $(C_FLAGS) --check
	ASM_FLAGS = $(ASM_FLAGS) --check
}

%option ERROR_FILE
{
	C_FLAGS = $(C_FLAGS) --error-file
	ASM_FLAGS = $(ASM_FLAGS) --error-file
	LLNG_FLAGS = $(LLNG_FLAGS) --error-file
}

%option MACRO_DEFINE
{
	# Add macro definitions
	CPLUS_FLAGS = $(CPLUS_FLAGS) -D$(MATCH)
	C_FLAGS = $(C_FLAGS) -D$(MATCH)
	ASM_DEFINE_FLAGS = $(ASM_DEFINE_FLAGS) -D$(MATCH)
}

%option MACRO_UNDEF
{
	# Add macro un-definitions
	CPLUS_FLAGS = $(CPLUS_FLAGS) -U$(MATCH)
	C_FLAGS = $(C_FLAGS) -U$(MATCH)
}

%option INCLUDE_DIR
{
	# Add include directories
	CPLUS_FLAGS = $(CPLUS_FLAGS) -I$(MATCH)
	C_FLAGS = $(C_FLAGS) -I$(MATCH)
	ASM_FLAGS = $(ASM_FLAGS) -I$(MATCH)
}

%option IO_STREAMS
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) --io-streams
}

%option NO_DEFLIB_PATH
{
	LIB_FLAGS = -L
}

%option LIBRARY_DIR
{
	# Add library directories
	LIB_FLAGS = $(LIB_FLAGS) -L$(MATCH)
}

%option LIBRARY_FILE
{
	# Add libraries
	LIB_FLAGS = $(LIB_FLAGS) -l$(MATCH)
}

# We have suboptions PROFBLOCK, PROFCALL, PROFFUNC, PROFTIME and BR_STAT.
# PROFEDGE is not yet available.
# We have libraries for block/function, callgraph, callgraph/timing and timing,
# so do something smart with correct combinations, and nothing with the rest.
P_LIB_TYPE	=
%switch	$(TARGET)
{
	%case	"mb" "3000" "ppc"
	{
		%option PROFILE
		{
		        PROFILING_FLAGS = $(PROFILING_FLAGS)$(MATCH)

			%if !option(PROFCALL) && !option(PROFTIME) && ( option(PROFBLOCK) || option(PROFFUNC) )
			{
				# function or block
				P_LIB_TYPE = b
			}
			%elif !option(PROFCALL) && !option(PROFBLOCK) && option(PROFTIME)
			{
				# timing
				P_LIB_TYPE = t
			}
			%elif option(PROFCALL) && !option(PROFBLOCK) && !option(PROFTIME)
			{
				# callgraph
				P_LIB_TYPE = c
			}
			%elif option(PROFCALL) && !option(PROFBLOCK) && option(PROFTIME)
			{
				# callgraph + timing
				P_LIB_TYPE = ct
			}
		        %elif option(BR_STAT) && (!option(PROFBLOCK) || (!option(PROFCALL) && !option(PROFTIME)))
		        {
		                # no profiling libraries needed for static profiling
		                # and the combination that does need libraries is valid.
		        }
			%else
			{
				%diag F_profiling_combo
			}
		}

		%if option(PROFILE)
		{
		        C_FLAGS = $(C_FLAGS) -p$(PROFILING_FLAGS)

			%if $(P_LIB_TYPE)
			{
				# Settings for dynamic profiling
				%switch	$(TARGET)
				{
					%case	"3000" "ppc"
					{
					        ASM_DEFINE_FLAGS = $(ASM_DEFINE_FLAGS) -D__PROF_ENABLE__
					}
				}
				%if !option(SYMBOLIC_DEBUG)
				{
				        C_FLAGS = $(C_FLAGS) -g
				}
			}
		}
	}

	%default
	{
		%if option(PROFILE)
		{
			%diag F_no_profiling
		}
	}
}

%if !option(NO_SYSLIBS)
{
	# Default library names
	STL_LIB		= -lstl$(TARGET)
	CPLUS_LIB	= -lcp$(TARGET)
	C_LIB		= -lc$(TARGET)
	FP_LIB		= -lfp$(TARGET)
	RT_LIB		= -lrt$(TARGET)
	P_LIB		= -lp$(P_LIB_TYPE)$(TARGET)

	%if option(EXCEPTIONS) || option(IO_STREAMS)
	{
		EH_TAG	= x
	}

	# Exceptional cases
	%switch $(TARGET)
	{
		%case 51
		{
			%if $(REENTRANT)
			{
				C_LIB	= $(C_LIB)$(MODEL)r
				FP_LIB	= $(FP_LIB)$(MODEL)r
			}
			%else
			{
				C_LIB	= $(C_LIB)$(MODEL)s
				FP_LIB	= $(FP_LIB)$(MODEL)s
			}			
		}
		%case mb
		{
			STL_LIB 	= $(STL_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)$(EH_TAG)
			CPLUS_LIB  	= $(CPLUS_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)$(LIB_FPU)$(EH_TAG)
			ABI = "a"
			C_LIB  		= $(C_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)$(LIB_FPU)
			FP_LIB 		= $(FP_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)
			RT_LIB 		= $(RT_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)
			P_LIB 		= $(P_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)
		}
		%case 3000
		{
			STL_LIB		= $(STL_LIB)$(LIB_MUL)$(LIB_DIV)$(EH_TAG)
			CPLUS_LIB	= $(CPLUS_LIB)$(LIB_MUL)$(LIB_DIV)$(EH_TAG)
			C_LIB		= $(C_LIB)$(LIB_MUL)$(LIB_DIV)
			FP_LIB		= $(FP_LIB)$(LIB_MUL)$(LIB_DIV)
			RT_LIB		=
			P_LIB		= $(P_LIB)$(LIB_MUL)$(LIB_DIV)
		}
		%case ppc
		{
			STL_LIB		= $(STL_LIB)$(EH_TAG)
			CPLUS_LIB	= $(CPLUS_LIB)$(EH_TAG)
			RT_LIB =
		}
		%case pb 165x
		{
			C_LIB  =
			FP_LIB =
			RT_LIB =
		}
	}

	%if option(SINGLE_FP) && $(C_LIB)
	{
		%switch $(TARGET)
		{
			# Do not add 's' when the single precision is the default
			%case 51 z80 
			{
				# do nothing
			}
			%default
			{
				STL_LIB		= $(STL_LIB)s
				CPLUS_LIB	= $(CPLUS_LIB)s
				C_LIB		= $(C_LIB)s
			}
		}
	}

	%if option(TRAP_FP) && $(FP_LIB)
	{
		FP_LIB	= $(FP_LIB)t
	}

	%if !$(P_LIB_TYPE)
	{
		P_LIB	=
	}

	%if !($(HAVE_CPLUS) || option(FORCE_CPLUS))
	{
		# Clear STL/C++ libraries when not used
		STL_LIB		=
		CPLUS_LIB	=
	}

	%if !option(IO_STREAMS)
	{
		# Clear STL library when not used
		STL_LIB	=
	}

	SYSLIBS	= $(STL_LIB) $(CPLUS_LIB) $(P_LIB) $(C_LIB) $(FP_LIB) $(RT_LIB)
}

%option	ERRWARN
{
	%if !$(MATCH)
	{
		CPLUS_FLAGS = $(CPLUS_FLAGS) --warnings-as-errors
		C_FLAGS = $(C_FLAGS) --warnings-as-errors
		ASM_FLAGS = $(ASM_FLAGS) --warnings-as-errors
		LLNG_FLAGS = $(LLNG_FLAGS) --warnings-as-errors
	}
}

%option NOWARN
{
	%if !$(MATCH)
	{
		CPLUS_FLAGS = $(CPLUS_FLAGS) --no-warnings
		C_FLAGS = $(C_FLAGS) --no-warnings
		ASM_FLAGS = $(ASM_FLAGS) --no-warnings
		LLNG_FLAGS = $(LLNG_FLAGS) --no-warnings
	}
}

%if !option(SHOW_CPLUS_WARN) && !option(NOWARN)
{	
	IC_FLAGS = $(IC_FLAGS) --no-warnings
}

%option OUTPUT_FORMAT
{
	LLNG_OUTPUT_FLAGS = :$(MATCH)
	%switch $(MATCH)
	{
		%case "ihex" "IHEX"
		{
			LLNG_OUT = $(HEX_OUT)
		}
		%case "srec" "SREC"
		{
			LLNG_OUT = $(SREC_OUT)
		}
	}
	%if option(OUTPUT_ADDRSIZE)
	{
		LLNG_OUTPUT_FLAGS = $(LLNG_OUTPUT_FLAGS):option(OUTPUT_ADDRSIZE)
	}
	%if option(OUTPUT_SPACE)
	{
		LLNG_OUTPUT_FLAGS = $(LLNG_OUTPUT_FLAGS),option(OUTPUT_SPACE)
	}
}

%option PREPROC
{       # -E -> use only for preprocessing, remember flags in PP_FLAGS
        PP_FLAGS = $(PP_FLAGS) -E$(MATCH)
}

%if option(PREPROC_COMP)
{
	PREPROC_ONLY="1"	# For single input file, we should only use the basename of $(OUTPUT)
}				# to specify the name of the pre-processor output file
%else
{
	PREPROC_ONLY=""		# For single input file, we should use $(OUTPUT) to specify the name
}				# of the pre-processor output file

%option SYMBOLIC_DEBUG
{
	# CPLUS_FLAGS = $(CPLUS_FLAGS) -g
	C_FLAGS = $(C_FLAGS) -g
	ASM_FLAGS = $(ASM_FLAGS) -g
}

%option TYPE_CHECK
{
	C_FLAGS = $(C_FLAGS) --global-type-checking
	LLNG_FLAGS = $(LLNG_FLAGS) --global-type-checking
}

%option KEEP_FILES
{
	# Not implemented in the C++ compiler
	C_FLAGS = $(C_FLAGS) -k
	ASM_FLAGS = $(ASM_FLAGS) -k
	LLNG_FLAGS = $(LLNG_FLAGS) -k
}

%option TRADEOFF
{
	C_FLAGS = $(C_FLAGS) -t$(MATCH)
}

%option EXCEPTIONS
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) -x
}

%if option(NO_AUTO_INST)
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) --no-auto-instantiation
}

%option INSTANTIATE
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) -t$(MATCH)
}


%if $(HAVE_CPLUS) || option(FORCE_MUNCH)
{
	LLNG_FLAGS = $(LLNG_FLAGS) --munch
}

%option PASS_CPLUS
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) $(MATCH)
}

%option	PASS_C
{
	C_FLAGS = $(C_FLAGS) $(MATCH)
}

%option	PASS_ASM
{
	ASM_FLAGS = $(ASM_FLAGS) $(MATCH)
}

%option	PASS_LLNG
{
	LLNG_FLAGS = $(LLNG_FLAGS) $(MATCH)
}

%option LSL_FILE
{
	LSL_FLAGS = $(LSL_FLAGS) -d$(MATCH)
}

%option	ASM_LISTFILE
{
	ASM_LIST_FILE = 1
	ASM_LIST_NAME = $(MATCH)
}

# non-control program options
#
# priority:	C and C++ compiler / Linker/Locator / Assembler
#
ASM_OPT_FILE	= opt-as$(TARGET).spec
LLNG_OPT_FILE	= opt-tll.spec


%if	$(TARGET) == "ppc"
{
	%set_option C_FLAGS
	{
# generated by opttool

	-A
	--language
	-C
	--cpu
	-H
	--include-file
	-K
	-O
	--optimize
	-R
	--rename-sections
	-ccng
	-m
	--call
	-p
	--profile
	-r
	--runtime
	-s
	--source
	-t
	--tradeoff
	--call-info
	--cert
	--check
	--compact-max-size
	--extern-sdata
	--global-type-checking
	--inline
	--inline-max-incr
	--inline-max-size
	--max-call-depth
	--metrics
	--misrac
	--misrac-advisory-warnings
	--misrac-required-warnings
	--misrac-version
	--no-stdinc
	--patcvg
	--qualifier-file
	--rtl-alloc
	--sdata
	--signed-bitfields
	}

	%set_option CPLUS_FLAGS
	{
# generated by opttool

	--strict
	-C
	--cpu
	-H
	--include-file
	--list-file
	--xref-file
	--strict-warnings
	--error-limit
	--no-use-before-set-warnings
	--remarks
	--schar
	--instantiate
	--uchar
	--exceptions
	--alternative-tokens
	--anachronisms
	--base-assign-op-is-default
	--building-runtime
	--c++0x
	--context-limit
	--create-pch
	--dollar
	--embedded-c++
	--exported-template-file
	--extended-variadic-macros
	--force-vtbl
	--friend-injection
	--g++
	--gnu-version
	--guiding-decls
	--implicit-extern-c-type-conversion
	--implicit-include
	--incl-suffixes
	--include-macros-file
	--init-priority
	--late-tiebreaker
	--long-lifetime-temps
	--long-long
	--multibyte-chars
	--namespaces
	--no-arg-dep-lookup
	--no-array-new-and-delete
	--no-auto-instantiation
	--no-bool
	--no-class-name-injection
	--no-const-string-literals
	--no-dep-name
	--no-distinct-template-signatures
	--no-enum-overloading
	--no-explicit
	--no-export
	--no-extern-inline
	--no-for-init-diff-warning
	--no-implicit-typename
	--no-inlining
	--no-namespaces
	--no-nonconst-ref-anachronism
	--no-parse-templates
	--no-pch-messages
	--no-preprocessing-only
	--no-stdinc
	--no-stdstlinc
	--no-type-traits-helpers
	--no-typename
	--nonconst-ref-anachronism
	--nonstd-qualifier-deduction
	--nonstd-using-decl
	--old-for-init
	--old-line-commands
	--old-specializations
	--pch
	--pch-dir
	--pch-verbose
	--pending-instantiations
	--remove-unneeded-entities
	--rtti
	--sdata
	--signed-bitfields
	--special-subscript-cost
	--suppress-vtbl
	--template-directory
	--time-limit
	--timing
	--trace-includes
	--type-traits-helpers
	--use-pch
	--using-std
	--variadic-macros
	--wchar_t-keyword
	}
}



%set_option LLNG_FLAGS
{
# generated by opttool

	--map-file
	-N
	--no-rom-copy
	-O
	--optimize
	-P
	--print-mangled-symbols
	-R
	--relocatable
	-S
	--strip-debug
	-c
	--chip-output
	-d
	--lsl-file
	-e
	--extern
	-i
	--user-provided-initialization-code
	-m
	--map-file-format
	-r
	--incremental
	--case-insensitive
	--check-struct-tags
	--entry-point
	--first-library-first
	--global-type-checking
	--hex-format
	--hex-record-size
	--import-object
	--link-only
	--lsl-check
	--lsl-dump
	--max-locate-iterations
	--merge
	--metrics
	--misra-c-report
	--munch
	--no-rescan
	--non-romable
}



%if	$(TARGET) == "ppc"
{
	%set_option ASM_FLAGS
	{
# generated by opttool

	-C
	--cpu
	-H
	--include-file
	-L
	--list-format
	-N
	--nested-sections
	-O
	--optimize
	-a
	--absolute-mode
	-c
	--case-insensitive
	-i
	--symbol-scope
	-m
	--preprocessor-type
	-t
	--section-info
	--check
	--emit-locals
	--fast
	--fpu
	--metrics
	--require-end
	--type-checking
	}
}


# get all input files
ALL_FILES = $(CPLUS_FILES) $(C_FILES) $(MIL_FILES) $(ASM_FILES)
%if count(ALL_FILES) == 1
{
	SINGLE_INPUT = 1
}
%elif   has_arg(DEPFILE)
{
        %diag F_depfile_file
}

%option DEPFILE
{
        DEPFILEARG = $(MATCH)
}

%option MAKETARGET
{
        DEP_TARGET = --make-target=$(MATCH)
}

# preprocessing

%if option(PREPROC)
{
        %action $(CPLUS_FILES)
        {
		%if option(DUMP)
		{
			OUT =	# Always send to stdout
		}
		%elif option(MAKEDEP)
		{
			OUT = -o output_file($(MATCH), $(DEP_OUT), $(SINGLE_INPUT), "1", $(PREPROC_ONLY) )
			DEP_FLAGS = $(DEP_TARGET)
		}
		%else
		{
			OUT = -o output_file($(MATCH), $(PRE_OUT), $(SINGLE_INPUT), "1", $(PREPROC_ONLY) )
		}

	        $(CPFE) $(PP_FLAGS) $(DEP_FLAGS) $(CPLUS_FLAGS) $(STATIC_FLAGS) $(OUT) $(MATCH)
        }
        %action $(C_FILES)
        {
		%if option(DUMP)
		{
			OUT =	# Always send to stdout
		}
		%elif option(MAKEDEP)
		{
			OUT = -o output_file($(MATCH), $(DEP_OUT), $(SINGLE_INPUT), "1", $(PREPROC_ONLY) )
			DEP_FLAGS = $(DEP_TARGET)
		}
		%else
		{
			OUT = -o output_file($(MATCH), $(PRE_OUT), $(SINGLE_INPUT), "1", $(PREPROC_ONLY) )
		}

		$(CFE) $(PP_FLAGS) $(DEP_FLAGS) $(C_FLAGS) $(STATIC_FLAGS) $(OUT) $(MATCH)
        }
}

%stop option(PREPROC) && !option(PREPROC_COMP) 

# compilation actions

%if	count(CPLUS_FILES) == 1 && count(C_FILES) == 0 && count(ASM_FILES) == 0 && count(OBJ_FILES) == 0 && count(LIB_FILES) == 0 &&
	!(option(C_CFILE) || option(C_ASSEMBLY) || option(C_OBJECT) || option(C_RELOCATION)) &&
	!option(INSTANTIATE)
{
	CPLUS_FLAGS = $(CPLUS_FLAGS) -tused
}

%action $(CPLUS_FILES)
{
        %if option(ERROR_FILE)
        {
                ERR_FLAGS = --error-file=replace_extension($(MATCH), ecp)
        }

        %if option(DEPFILE)
        {
                %if !$(DEPFILEARG)
                {
                        DEP_FLAGS = --dep-file=output_file($(MATCH), $(DEP_OUT), "", "1") $(DEP_TARGET)
                }
                %else
                {
                        DEP_FLAGS = --dep-file=$(DEPFILEARG) $(DEP_TARGET)
                }
        }

	OUT = output_file($(MATCH), $(CPFE_OUT), $(SINGLE_INPUT), option(C_CFILE))
        $(CPFE) $(DEP_FLAGS) $(CPLUS_FLAGS) $(ERR_FLAGS) -o $(OUT) $(MATCH)

	%if !option(CHECK)
	{
	       	GEN_C_FILES = $(GEN_C_FILES) $(OUT)
	}
}

%stop option(C_CFILE)

%action $(C_FILES)
{
        %if option(DEPFILE)
        {
                %if !$(DEPFILEARG)
                {
			DEP_FLAGS = --dep-file=output_file($(MATCH), $(DEP_OUT), "", "1") $(DEP_TARGET)
                }
                %else
                {
			DEP_FLAGS = --dep-file=$(DEPFILEARG) $(DEP_TARGET)
		}
        }

	%if option(MILLINK)
	{
		OUT = output_file($(MATCH), $(MIL_OUT), $(SINGLE_INPUT), option(C_MIL))
		$(CFE) $(DEP_FLAGS) $(C_FLAGS) --mil -o $(OUT) $(MATCH)

		%if !option(CHECK)
		{
			GEN_MIL_FILES = $(GEN_MIL_FILES) $(OUT)
		}
	}
	%else
	{	
		OUT = output_file($(MATCH), $(CFE_OUT), $(SINGLE_INPUT), option(C_ASSEMBLY))
		$(CFE) $(DEP_FLAGS) $(C_FLAGS) $(STATIC_FLAGS) -o $(OUT) $(MATCH)

		%if !option(CHECK)
		{
		        GEN_ASM_FILES = $(GEN_ASM_FILES) $(OUT)
		}
	}
}

%action $(IC_FILES) $(GEN_C_FILES)
{
	%if option(MILLINK)
	{
		OUT = output_file($(MATCH), $(MIL_OUT), $(SINGLE_INPUT), option(C_MIL))
		$(CFE) $(C_FLAGS) $(IC_FLAGS) --mil -o $(OUT) $(MATCH)

		GEN_MIL_FILES = $(GEN_MIL_FILES) $(OUT)
	}
	%else
	{	
		OUT = output_file($(MATCH), $(CFE_OUT), $(SINGLE_INPUT), option(C_ASSEMBLY))
		$(CFE) $(C_FLAGS) $(IC_FLAGS) $(STATIC_FLAGS) -o $(OUT) $(MATCH)

		%if !option(CHECK)
		{
			GEN_ASM_FILES = $(GEN_ASM_FILES) $(OUT)
		}
	}
}

%stop option(C_MIL)

%single_action $(MIL_FILES) $(GEN_MIL_FILES)
{
	OUT_FILE = output_file($(MATCH), $(CFE_OUT), $(SINGLE_INPUT), option(C_ASSEMBLY))

	$(CFE) $(C_FLAGS) $(STATIC_FLAGS) -o $(OUT_FILE) $(MATCH)

	%if !option(CHECK)
	{
		GEN_ASM_FILES = $(GEN_ASM_FILES) $(OUT_FILE)
	}
}

%stop option(C_ASSEMBLY)

%action $(ASM_FILES)
{
	OUT = output_file($(MATCH), $(ASM_OUT), $(SINGLE_INPUT), option(C_OBJECT))
	%if	$(ASM_LIST_FILE)
	{
		LST_NAME = ""
		%if	$(SINGLE_INPUT)
		{
			LST_NAME = $(ASM_LIST_NAME)
		}
		%if	! $(LST_NAME)
		{
			LST_NAME = output_file($(MATCH), $(ASM_LST), $(SINGLE_INPUT), "1", "1")
		}
		ASM_LST_FLAGS = -l$(LST_NAME)
	}
	%else
	{
		ASM_LST_FLAGS = ""
	}

	$(ASM) $(ASM_DEFINE_FLAGS) $(ASM_FLAGS) $(ASM_LST_FLAGS) -o $(OUT) $(MATCH)

	%if !option(CHECK)
	{
		GEN_OBJ_FILES = $(GEN_OBJ_FILES) $(OUT)
	}
}

%action $(GEN_ASM_FILES)
{
	OUT = output_file($(MATCH), $(ASM_OUT), $(SINGLE_INPUT), option(C_OBJECT))
	%if	$(ASM_LIST_FILE)
	{
		LST_NAME = ""
		%if	$(SINGLE_INPUT)
		{
			LST_NAME = $(ASM_LIST_NAME)
		}
		%if	! $(LST_NAME)
		{
			LST_NAME = output_file($(MATCH), $(ASM_LST), $(SINGLE_INPUT), "1", "1")
		}
		ASM_LST_FLAGS = -l$(LST_NAME)
	}
	%else
	{
		ASM_LST_FLAGS = ""
	}

	$(ASM) $(ASM_FLAGS) $(ASM_LST_FLAGS) -o $(OUT) $(MATCH)

	GEN_OBJ_FILES = $(GEN_OBJ_FILES) $(OUT)
}

%stop option(C_OBJECT)

%single_action $(OBJ_FILES) $(GEN_OBJ_FILES) $(LIB_FILES)
{
	OBJ_FILES = $(OBJ_FILES) $(GEN_OBJ_FILES) $(LIB_FILES)
}

%single_action $(OBJ_FILES)
{
	# Use variable OUTPUT to set the output name
	%if option(C_RELOCATION)
	{
		LLNG_FLAGS = --incremental $(LLNG_FLAGS)
		LLNG_OUT = $(LK_OUT)
	}
	OUT_FILE = output_file($(OUTPUT), $(LLNG_OUT), "1", "1" )
	$(LLNG) $(MATCH) -o $(OUT_FILE)$(LLNG_OUTPUT_FLAGS) $(LSL_FLAGS) $(LLNG_FLAGS) $(LIB_FLAGS) $(SYSLIBS)
}

#
# Local Variables:
# mode:			text
# fill-column:		120
# comment-start:	"#"
# End:
#
