<?xml version="1.0"?>
<!--
    =============================
    2001-2004 Altium BV
    @(#)sdk.xml	1.151 10/08/27
    =============================
-->
<tool_chain>
    <doil_version>1.1</doil_version>
    <name>TASKING 165x</name>
    <abbrev>165x</abbrev>
    <caption>TASKING TSK165x</caption>
    <bin_dir>c165x\bin</bin_dir>
    <obj_suffix>.obj</obj_suffix>
    <include>global.tcc</include>
    <file_filters>
        <file_filter caption="All files (*.*)" filter="*.*"/>
        <file_filter caption="C source file (*.c)" filter="*.c"/>
        <file_filter caption="Header file (*.h)" filter="*.h"/>
        <file_filter caption="Assembler file (*.asm,*.src,*.inc)" filter="*.asm;*.src;*.inc"/>
        <file_filter caption="Absolute file (*.abs)" filter="*.abs"/>
        <file_filter caption="Library (*.lib)" filter="*.lib"/>
        <file_filter caption="Object file (*.obj)" filter="*.obj"/>
        <file_filter caption="Linker script file (*.lsl)" filter="*.lsl"/>
        <file_filter caption="Debugger config file (*.cfg)" filter="*.cfg"/>
        <file_filter caption="Debugger command file (*.cmd)" filter="*.cmd"/>
        <file_filter caption="Debugger log file (*.log)" filter="*.log"/>
        <file_filter caption="Intel hex file (*.hex)" filter="*.hex"/>
        <file_filter caption="OIL configuration file (*.oil)" filter="*.oil"/>
        <file_filter caption="Software Platform Builder configuration file (*.swplatform)" filter="*.swplatform"/>
    </file_filters>
    <global_scripts>
        Function getTarget : string;
        Begin
           Result := '165x'
        End;
        Function projLslFileName : string;
        Begin
           Result := DXP.OutDir + DXP.ProjectName + '.lsl'
        End;
    </global_scripts>
    <options>
        <group id="GPProcessor">
            <caption>Processor</caption>
            <generate_option if="CPP_Nature.Selected OR C_Nature.Selected OR ASM_Nature.Selected"/>
            <tool_id id_ref="PROC"/>
            <global/>   
            <group id="PrProcessorDefinition">
                <caption>Processor Definition</caption>
                    <text id="Family">
                        <!-- Set by Altium Designer -->
                        <invisible/>
                        <default state="Legacy"/>
                    </text>
                <tool_id id_ref="PROC"/>
                <!-- for the oil file --> 
                <file_suffix_in_project id="HasOil"> 
                    <suffix>.oil</suffix>
                    <makefile_generator> 
                        <selected> 
                            OilLibFile := ChangeFileExt(HasOil.State,'.lib');
                            DXP.AddBuildTarget(DXP.OutDir + ExtractFileName(OilLibFile));
                            DXP.AddToolDependency('$(PROJ).rtos\osek.lib','TOC');
                            DXP.AddToolDependency('$(PROJ).rtos\osek.lib','LK');
                            DXP.WriteToFile(DXP.OutDir + 'xvwdll.ini','radm: osek_radm.dll');
                            DXP.WriteToFile(DXP.OutDir + 'xvwdll.ini','orti: ' + DXP.ProjectDir + '\orti.txt'); 
                        </selected>
                    </makefile_generator> 
                </file_suffix_in_project>
                <file_suffix_in_project id="HasAppStack"> 
                    <suffix>.swplatform</suffix>
                    <makefile_generator> 
                        <selected> 
                            AppStackLibFile := ChangeFileExt(HasAppStack.State,'.lib');
                            DXP.AddBuildTarget(DXP.OutDir + ExtractFileName(AppStackLibFile));
                            DXP.AddToolDependency('$(OUTDIR)\frameout\__framework.lib','LK');
                        </selected>
                    </makefile_generator> 
                </file_suffix_in_project>
                <choices id="Processor">
                    <single/>
                    <caption>Processor</caption>
                    <tool_tip>The selected device determines the processor for which the application is compiled and which options are available.</tool_tip>
                    <default state="ProcTSK165A"/>
                    <choice id="ProcTSK165A">
                        <caption>TSK165A</caption>
                        <generate_option if="AnsiSameText(Family.State,'Legacy') OR AnsiSameText(Processor.State, 'ProcTSK165A')"/>
                        <makefile_generator>
                            <selected>
                                Processor.Flag := 'tsk165a';
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="ProcTSK165B">
                        <caption>TSK165B</caption>
                        <generate_option if="AnsiSameText(Family.State,'Legacy') OR AnsiSameText(Processor.State, 'ProcTSK165B')"/>
                        <makefile_generator>
                            <selected>
                                Processor.Flag := 'tsk165b';
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="ProcTSK165C">
                        <caption>TSK165C</caption>
                        <generate_option if="AnsiSameText(Family.State,'Legacy') OR AnsiSameText(Processor.State, 'ProcTSK165C')"/>
                        <makefile_generator>
                            <selected>
                                Processor.Flag := 'tsk165c';
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                    <text id="ProcTSK165AInLsl">
                        <invisible/>
                        <generate_option if="ProcTSK165A.Selected"/>
                        <makefile_generator>
                            <selected>
                                    DXP.AddToolDependency(DXP.OutDir + DXP.ProjectName + '.lsl','LKLC');
                            </selected>
                        </makefile_generator>
                    </text>
                    <text id="ProcTSK165BInLsl">
                        <invisible/>
                        <generate_option if="ProcTSK165B.Selected"/>
                        <makefile_generator>
                            <selected>
                                    DXP.AddToolDependency(DXP.OutDir + DXP.ProjectName + '.lsl','LKLC');
                            </selected>
                        </makefile_generator>
                    </text>
                    <text id="ProcTSK165CInLsl">
                        <invisible/>
                        <generate_option if="ProcTSK165C.Selected"/>
                        <makefile_generator>
                            <selected>
                                    DXP.AddToolDependency(DXP.OutDir + DXP.ProjectName + '.lsl','LKLC');
                            </selected>
                        </makefile_generator>
                    </text>
                <text id="OptCpu">
                    <default state="SELECTED"/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            OPT_CPU := '-C' + Processor.Flag + #13#10;
                        </selected>
                    </makefile_generator>
                </text>
                <text id="XvwdllCpu">
                    <default state="SELECTED"/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            DXP.WriteToFile(DXP.OutDir + 'xvwdll.ini','cpu_type: ' + Processor.Flag);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="OptArch">
                    <default state="SELECTED"/>
                    <invisible/>
                     <makefile_generator>
                        <selected>
                            OptArch.Flag := '165x';
                        </selected>
                    </makefile_generator>
                </text>
                <text id="CpuExtMem">
                    <default state="SELECTED"/>
                    <invisible/>
                </text>
            </group>
        </group>

        <text id="CPP_Nature">
            <invisible/>
            <default state="NOTSELECTED"/>
        </text>

        <text id="C_Nature">
            <invisible/>
            <default state="NOTSELECTED"/>
        </text>

        <text id="ASM_Nature">
            <invisible/>
            <default state="SELECTED"/>
            <generate_option if="CPP_Nature.Selected OR C_Nature.Selected OR DXP.ProjContainsSuffix('.asm')"/>
        </text>
        <group id="Assembler">
            <caption>Assembler</caption>
            <generate_option if="ASM_Nature.Selected"/>
            <tool_id id_ref="AS"/>
            <group id="AsPreprocessing">
                <caption>Preprocessing</caption>
                <tool_id id_ref="AS"/>
                <table_edit id="AsmDefine">
                    <caption>User macro</caption>
                    <tool_tip>You can use a macro as a symbol in your assembly source, for example to create conditional assembly.<br/>
With this option you can assign values to macros you use in your assembly source.<br/>
In the drop-down table, specify a macro name and a value. If you omit the value, the macro expands to 1.</tool_tip>
                    <column caption="Macro">
                        <text id="AsmMacro">
                            <caption>Macro</caption>
                            <makefile_generator>
                                <selected>
                                    AsmMacro.Flag :=  AsmMacro.State ;
                                </selected>
                            </makefile_generator>
                        </text>
                    </column>
                    <column caption="Value">
                        <text id="AsmValue">
                            <caption>Value</caption>
                            <makefile_generator>
                                <selected>
                                    AsmValue.Flag := '="' + AsmValue.State + '"';
                                </selected>
                            </makefile_generator>
                        </text>
                    </column>
                    <text id="AsmDefine_Script">
                        <invisible/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-D' + AsmMacro.Flag + AsmValue.Flag );
                            </selected>
                        </makefile_generator>
                    </text>
                </table_edit>
                <text id="AsmSpecInc">
                    <caption>Include this file before source</caption>
                    <tool_tip>This file is included at the beginning of each assembly source file. <br/>
This is the same as specifying .INCLUDE 'file' at the beginning of each assembly source.<br/>
Specify the (full path and) file name to include a common include file for all assembly source files.</tool_tip>
                    <button on_click="DXP.FileOpenDialog(AsmSpecInc)"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wa-H"' + AsmSpecInc.State + '"');
                            DXP.AddToolDependency(AsmSpecInc.State, 'AS');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="AsmSysIncDir">
                    <default state="SELECTED"/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(DXP.IncDir,';',' ','-Wa-I"','"') );
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="AsDebugInformation">
                <caption>Debug Information</caption>
                <tool_id id_ref="AS"/>
                <choices id="Choices_Asmdebug1">
                    <caption>Debug information</caption>
                    <tool_tip>With debug information a debugger can display the original assembly source instead of disassembling the memory contents.<br/>
Select 'No debug information' to reduce code size if your application is working fine.<br/>
If you select 'Custom debug information' select one or more options below.</tool_tip>
                    <single/>
                    <default state="Asmdebug2"/>
                    <choice id="Asmdebug1">
                        <caption>No debug information</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-gAHLS');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmdebug2">
                        <caption>Automatic HLL or assembly level debug information</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-gs');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmdebug3">
                        <caption>Custom debug information</caption>
                    </choice>
                </choices>
                <choices id="Choices_Asmdebug3a">
                    <caption>Custom debug information</caption>
                    <tool_tip>Select 'Pass HLL debug information' if your source is a C file and you want to keep debug information generated by the C compiler.<br/>
Select 'Assembler source line information' to be able to debug an assembly source file.</tool_tip>
                    <single/>
                    <default state="Asmdebug3h"/>
                    <generate_option if="Asmdebug3.Selected"/>
                    <choice id="Asmdebug3a">
                        <caption>Assembler source line information</caption>
                        <makefile_generator>
                            <selected>
                                Asmdebug3a.Flag := 'a';
                            </selected>
                            <not_selected>
                                Asmdebug3a.Flag := 'A';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmdebug3h">
                        <caption>Pass HLL debug information</caption>
                        <generate_option if="0 AND Asmdebug3.Selected"/>
                        <makefile_generator>
                            <selected>
                                Asmdebug3h.Flag := 'h';
                            </selected>
                            <not_selected>
                                Asmdebug3h.Flag := 'H';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmdebug3None">
                        <caption>None of the above</caption>
                    </choice>
                </choices>
                <choices id="Choices_Asmdebug3l">
                    <default state=""/>
                    <choice id="Asmdebug3l">
                        <caption>Assembler local symbols information</caption>
                        <tool_tip>With this information you can see names of labels during debugging.<br/>
Select this option to add debug information about local symbols to the object file.</tool_tip>
                        <generate_option if="Asmdebug3.Selected"/>
                        <makefile_generator>
                            <selected>
                                Asmdebug3l.Flag := 'l';
                            </selected>
                            <not_selected>
                                Asmdebug3l.Flag := 'L';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="Asmdebug3_Script">
                    <invisible/>          
                    <default state="SELECTED"/>          
                    <generate_option if="Asmdebug3.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wa-g' + Asmdebug3a.Flag + Asmdebug3h.Flag + Asmdebug3l.Flag );
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="AsListFile">
                <caption>List File</caption>
                <tool_id id_ref="AS"/>
                <choices id="Choices_AsmList">
                    <default state=""/>
                    <choice id="AsmList">
                        <caption>Generate list file</caption>
                        <tool_tip>A list file shows the generated object code and the relative addresses.<br/>
Select this option to generate a list file with the same name as the source file but with extension .lst.<br/>
Additionally, specify below which information you want in the list file.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-l');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <subgroup>
                    <caption>List file format</caption>
                    <choices id="Choices_AsmListD">
                        <default state="AsmListD,AsmListI,AsmListL,AsmListN,AsmListQ,AsmListR,AsmListS,AsmListW,AsmListY"/>
                        <choice id="AsmOutputSectionSum">
                            <caption>Display section information</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('-Wa-tl');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListD">
                            <caption>Section directives (.SECTION)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListD.Flag := 'd';
                                </selected>
                                <not_selected>
                                    AsmListD.Flag := 'D';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListE">
                            <caption>Symbol definition directives (e.g. .EXTERN .CALLS)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListE.Flag := 'e';
                                </selected>
                                <not_selected>
                                    AsmListE.Flag := 'E';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListG">
                            <caption>Generic instruction expansion</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListG.Flag := 'g';
                                </selected>
                                <not_selected>
                                    AsmListG.Flag := 'G';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListI">
                            <caption>Generic instructions</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListI.Flag := 'i';
                                </selected>
                                <not_selected>
                                    AsmListI.Flag := 'I';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListL">
                            <caption>C preprocessor #line directives</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListL.Flag := 'l';
                                </selected>
                                <not_selected>
                                    AsmListL.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListM">
                            <caption>Macro/dup definitions (e.g. .MACRO)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListM.Flag := 'm';
                                </selected>
                                <not_selected>
                                    AsmListM.Flag := 'M';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListN">
                            <caption>Empty source lines (newline)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListN.Flag := 'n';
                                </selected>
                                <not_selected>
                                    AsmListN.Flag := 'N';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListP">
                            <caption>Conditional assembly (.IF, .ELSE, .ENDIF)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListP.Flag := 'p';
                                </selected>
                                <not_selected>
                                    AsmListP.Flag := 'P';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListQ">
                            <caption>Assembler equates and set directives (.EQU, .SET)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListQ.Flag := 'q';
                                </selected>
                                <not_selected>
                                    AsmListQ.Flag := 'Q';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListR">
                            <caption>Relocation characters ('r')</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListR.Flag := 'r';
                                </selected>
                                <not_selected>
                                    AsmListR.Flag := 'R';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListS">
                            <caption>HLL symbolic debug information (.SYMB)</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListS.Flag := 's';
                                </selected>
                                <not_selected>
                                    AsmListS.Flag := 'S';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListV">
                            <caption>Assembler equates and set values</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListV.Flag := 'v';
                                </selected>
                                <not_selected>
                                    AsmListV.Flag := 'V';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListW">
                            <caption>Wrapped source lines</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListW.Flag := 'w';
                                </selected>
                                <not_selected>
                                    AsmListW.Flag := 'W';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListX">
                            <caption>Macro expansions</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListX.Flag := 'x';
                                </selected>
                                <not_selected>
                                    AsmListX.Flag := 'X';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="AsmListY">
                            <caption>Cycle counts</caption>
                            <tool_tip id_ref="TT_AsmList"/>
                            <generate_option if="AsmList.Selected"/>
                            <makefile_generator>
                                <selected>
                                    AsmListY.Flag := 'y';
                                </selected>
                                <not_selected>
                                    AsmListY.Flag := 'Y';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                    <text id="AsmListControls">
                        <invisible/>
                        <generate_option if="AsmList.Selected"/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-L' + AsmListD.Flag + AsmListE.Flag + AsmListG.Flag + AsmListI.Flag + AsmListL.Flag + AsmListM.Flag + AsmListN.Flag + AsmListP.Flag + AsmListQ.Flag + AsmListR.Flag + AsmListS.Flag + AsmListV.Flag + AsmListW.Flag + AsmListX.Flag + AsmListY.Flag
);
                            </selected>
                        </makefile_generator>
                    </text>
                </subgroup>
            </group>
            <group id="AsDiagnostics">
                <caption>Diagnostics</caption>
                <tool_id id_ref="AS"/>
                <choices id="Choices_AsmWarn">
                    <caption>Error reporting</caption>
                    <tool_tip>During the assembly process warnings can occur. By default, all warnings are reported.<br/>
Select one of the suppress options to hide the warning messages that are of no importance to you.</tool_tip>
                    <single/>
                    <default state="AsmWarn"/>
                    <choice id="AsmWarn">
                        <caption>Report all warnings</caption>
                    </choice>
                    <choice id="AsmNoWarn">
                        <caption>Suppress all warnings</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-w');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="AsmSpecWarn">
                        <caption>Suppress specific warnings</caption>
                    </choice>
                </choices>
                <text id="AsmWarnList">
                    <multi/>
                    <caption>    Specific warnings to suppress</caption>
                    <tool_tip>Specify one or more warnings to suppress, separated by commas.<br/>
For example: 10,20,130</tool_tip>
                    <generate_option if="AsmSpecWarn.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(AsmWarnList.State ,',',' ','-Wa-w') );
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_AsmWarningsAsErrors">
                    <default state=""/>
                    <choice id="AsmWarningsAsErrors">
                        <caption>Treat warnings as errors</caption>
                        <tool_tip>When warnings occur the assembly process continues.<br/>
When errors occur the assembly process stops.<br/>
Select this option to stop the assembly process also when only warnings occur.</tool_tip>
                        <generate_option if="NOT AsmNoWarn.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa--warnings-as-errors');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="AsMiscellaneous">
                <caption>Miscellaneous</caption>
                <tool_id id_ref="AS"/>
                <choices id="Choices_AsmCase">
                    <default state="AsmCase"/>
                    <choice id="AsmCase">
                        <caption>Assemble case sensitive (required for C language)</caption>
                        <tool_tip>All identifiers (for example, labels) will appear in the object file exactly as they appear in the source file.<br/>
Clear this option to convert all identifiers to upper case. For example, if you write your own assembly file.</tool_tip>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('-Wa--case-insensitive');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_Asmlabels1">
                    <caption>Labels are by default</caption>
                    <tool_tip>This option determines how to treat labels that are not specified explicitly as global or local.<br/>
Local labels are only known in the current module.<br/>
Select 'Global' to specify that the labels in the current module can be accessed from other modules.</tool_tip>
                    <single/>
                    <default state="Asmlabels1"/>
                    <choice id="Asmlabels1">
                        <caption>Local</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-il');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Asmlabel2">
                        <caption>Global</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wa-ig');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <cmdoptions id="CmdOptAS" tool_id_ref="AS"/>
                <text id="AsmAdditional">
                    <multi/>
                    <caption>Additional assembler options</caption>
                    <tool_tip>Some assembler options are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(AsmAdditional.State);
                        </selected>
                    </makefile_generator>
                </text>
            </group>
        </group>

        <group id="Linker">
            <caption>Linker</caption>
            <generate_option if="CPP_Nature.Selected OR C_Nature.Selected OR ASM_Nature.Selected"/>
            <global/>   
            <tool_id id_ref="LK"/>
            <group id="LkOutputFormat">
                <caption>Output Format</caption>
                <tool_id id_ref="LK"/>
                <text id="LkIeeeTargetExt">
                    <invisible/>
                    <freeze_state if="TRUE" state="abs"/>
                </text>
                <choices id="Choices_LkIeee">
                    <caption>Output format</caption>
                    <tool_tip>This option determines the resulting file of a compile.<br/>
By default, the resulting file is an application you can debug.<br/>
Select 'Library for TASKING Linker' if you want to build a library for use in other projects.</tool_tip>
                    <single/>
                    <default state="LkIeee"/>
                    <choice id="LkIeee">
                        <caption>Absolute file for debuggers (.abs)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.SetPrjTargetExt(LkIeeeTargetExt.state);
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkLib">
                        <caption>Library for TASKING Linker (.lib)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.SetPrjTargetExt('lib');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_LkIhex">
                    <default state="LkIhex"/>
                    <choice id="LkIhex">
                        <caption>Intel HEX records for EPROM programmers (.hex)</caption>
                        <tool_tip>To select this option you must set the output format to 'Absolute file for debuggers'.<br/>
Select this option to generate an additional output file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                    </choice>
                    <choice id="LkSrec">
                        <caption>Motorola S-records for EPROM programmers (.sre)</caption>
                        <tool_tip>To select this option you must set the output format to 'Absolute file for debuggers'.<br/>
Select this option to generate an additional output file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="LkIhex_Script">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="LkIhex.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl-c"' + DXP.OutDir + DXP.ProjectName + ':IHEX"');
                        </selected>
                    </makefile_generator>
                </text>

                <text id="LkSrec_Script">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="LkSrec.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl-c"' + DXP.OutDir + DXP.ProjectName + ':SREC"');
                        </selected>
                    </makefile_generator>
                </text>


                <text id="LkMemoryUseConstraintFile">
                    <default state="SELECTED"/>
                    <invisible/>
                    <generate_option if="LkStdLsl.Selected"/>
                    <makefile_generator>
                        <selected>
                            AddMemConstraint;
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="LkOptimization">
                <caption>Optimization</caption>
                <tool_id id_ref="LK"/>
                <choices id="LkOptim">
                    <single/>
                    <caption>Optimization level</caption>
                    <tool_tip>Select a predefined set of optimizations or select 'Custom optimization' to enable individual optimizations.<br/>
Select 'Full optimization' for the final application.</tool_tip>
                    <default state="LkOL1"/>
                    <generate_option if="NOT LkLib.Selected"/>
                    <choice id="LkOL0">
                        <caption>No optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl-O0');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkOL1">
                        <caption>Default optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl-O1');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkOL2">
                        <caption>Full optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl-O2');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkOLAdv">
                        <caption>Custom optimization</caption>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Custom optimization</caption>
                    <choices id="Choices_LkOc">
                        <default state="LkOc,LkOt"/>
                        <choice id="LkOc">
                            <caption>Delete un-referenced sections</caption>
                            <tool_tip>Removes sections that are never used from the output file.<br/>
This option is only useful when you compile without debug information, because debug information generally uses all sections.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOc.Flag := 'c';
                                </selected>
                                <not_selected>
                                    LkOc.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkOl">
                            <caption>Use first fit decreasing algorithm</caption>
                            <tool_tip>Puts small sections into gaps that were formed during the locate process.<br/>
This optimization only applies to unrestricted sections.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOl.Flag := 'l';
                                </selected>
                                <not_selected>
                                    LkOl.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                       <choice id="LkOt">
                            <caption>Copy table compression</caption>
                            <tool_tip>Compresses the size of the copy table when possible.<br/>
Smart restrictions are emitted to obtain large contiguous blocks of sections that can be copied/cleared in one copy table action instead of multiple little copy/clear actions.<br/>
This optimization reduces both memory usage and startup speed.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOt.Flag := 't';
                                </selected>
                                <not_selected>
                                    LkOt.Flag := 'T';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkOx">
                            <caption>Delete duplicate code</caption>
                            <tool_tip>Removes duplicate code from the output file.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOx.Flag := 'x';
                                </selected>
                                <not_selected>
                                    LkOx.Flag := 'X';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkOy">
                            <caption>Delete duplicate constant data</caption>
                            <tool_tip>Removes duplicate constant data from the output file.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOy.Flag := 'y';
                                </selected>
                                <not_selected>
                                    LkOy.Flag := 'Y';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <text id="LkOLAdv_Script">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="LkOLAdv.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl-O' + LkOc.Flag + LkOl.Flag + LkOt.Flag + LkOx.Flag + LkOy.Flag
);
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="LkMapFile">
                <caption>Map File</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LkMap">
                    <default state="LkMap"/>
                    <choice id="LkMap">
                        <caption>Generate a memory map file (.map)</caption>
                        <tool_tip>A map file shows how the linker has mapped the sections and symbols from the various object files to output sections.<br/>
Select this option to generate a map file with the same name as the project file but with extension .map.<br/>
Additionally, specify below which information you want in the map file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddGeneratedFile( DXP.OutDir + DXP.ProjectName + '.map'#13#10);
                                DXP.AddToolCmdOption('-Wl-M');
                            </selected>
                            <not_selected>
                                DXP.AddToolCmdOption('--no-map-file');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Map file format</caption>
                    <choices id="Choices_LkMapFileCallgraph">
                        <default state="LkMapFileCallgraph,LkMapFileProcessed,LkMapFileLink,LkMapFileLocate,LkMapFileMemory,LkMapFileOverlay,LkMapFileCrossRef,LkMapFileRules"/>
                        <choice id="LkMapFileCallgraph">
                            <caption>Call graph information</caption>
                            <tool_tip>Shows a schematic overview how functions call each other.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileCallgraph.Flag := 'c';
                                </selected>
                                <not_selected>
                                    LkMapFileCallgraph.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileProcessed">
                            <caption>Processed files information</caption>
                            <tool_tip>Shows all files processed by the linker. This also includes object files extracted from libraries, and the symbol that led to the extraction.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileProcessed.Flag := 'f';
                                </selected>
                                <not_selected>
                                    LkMapFileProcessed.Flag := 'F';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileLink">
                            <caption>Link result information</caption>
                            <tool_tip>Shows per object file how the linker has mapped the sections from the various objects files to output sections.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileLink.Flag := 'k';
                                </selected>
                                <not_selected>
                                    LkMapFileLink.Flag := 'K';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileLocate">
                            <caption>Locate result information</caption>
                            <tool_tip>Shows the absolute position of each section in the output file and shows a list of all external symbols.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileLocate.Flag := 'l';
                                </selected>
                                <not_selected>
                                    LkMapFileLocate.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileMemory">
                            <caption>Memory usage information</caption>
                            <tool_tip>Shows the memory usage in totals and percentages for spaces and chips.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileMemory.Flag := 'm';
                                </selected>
                                <not_selected>
                                    LkMapFileMemory.Flag := 'M';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileOverlay">
                            <caption>Overlay information</caption>
                            <tool_tip>Shows the locate overlay information if you used overlay groups in the linker script file.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileOverlay.Flag := 'o';
                                </selected>
                                <not_selected>
                                    LkMapFileOverlay.Flag := 'O';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileStatics">
                            <caption>Module local symbols</caption>
                            <tool_tip>Shows for each local scope the name, address and space where the local symbol resides.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileStatics.Flag := 'q';
                                </selected>
                                <not_selected>
                                    LkMapFileStatics.Flag := 'Q';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileCrossRef">
                            <caption>Cross reference information</caption>
                            <tool_tip>Shows a list of all symbols and for each symbol the object files in which the symbol is referenced.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileCrossRef.Flag := 'r';
                                </selected>
                                <not_selected>
                                    LkMapFileCrossRef.Flag := 'R';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileLsl">
                            <caption>Processor and memory information</caption>
                            <tool_tip>Shows the name of the processor and core and shows names, sizes and mappings of spaces, buses and memory.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileLsl.Flag := 's';
                                </selected>
                                <not_selected>
                                    LkMapFileLsl.Flag := 'S';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileRules">
                            <caption>Locate rules</caption>
                            <tool_tip>Shows the rules the linker uses to locate sections. For example, this part lists which sections are absolute, contiguous or unrestricted.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileRules.Flag := 'u';
                                </selected>
                                <not_selected>
                                    LkMapFileRules.Flag := 'U';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <text id="LkMapFileCustom_Script">
                    <invisible/>
                    <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-Wl-m' + LkMapFileCallgraph.Flag + LkMapFileProcessed.Flag + LkMapFileLink.Flag + LkMapFileLocate.Flag + LkMapFileMemory.Flag + LkMapFileOverlay.Flag + LkMapFileStatics.Flag + LkMapFileCrossRef.Flag + LkMapFileLsl.Flag + LkMapFileRules.Flag
);
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="LkDiagnostics">
                <caption>Diagnostics</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LKWarn">
                    <caption>Error reporting</caption>
                    <generate_option if="NOT LkLib.Selected"/>
                    <tool_tip>During the link process warnings can occur. By default, all warnings are reported.<br/>
Select one of the suppress options to hide the warning messages that are of no importance to you.</tool_tip>
                    <single/>
                    <default state="LKWarn"/>
                    <choice id="LKWarn">
                        <caption>Report all warnings</caption>
                    </choice>
                    <choice id="LKNoWarn">
                        <caption>Suppress all warnings</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl--no-warnings');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LKSpecWarn">
                        <caption>Suppress specific warnings</caption>
                    </choice>
                </choices>
                <text id="LKWarnList">
                    <multi/>
                    <caption>    Specific warnings to suppress</caption>
                    <tool_tip>Specify one or more warnings to suppress, separated by commas.<br/>
For example: 126,135,144</tool_tip>
                    <generate_option if="LKSpecWarn.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(LKWarnList.State ,',',' ','-Wl-w') );
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_LKWarningsAsErrors">
                    <default state=""/>
                    <choice id="LKWarningsAsErrors">
                        <caption>Treat warnings as errors</caption>
                        <tool_tip>When warnings occur the link process continues.<br/>
When errors occur the link process stops.<br/>
Select this option to stop the link process also when only warnings occur.</tool_tip>
                        <generate_option if="NOT LKNoWarn.Selected AND NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl--warnings-as-errors');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="LkMiscellaneous">
                <caption>Miscellaneous</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LkNonRomable">
                    <!-- Set by Altium Designer Locate option frame -->
                    <invisible/>
                    <default state=""/>
                    <choice id="LkNonRomable">
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--non-romable');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkNonRomableUser"/>
                </choices>
                <choices id="Choices_LkIncludeDebug">
                    <default state="LkIncludeDebug,LkCase"/>
                    <choice id="LkIncludeDebug">
                        <caption>Include symbolic debug information</caption>
                        <tool_tip>Normally the linker passes debug information enabled by the compiler or assembler to the output file.<br/>
Clear this option to strip debug information from the output file. This can be useful to reduce the size of the output file or to allow more optimizations.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('--strip-debug');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkCase">
                        <caption>Link case sensitive (required for C language)</caption>
                        <tool_tip>All identifiers will appear in the object file exactly as they appear in the source file.<br/>
Clear this option to convert all identifiers to upper case. For example, if you write your own assembly file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('-Wl--case-insensitive');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkDumpLsl">
                        <caption>Dump processor and memory info from LSL file</caption>
                        <tool_tip>Select this option to dump the processor and memory information in a separate file with extension .ldf.<br/>
The same information is available in the map file when you select 'Processor and memory information' on the 'Map File' page.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--lsl-dump');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkUserLsl">
                        <caption>Use project specific LSL file</caption>
                        <tool_tip>Normally Altium Designer generates LSL files depending on your project settings.<br/>
Select this option to specify your own LSL file. Enter the name of your LSL file in the field below.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                    </choice>
                </choices>
                <text id="LkUserLslField">
                    <caption>    LSL file</caption>
                    <tool_tip>Enter the name of your LSL file to use with this project.</tool_tip>
                    <generate_option if="LkUserLsl.Selected"/>
                    <button on_click="DXP.FileOpenDialog(LkUserLslField)"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-d"' + LkUserLslField.State + '"');
                        </selected>
                    </makefile_generator>
                </text>
                <table_edit id="LkDefine">
                    <caption>User macro</caption>
                    <tool_tip>You can use a macro as a symbol in your LSL file, for example to create conditional parts.<br/>
With this option you can assign values to macros you use in your LSL file.<br/>
In the drop-down table, specify a macro name and a value. If you omit the value, the macro expands to 1.</tool_tip>
                    <generate_option if="NOT LkLib.Selected"/>
                    <column caption="Macro">
                        <text id="LkMacro">
                            <caption>Macro</caption>
                        </text>
                    </column>
                    <column caption="Value">
                        <text id="LkValue">
                            <caption>Value</caption>
                        </text>
                    </column>
                    <text id="LkDefine_Loop">
                        <invisible/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-Wl-D' + LkMacro.State + '="' + LkValue.State + '"');
                            </selected>
                        </makefile_generator>
                    </text>
                </table_edit>
                <cmdoptions id="CmdOptLK" tool_id_ref="LK"/>
                <text id="LkAdditional">
                    <multi/>
                    <caption>Additional linker options</caption>
                    <tool_tip>Some linker options are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                    <generate_option if="NOT LkLib.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(LkAdditional.State);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkStdLsl">
                    <invisible/>
                    <generate_option if="NOT LkLib.Selected AND NOT LkUserLsl.Selected"/>
                    <default state="SELECTED"/>
                </text>

                <text id="LkStdLslMemoryDefine">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="NOT LkLib.Selected AND NOT LkUserLsl.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolDependency(projLslFileName,'LK');
                            DXP.WriteToFile(projLslFileName,'#define __MEMORY');
                        </selected>
                    </makefile_generator>
                </text>

                <text id="LkLslSwArch">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolDependency(projLslFileName,'LK');
                            DXP.WriteToFile(projLslFileName,'#define __SW_ARCH' + #9#9 + 'c165x');
                            DXP.WriteToFile(projLslFileName,'#define __SW_LSL' + #9#9 + '"165x.lsl"');
                        </selected>
                    </makefile_generator>
                </text>
            </group>
        </group>
    </options>
    <global_tool_tips>
        <global_tool_tip id="TT_AsmList">To change this option, first select 'Generate list file'.</global_tool_tip>
    </global_tool_tips>
    <tool_definitions>
        <options>
            <macro name="OPT_CPU" value="OPT_CPU"/>
            <macro name="OPT_ARCH" value="OPT_ARCH"/>
            <macro name="OPT_CC" value="DXP.GetToolCmdOption('CC')"/>
            <macro name="OPT_AS" value="DXP.GetToolCmdOption('AS')"/>
            <macro name="OPT_LK" value="DXP.GetToolCmdOption('LK')"/>
        </options>
        <tool>
            <tool_id id="CC"/>
            <suffix_src value=".c"/>
            <suffix_dest value=".src"/>
            <depend_method value="1"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_CC) %file"/>
            <action>
                <![CDATA[
ifdef PREPROCESS
    @echo Preprocessing ${*F}.c
    %exe(cc165x.exe) -E$(PREPROCESSFLAGS) -o "$*.pre" -f %optfile
endif
    @echo Compiling ${*F}.c
    %exe(cc165x.exe) -cs -o "$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="AS"/>
            <suffix_src value=".src"/>
            <suffix_dest value=".obj"/>
            <depend_method value="2"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_AS) %file"/>
            <action>
                <![CDATA[
    @echo Assembling ${*F}.src
    %exe(cc165x.exe) -c -o "$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="AS"/>
            <suffix_src value=".asm"/>
            <suffix_dest value=".obj"/>
            <depend_method value="2"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_AS) %file"/>
            <action>
                <![CDATA[
    @echo Assembling ${*F}.asm
    %exe(cc165x.exe) -c -o "$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="AR"/>
            <suffix_src value=".obj"/>
            <suffix_dest value=".lib"/>
            <action>
                <![CDATA[
    @echo Creating library ${@F}
    %exe(..\..\bin\tlb.exe) -crv "$@" %file
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="LK"/>
            <suffix_src value=".obj"/>
            <suffix_dest value=".abs"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_LK) %file $(EXT_LIBRARIES)"/>
            <action>
                <![CDATA[
    @echo Linking and Locating ${@F}
    %exe(cc165x.exe) -o "$@" -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="LK"/>
            <suffix_src value=".abs"/>
            <suffix_dest value=".hex"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_LK) %file $(EXT_LIBRARIES)"/>
            <action>
                <![CDATA[ 
    @echo Linking and Locating ${@F}
    %exe(cc165x.exe) -o "$@":IHEX -f %optfile
                ]]>
            </action>
        </tool>
        <tool>
            <tool_id id="TOC"/>
            <suffix_src value=".oil"/>
            <suffix_dest value=".lib"/>
            <action>
                <![CDATA[ 
"$(PROJ).rtos\osek.lib" : %file

OILFILE=%file
include "$(PRODDIR)\c165x\osek\osek.mk"
EXT_LIBRARIES += "$(PROJ).rtos\osek.lib"
                ]]>
            </action>
        </tool>
        <tool>
           <tool_id id="APPSTACK"/>
            <suffix_src value=".swplatform"/>
            <suffix_dest value=".lib"/>
            <action>
                <![CDATA[
"$(OUTDIR)\frameout\__framework.lib" : %file

TARGET=165x
include "$(PRODDIR)\etc\swplatform.mak"
EXT_LIBRARIES += "$(OUTDIR)\frameout\__framework.lib"
                ]]>
            </action>
        </tool>
    </tool_definitions>
</tool_chain>
