////////////////////////////////////////////////////////////////////////////
//
//  File        :  165x.lsl
//
//  Version	:  1.13
//
//  Description :  Linker script file for the PIC165x architecture
//
//  Copyright 2003 Altium BV
//


////////////////////////////////////////////////////////////////////////////
//
// Some default values
//

#ifndef __HEAP
#define __HEAP 4
#endif

#ifdef __TSK165A
#define NR_OF_DATA_BANKS 1
#define NR_OF_CODE_PAGES 1
#endif
#ifdef __TSK165B
#define NR_OF_DATA_BANKS 4
#define NR_OF_CODE_PAGES 4
#endif
#ifdef __TSK165C
#define NR_OF_DATA_BANKS 4
#define NR_OF_CODE_PAGES 4
#endif
#ifdef __TSK165D
#define NR_OF_DATA_BANKS 8
#define NR_OF_CODE_PAGES 8
#endif

#ifndef NR_OF_DATA_BANKS
#define NR_OF_DATA_BANKS 4
#endif

#ifndef NR_OF_CODE_PAGES
#define NR_OF_CODE_PAGES 4
#endif

// 32 bytes data available per bank
#define MAX_DATA_SIZE ( NR_OF_DATA_BANKS * 32 )

// 512 bytes code available per page
#define MAX_CODE_SIZE ( NR_OF_CODE_PAGES * 512 )

architecture c165x
{
	endianness
	{
		big;
	}
	
	space data
	{
		id = 1;
		mau = 8;
		map (src_offset=0x00, dest_offset=0x00, size=0x10, dest=bus:data_bus);
		map (src_offset=0x10, dest_offset=0x10, size=0x10, dest=bus:data_bus);
#if ( NR_OF_DATA_BANKS > 1 )
		map (src_offset=0x20, dest_offset=0x00, size=0x10, dest=bus:data_bus);
		map (src_offset=0x30, dest_offset=0x30, size=0x10, dest=bus:data_bus);
#if ( NR_OF_DATA_BANKS > 2 )
		map (src_offset=0x40, dest_offset=0x00, size=0x10, dest=bus:data_bus);
		map (src_offset=0x50, dest_offset=0x50, size=0x10, dest=bus:data_bus);
#if ( NR_OF_DATA_BANKS > 3 )
		map (src_offset=0x60, dest_offset=0x00, size=0x10, dest=bus:data_bus);
		map (src_offset=0x70, dest_offset=0x70, size=0x10, dest=bus:data_bus);
#if ( NR_OF_DATA_BANKS > 4 )
		map (src_offset=0x80, dest_offset=0x00, size=0x10, dest=bus:data_bus);
		map (src_offset=0x90, dest_offset=0x90, size=0x10, dest=bus:data_bus);
#if ( NR_OF_DATA_BANKS > 5 )
		map (src_offset=0xa0, dest_offset=0x00, size=0x10, dest=bus:data_bus);
		map (src_offset=0xb0, dest_offset=0xb0, size=0x10, dest=bus:data_bus);
#if ( NR_OF_DATA_BANKS > 6 )
		map (src_offset=0xc0, dest_offset=0x00, size=0x10, dest=bus:data_bus);
		map (src_offset=0xd0, dest_offset=0xd0, size=0x10, dest=bus:data_bus);
#if ( NR_OF_DATA_BANKS > 7 )
		map (src_offset=0xe0, dest_offset=0x00, size=0x10, dest=bus:data_bus);
		map (src_offset=0xf0, dest_offset=0xf0, size=0x10, dest=bus:data_bus);
#endif		
#endif		
#endif		
#endif		
#endif		
#endif		
#endif		
		heap "heap" (min_size = __HEAP);
		
                section_layout
                {
                        group ( run_addr=0, ordered, contiguous ) reserved "sfr" ( size=1 );
#ifdef __TSK165C
                        group ( run_addr=2, ordered, contiguous ) reserved "sfr" ( size=9 );
#else
                        group ( run_addr=2, ordered, contiguous ) reserved "sfr" ( size=6 );
#endif
		}
	}
	
	space code
	{
		id = 2;
		mau = 12;
		map (size=(MAX_CODE_SIZE), dest=bus:code_bus);

		// The linker generates an __init routine for 
		// .data and .bss sections:
		direct_init;
                section_layout
                {
			"__init" := "__lc_ub_dinit";
                }
	}
	
	space bit
	{
		id = 3;
		mau = 1;
		map (size=0x100, dest=space:data);
	}
	
	bus data_bus
	{
		mau = 8;
		width = 8;
	}
	
	bus code_bus
	{
		mau = 12;
		width = 12;
	}
}

////////////////////////////////////////////////////////////////////////////
//
// If no memory is defined yet use the following memory settings
//
#ifndef __MEMORY
memory xram
{
    mau = 8;
    type = ram;
    size = (MAX_DATA_SIZE);
    map ( dest=bus:c165x:data_bus, src_offset=0x0, dest_offset=0x0, size=(MAX_DATA_SIZE) );
}
memory xrom
{
    mau = 12;
    type = rom;
    size = (MAX_CODE_SIZE);
    map ( dest=bus:c165x:code_bus, src_offset=0x0, dest_offset=0x0, size=(MAX_CODE_SIZE) );
}
#endif /* __MEMORY */
