






# tcc.spec  --  specification file for the control program
# @(#)tcc.spec	1.74

# tool configuration
%if user_func( get_target )
{
	TARGET  = user_func( get_target )
	CFE	= c$(TARGET)
	ASM	= as$(TARGET)
	LLNG	= lk$(TARGET)
}
%else
{
	TARGET	= option(TARGET)
	EXEDIR	= ../c$(TARGET)/bin
	CFE	= $(EXEDIR)/c$(TARGET)
	ASM	= $(EXEDIR)/as$(TARGET)
	LLNG	= tlk
}

# output extensions
MIL_OUT	 = mil
CFE_OUT	 = src
ASM_OUT	 = obj
ASM_LST	 = lst

LLNG_OUT = abs
LK_OUT	 = out
HEX_OUT  = hex
SREC_OUT = sre

DEFAULT_LSL_FLAG = -d$(TARGET).lsl

# input file handling
%file	*.c
{
	C_FILES = $(C_FILES) $(MATCH)
}

%file	*.mil
{
	MIL_FILES = $(MIL_FILES) $(MATCH)
}

%file	*.asm *.src
{
	ASM_FILES = $(ASM_FILES) $(MATCH)
}

%file	*.obj *.out *.eln *.elb
{
	OBJ_FILES = $(OBJ_FILES) $(MATCH)
}

%file	*.lib
{
	LIB_FLAGS = $(LIB_FLAGS) $(MATCH)
}

%file	*.lsl
{
	DEFAULT_LSL_FLAG =
	LSL_FLAGS = $(LSL_FLAGS) -d$(MATCH)
}

# handle options
%if option(ISO_MODE) == "99"
{
	C_FLAGS = -c99 $(C_FLAGS)
}
%elif option(ISO_MODE) == "90"
{
	C_FLAGS = -c90 $(C_FLAGS)
}

%option	SINGLE_FP
{
	C_FLAGS = $(C_FLAGS) -F
}

%option STATIC
{
	STATIC_FLAGS = --static
}

%option REENTRANT
{
	REENTRANT = 1
}

%option ENDIAN
{
	C_FLAGS = $(C_FLAGS) --big-endian
	ASM_FLAGS = $(ASM_FLAGS) --big-endian
	LLNG_FLAGS = $(LLNG_FLAGS) --endianness=big
}

%if !option(NO_MAPFILE)
{
	LLNG_FLAGS = $(LLNG_FLAGS) -M
}

%switch	option(MODEL)
{
	%case small s
	{
		MODEL = s
	}
	%case aux a
	{
		MODEL = a
	}
	%case large l
	{
		MODEL = l
	}
	%case medium m
	{
		MODEL = m
	}
	%default
	{
		%if !option(MODEL) && $(TARGET) == "51"
		{
			MODEL=s
		}
	}
}

# Handle '--use-hardware' option
%switch	$(TARGET)
	{
	# Default mb compiler: --use-hardware=MDB
	%case mb
	{
		%if option(USEMULTIPLY)
		{
			HARDWARE_FLAGS = $(HARDWARE_FLAGS)"m"
			LIB_MUL        = "m"
		}
		%if option(USEDIVIDE)
		{
			HARDWARE_FLAGS = $(HARDWARE_FLAGS)"d"
			LIB_DIV        = "d"
		}
		%if option(USEBARRELSHIFT)
		{
			%if $(TARGET) == "mb"
			{
				HARDWARE_FLAGS = $(HARDWARE_FLAGS)"b"
				LIB_BS         = "b"
			}
		}
		%if $(HARDWARE_FLAGS)
		{
			C_FLAGS   = $(C_FLAGS)   --use-hardware=$(HARDWARE_FLAGS)
			ASM_FLAGS = $(ASM_FLAGS) --use-hardware=$(HARDWARE_FLAGS)
		}
	}
	# Default 3000 compiler: --use-hardware=md
	# TODO: Only works well if option is used as: --use-hardware=md, --use-hardware=MD 
	#       or if the --use-hardware is left out completely.
	# Problem: option(USEMULTIPLY) evaluates to true if it is used (so the count counts)
	# it is not checked if it is enabled or not! Kdb will investigate...
	%case 3000
	{
		%if option(USEHARDWARE) 
		{
			%if option(USEMULTIPLY)
			{
				LIB_MUL = "m"
			}
			%else
			{
				HARDWARE_FLAGS = $(HARDWARE_FLAGS)"M"
				LIB_MUL = ""
			}
			%if option(USEDIVIDE)
			{
				LIB_DIV = "d"
			}
			%else
			{
				HARDWARE_FLAGS = $(HARDWARE_FLAGS)"D"
				LIB_DIV = ""
			}
		}
		%else
		{
			LIB_MUL        = "m"
			LIB_DIV        = "d"
		}
		%if $(HARDWARE_FLAGS)
		{
			C_FLAGS   = $(C_FLAGS)   --use-hardware=$(HARDWARE_FLAGS)
			ASM_FLAGS = $(ASM_FLAGS) --use-hardware=$(HARDWARE_FLAGS)
		}
	}
	%case nios
	{
		%if option(USEHARDWARE) 
		{
			%if option(USEMULTIPLY)
			{
				LIB_MUL = "m"
			}
			%else
			{
				HARDWARE_FLAGS = $(HARDWARE_FLAGS)"M"
				LIB_MUL = ""
			}
			%if option(USEDIVIDE)
			{
				LIB_DIV = "d"
			}
			%else
			{
				HARDWARE_FLAGS = $(HARDWARE_FLAGS)"D"
				LIB_DIV = ""
			}
		}
		%else
		{
			LIB_MUL        = "m"
			LIB_DIV        = "d"
		}
		%if $(HARDWARE_FLAGS)
		{
			C_FLAGS   = $(C_FLAGS)   --use-hardware=$(HARDWARE_FLAGS)
			ASM_FLAGS = $(ASM_FLAGS) --use-hardware=$(HARDWARE_FLAGS)
		}
	}
}

%if $(REENTRANT)
{
	C_FLAGS = $(C_FLAGS) --reentrant
}

%if $(MODEL)
{
	C_FLAGS = $(C_FLAGS) -M$(MODEL)
}


%option CPU
{
        CPU=$(MATCH)
}


%if option (CPU)
{
	C_FLAGS = $(C_FLAGS) -C$(CPU)
	ASM_FLAGS = $(ASM_FLAGS) -C$(CPU)

	%if $(TARGET) == "165x"
	{
		%switch $(CPU)
		{
			%case tsk165a
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__TSK165A
			}
			%case tsk165b
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__TSK165B
			}
			%case tsk165c
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__TSK165C
			}
			%case tsk165d
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__TSK165D
			}
		}
	}

	%if $(TARGET) == "pb"
	{
		%switch $(CPU)
		{
			%case pb1
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__PB1
			}
			%case pb1c
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__PB1C
			}
			%case pb2
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__PB2
			}
		}
	}

	%if $(TARGET) == "nios"
	{
		%switch $(CPU)
		{
			%case nios2f
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__NIOS2F
			}
			%case nios2s
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__NIOS2S
			}
			%case nios2e
			{
				LLNG_FLAGS = $(LLNG_FLAGS) -D__NIOS2E
			}
		}
	}
}

%option ERROR_FILE
{
	C_FLAGS = $(C_FLAGS) --error-file
	ASM_FLAGS = $(ASM_FLAGS) --error-file
	LLNG_FLAGS = $(LLNG_FLAGS) --error-file
}

%option MACRO_DEFINE
{
        # Add macro definitions
        C_FLAGS = $(C_FLAGS) -D$(MATCH)
        ASM_FLAGS = $(ASM_FLAGS) -D$(MATCH)
}

%option MACRO_UNDEF
{
        # Add macro un-definitions
        C_FLAGS = $(C_FLAGS) -U$(MATCH)
}

%option INCLUDE_DIR
{
        # Add include directories
        C_FLAGS = $(C_FLAGS) -I$(MATCH)
        ASM_FLAGS = $(ASM_FLAGS) -I$(MATCH)
}

%option NO_DEFLIB_PATH
{
	LIB_FLAGS = -L
}

%option LIBRARY_DIR
{
        # Add library directories
        LIB_FLAGS = $(LIB_FLAGS) -L$(MATCH)
}

%option LIBRARY_FILE
{
        # Add libraries
        LIB_FLAGS = $(LIB_FLAGS) -l$(MATCH)
}

# We have suboptions PROFBLOCK, PROFCALL, PROFFUNC and PROFTIME.
# PROFEDGE is not yet available.
# We have libraries for block/function, callgraph, callgraph/timing and timing,
# so do something smart with correct combinations, and nothing with the rest.
#
# We also ensure that the assembler and linker emit local symbols so that
# profiling of static functions will produce correct results.
P_LIB_TYPE	=
%switch	$(TARGET)
{
	%case	"mb" "3000" "ppc" "nios"
	{
		%if option(PROFBLOCK)
		{
			PROFILING_FLAGS = $(PROFILING_FLAGS)"b"
		}
		%if option(PROFCALL)
		{
			PROFILING_FLAGS = $(PROFILING_FLAGS)"c"
		}
		%if option(PROFFUNC)
		{
			PROFILING_FLAGS = $(PROFILING_FLAGS)"f"
		}
		%if option(PROFTIME)
		{
			PROFILING_FLAGS = $(PROFILING_FLAGS)"t"
		}
		%if $(PROFILING_FLAGS)
		{
			C_FLAGS = $(C_FLAGS) -p$(PROFILING_FLAGS)
			ASM_FLAGS = $(ASM_FLAGS) --emit-locals
			LLNG_FLAGS = $(LLNG_FLAGS) -mq
		}
		# Select library
		%if !option(PROFCALL) && !option(PROFTIME)
		{
			# function or block
			P_LIB_TYPE = b
		}
		%elif !option(PROFCALL) && !option(PROFBLOCK) && option(PROFTIME)
		{
			# timing
			P_LIB_TYPE = t
		}
		%elif option(PROFCALL) && !option(PROFBLOCK) && !option(PROFTIME)
		{
			# callgraph
			P_LIB_TYPE = c
		}
		%elif option(PROFCALL) && !option(PROFBLOCK) && option(PROFTIME)
		{
			# callgraph + timing
			P_LIB_TYPE = ct
		}
		%else
		{
			%diag F_profiling_combo
		}
	}
	%default
	{
		%if option(PROFILE)
		{
			%diag F_no_profiling
		}
	}
}

%if !option(NO_SYSLIBS)
{
	# Default library names
	C_LIB	= -lc$(TARGET)
	FP_LIB	= -lfp$(TARGET)
	RT_LIB	= -lrt$(TARGET)
	P_LIB	= -lp$(P_LIB_TYPE)$(TARGET)

	# Exceptional cases
	%switch $(TARGET)
	{
		%case 51
		{
			%if $(REENTRANT)
			{
				C_LIB	= $(C_LIB)$(MODEL)r
				FP_LIB	= $(FP_LIB)$(MODEL)r
			}
			%else
			{
				C_LIB	= $(C_LIB)$(MODEL)s
				FP_LIB	= $(FP_LIB)$(MODEL)s
			}			
		}
		%case mb
		{
			ABI = "a"
			C_LIB  = $(C_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)
			FP_LIB = $(FP_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)
			RT_LIB = $(RT_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)
			P_LIB = $(P_LIB)$(ABI)$(LIB_MUL)$(LIB_DIV)$(LIB_BS)
		}
		%case 3000
		{
			C_LIB  = $(C_LIB)$(LIB_MUL)$(LIB_DIV)
			FP_LIB = $(FP_LIB)$(LIB_MUL)$(LIB_DIV)
			RT_LIB =
			P_LIB = $(P_LIB)$(LIB_MUL)$(LIB_DIV)
		}
		%case nios
		{
			C_LIB  = $(C_LIB)$(LIB_MUL)$(LIB_DIV)
			FP_LIB = $(FP_LIB)$(LIB_MUL)$(LIB_DIV)
			RT_LIB =
			P_LIB = $(P_LIB)$(LIB_MUL)$(LIB_DIV)
		}
		%case ppc
		{
			RT_LIB =
		}
		%case pb 165x
		{
			C_LIB  =
			FP_LIB =
			RT_LIB =
		}
	}

	%if option(SINGLE_FP) && $(C_LIB)
	{
		%switch $(TARGET)
		{
			# Do not add 's' when the single precision is the default
			%case 51 z80 
			{
				# do nothing
			}
			%default
			{
				C_LIB	= $(C_LIB)s
			}
		}
	}

	%if option(TRAP_FP) && $(FP_LIB)
	{
		FP_LIB	= $(FP_LIB)t
	}

	%if !option(PROFILE)
	{
		P_LIB	=
	}

        LIB_FLAGS = $(LIB_FLAGS) $(P_LIB) $(C_LIB) $(FP_LIB) $(RT_LIB)

}

%option	ERROR_WARNINGS
{
	C_FLAGS = $(C_FLAGS) --warnings-as-errors
	ASM_FLAGS = $(ASM_FLAGS) --warnings-as-errors
	LLNG_FLAGS = $(LLNG_FLAGS) --warnings-as-errors
}

%option NO_WARNINGS_NR
{
	C_FLAGS = $(C_FLAGS) --no-warnings=$(MATCH)
}

%option NO_WARNINGS
{
	C_FLAGS = $(C_FLAGS) --no-warnings
	ASM_FLAGS = $(ASM_FLAGS) --no-warnings
	LLNG_FLAGS = $(LLNG_FLAGS) --no-warnings
}

%option OUTPUT_FORMAT
{
	LLNG_OUTPUT_FLAGS = :$(MATCH)
	%switch $(MATCH)
	{
		%case "ihex" "IHEX"
		{
			LLNG_OUT = $(HEX_OUT)
		}
		%case "srec" "SREC"
		{
			LLNG_OUT = $(SREC_OUT)
		}
	}
	%if option(OUTPUT_ADDRSIZE)
	{
		LLNG_OUTPUT_FLAGS = $(LLNG_OUTPUT_FLAGS):option(OUTPUT_ADDRSIZE)
	}
	%if option(OUTPUT_SPACE)
	{
		LLNG_OUTPUT_FLAGS = $(LLNG_OUTPUT_FLAGS),option(OUTPUT_SPACE)
	}
}

%option PREPROCESS
{
	C_FLAGS = -E$(MATCH) $(C_FLAGS)
	CFE_OUT = pre
}

%option SYMBOLIC_DEBUG
{
	C_FLAGS = $(C_FLAGS) -g
	ASM_FLAGS = $(ASM_FLAGS) -g
}

%option KEEP_FILES
{
	# Not implemented in the C++ compiler
	C_FLAGS = $(C_FLAGS) -k
	ASM_FLAGS = $(ASM_FLAGS) -k
	LLNG_FLAGS = $(LLNG_FLAGS) -k
}

%option TRADEOFF
{
        C_FLAGS = $(C_FLAGS) -t$(MATCH)
}

%option	PASS_C
{
	C_FLAGS = $(C_FLAGS) $(MATCH)
}

%option	PASS_ASM
{
	ASM_FLAGS = $(ASM_FLAGS) $(MATCH)
}

%option	PASS_LLNG
{
	LLNG_FLAGS = $(LLNG_FLAGS) $(MATCH)
}

%option LSL_FILE
{
	DEFAULT_LSL_FLAG =
	LSL_FLAGS = $(LSL_FLAGS) -d$(MATCH)
}

%option	ASM_LISTFILE
{
	ASM_LIST_FILE = 1
	ASM_LIST_NAME = $(MATCH)
}

%if $(TARGET) == "nios"
{
	# Temporary: to avoid problems with the -Ox option
	LLNG_FLAGS = $(LLNG_FLAGS) -O0
}

%if $(TARGET) == "3000"
{
	# Temporary: to avoid problems with the -Ox option
	LLNG_FLAGS = $(LLNG_FLAGS) -O0
}

%if $(TARGET) == "ppc"
{
	# Temporary: to avoid problems with the -Ox option
	LLNG_FLAGS = $(LLNG_FLAGS) -O0
}

# non-control program options
#
# priority:     C compiler / Linker/Locator / Assembler
#
ASM_OPT_FILE	= opt-as$(TARGET).spec
LLNG_OPT_FILE	= opt-tll.spec


%if	$(TARGET) == "165x"
{
}



%set_option LLNG_FLAGS
{
# generated by opttool

	-N
	--no-rom-copy
	-O
	--optimize
	-R
	--relocatable
	-S
	--strip-debug
	-c
	--chip-output
	-d
	--lsl-file
	-e
	--extern
	-i
	--user-provided-initialization-code
	-m
	--map-file-format
	-r
	--incremental
	--case-insensitive
	--entry-point
	--first-library-first
	--link-only
	--lsl-check
	--lsl-dump
	--merge
	--metrics
	--misra-c-report
	--munch
	--no-rescan
	--non-romable
}



%if	$(TARGET) == "165x"
{
	%set_option ASM_FLAGS
	{
# generated by opttool

	-H
	--include-file
	-L
	--list-format
	-N
	--nested-sections
	-O
	--optimize
	-a
	--absolute-mode
	-c
	--case-insensitive
	-i
	--symbol-scope
	-m
	--preprocessor-type
	-t
	--section-info
	--check
	--emit-locals
	--fast
	--metrics
	--require-end
	--type-checking
	}
}


%if $(MAPFILE)
{
	LLNG_FLAGS = $(LLNG_FLAGS) -M
}

# get all input files
ALL_FILES = $(CPLUS_FILES) $(C_FILES) $(MIL_FILES) $(ASM_FILES)
%if count(ALL_FILES) == 1
{
	SINGLE_INPUT = 1
}


# actions
%action $(C_FILES)
{
	%if option(MIL)
	{
		OUT = output_file($(MATCH), $(MIL_OUT), $(SINGLE_INPUT), option(C_MIL))
	        $(CFE) $(C_FLAGS) --mil -o $(OUT) $(MATCH)

		%remove_file !option(C_MIL), $(OUT)

	        GEN_MIL_FILES = $(GEN_MIL_FILES) $(OUT)
	}
	%elif option(PREPROCESS)
	{
		OUT = output_file($(MATCH), $(CFE_OUT), $(SINGLE_INPUT), "1" )
	        $(CFE) $(C_FLAGS) $(STATIC_FLAGS) -o $(OUT) $(MATCH)

	}	
	%else
	{	
		OUT = output_file($(MATCH), $(CFE_OUT), $(SINGLE_INPUT), option(C_ASSEMBLY))
	        $(CFE) $(C_FLAGS) $(STATIC_FLAGS) -o $(OUT) $(MATCH)

		%remove_file !option(C_ASSEMBLY), $(OUT)

	        GEN_ASM_FILES = $(GEN_ASM_FILES) $(OUT)
	}
}

%stop option(C_MIL) || option(PREPROCESS)

%single_action $(MIL_FILES) $(GEN_MIL_FILES)
{
	OUT_FILE = output_file($(OUTPUT), $(CFE_OUT), $(SINGLE_INPUT), option(C_ASSEMBLY))

        $(CFE) $(C_FLAGS) $(STATIC_FLAGS) -o $(OUT_FILE) $(MATCH)

	%remove_file !option(C_ASSEMBLY), $(OUT_FILE)

        GEN_ASM_FILES = $(GEN_ASM_FILES) $(OUT_FILE)
}

%stop option(C_ASSEMBLY) || option(PREPROCESS)

%action $(ASM_FILES) $(GEN_ASM_FILES)
{
	OUT = output_file($(MATCH), $(ASM_OUT), $(SINGLE_INPUT), option(C_OBJECT))
	%if	$(ASM_LIST_FILE)
	{
		LST_NAME = ""
		%if	$(SINGLE_INPUT)
		{
			LST_NAME = $(ASM_LIST_NAME)
		}
		%if	! $(LST_NAME)
		{
			LST_NAME = output_file($(MATCH), $(ASM_LST), "1", "0")
		}
		ASM_LST_FLAGS = -l$(LST_NAME)
	}
	%else
	{
		ASM_LST_FLAGS = ""
	}

        $(ASM) $(ASM_FLAGS) $(ASM_LST_FLAGS) -o $(OUT) $(MATCH)

	%remove_file !option(C_OBJECT), $(OUT)

        GEN_OBJ_FILES = $(GEN_OBJ_FILES) $(OUT)
}

%stop option(C_OBJECT)

%single_action $(OBJ_FILES) $(GEN_OBJ_FILES)
{
        # Use variable OUTPUT to set the output name
	%if option(C_RELOCATION)
	{
		LLNG_FLAGS = --incremental $(LLNG_FLAGS)
		LLNG_OUT = $(LK_OUT)
	}
	OUT_FILE = output_file($(OUTPUT), $(LLNG_OUT), "1", "1" )
        $(LLNG) $(MATCH) -o $(OUT_FILE)$(LLNG_OUTPUT_FLAGS) $(DEFAULT_LSL_FLAG) $(LSL_FLAGS) $(LLNG_FLAGS) $(LIB_FLAGS) $(DUMMY)
}

#
# Local Variables:
# mode:			text
# fill-column:		120
# comment-start:	"#"
# End:
#
