<?xml version="1.0"?>
<tool_chain>
    <doil_version>1.1</doil_version>
    <name>TASKING CHC</name>
    <abbrev>hc</abbrev>
    <caption>TASKING CHC</caption>
    <bin_dir>chc\bin</bin_dir>
    <inc_dir>chc\include</inc_dir>
    <lib_dir>chc\lib</lib_dir>
    <obj_suffix>.c</obj_suffix>
    <include>global.tcc</include>
    <hide_dialog/>
    <global_scripts>
        Function getWorkDir : string;
        Begin
            If HwCompStandalone.Selected Then
                Result := '$(OUTDIR)'
            Else
                Result := '$(OUTDIR)\..';
        End;
        Function getTarget : string;
        Begin
           Result := 'hc'
        End;
        Function projVHDLFileName : string;
        Begin
           Result := getWorkDir + '\$(PROJ).vhd';
        End;
        Function projVerilogFileName : string;
        Begin
           Result := getWorkDir + '\$(PROJ).v';
        End;
    </global_scripts>
    <options>

        <group id="Compiler">
            <tool_id id_ref="CC"/>
            <caption>C Compiler</caption>
            <group id="CcPreprocessing">
                <caption>Preprocessing</caption>
                <tool_id id_ref="CC"/>
                <text id="Qualifiers">
                    <caption>Qualifier file</caption>
                    <default state="SELECTED"/>          
                    <tool_tip>This file is a qualifier file that inserts qualifiers into the code during pre processing.</tool_tip>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--qualifier-file="' + getWorkDir + '\$(PROJ).qua"');
                            DXP.AddToolDependency('"' + getWorkDir + '\$(PROJ).qua"', 'CC');
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_HwCompTargetExt">
                    <invisible/>
                    <default state="HwCompTargetExt"/>
                    <choice id="HwCompTargetExt">
                        <makefile_generator>
                            <selected>
                                DXP.SetPrjTargetExt('vhd');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <text id="HwCompIncDir">
                    <default state="SELECTED"/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(DXP.IncDir,';',' ','-I"','"') );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="HwCompAdditionalIncDir">
                    <default state=""/>
                    <invisible/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(HwCompAdditionalIncDir.State,';',' ','-I"','"') );
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_HwCompGlobalOptions">
                    <invisible/>
                    <default state="HwCompGlobalOptions"/>
                    <choice id="HwCompGlobalOptions">
                        <makefile_generator>
                            <selected>
                                // DXP.AddToolCmdOption('$toolref(tasking_chc_global)');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CompPrep">
                    <default state=""/>
                    <global/>
                    <choice id="CompPrep">
                        <caption>Store the C compiler preprocess output (&lt;file&gt;.pre)</caption>
                        <tool_tip>By default, the results of preprocessed files are deleted while compiling.<br/>
Select this option to store the results of the preprocessing phase in the output directory.<br/>
Preprocessed files have extension '.pre'.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToMakeFile('PREPROCESS');
                                DXP.AddGeneratedFile(DXP.ProjectDir + DXP.ProjectName + '.pre');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_HwCompNoStdInc">
                    <choice id="HwCompNoStdInc">
                    <caption>Skip the standard include files directory</caption>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--no-stdinc');
                        </selected>
                    </makefile_generator>
                    </choice>
                </choices>
                <table_edit id="CompDefine">
                    <caption>Defined symbols</caption>
                    <column column="Macro">
                        <text id="CMacro">
                            <caption>Macro</caption>
                        </text>
                    </column>
                    <column column="Value">
                        <text id="CValue">
                            <caption>Value</caption>
                        </text>
                    </column>
                    <text id="HwCompDefine_Loop">
                        <invisible/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-D' + CMacro.State + '="' + CValue.State + '"');
                            </selected>
                        </makefile_generator>
                    </text>
                </table_edit>
                <text id="CompSpecInc">
                    <caption>Pre-include files</caption>    
                    <button on_click="DXP.FileOpenDialog(CompSpecInc)"/>    
                    <default state=""/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-H"' + CompSpecInc.State + '"');
                        </selected>
                    </makefile_generator>
                </text>
            </group>
            <group id="CcLanguage">
                <caption>Language</caption>
                <tool_id id_ref="CC"/>
                <choices id="Choices_CompISO90">
                    <single/>
                    <caption>Comply to standard</caption>
                    <choice id="CompISO90">
                        <caption>ISO C90</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--iso=90');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompISO99">
                        <caption>ISO C99</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--iso=99');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <default state="CompISO99"/>
                </choices>
                <choices id="Choices_HwCompMode">
                    <default state="HwCompMode32Bit"/>
                    <single/>
                    <caption>Operating mode</caption>
                    <choice id="HwCompMode16Bit">
                        <caption>16-bit</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--integer-16bit');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="HwCompMode32Bit">
                        <caption>32-bit</caption>
                    </choice>
                </choices>
                <choices id="Choices_HwCompOnlyRtlQualified">
                    <default state="HwCompOnlyRtlQualfied"/>
                    <choice id="HwCompOnlyRtlQualfied">
                        <caption>Enable HW-SW mode</caption>
                        <makefile_generator>
                            <selected>DXP.AddToolCmdOption('--only-rtl-qualified');</selected>
                        </makefile_generator>
                    </choice>
                    <choice id="HwCompStandalone">
                        <caption>Standalone mode</caption>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Language extensions</caption>
                    <choices id="Choices_CompLanguageCpp">
                        <default state="CompLanguageCpp,CompLanguageVolatile"/>
                        <choice id="CompLanguageGnu">
                            <caption>Allow GNU C extensions</caption>
                            <tool_tip>Select this option to enable GNU C compiler language extensions</tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--language=+gcc');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompLanguageCpp">
                            <caption>Allow C++ style comments in ISO C90 mode</caption>
                            <tool_tip>In ISO C99 mode C++ comments are always accepted.<br/>
Select this option to allow C++ style comments (//) in ISO C90 mode.</tool_tip>
                            <generate_option if="CompISO90.Selected"/>
                            <makefile_generator>
                                <not_selected>
                                    DXP.AddToolCmdOption('--language=-comments');
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompLanguageStrings">
                            <caption>Check assignment of string literal to non-const string pointer</caption>
                            <tool_tip>The compiler generates a warning when you assign a constant string to a non-constant string pointer.</tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--language=-strings');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompLanguageVolatile">
                            <caption>Allow optimization across volatile access</caption>
                            <tool_tip>By default, the compiler will block optimization when reading or writing a volatile object, by treating the<br/>
access as a call to an unknown function.</tool_tip>
                            <makefile_generator>
                                <not_selected>
                                    DXP.AddToolCmdOption('--language=+volatile');
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <choices id="Choices_CompUnsignedChars">
                    <default state=""/>
                    <choice id="CompUnsignedChars">
                        <caption>Treat 'char' variables as unsigned</caption>
                        <tool_tip>By default, 'char' is the same as specifying 'signed char'.<br/>
Select this option to treat 'char' by default as 'unsigned char'.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--uchar');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompSignedBitfields">
                        <caption>Treat 'int' bit-fields as signed</caption>
                        <tool_tip>By default, an 'int' bit-field is treated as 'unsigned int'. This offers the best performance.<br/>
Select this option to treat 'int' bit-fields by default as 'signed int'.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--signed-bitfields');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_HwCompFastFloat">
                    <default state=""/>
                    <choice id="HwCompFastFloat">
                        <caption>Don't normalize/denormalize intermediate floating point results</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--fast-float');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_HwCompNoPartition">
                    <default state=""/>
                    <choice id="HwCompNoPartition">
                        <caption>Disable memory partitioning</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--no-partition');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_HwCompFloatSingle">
                    <default state=""/>
                    <generate_option if="Not HwCompFloatSingle.Selected"/>
                    <choice id="HwCompFloatSingle">
                        <caption>Treat double as float</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--no-double');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_HwCompNotStatic">
                    <default state=""/>
                    <choice id="HwCompStatic">
                        <caption>Don't treat external definitions as "static"</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--not-static');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CompIntegerEnumeration">
                    <choice id="CompIntegerEnumeration">
                        <caption>Treat enumerated types always as integer</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--integer-enumeration');
                            </selected>
                            <!-- small enumerated types are not supported by the TSK3000 compiler -->
                            <not_selected>
                                DXP.AddToolCmdOption('--integer-enumeration');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_HwCompNoAddressZeroReservation">
                     <choice id="HwCompNoAddressZeroReservation">
                         <caption>Disable address zero reservation</caption>
                         <makefile_generator>
                             <selected>
                                 DXP.AddToolCmdOption('--no-address-zero-reservation');
                             </selected>
                         </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_HwCompNoResourceSharing">
                     <choice id="HwCompNoResourceSharing">
                         <caption>Disable the automatic resource sharing in the binder.</caption>
                         <makefile_generator>
                             <selected>
                                 DXP.AddToolCmdOption('--no-resource-sharing');
                             </selected>
                         </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_HwCompNoChaining">
                     <choice id="HwCompNoChaining">
                         <caption>Disable the combinatorial chaining of operations together in one state.</caption>
                         <makefile_generator>
                             <selected>
                                 DXP.AddToolCmdOption('--no-chaining');
                             </selected>
                         </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_HwCompShareConstant">
                     <choice id="HwCompShareConstant">
                         <caption>Disable the generation of special dedicated resources for operation with constants.</caption>
                         <makefile_generator>
                             <selected>
                                 DXP.AddToolCmdOption('--share-constant');
                             </selected>
                         </makefile_generator>
                    </choice>
                </choices>
		<choices id="Choices_HwCompJtagDebugInterface">
		    <choice id="HwCompJtagDebugInterface">
			<caption>Generate a Jtag port for debug input and output.</caption>
			<makefile_generator>
			     <selected>
				 DXP.addToolCmdOption('--jtag');
			     </selected>
			</makefile_generator>
		    </choice>
                </choices>
		<choices id="Choices_HwCompJtagLossless">
		    <choice id="HwCompJtagLossless">
			<caption>Use lossless comminucation on the Jtag debug console.</caption>
			<makefile_generator>
			     <selected>
				 DXP.addToolCmdOption('--jtag=+lossless');
			     </selected>
			</makefile_generator>
		    </choice>
		</choices>
		<text id="HwCompJtagBufferDepth">
			<caption>Specify the depth of the Jtag debug buffer.</caption>
			<makefile_generator>
			     <selected>
				 DXP.addToolCmdOption('--jtag-buffer-depth=' + HwCompJtagBufferDepth.State);
			     </selected>
			</makefile_generator>
		 </text>
	         <text id="HwCompJtagBufferWidth">
			<caption>Specify the width of the Jtag debug buffer.</caption>
			<makefile_generator>
			     <selected>
				 DXP.addToolCmdOption('--jtag-buffer-width=' +  HwCompJtagBufferWidth.State);
			     </selected>
			</makefile_generator>
		</text>
                <choices id="Choices_HwCompEasyDebug">
                     <choice id="HwCompEasyDebug">
                         <caption>Instruct the compiler to try to generate code that is close to the C source code.</caption>
                         <makefile_generator>
                             <selected>
                                 DXP.AddToolCmdOption('--easy-debug');
                             </selected>
                         </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="CcCodeGeneration">
                <caption>Code Generation</caption>
                <tool_id id_ref="CC"/>
                <subgroup>
                    <caption>Composite types</caption>
                    <choices id="CompAlignComposites">
                        <single/>
                        <caption>Alignment of composite types</caption>
                        <tool_tip>Set the alignment for composite types (structs, unions and arrays).<br/>
Natural alignment will set the alignment to the natural alignment of the most strictly aligned member of the composite type.<br/>
For example: a character array will be byte-aligned.<br/>
Optimal alignment will set the alignment to 1, 2, or 4 bytes depending on the size of the composite type. The alignment will be optimal in the sense that the compiler will generate more efficient access code.<br/>
For example: a character array will be word-aligned (4 bytes).</tool_tip>
                        <default state="CompACNatural"/>
                        <choice id="CompACNatural">
                            <caption>Natural alignment</caption>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--align-composites=n');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompACOptimal">
                            <caption>Optimal alignment</caption>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--align-composites=o');
                                </selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <subgroup>
                    <caption>Software/Hardware Compatibility</caption>
                    <text id="HwCompCoreCompatibility">
                        <invisible/>
                        <default state=""/>
                        <generate_option if="HwCompOnlyRtlQualfied.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption( '--core-compatibility=c' + HwCompCoreCompatibility.State );
                            </selected>
                        </makefile_generator>
                    </text>
                    <choices id="Choices_BigEndian">
                        <!-- Only used by the Arm which has a big-endian option -->
                        <invisible/>
                        <default state=""/>
                        <choice id="BigEndian">
                            <global/>
                        </choice>
                    </choices>
                    <text id="HwCompEndianness">
                        <invisible/>
                        <default state=""/>
                        <freeze_State if="BigEndian.Selected" state="big"/>
                        <makefile_generator>
                            <selected>
                                HwCompEndianness.Flag := '--endianness=' + HwCompEndianness.State;
                                DXP.AddToolCmdOption( HwCompEndianness.Flag );
                            </selected>
                        </makefile_generator>
                    </text>
                </subgroup>
                <subgroup>
                    <caption>Target</caption>
                    <text id="HwCompTargetDevice">
                        <caption>Target device</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--target-device=' + HwCompTargetDevice.State);
                            </selected>
                        </makefile_generator>
                    </text>
                    <text id="HwCompResourceDefinition">
                        <caption>Resource definitions</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--resource-definition="' + HwCompResourceDefinition.State +'"');
                            </selected>
                        </makefile_generator>
                        <button on_click="DXP.FileOpenDialog(HwCompResourceDefinition);"/>
                    </text>
                </subgroup>
                <subgroup>
                    <caption>Output Files</caption>
                    <text id="HwCompHasm">
                        <caption>HASM</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-o ' + HwCompHasm.State);
                            </selected>
                        </makefile_generator>
                        <button on_click="DXP.FileOpenDialog(HwCompHasm);"/>        
                    </text>
                    <text id="HwCompMetadata">
                        <caption>Metadata</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--metadata=' + HwCompMetadata.State);
                            </selected>
                        </makefile_generator>
                        <button on_click="DXP.FileOpenDialog(HwCompMetadata);"/>        
                    </text>
                    <text id="HwCompRedefineQualifiers">
                        <caption>Qualifier redefine file</caption>
                        <makefile_generator>
                            <selected>
                                 DXP.AddToolCmdOption('--redefine-qualifiers=' + HwCompRedefineQualifiers.State);
                            </selected>
                        </makefile_generator>
                        <button on_click="DXP.FileOpenDialog(HwCompRedefineQualifiers);"/>
                    </text>
                </subgroup>    
            </group>
            <group id="CcOptimization">
                <caption>Optimization</caption>
                <tool_id id_ref="CC"/>
                <choices id="HwCompOptim">
                    <single/>
                    <caption>Optimization level</caption>
                    <tool_tip>Optimizing for speed and or code size is at the cost of debugging ease.<br/>
Select a predefined set of optimizations or select 'Custom optimization' to enable individual optimizations.<br/>
Select 'Full optimization' for the final application.</tool_tip>
                    <default state="HwCompOL2"/>
                    <choice id="HwCompOL0">
                        <caption>No optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-O0');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="HwCompOL1">
                        <caption>Few optimizations</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-O1');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="HwCompOL2">
                        <caption>Medium optimization (default)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-O2');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="HwCompOL3">
                        <caption>Full optimization</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('-O3');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="HwCompOLAdv">
                        <caption>Custom optimization</caption>
                    </choice>
                </choices>
                <choices id="HwCompTrade">
                    <single/>
                    <caption>Size/speed trade-off</caption>
                    <tool_tip>Determines how the individual optimizations work.<br/>
Select a trade-off to optimize for speed (at the cost of size) or vice versa.</tool_tip>
                    <default state="Trade00"/>
                    <choice id="Trade00">
                        <caption>Level 0 (fully optimize for speed)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=0');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Trade01">
                        <caption>Level 1</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=1');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Trade02">
                        <caption>Level 2</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=2');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Trade03">
                        <caption>Level 3</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=3');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="Trade04">
                        <caption>Level 4 (fully optimize for size)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--tradeoff=4');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Custom optimization</caption>                    
                    <choices id="Choices_HwCompOL">
                        <default state="HwCompOLa,HwCompOLb,HwCompOLc,HwCompOLd,HwCompOLe,HwCompOLf,HwCompOLg,HwCompOLk,HwCompOLl,HwCompOLm,HwCompOLo,HwCompOLp,HwCompOLq,HwCompOLs,HwCompOLt,HwCompOLv,HwCompOLw,HwCompOLy"/>
                        <choice id="HwCompOLa">
                            <caption>Coalescer</caption>
                            <tool_tip>Removes unnecessary MOVE instructions.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLa.Flag := 'a';
                                </selected>
                                <not_selected>
                                    HwCompOLa.Flag := 'A';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLb">
                            <caption>Output parameters</caption>
                            <tool_tip>Try to treat pointer parameters as extra return values.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLa.Flag := 'b';
                                </selected>
                                <not_selected>
                                    HwCompOLa.Flag := 'B';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLc">
                            <caption>Common subexpression elimination (CSE)</caption>
                            <tool_tip>Avoids recalculation of identical expressions.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLc.Flag := 'c';
                                </selected>
                                <not_selected>
                                    HwCompOLc.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLd">
                            <caption>Predicate optimizations</caption>
                            <tool_tip>Tries to simplify predicate expressions.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLc.Flag := 'd';
                                </selected>
                                <not_selected>
                                    HwCompOLc.Flag := 'D';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLe">
                            <caption>Expression simplification</caption>
                            <tool_tip>Removes useless expressions introduced by macros or by the compiler (for example, multiplications by 1 or 0).</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLe.Flag := 'e';
                                </selected>
                                <not_selected>
                                    HwCompOLe.Flag := 'E';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLf">
                            <caption>Control flow simplification</caption>
                            <tool_tip>Simplifies the program flow by removing unnecessary code and reducing the number of jumps.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLf.Flag := 'f';
                                </selected>
                                <not_selected>
                                    HwCompOLf.Flag := 'F';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLg">
                            <caption>Generic assembly code optimizations</caption>
                            <tool_tip>A set of target independent optimizations that increase speed and decrease code size.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLg.Flag := 'g';
                                </selected>
                                <not_selected>
                                    HwCompOLg.Flag := 'G';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLi">
                            <caption>Automatic function inlining</caption>
                            <tool_tip>Small fuctions that are not too often called, are inlined to save function calls.<br/>
Below, you can refine this inline optimization.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLi.Flag := 'i';
                                </selected>
                                <not_selected>
                                    HwCompOLi.Flag := 'I';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLk">
                            <caption>Scheduler</caption>
                            <tool_tip>Rearranges assembly instructions.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLk.Flag := 'k';
                                </selected>
                                <not_selected>
                                    HwCompOLk.Flag := 'K';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLl">
                            <caption>Loop transformations</caption>
                            <tool_tip>Rearranges loop constructions to improve possibilities for 'Constant propagation' and 'Common subexpression elimination'.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLl.Flag := 'l';
                                </selected>
                                <not_selected>
                                    HwCompOLl.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLm">
                            <caption>SIMD optimizations</caption>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLo.Flag := 'm';
                                </selected>
                                <not_selected>
                                    HwCompOLo.Flag := 'M';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLo">
                            <caption>Forward store</caption>
                            <tool_tip>Uses a temporary variable to cache multiple assignments (stores) to the same non-automatic variable.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLo.Flag := 'o';
                                </selected>
                                <not_selected>
                                    HwCompOLo.Flag := 'O';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLp">
                            <caption>Constant propagation</caption>
                            <tool_tip>Replaces variables with known values by those values.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLp.Flag := 'p';
                                </selected>
                                <not_selected>
                                    HwCompOLp.Flag := 'P';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLq">
                            <caption>Speculation</caption>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLp.Flag := 'q';
                                </selected>
                                <not_selected>
                                    HwCompOLp.Flag := 'Q';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLs">
                            <caption>Subscript strength reduction</caption>
                            <tool_tip>An array of pointers subscripted with a loop iterator variable, is replaced by the dereference of a pointer that is updated whenever the iterator is updated.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLs.Flag := 's';
                                </selected>
                                <not_selected>
                                    HwCompOLs.Flag := 'S';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLt">
                            <caption>Expression tree reordening</caption>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLs.Flag := 't';
                                </selected>
                                <not_selected>
                                    HwCompOLs.Flag := 'T';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLu">
                            <caption>Unroll small loops</caption>
                            <tool_tip>Reduces the number of branches: short loops are eliminated by replacing them with a number of copies.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLu.Flag := 'u';
                                </selected>
                                <not_selected>
                                    HwCompOLu.Flag := 'U';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLv">
                            <caption>Convert IF statements using predicates</caption>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLs.Flag := 'v';
                                </selected>
                                <not_selected>
                                    HwCompOLs.Flag := 'V';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLw">
                            <caption>Software pipelining</caption>
                            <tool_tip>Various loop optimizations.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLw.Flag := 'w';
                                </selected>
                                <not_selected>
                                    HwCompOLw.Flag := 'W';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="HwCompOLy">
                            <caption>Peephole optimizer (remove redundant code)</caption>
                            <tool_tip>Improves the generated assembly by replacing instruction sequences by equivalent but faster and/or shorter sequences, or by deleting unnecessary instructions.</tool_tip>
                            <generate_option if="HwCompOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    HwCompOLy.Flag := 'y';
                                </selected>
                                <not_selected>
                                    HwCompOLy.Flag := 'Y';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <text id="HwCompOLAdv_Script"> 
                    <invisible/>
                    <generate_option if="HwCompOLAdv.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('--optimize=' + HwCompOLa.Flag + HwCompOLc.Flag + HwCompOLe.Flag + HwCompOLf.Flag + HwCompOLg.Flag + HwCompOLh.Flag + HwCompOLi.Flag
+ HwCompOLk.Flag
+ HwCompOLl.Flag + HwCompOMo.Flag + HwCompOLo.Flag + HwCompOLp.Flag + HwCompOLq.Flag
+ HwCompOLs.Flag + HwCompOLt.Flag
+ HwCompOLu.Flag
+ HwCompOLv.Flag 
+ HwCompOLw.Flag
+ HwCompOLy.Flag );
                        </selected>
                    </makefile_generator>
                </text>
                <subgroup>
                    <caption>Refine inlining optimization</caption>
                    <choices id="Choices_HwCompOptimInline">
                    <default state=""/>
                        <choice id="HwCompOptimInline">
                            <caption>Always inline function calls</caption>
                            <tool_tip>With this option you instruct the compiler to inline calls to functions without the <pre>__noinline</pre> function<br/>
qualifier whenever possible.<br/>
                            </tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('-Wc--inline');
                                </selected>
                           </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
            </group>

            <group id="MISRAC">
                <caption>MISRA-C</caption>
                <tool_id id_ref="CC"/>
                <choices id="Choices_MISRACChecking">
                    <caption>MISRA-C checking</caption>
                    <tool_tip>The compiler can check the C source against MISRA-C rules.<br/>
Select against which MISRA-C rules the C source should be checked.<br/>
If you select 'Custom configuration', select or clear individual rules on the 'Custom configuration' page.</tool_tip>
                    <single/>
                    <default state="MISRACDisabled"/>
                    <choice id="MISRACDisabled">
                        <caption>Disabled</caption>
                    </choice>
                    <choice id="MISRACMisra">
                        <caption>Supported required rules only</caption>
                        <makefile_generator>
                            <selected>
                                if MISRAC1998.Selected then
                                    MISRACCustom.Flag := '1,5,7,8,9,11,14,16,17,19,20,21,24,26,29,30,31,32,33,34,35,37,38,39,42,43,45,46,50,52,53,54,56,57,58,59,61,62,64,65,68,69,70,71,72,73,74,75,76,77,78,79,80,83,84,87,88,89,90,91,94,95,96,98,99,100,103,104,105,106,107,108,109,110,111,112,113,114,115,118,119,120,121,122,123,124,125,126,127';
                                if MISRAC2004.Selected then
                                    MISRACCustom.Flag := '1.1,1.2,2.1,2.2,2.3,3.4,3.5,4.1,4.2,5.1,5.2,5.3,5.4,6.1,6.2,6.4,6.5,7.1,8.1,8.2,8.3,8.4,8.5,8.6,8.7,8.8,8.9,8.11,8.12,9.1,9.2,9.3,10.1,10.2,10.3,10.4,10.5,10.6,11.1,11.2,11.5,12.2,12.3,12.4,12.5,12.7,12.8,12.9,12.10,12.12,13.1,13.3,13.4,13.5,13.6,13.7,14.1,14.2,14.3,14.4,14.5,14.6,14.7,14.8,14.9,14.10,15.1,15.2,15.3,15.4,15.5,16.1,16.2,16.3,16.4,16.5,16.6,16.8,16.9,16.10,17.3,17.4,17.6,18.1,18.2,18.4,19.3,19.4,19.5,19.6,19.8,19.9,19.10,19.11,19.12,19.14,19.15,19.16,19.17,20.1,20.2,20.4,20.5,20.6,20.7,20.8,20.9,20.10,20.11,20.12';
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="MISRACAll">
                        <caption>Supported required and advisory rules</caption>
                        <makefile_generator>
                            <selected>
                                if MISRAC1998.Selected then
                                    MISRACCustom.Flag := '1,3,5,7,8,9,10,11,12,13,14,16,17,18,19,20,21,22,24,26,28,29,30,31,32,33,34,35,36,37,38,39,40,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,118,119,120,121,122,123,124,125,126,127';
                                if MISRAC2004.Selected then
                                    MISRACCustom.Flag := '1.1,1.2,2.1,2.2,2.3,2.4,3.4,3.5,4.1,4.2,5.1,5.2,5.3,5.4,5.5,5.6,5.7,6.1,6.2,6.3,6.4,6.5,7.1,8.1,8.2,8.3,8.4,8.5,8.6,8.7,8.8,8.9,8.11,8.12,9.1,9.2,9.3,10.1,10.2,10.3,10.4,10.5,10.6,11.1,11.2,11.3,11.4,11.5,12.1,12.2,12.3,12.4,12.5,12.6,12.7,12.8,12.9,12.10,12.11,12.12,12.13,13.1,13.2,13.3,13.4,13.5,13.6,13.7,14.1,14.2,14.3,14.4,14.5,14.6,14.7,14.8,14.9,14.10,15.1,15.2,15.3,15.4,15.5,16.1,16.2,16.3,16.4,16.5,16.6,16.7,16.8,16.9,16.10,17.3,17.4,17.5,17.6,18.1,18.2,18.4,19.1,19.2,19.3,19.4,19.5,19.6,19.7,19.8,19.9,19.10,19.11,19.12,19.13,19.14,19.15,19.16,19.17,20.1,20.2,20.4,20.5,20.6,20.7,20.8,20.9,20.10,20.11,20.12';
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="MISRACCustom">
                        <caption>Custom configuration</caption>
                    </choice>
                </choices>
                <choices id="Choices_MISRACVersion">
                    <caption>MISRA-C version</caption>
                    <tool_tip>select MISRA-C version: 1998 or 2004.</tool_tip>
                    <generate_option if="NOT MISRACDisabled.Selected"/>
                    <single/>
                    <default state="MISRAC2004"/>
                    <choice id="MISRAC2004">
                        <caption>2004</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--misrac-version=2004');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="MISRAC1998">
                        <caption>1998</caption>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--misrac-version=1998');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_MISRACReport">
                    <default state="MISRACReport"/>
                    <choice id="MISRACReport">
                        <caption>Produce a MISRA-C report</caption>
                        <tool_tip>The MISRA-C Quality Assurance report lists the various modules in the project with the respective MISRA-C settings at the time of compilation.<br/>
Select this option to generate a report.<br/>
The report is stored in the ouput directory and named after your project with exension '.mcr'</tool_tip>
                        <generate_option if="NOT MISRACDisabled.Selected"/>
                    </choice>
                </choices>
                <text id="MISRACNotImplemented">
                    <invisible/>
                    <default state="NOTSELECTED"/>
                </text>
                <subgroup>
                    <caption>Diagnostics</caption>
                    <choices id="Choices_MISRACAWarnings">
                        <default state=""/>
                        <choice id="CompMISRACAdvisoryWarnings">
                            <caption>Turn advisory rule violation into warning</caption>
                            <tool_tip>Normally, if an advisory rule is violated, the compiler generates an error. As a consequence, no output files are generated.<br/>
Select this option to generate warnings instead of errors.</tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--misrac-advisory-warnings');
                                </selected>
                            </makefile_generator>
                        </choice>
                        <choice id="CompMISRACRequiredWarnings">
                            <caption>Turn required rule violation into warning</caption>
                            <tool_tip>Normally, if a required rule is violated, the compiler generates an error. As a consequence, no output files are generated.<br/>
Select this option to generate warnings instead of errors.</tool_tip>
                            <makefile_generator>
                                <selected>
                                    DXP.AddToolCmdOption('--misrac-required-warnings');
                                </selected>
                             </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
                <group id="MISRAC1998Rules">
                    <caption>Custom Configuration 1998</caption>
                    <tool_id id_ref="CC"/>
                    <generate_option if="MISRACCustom.Selected AND MISRAC1998.Selected"/>
                    <subgroup>
                        <caption>Environment</caption>
                        <choices id="Choices_1998_Environment">
                            <default state="Choise_1998_1"/>
                            <choice id="Choise_1998_1">
                                <caption>1. [R] The code shall conform to standard C, without language extensions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_2">
                                <caption>2. [A] Other languages should only be used with an interface standard</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_3">
                                <caption>3. [A] Inline assembly is only allowed in dedicated C functions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_4">
                                <caption>4. [A] Provision should be made for appropriate run-time checking</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '4';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Character Sets</caption>
                        <choices id="Choices_1998_Character_Sets">
                            <default state="Choise_1998_5,Choise_1998_6,Choise_1998_7,Choise_1998_8"/>
                            <choice id="Choise_1998_5">
                                <caption>5. [R] Only use characters and escape sequences defined by ISO C</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_6">
                                <caption>6. [R] Character values shall be restricted to a subset of ISO 106460-1</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_7">
                                <caption>7. [R] Trigraphs shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_8">
                                <caption>8. [R] Multibyte characters and wide string literals shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Comments</caption>
                        <choices id="Choices_1998_Comments">
                            <default state="Choise_1998_9"/>
                            <choice id="Choise_1998_9">
                                <caption>9. [R] Comments shall not be nested</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_10">
                                <caption>10. [A] Sections of code should not be "commented out"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Identifiers</caption>
                        <choices id="Choices_1998_Identifiers">
                            <default state="Choise_1998_11"/>
                            <choice id="Choise_1998_11">
                                <caption>11. [R] Identifiers shall not rely on significance of more than 31 characters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_12">
                                <caption>12. [A] The same identifier shall not be used in multiple name spaces</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Types</caption>
                        <choices id="Choices_1998_Types">
                            <default state="Choise_1998_14,Choise_1998_16,Choise_1998_17"/>
                            <choice id="Choise_1998_13">
                                <caption>13. [A] Specific-length typedefs should be used instead of the basic types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_14">
                                <caption>14. [R] Use "unsigned char" or "signed char" instead of plain "char"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_15">
                                <caption>15. [A] Floating point implementations should comply with a standard</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_16">
                                <caption>16. [R] The bit representation of floating point numbers shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_17">
                                <caption>17. [R] "typedef" names shall not be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Constants</caption>
                        <choices id="Choices_1998_Constants">
                            <default state="Choise_1998_19"/>
                            <choice id="Choise_1998_18">
                                <caption>18. [A] Numeric constants should be suffixed to indicate type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_19">
                                <caption>19. [R] Octal constants (other than zero) shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Declarations and Definitions</caption>
                        <choices id="Choices_1998_Declarations_and_Definitions">
                            <default state="Choise_1998_20,Choise_1998_21,Choise_1998_24,Choise_1998_25,Choise_1998_26,Choise_1998_29"/>
                            <choice id="Choise_1998_20">
                                <caption>20. [R] All object and function identifiers shall be declared before use</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_21">
                                <caption>21. [R] Identifiers shall not hide identifiers in an outer scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '21';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_22">
                                <caption>22. [A] Declarations should be at function scope where possible</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '22';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_23">
                                <caption>23. [A] All declarations at file scope should be static where possible</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '23';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_24">
                                <caption>24. [R] Identifiers shall not have both internal and external linkage</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '24';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_25">
                                <caption>25. [R] Identifiers with external linkage shall have exactly one definition</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '25';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_26">
                                <caption>26. [R] Multiple declarations for objects or functions shall be compatible</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '26';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_27">
                                <caption>27. [A] External objects should not be declared in more than one file</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '27';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_28">
                                <caption>28. [A] The "register" storage class specifier should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '28';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_29">
                                <caption>29. [R] The use of a tag shall agree with its declaration</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '29';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Initialization</caption>
                        <choices id="Choices_1998_Initialization">
                            <default state="Choise_1998_30,Choise_1998_31,Choise_1998_32"/>
                            <choice id="Choise_1998_30">
                                <caption>30. [R] All automatics shall be initialized before being used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '30';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_31">
                                <caption>31. [R] Braces shall be used in the initialization of arrays and structures</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '31';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_32">
                                <caption>32. [R] Only the first, or all enumeration constants may be initialized</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '32';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Operators</caption>
                        <choices id="Choices_1998_Operators">
                            <default state="Choise_1998_33,Choise_1998_34,Choise_1998_35,Choise_1998_37,Choise_1998_38,Choise_1998_39,Choise_1998_42"/>
                            <choice id="Choise_1998_33">
                                <caption>33. [R] The right hand operand of &amp;&amp; or || shall not contain side effects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '33';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_34">
                                <caption>34. [R] The operands of a logical &amp;&amp; or || shall be primary expressions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '34';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_35">
                                <caption>35. [R] Assignment operators shall not be used in Boolean expressions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '35';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_36">
                                <caption>36. [A] Logical operators should not be confused with bitwise operators</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '36';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_37">
                                <caption>37. [R] Bitwise operations shall not be performed on signed integers</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '37';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_38">
                                <caption>38. [R] A shift count shall be between 0 and the operand width minus 1</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '38';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_39">
                                <caption>39. [R] The unary minus shall not be applied to an unsigned expression</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '39';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_40">
                                <caption>40. [A] "sizeof" should not be used on expressions with side effects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '40';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_41">
                                <caption>41. [A] The implementation of integer division should be documented</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '41';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_42">
                                <caption>42. [R] The comma operator shall only be used in a "for" condition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '42';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Conversions</caption>
                        <choices id="Choices_1998_Conversions">
                            <default state="Choise_1998_43,Choise_1998_45"/>
                            <choice id="Choise_1998_43">
                                <caption>43. [R] Don't use implicit conversions which may result in information loss</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '43';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_44">
                                <caption>44. [A] Redundant explicit casts should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '44';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_45">
                                <caption>45. [R] Type casting from any type to or from pointers shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '45';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Expressions</caption>
                        <choices id="Choices_1998_Expressions">
                            <default state="Choise_1998_46,Choise_1998_50"/>
                            <choice id="Choise_1998_46">
                                <caption>46. [R] The value of an expression shall be evaluation order independent</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '46';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_47">
                                <caption>47. [A] No dependence should be placed on operator precedence rules</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '47';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_48">
                                <caption>48. [A] Mixed arithmetic should use explicit casting</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '48';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_49">
                                <caption>49. [A] Tests of a (non-Boolean) value against 0 should be made explicit</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '49';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_50">
                                <caption>50. [R] F.P. variables shall not be tested for exact equality or inequality</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '50';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_51">
                                <caption>51. [A] Constant unsigned integer expressions should not wrap-around</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '51';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Control Flow</caption>
                        <choices id="Choices_1998_Control_Flow">
                            <default state="Choise_1998_52,Choise_1998_53,Choise_1998_54,Choise_1998_56,Choise_1998_57,Choise_1998_58,Choise_1998_59,Choise_1998_61,Choise_1998_62,Choise_1998_64,Choise_1998_65"/>
                            <choice id="Choise_1998_52">
                                <caption>52. [R] There shall be no unreachable code</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '52';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_53">
                                <caption>53. [R] All non-null statements shall have a side-effect</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '53';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_54">
                                <caption>54. [R] A null statement shall only occur on a line by itself</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '54';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_55">
                                <caption>55. [A] Labels should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '55';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_56">
                                <caption>56. [R] The "goto" statement shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '56';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_57">
                                <caption>57. [R] The "continue" statement shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '57';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_58">
                                <caption>58. [R] The "break" statement shall not be used (except in a "switch")</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '58';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_59">
                                <caption>59. [R] An "if" or loop body shall always be enclosed in braces</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '59';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_60">
                                <caption>60. [A] All "if", "else if" constructs should contain a final "else"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '60';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_61">
                                <caption>61. [R] Every non-empty "case" clause shall be terminated with a "break"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '61';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_62">
                                <caption>62. [R] All "switch" statements should contain a final "default" case</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '62';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_63">
                                <caption>63. [A] A "switch" expression should not represent a Boolean case</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '63';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_64">
                                <caption>64. [R] Every "switch" statement shall have at least one "case"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '64';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_65">
                                <caption>65. [R] Floating point variables shall not be used as loop counters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '65';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_66">
                                <caption>66. [A] A "for" should only contain expressions concerning loop control</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '66';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_67">
                                <caption>67. [A] Iterator variables should not be modified in a "for" loop</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '67';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Functions</caption>
                        <choices id="Choices_1998_Functions">
                            <default state="Choise_1998_68,Choise_1998_69,Choise_1998_70,Choise_1998_71,Choise_1998_72,Choise_1998_73,Choise_1998_74,Choise_1998_75,Choise_1998_76,Choise_1998_77,Choise_1998_78,Choise_1998_79,Choise_1998_80,Choise_1998_83,Choise_1998_84"/>
                            <choice id="Choise_1998_68">
                                <caption>68. [R] Functions shall always be declared at file scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '68';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_69">
                                <caption>69. [R] Functions with variable numbers of arguments shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '69';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_70">
                                <caption>70. [R] Functions shall not call themselves, either directly or indirectly</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '70';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_71">
                                <caption>71. [R] Function prototypes shall be visible at the definition and call</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '71';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_72">
                                <caption>72. [R] The function prototype of the declaration shall match the definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '72';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_73">
                                <caption>73. [R] Identifiers shall be given for all prototype parameters or for none</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '73';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_74">
                                <caption>74. [R] Parameter identifiers shall be identical for declaration/definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '74';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_75">
                                <caption>75. [R] Every function shall have an explicit return type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '75';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_76">
                                <caption>76. [R] Functions with no parameters shall have a "void" parameter list</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '76';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_77">
                                <caption>77. [R] An actual parameter type shall be compatible with the prototype</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '77';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_78">
                                <caption>78. [R] The number of actual parameters shall match the prototype</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '78';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_79">
                                <caption>79. [R] The values returned by "void" functions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '79';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_80">
                                <caption>80. [R] Void expressions shall not be passed as function parameters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '80';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_81">
                                <caption>81. [A] "const" should be used for reference parameters not modified</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '81';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_82">
                                <caption>82. [A] A function should have a single point of exit</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '82';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_83">
                                <caption>83. [R] Every exit point shall have a "return" of the declared return type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '83';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_84">
                                <caption>84. [R] For "void" functions, "return" shall not have an expression</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '84';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_85">
                                <caption>85. [A] Function calls with no parameters should have empty parentheses</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '85';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_86">
                                <caption>86. [A] If a function returns error information, it should be tested</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '86';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Pre-processing Directives</caption>
                        <choices id="Choices_1998_Pre_processing_Directives">
                            <default state="Choise_1998_87,Choise_1998_88,Choise_1998_89,Choise_1998_90,Choise_1998_91,Choise_1998_94,Choise_1998_95,Choise_1998_96,Choise_1998_98,Choise_1998_99,Choise_1998_100"/>
                            <choice id="Choise_1998_87">
                                <caption>87. [R] #include shall only be preceded by other directives or comments</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '87';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_88">
                                <caption>88. [R] Non-standard characters shall not occur in #include directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '88';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_89">
                                <caption>89. [R] #include shall be followed by either &lt;filename&gt; or "filename"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '89';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_90">
                                <caption>90. [R] Plain macros shall only be used for constants/qualifiers/specifiers</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '90';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_91">
                                <caption>91. [R] Macros shall not be #define'd and #undef'd within a block</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '91';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_92">
                                <caption>92. [A] #undef should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '92';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_93">
                                <caption>93. [A] A function should be used in preference to a function-like macro</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '93';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_94">
                                <caption>94. [R] A function-like macro shall not be used without all arguments</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '94';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_95">
                                <caption>95. [R] Macro arguments shall not contain pre-preprocessing directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '95';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_96">
                                <caption>96. [R] Macro definitions/parameters should be enclosed in parentheses</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '96';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_97">
                                <caption>97. [A] Don't use undefined identifiers in pre-processor directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '97';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_98">
                                <caption>98. [R] A macro definition shall contain at most one # or ## operator</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '98';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_99">
                                <caption>99. [R] All uses of the #pragma directive shall be documented</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '99';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_100">
                                <caption>100. [R] "defined" shall only be used in one of the two standard forms</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '100';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Pointers and Arrays</caption>
                        <choices id="Choices_1998_Pointers_and_Arrays">
                            <default state="Choise_1998_103,Choise_1998_104,Choise_1998_105,Choise_1998_106,Choise_1998_107"/>
                            <choice id="Choise_1998_101">
                                <caption>101. [A] Pointer arithmetic should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '101';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_102">
                                <caption>102. [A] No more than 2 levels of pointer indirection should be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '102';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_103">
                                <caption>103. [R] No relational operators between pointers to different objects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '103';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_104">
                                <caption>104. [R] Non-constant pointers to functions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '104';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_105">
                                <caption>105. [R] Functions assigned to the same pointer shall be of identical type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '105';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_106">
                                <caption>106. [R] Automatic address may not be assigned to a longer lived object</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '106';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_107">
                                <caption>107. [R] The null pointer shall not be de-referenced</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '107';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Structures and Unions</caption>
                        <choices id="Choices_1998_Structures_and_Unions">
                            <default state="Choise_1998_108,Choise_1998_109,Choise_1998_110,Choise_1998_111,Choise_1998_112,Choise_1998_113"/>
                            <choice id="Choise_1998_108">
                                <caption>108. [R] All struct/union members shall be fully specified</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '108';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_109">
                                <caption>109. [R] Overlapping variable storage shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '109';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_110">
                                <caption>110. [R] Unions shall not be used to access the sub-parts of larger types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '110';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_111">
                                <caption>111. [R] Bit fields shall have type "unsigned int" or "signed int"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '111';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_112">
                                <caption>112. [R] Bit fields of type "signed int" shall be at least 2 bits long</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '112';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_113">
                                <caption>113. [R] All struct/union members shall be named</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '113';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>Standard Libraries</caption>
                        <choices id="Choices_1998_Standard_Libraries">
                            <default state="Choise_1998_114,Choise_1998_115,Choise_1998_116,Choise_1998_117,Choise_1998_118,Choise_1998_119,Choise_1998_120,Choise_1998_121,Choise_1998_122,Choise_1998_123,Choise_1998_124,Choise_1998_125,Choise_1998_126,Choise_1998_127"/>
                            <choice id="Choise_1998_114">
                                <caption>114. [R] Reserved and standard library names shall not be redefined</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '114';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_115">
                                <caption>115. [R] Standard library function names shall not be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '115';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_116">
                                <caption>116. [R] Production libraries shall comply with the MISRA-C restrictions</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '116';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_117">
                                <caption>117. [R] The validity of library function parameters shall be checked</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '117';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_118">
                                <caption>118. [R] Dynamic heap memory allocation shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '118';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_119">
                                <caption>119. [R] The error indicator "errno" shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '119';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_120">
                                <caption>120. [R] The macro "offsetof" shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '120';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_121">
                                <caption>121. [R] &lt;locale.h&gt; and the "setlocale" function shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '121';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_122">
                                <caption>122. [R] The setjmp and longjmp functions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '122';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_123">
                                <caption>123. [R] The signal handling facilities of &lt;signal.h&gt; shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '123';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_124">
                                <caption>124. [R] The &lt;stdio.h&gt; library shall not be used in production code</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '124';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_125">
                                <caption>125. [R] The functions atof/atoi/atol shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '125';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_126">
                                <caption>126. [R] The functions abort/exit/getenv/system shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '126';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_1998_127">
                                <caption>127. [R] The time handling functions of library &lt;time.h&gt; shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '127';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                </group>
                <group id="MISRAC2004Rules">
                    <caption>Custom Configuration 2004</caption>
                    <tool_id id_ref="CC"/>
                    <generate_option if="MISRACCustom.Selected AND MISRAC2004.Selected"/>
                    <subgroup>
                        <caption>1. Environment</caption>
                        <choices id="Choices_2004_1_Environment">
                            <default state="Choise_2004_1_1,Choise_2004_1_2,Choise_2004_1_3,Choise_2004_1_4"/>
                            <choice id="Choise_2004_1_1">
                                <caption>1.1. [R] No language extensions shall be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_1_2">
                                <caption>1.2. [R] Don't rely on undefined or unspecified behavior</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_1_3">
                                <caption>1.3. [R] Multiple compilers/languages shall only be used if there is a common defined interface standard</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_1_4">
                                <caption>1.4. [R] The compiler/linker shall be checked to ensure that 31 character significance and case sensitivity are supported for external identifiers</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_1_5">
                                <caption>1.5. [A] Floating-point implementations should comply with a defined floating-point standard</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '1.5';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>2. Language extensions</caption>
                        <choices id="Choices_2004_2_Language_extensions">
                            <default state="Choise_2004_2_1,Choise_2004_2_2,Choise_2004_2_3"/>
                            <choice id="Choise_2004_2_1">
                                <caption>2.1. [R] Inline assembly shall be encapsulated and isolated</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_2_2">
                                <caption>2.2. [R] // Comments shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_2_3">
                                <caption>2.3. [R] Comments shall not be nested</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_2_4">
                                <caption>2.4. [A] Sections of code should not be commented out</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '2.4';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>3. Documentation</caption>
                        <choices id="Choices_2004_3_Documentation">
                            <default state="Choise_2004_3_1,Choise_2004_3_2,Choise_2004_3_4,Choise_2004_3_5"/>
                            <choice id="Choise_2004_3_1">
                                <caption>3.1. [R] All usage of implementation-defined behavior shall be documented</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_2">
                                <caption>3.2. [R] The character set and the corresponding encoding shall be documented</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_3">
                                <caption>3.3. [A] The implementation of integer division in the chosen compiler should be determined, documented and taken into account</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_4">
                                <caption>3.4. [R] All uses of '#pragma' shall be documented and explained</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_5">
                                <caption>3.5. [R] Structures with bitfields should not contain other members</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_3_6">
                                <caption>3.6. [A] All libraries used shall be written to comply with the provisions of this document, and shall have been subject to appropriate validation</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '3.6';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>4. Character sets</caption>
                        <choices id="Choices_2004_4_Character_sets">
                            <default state="Choise_2004_4_1,Choise_2004_4_2"/>
                            <choice id="Choise_2004_4_1">
                                <caption>4.1. [R] Only use characters defined by the C standard</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '4.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_4_2">
                                <caption>4.2. [R] Trigraphs shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '4.2';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>5. Identifiers</caption>
                        <choices id="Choices_2004_5_Identifiers">
                            <default state="Choise_2004_5_1,Choise_2004_5_2,Choise_2004_5_3,Choise_2004_5_4"/>
                            <choice id="Choise_2004_5_1">
                                <caption>5.1. [R] Identifiers shall not rely on significance of more than 31 characters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_2">
                                <caption>5.2. [R] Identifiers shall not hide identifiers in an outer scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_3">
                                <caption>5.3. [R] Typedef names should not be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_4">
                                <caption>5.4. [R] A tag name shall be a unique identifier</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_5">
                                <caption>5.5. [A] No object or function identifier with static storage duration should be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_6">
                                <caption>5.6. [A] The same identifier shall not be used in multiple name spaces</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_5_7">
                                <caption>5.7. [A] No identifier name should be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '5.7';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>6. Types</caption>
                        <choices id="Choices_2004_6_Types">
                            <default state="Choise_2004_6_1,Choise_2004_6_2,Choise_2004_6_4,Choise_2004_6_5"/>
                            <choice id="Choise_2004_6_1">
                                <caption>6.1. [R] Plain 'char' shall be used only for character values</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_6_2">
                                <caption>6.2. [R] Signed and unsigned char type shall be used only for the storage and use of numeric values</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_6_3">
                                <caption>6.3. [A] Specific-length typedefs should be used instead of the basic types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_6_4">
                                <caption>6.4. [R] Bit fields shall have type 'unsigned int' or 'signed int'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_6_5">
                                <caption>6.5. [R] Bit fields of type 'signed int' shall be at least 2 bits long</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '6.5';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>7. Constants</caption>
                        <choices id="Choices_2004_7_Constants">
                            <default state="Choise_2004_7_1"/>
                            <choice id="Choise_2004_7_1">
                                <caption>7.1. [R] Octal constants (other than zero) shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '7.1';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>8. Declarations and definitions</caption>
                        <choices id="Choices_2004_8_Declarations_and_definitions">
                            <default state="Choise_2004_8_1,Choise_2004_8_2,Choise_2004_8_3,Choise_2004_8_4,Choise_2004_8_5,Choise_2004_8_6,Choise_2004_8_7,Choise_2004_8_8,Choise_2004_8_9,Choise_2004_8_10,Choise_2004_8_11,Choise_2004_8_12"/>
                            <choice id="Choise_2004_8_1">
                                <caption>8.1. [R] Function prototypes shall be visible at the definition and call</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_2">
                                <caption>8.2. [R] Every function shall have an explicit return type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_3">
                                <caption>8.3. [R] The function prototype of the declaration shall match the definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_4">
                                <caption>8.4. [R] Multiple declarations for objects or functions shall be compatible</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_5">
                                <caption>8.5. [R] There shall be no definitions of objects or functions in a header file</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_6">
                                <caption>8.6. [R] Functions shall always be declared at file scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_7">
                                <caption>8.7. [R] Objects accessed by a single function shall be defined at block scope</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_8">
                                <caption>8.8. [R] An external object or function shall be declared in one and only one file</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_9">
                                <caption>8.9. [R] An identifier with external linkage shall have exactly one external definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_10">
                                <caption>8.10. [R] All declarations and definitions of objects or functions at file scope shall have internal linkage unless external linkage is required</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.10';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_11">
                                <caption>8.11. [R] Identifiers shall not have both internal and external linkage</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_8_12">
                                <caption>8.12. [R] External array shall have a known size</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '8.12';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>9. Initialization</caption>
                        <choices id="Choices_2004_9_Initialization">
                            <default state="Choise_2004_9_1,Choise_2004_9_2,Choise_2004_9_3"/>
                            <choice id="Choise_2004_9_1">
                                <caption>9.1. [R] All automatics shall be initialized before being used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '9.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_9_2">
                                <caption>9.2. [R] Braces shall be used in the initialization of arrays and structures</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '9.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_9_3">
                                <caption>9.3. [R] Only the first, or all enumeration constants may be initialized</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '9.3';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>10. Arithmetic type conversions</caption>
                        <choices id="Choices_2004_10_Arithmetic_type_conversions">
                            <default state="Choise_2004_10_1,Choise_2004_10_2,Choise_2004_10_3,Choise_2004_10_4,Choise_2004_10_5,Choise_2004_10_6"/>
                            <choice id="Choise_2004_10_1">
                                <caption>10.1. [R] Restrict the use of implicit conversions for integer types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_2">
                                <caption>10.2. [R] Restrict the use of implicit conversions for floating types</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_3">
                                <caption>10.3. [R] A complex integer expression may only be cast to a type of the same signedness that is no wider than the underlying type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_4">
                                <caption>10.4. [R] A complex floating expression may only be cast to a type that is no wider than the underlying type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_5">
                                <caption>10.5. [R] Don't use ~ or &lt;&lt; on small unsigned types without a cast</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_10_6">
                                <caption>10.6. [R] A 'U' suffix should be applied to all constants of unsigned type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '10.6';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>11. Pointer type conversions</caption>
                        <choices id="Choices_2004_11_Pointer_type_conversions">
                            <default state="Choise_2004_11_1,Choise_2004_11_2,Choise_2004_11_5"/>
                            <choice id="Choise_2004_11_1">
                                <caption>11.1. [R] A function pointer shall only be converted to/from an integral type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_11_2">
                                <caption>11.2. [R] An object pointer shall only be converted to/from an integral type, another object pointer, or void pointer</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_11_3">
                                <caption>11.3. [A] A pointer type should not be cast to/from an integral type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_11_4">
                                <caption>11.4. [A] An object pointer type should not be cast to/from a different object pointer type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_11_5">
                                <caption>11.5. [R] A cast shall not remove 'const' or 'volatile' qualifiers</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '11.5';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>12. Expressions</caption>
                        <choices id="Choices_2004_12_Expressions">
                            <default state="Choise_2004_12_2,Choise_2004_12_3,Choise_2004_12_4,Choise_2004_12_5,Choise_2004_12_7,Choise_2004_12_8,Choise_2004_12_9,Choise_2004_12_10,Choise_2004_12_12"/>
                            <choice id="Choise_2004_12_1">
                                <caption>12.1. [A] No dependency should be placed on operator precedence rules</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_2">
                                <caption>12.2. [R] The value of an expression shall be evaluation order independent</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_3">
                                <caption>12.3. [R] 'sizeof' should not be used on expressions with side effects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_4">
                                <caption>12.4. [R] The right hand side of &amp;&amp; or || shall not contain side effects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_5">
                                <caption>12.5. [R] The operands of a logical &amp;&amp; or || shall be primary expressions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_6">
                                <caption>12.6. [A] The operators &amp;&amp;, || and ! should be used exclusively for Boolean operands</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_7">
                                <caption>12.7. [R] Bitwise operations shall not be performed on signed operands</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_8">
                                <caption>12.8. [R] A shift count shall be between 0 and the operand width minus 1</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_9">
                                <caption>12.9. [R] The unary minus shall not be applied to an unsigned expression</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_10">
                                <caption>12.10. [R] The comma operator shall only be used in a 'for' condition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.10';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_11">
                                <caption>12.11. [A] Evaluation of unsigned expressions should not lead to wrap-around</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_12">
                                <caption>12.12. [R] The bit representations of floating point numbers shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.12';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_12_13">
                                <caption>12.13. [A] The ++ and -- operators should not be mixed with other operators</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '12.13';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>13. Control statement expressions</caption>
                        <choices id="Choices_2004_13_Control_statement_expressions">
                            <default state="Choise_2004_13_1,Choise_2004_13_3,Choise_2004_13_4,Choise_2004_13_5,Choise_2004_13_6,Choise_2004_13_7"/>
                            <choice id="Choise_2004_13_1">
                                <caption>13.1. [R] Assignment operators shall not be used in Boolean expressions</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_2">
                                <caption>13.2. [A] Tests of a value against zero should be made explicit</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_3">
                                <caption>13.3. [R] F.P. variables shall not be tested for exact equality or inequality</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_4">
                                <caption>13.4. [R] Floating point variables shall not be used as loop counters</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_5">
                                <caption>13.5. [R] Only loop control expressions should appear within a for statement</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_6">
                                <caption>13.6. [R] Iterator variables should not be modified in the loop</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_13_7">
                                <caption>13.7. [R] Boolean operations whose result is invariant shall not be permitted</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '13.7';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>14. Control flow</caption>
                        <choices id="Choices_2004_14_Control_flow">
                            <default state="Choise_2004_14_1,Choise_2004_14_2,Choise_2004_14_3,Choise_2004_14_4,Choise_2004_14_5,Choise_2004_14_6,Choise_2004_14_7,Choise_2004_14_8,Choise_2004_14_9,Choise_2004_14_10"/>
                            <choice id="Choise_2004_14_1">
                                <caption>14.1. [R] There shall be no unreachable code</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_2">
                                <caption>14.2. [R] All non-null statements shall have a side-effect</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_3">
                                <caption>14.3. [R] A null statement shall only occur on a line by itself</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_4">
                                <caption>14.4. [R] The 'goto' statement shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_5">
                                <caption>14.5. [R] The 'continue' statement shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_6">
                                <caption>14.6. [R] An iteration statement shall have at most one break statement</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_7">
                                <caption>14.7. [R] A function should have a single point of exit</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_8">
                                <caption>14.8. [R] The body of a 'switch' or loop shall be a compound statement</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_9">
                                <caption>14.9. [R] 'if'/'else' shall be followed by a compound statement, except for 'else' followed by 'if'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_14_10">
                                <caption>14.10. [R] All 'if', 'else if' constructs should contain a final 'else'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '14.10';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>15. Switch statement</caption>
                        <choices id="Choices_2004_15_Switch_statement">
                            <default state="Choise_2004_15_1,Choise_2004_15_2,Choise_2004_15_3,Choise_2004_15_4,Choise_2004_15_5"/>
                            <choice id="Choise_2004_15_1">
                                <caption>15.1. [R] A case label shall only be used in the outermost compound statement of a switch</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_15_2">
                                <caption>15.2. [R] Every non-empty 'case' clause shall be terminated with a 'break'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_15_3">
                                <caption>15.3. [R] All 'switch' statements should contain a final 'default' case</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_15_4">
                                <caption>15.4. [R] A 'switch' expression should not represent a Boolean case</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_15_5">
                                <caption>15.5. [R] Every 'switch' shall have at least one 'case'</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '15.5';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>16. Functions</caption>
                        <choices id="Choices_2004_16_Functions">
                            <default state="Choise_2004_16_1,Choise_2004_16_2,Choise_2004_16_3,Choise_2004_16_4,Choise_2004_16_5,Choise_2004_16_6,Choise_2004_16_8,Choise_2004_16_9,Choise_2004_16_10"/>
                            <choice id="Choise_2004_16_1">
                                <caption>16.1. [R] Functions with variable number of arguments shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_2">
                                <caption>16.2. [R] Functions shall not call themselves</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_3">
                                <caption>16.3. [R] Identifiers shall be given for all prototype parameters or for none</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_4">
                                <caption>16.4. [R] Parameter identifiers shall be identical for declaration/definition</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_5">
                                <caption>16.5. [R] Functions with no parameters shall have a 'void' parameter list</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_6">
                                <caption>16.6. [R] The number of actual parameters shall match the prototype</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_7">
                                <caption>16.7. [A] 'const' should be used on pointer parameters whenever possible</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_8">
                                <caption>16.8. [R] Every exit point shall have a 'return' of the declared return type</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_9">
                                <caption>16.9. [R] Function calls with no parameters should have empty parentheses</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_16_10">
                                <caption>16.10. [R] Error information returned by a function should be tested</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '16.10';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>17. Pointers and arrays</caption>
                        <choices id="Choices_2004_17_Pointers_and_arrays">
                            <default state="Choise_2004_17_1,Choise_2004_17_2,Choise_2004_17_3,Choise_2004_17_4,Choise_2004_17_6"/>
                            <choice id="Choise_2004_17_1">
                                <caption>17.1. [R] Pointer arithmetic shall only be applied to pointers that address an array or array element</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_2">
                                <caption>17.2. [R] Pointer subtraction shall only be applied to pointers that address elements of the same array</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_3">
                                <caption>17.3. [R] Relational operators shall not be applied to pointers to different objects</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_4">
                                <caption>17.4. [R] Array indexing shall be the only allowed form of pointer arithmetic</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_5">
                                <caption>17.5. [A] No more than 2 levels of pointer indirection should be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_17_6">
                                <caption>17.6. [R] An automatic address may not be assigned to a longer lived object</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '17.6';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>18. Structures and unions</caption>
                        <choices id="Choices_2004_18_Structures_and_unions">
                            <default state="Choise_2004_18_1,Choise_2004_18_2,Choise_2004_18_3,Choise_2004_18_4"/>
                            <choice id="Choise_2004_18_1">
                                <caption>18.1. [R] All members of a struct or union shall be fully specified</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_18_2">
                                <caption>18.2. [R] An object shall not be assigned to an overlapping object</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_18_3">
                                <caption>18.3. [R] An area of memory shall not be reused for unrelated purposes</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_18_4">
                                <caption>18.4. [R] Unions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '18.4';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>19. Preprocessing directives</caption>
                        <choices id="Choices_2004_19_Preprocessing_directives">
                            <default state="Choise_2004_19_3,Choise_2004_19_4,Choise_2004_19_5,Choise_2004_19_6,Choise_2004_19_8,Choise_2004_19_9,Choise_2004_19_10,Choise_2004_19_11,Choise_2004_19_12,Choise_2004_19_14,Choise_2004_19_15,Choise_2004_19_16,Choise_2004_19_17"/>
                            <choice id="Choise_2004_19_1">
                                <caption>19.1. [A] #include shall only be preceded by another directives or comments</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_2">
                                <caption>19.2. [A] Non-standard characters shall not occur in #include directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_3">
                                <caption>19.3. [R] #include shall be followed by either &lt;filename&gt; or "filename"</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_4">
                                <caption>19.4. [R] Macros shall only be used for initializers/constants/expressions/qualifiers/specifiers/do-while(0)</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_5">
                                <caption>19.5. [R] Macros shall not be defined/undefined within a block</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_6">
                                <caption>19.6. [R] #undef should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_7">
                                <caption>19.7. [A] A function should be used in preference to a function-like macro</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_8">
                                <caption>19.8. [R] A function-like macro shall not be used without all arguments</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_9">
                                <caption>19.9. [R] Macro arguments shall not contain tokens that look like directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_10">
                                <caption>19.10. [R] A macro parameter shall be enclosed in parentheses</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.10';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_11">
                                <caption>19.11. [R] Don't use undefined identifiers in pre-processing directives</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_12">
                                <caption>19.12. [R] A macro definition shall contain at most one # or ## operator</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.12';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_13">
                                <caption>19.13. [A] The '#' and '##' preprocessor operators should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.13';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_14">
                                <caption>19.14. [R] 'defined' shall only be used in one of the two standard forms</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.14';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_15">
                                <caption>19.15. [R] The contents of a header file shall not be included twice</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.15';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_16">
                                <caption>19.16. [R] Preprocessing directives shall be syntactically meaningful even when excluded</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.16';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_19_17">
                                <caption>19.17. [R] #else/#elif/#endif shall reside in the same file as the corresponding #if/#ifdef/#ifndef</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '19.17';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>20. Standard libraries</caption>
                        <choices id="Choices_2004_20_Standard_libraries">
                            <default state="Choise_2004_20_1,Choise_2004_20_2,Choise_2004_20_3,Choise_2004_20_4,Choise_2004_20_5,Choise_2004_20_6,Choise_2004_20_7,Choise_2004_20_8,Choise_2004_20_9,Choise_2004_20_10,Choise_2004_20_11,Choise_2004_20_12"/>
                            <choice id="Choise_2004_20_1">
                                <caption>20.1. [R] Reserved and standard library names shall not be redefined</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.1';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_2">
                                <caption>20.2. [R] Standard library function names shall not be reused</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.2';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_3">
                                <caption>20.3. [R] The validity of values passed to library functions shall be checked</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.3';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_4">
                                <caption>20.4. [R] Dynamic heap memory allocation shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.4';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_5">
                                <caption>20.5. [R] 'errno' should not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.5';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_6">
                                <caption>20.6. [R] The macro 'offsetof()' shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.6';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_7">
                                <caption>20.7. [R] The 'setjmp' and 'longjmp' functions shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.7';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_8">
                                <caption>20.8. [R] The signal handling facilities of &lt;signal.h&gt; shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.8';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_9">
                                <caption>20.9. [R] The &lt;stdio.h&gt; library shall not be used in production code</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.9';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_10">
                                <caption>20.10. [R] The functions atof/atoi/atol shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.10';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_11">
                                <caption>20.11. [R] The functions abort/exit/getenv/system shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.11';
                                    </selected>
                                </makefile_generator>
                            </choice>
                            <choice id="Choise_2004_20_12">
                                <caption>20.12. [R] The time handling functions of library &lt;time.h&gt; shall not be used</caption>
                                <generate_option if="MISRACCustom.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '20.12';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                    <subgroup>
                        <caption>21. Run-time failures</caption>
                        <choices id="Choices_2004_21_Run_time_failures">
                            <default state="Choise_2004_21_1"/>
                            <choice id="Choise_2004_21_1">
                                <caption>21.1. [R] Minimization of run-time failures shall be ensured by the use of at least one of: (a) static analysis tools/techniques; (b) dynamic analysis tools/techniques; (c) explicit coding of checks to handle run-time faults.</caption>
                                <generate_option if="MISRACNotImplemented.Selected"/>
                                <makefile_generator>
                                    <selected>
                                        if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                            MISRACCustom.Flag := MISRACCustom.Flag + ',';
                                        MISRACCustom.Flag := MISRACCustom.Flag + '21.1';
                                    </selected>
                                </makefile_generator>
                            </choice>

                        </choices>
                    </subgroup>
                </group>
                <text id="MISRACOptions">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            if NOT AnsiSameText(MISRACCustom.Flag,'') then
                                DXP.AddToolCmdOption('--misrac=' + MISRACCustom.Flag);
                        </selected>
                    </makefile_generator>
                </text>
            </group>

            <group id="CcDiagnostics">
                <caption>Diagnostics</caption>
                <tool_id id_ref="CC"/>
                <choices id="Choices_CompWarn">
                    <caption>Error reporting</caption>
                    <tool_tip>During the compile process warnings can occur. By default, all warnings are reported.<br/>
Select one of the suppress options to hide the warning messages that are of no importance to you.</tool_tip>
                    <single/>
                    <default state="CompWarn"/>
                    <choice id="CompWarn">
                        <caption>Report all warnings</caption>
                    </choice>
                    <choice id="CompNoWarn">
                        <caption>Suppress all warnings</caption>
                        <makefile_generator>
                            <selected>
                                CompNoWarn.Flag := '--no-warnings';
                                DXP.AddToolCmdOption(CompNoWarn.Flag);
                            </selected>
                            <not_selected>
                                CompNoWarn.Flag := '';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="CompSpecWarn">
                        <caption>Suppress specific warnings</caption>
                    </choice>
                </choices>
                <text id="HwCompWarnList">
                    <multi/>
                    <caption>    Specific warnings to suppress</caption>
                    <tool_tip>Specify one or more warnings to suppress, separated by commas (no spaces).<br/>
For example: 126,135,144</tool_tip>
                    <generate_option if="CompSpecWarn.Selected"/>
                    <makefile_generator>
                        <selected>
                            HwCompWarnList.Flag := DXP.SplitJoin(HwCompWarnList.State ,',',' ','-w');
                            DXP.AddToolCmdOption( HwCompWarnList.Flag );
                        </selected>
                        <not_selected>
                            HwCompWarnList.Flag := '';
                        </not_selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_CompWarningsAsErrors">
                    <default state=""/>
                    <choice id="CompWarningsAsErrors">
                        <caption>Treat warnings as errors</caption>
                        <tool_tip>When warnings occur the compile process continues.<br/>
When errors occur the compile process stops.<br/>
Select this option to stop the compile process also when only warnings occur.</tool_tip>
                        <generate_option if="NOT CompNoWarn.Selected"/>
                        <makefile_generator>
                            <selected>
                                CompWarningsAsErrors.Flag := '--warnings-as-errors';
                                DXP.AddToolCmdOption( CompWarningsAsErrors.Flag );
                            </selected>
                            <not_selected>
                                CompWarningsAsErrors.Flag := '';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="CcLibraries">
                <caption>Libraries</caption>
                <choices id="Choices_HwCompNoDefaultLibraries">
                    <choice id="HwCompNoDefaultLibraries">
                        <caption>Do not link default libraries</caption>
                    </choice>
                </choices>
                <table_edit id="HwCompLibraries">
                    <caption>Libraries</caption>
                    <column column="Libraries">
                        <text id="HwCompLibraryName">
                            <caption>Libraries</caption>
                        </text>
                    </column>
                    <text id="HwCompLibraries_Loop">
                        <invisible/>
                        <default state="SELECTED"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption(DXP.SplitJoin(LkLibrariesList.State,',',' ','-l"','"') );
                            </selected>
                        </makefile_generator>
                    </text>
                </table_edit>
                <text id="HwCompLibc">
                    <caption>Libc</caption>
                    <invisible/>
                    <generate_option if="NOT HwCompNoDefaultLibraries.Selected AND HwCompMode32Bit.Selected AND HwCompEndianness.Selected"/>      
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('"$(PRODDIR)/chc/lib/libc.ma"');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="HwCompLibc16">
                    <invisible/>
                    <generate_option if="NOT HwCompNoDefaultLibraries.Selected AND HwCompMode16Bit.Selected AND HwCompEndianness.Selected"/>
                    <caption>Libc16</caption>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('"$(PRODDIR)/chc/lib/libc16.ma"');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="HwCompLibcLittleEndian">
                    <caption>Libc</caption>
                    <invisible/>
                    <generate_option if="NOT HwCompNoDefaultLibraries.Selected AND HwCompMode32Bit.Selected AND NOT HwCompEndianness.Selected"/>      
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('"$(PRODDIR)/chc/lib/libcle.ma"');
                        </selected>
                    </makefile_generator>
                </text>
                <text id="HwCompLibc16LittleEndian">
                    <invisible/>
                    <generate_option if="NOT HwCompNoDefaultLibraries.Selected AND HwCompMode16Bit.Selected AND NOT HwCompEndianness.Selected"/>
                    <caption>Libc16</caption>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('"$(PRODDIR)/chc/lib/libc16le.ma"');
                        </selected>
                    </makefile_generator>
                </text>
            </group>

            <group id="CcMiscellaneous">
                <caption>Miscellaneous</caption> 
                <choices id="Choices_MixedAsm">
                    <default state=""/> 
                    <choice id="MixedAsm">
                        <caption>Merge source code with generated assembly</caption>
                        <tool_tip>Select this option to see the relation between the C source code and the generated assembly code.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--source');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <cmdoptions id="CmdOptCC" tool_id_ref="CC"/>
                <text id="CompAdditional_CHC">
                    <multi/>
                    <caption>Additional options</caption>
                    <tool_tip>Some compiler options are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( CompAdditional_CHC.State );
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_CompCHC_InitMemOnReset">
                    <choice id="HwCompInitMemOnReset">
                        <caption>Initialize ASP internal memories on reset</caption>
                        <tool_tip>Select this option to add copytables to the ASP internal memories.<br/> 
These copytables are used to reinitialize the memories after a reset.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--init-mem-on-reset');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CompCHC_NoClear">
                    <choice id="HwCompNoClear">
                        <caption>Don't clear non-initialized global/static variables</caption>
                        <tool_tip>Select this option if you do not want to clear non-initialized global/static
                            variables after a reset.</tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--no-clear');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CompCHC_RegisterOutputs">
                    <choice id="HwCompRegisterOutputs">
                        <caption>Register outputs.</caption>
                        <tool_tip>This option sets the qualifier __CC(register_outputs) for all __export and __import functions.
                                  This means the output ports and the done ports will remain valid until the next start signal.
                        </tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--register-outputs');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
                <choices id="Choices_CompCHC_StartOnEdge">
                    <choice id="HwCompStartOnEdge">
                        <caption>Start on edge.</caption>
                        <tool_tip>This option sets the qualifier __CC(start_on_edge) for all __export and __import functions.
                                  This means the function will start on a rising edge of the start signal, instead of on a high start signal.
                        </tool_tip>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--start-on-edge');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
        </group>

        <group id="Assembler">
            <caption>Assembler</caption>
            <tool_id id_ref="AS"/>
            <text id="HwAsDataOutput">
                <invisible/>
                <default state="SELECTED"/>
                <generate_option if="HwCompOnlyRtlQualfied.Selected"/>
                <makefile_generator>
                    <selected>
                        HwAsDataOutput.Flag := '$(OUTDIR)\$(PROJ)_c' + HwCompCoreCompatibility.State + '.obj';
                        DXP.AddGeneratedFile( HwAsDataOutput.Flag );
                    </selected>
                </makefile_generator>
            </text>
        </group>

        <group id="Linker">
            <caption>Linker</caption>
            <global/>
            <group id="LkOutputFormat">
                <tool_id id_ref="LK"/>
                <caption>Output Format</caption>
                <choices id="Choices_LkIeee">
                    <caption>Output format</caption>
                    <tool_tip>This option determines the resulting file of a compile.<br/>
By default, the resulting file is an application you can debug.<br/>
Select 'Library for TASKING Linker' if you want to build a library for use in other projects.</tool_tip>
                    <single/>
                    <default state="LkIeee"/>
                    <choice id="LkIeee">
                        <caption>Absolute file for debuggers (.abs)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.SetPrjTargetExt('vhd');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkLib">
                        <caption>Library for TASKING Linker (.lib)</caption>
                        <makefile_generator>
                            <selected>
                                DXP.SetPrjTargetExt('lib');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="LkOptimization">
                <caption>Optimization</caption>
                <tool_id id_ref="LK"/>
                <choices id="LkOptim">
                    <single/>
                    <caption>Optimization level</caption>
                    <tool_tip>Select a predefined set of optimizations or select 'Custom optimization' to enable individual optimizations.<br/>
Select 'Full optimization' for the final application.</tool_tip>
                    <default state="LkOL1"/>
                    <generate_option if="NOT LkLib.Selected"/>
                    <choice id="LkOL0">
                        <caption>No optimization</caption>
                        <makefile_generator>
                            <selected>
                                LkOL0.Flag := '-O0';
                            </selected>
                            <not_selected>
                                LkOL0.Flag := '';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkOL1">
                        <caption>Default optimization</caption>
                        <makefile_generator>
                            <selected>
                                LkOL1.Flag := '-O1';
                            </selected>
                            <not_selected>
                                LkOL1.Flag := '';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkOL2">
                        <caption>Full optimization</caption>
                        <makefile_generator>
                            <selected>
                                LkOL2.Flag := '-O2';
                            </selected>
                            <not_selected>
                                LkOL2.Flag := '';
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkOLAdv">
                        <caption>Custom optimization</caption>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Custom optimization</caption>
                    <choices id="Choices_LkOc">
                        <default state="LkOc,LkOt"/>
                        <choice id="LkOc">
                            <caption>Delete un-referenced sections</caption>
                            <tool_tip>Removes sections that are never used from the output file.<br/>
This option is only useful when you compile without debug information, because debug information generally uses all sections.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOc.Flag := 'c';
                                </selected>
                                <not_selected>
                                    LkOc.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkOl">
                            <caption>Use first fit decreasing algorithm</caption>
                            <tool_tip>Puts small sections into gaps that were formed during the locate process.<br/>
This optimization only applies to unrestricted sections.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOl.Flag := 'l';
                                </selected>
                                <not_selected>
                                    LkOl.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                       <choice id="LkOt">
                            <caption>Copy table compression</caption>
                            <tool_tip>Compresses the size of the copy table when possible.<br/>
Smart restrictions are emitted to obtain large contiguous blocks of sections that can be copied/cleared in one copy table action instead of multiple little copy/clear actions.<br/>
This optimization reduces both memory usage and startup speed.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOt.Flag := 't';
                                </selected>
                                <not_selected>
                                    LkOt.Flag := 'T';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkOx">
                            <caption>Delete duplicate code</caption>
                            <tool_tip>Removes duplicate code from the output file.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOx.Flag := 'x';
                                </selected>
                                <not_selected>
                                    LkOx.Flag := 'X';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkOy">
                            <caption>Delete duplicate constant data</caption>
                            <tool_tip>Removes duplicate constant data from the output file.</tool_tip>
                            <generate_option if="LkOLAdv.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkOy.Flag := 'y';
                                </selected>
                                <not_selected>
                                    LkOy.Flag := 'Y';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
            </group>
            <group id="LkMapFile">
                <caption>Map File</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LkMap">
                    <default state="LkMap"/>
                    <choice id="LkMap">
                        <caption>Generate a memory map file (.map)</caption>
                        <tool_tip>A map file shows how the linker has mapped the sections and symbols from the various object files to output sections.<br/>
Select this option to generate map files with the same name as the project file but with extension .sw.map or .hw.map.<br/>
Additionally, specify below which information you want in the map file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                    </choice>
                </choices>
                <subgroup>
                    <caption>Map file format</caption>
                    <choices id="Choices_LkMapFileCallgraph">
                        <default state="LkMapFileCallgraph,LkMapFileProcessed,LkMapFileLink,LkMapFileLocate,LkMapFileMemory,LkMapFileOverlay,LkMapFileCrossRef,LkMapFileRules"/>
                        <choice id="LkMapFileCallgraph">
                            <caption>Call graph information</caption>
                            <tool_tip>Shows a schematic overview how functions call each other.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileCallgraph.Flag := 'c';
                                </selected>
                                <not_selected>
                                    LkMapFileCallgraph.Flag := 'C';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileProcessed">
                            <caption>Processed files information</caption>
                            <tool_tip>Shows all files processed by the linker. This also includes object files extracted from libraries, and the symbol that led to the extraction.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileProcessed.Flag := 'f';
                                </selected>
                                <not_selected>
                                    LkMapFileProcessed.Flag := 'F';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileLink">
                            <caption>Link result information</caption>
                            <tool_tip>Shows per object file how the linker has mapped the sections from the various objects files to output sections.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileLink.Flag := 'k';
                                </selected>
                                <not_selected>
                                    LkMapFileLink.Flag := 'K';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileLocate">
                            <caption>Locate result information</caption>
                            <tool_tip>Shows the absolute position of each section in the output file and shows a list of all external symbols.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileLocate.Flag := 'l';
                                </selected>
                                <not_selected>
                                    LkMapFileLocate.Flag := 'L';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileMemory">
                            <caption>Memory usage information</caption>
                            <tool_tip>Shows the memory usage in totals and percentages for spaces and chips.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileMemory.Flag := 'm';
                                </selected>
                                <not_selected>
                                    LkMapFileMemory.Flag := 'M';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileOverlay">
                            <caption>Overlay information</caption>
                            <tool_tip>Shows the locate overlay information if you used overlay groups in the linker script file.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileOverlay.Flag := 'o';
                                </selected>
                                <not_selected>
                                    LkMapFileOverlay.Flag := 'O';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileStatics">
                            <caption>Module local symbols</caption>
                            <tool_tip>Shows for each local scope the name, address and space where the local symbol resides.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileStatics.Flag := 'q';
                                </selected>
                                <not_selected>
                                    LkMapFileStatics.Flag := 'Q';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileCrossRef">
                            <caption>Cross reference information</caption>
                            <tool_tip>Shows a list of all symbols and for each symbol the object files in which the symbol is referenced.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileCrossRef.Flag := 'r';
                                </selected>
                                <not_selected>
                                    LkMapFileCrossRef.Flag := 'R';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileLsl">
                            <caption>Processor and memory information</caption>
                            <tool_tip>Shows the name of the processor and core and shows names, sizes and mappings of spaces, buses and memory.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileLsl.Flag := 's';
                                </selected>
                                <not_selected>
                                    LkMapFileLsl.Flag := 'S';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                        <choice id="LkMapFileRules">
                            <caption>Locate rules</caption>
                            <tool_tip>Shows the rules the linker uses to locate sections. For example, this part lists which sections are absolute, contiguous or unrestricted.</tool_tip>
                            <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                            <makefile_generator>
                                <selected>
                                    LkMapFileRules.Flag := 'u';
                                </selected>
                                <not_selected>
                                    LkMapFileRules.Flag := 'U';
                                </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </subgroup>
            </group>
            <group id="LkDiagnostics">
                <caption>Diagnostics</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LKWarn">
                    <caption>Error reporting</caption>
                    <tool_tip>During the link process warnings can occur. By default, all warnings are reported.<br/>
Select one of the suppress options to hide the warning messages that are of no importance to you.</tool_tip>
                    <single/>
                    <default state="LKWarn"/>
                    <choice id="LKWarn">
                        <caption>Report all warnings</caption>
                        <generate_option if="NOT LkLib.Selected"/>
                    </choice>
                    <choice id="LKNoWarn">
                        <caption>Suppress all warnings</caption>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--no-warnings');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LKSpecWarn">
                        <caption>Suppress specific warnings</caption>
                        <generate_option if="NOT LkLib.Selected"/>
                    </choice>
                </choices>
                <text id="LKWarnList">
                    <multi/>
                    <caption>    Specific warnings to suppress</caption>
                    <tool_tip>Specify one or more warnings to suppress, separated by commas (no spaces).<br/>
For example: 126,135,144</tool_tip>
                    <generate_option if="LKSpecWarn.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(DXP.SplitJoin(LKWarnList.State ,',',' ','-w') );
                        </selected>
                    </makefile_generator>
                </text>
                <choices id="Choices_LKWarningsAsErrors">
                    <default state=""/>
                    <choice id="LKWarningsAsErrors">
                        <caption>Treat warnings as errors</caption>
                        <tool_tip>When warnings occur the link process continues.<br/>
When errors occur the link process stops.<br/>
Select this option to stop the link process also when only warnings occur.</tool_tip>
                        <generate_option if="NOT LKNoWarn.Selected AND NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--warnings-as-errors');
                            </selected>
                        </makefile_generator>
                    </choice>
                </choices>
            </group>
            <group id="LkMiscellaneous">
                <caption>Miscellaneous</caption>
                <tool_id id_ref="LK"/>
                <choices id="Choices_LkIncludeDebug">
                    <default state="LkIncludeDebug,LkCase"/>
                    <choice id="LkNonRomable">
                        <caption>Application is not romable</caption>
                        <tool_tip>With this option you tell the linker that the application is not romable.
The linker will locate all ROM sections including the copy table in RAM.<br/>
When the application is started, data section will be re-initialized
and bss sections cleared as usual.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--non-romable');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkNoRomCopy">
                        <caption>Do not generate ROM copy for re-initializing data</caption>
                        <tool_tip>With this option the linker will not generate a ROM copy for data
sections. A copy table is generated and contains entries to clear BSS
sections.  However, no entries to copy data sections from ROM to RAM are
placed in the copy table. The data sections are initialized when the
application is downloaded. The data sections are not re-initialized
when the application is restarted.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--no-rom-copy');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkIncludeDebug">
                        <caption>Include symbolic debug information</caption>
                        <tool_tip>Normally the linker passes debug information enabled by the compiler or assembler to the output file.<br/>
Clear this option to strip debug information from the output file. This can be useful to reduce the size of the output file or to allow more optimizations.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('--strip-debug');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkCase">
                        <caption>Link case sensitive (required for C language)</caption>
                        <tool_tip>All identifiers will appear in the object file exactly as they appear in the source file.<br/>
Clear this option to convert all identifiers to upper case. For example, if you write your own assembly file.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <not_selected>
                                DXP.AddToolCmdOption('--case-insensitive');
                            </not_selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkDumpLsl">
                        <caption>Dump processor and memory info from LSL file</caption>
                        <tool_tip>Select this option to dump the processor and memory information in a separate file with extension .ldf.<br/>
The same information is available in the map file when you select 'Processor and memory information' on the 'Map File' page.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption('--lsl-dump');
                            </selected>
                        </makefile_generator>
                    </choice>
                    <choice id="LkUserLsl">
                        <caption>Use project specific LSL file</caption>
                        <tool_tip>Normally Altium Designer generates LSL files depending on your project settings.<br/>
Select this option to specify your own LSL file. Enter the name of your LSL file in the field below.</tool_tip>
                        <generate_option if="NOT LkLib.Selected"/>
                    </choice>
                </choices>
                <text id="LkUserLslField">
                    <caption>    LSL file</caption>
                    <tool_tip>Enter the name of your LSL file to use with this project.</tool_tip>
                    <generate_option if="LkUserLsl.Selected"/>
                    <button on_click="DXP.FileOpenDialog(LkUserLslField)"/>
                    <makefile_generator>
                        <selected>
                            LkStdLsl.Flag := '--lsl-file="' + LkUserLslField.state + '"';
                        </selected>
                    </makefile_generator>
                </text>
                <cmdoptions id="CmdOptLK" tool_id_ref="LK"/>
                <text id="LkAdditional">
                    <multi/>
                    <caption>Additional linker options</caption>
                    <tool_tip>Some linker options are not covered by Altium Designer.<br/>
If needed, specify additional command line options, separated by spaces.</tool_tip>
                    <generate_option if="NOT LkLib.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(LkAdditional.State);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkStdLsl">
                    <invisible/>
                    <generate_option if="NOT LkLib.Selected AND NOT LkUserLsl.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            If HwCompStandalone.Selected Then
                                LkStdLsl.Flag := '--lsl-file="$(PROJ).lsl"'
                            Else
                                LkStdLsl.Flag := '--lsl-file="$(PROJ)_mem.lsl"';
                        </selected>
                    </makefile_generator>
                </text>
            </group>

            <group id="LkhcSoftwareCore">
                <tool_id id_ref="LK_SW"/>
                <caption>Software Core</caption>
                <text id="LkhcSoftwareOutput">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( '-o "' + getWorkDir + '\$(PROJ).abs"' );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcSoftwareInput">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( '"' + getWorkDir + '\$(PROJ).o"' );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkHcSoftwareDataInput">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="HwAsDataOutput.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( HwAsDataOutput.Flag );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcSoftwareMapFile">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="LkMap.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddGeneratedFile( '"$(OUTDIR)\$(PROJ).sw.map"');
                            DXP.AddToolCmdOption( '-M"$(OUTDIR)\$(PROJ).sw.map"' );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcSoftwareEndianness">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( HwCompEndianness.Flag );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcSoftwareOL_Script">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="NOT LkOLAdv.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(LkOL0.Flag + LkOL1.Flag + LkOL2.Flag);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcSoftwareOLAdv_Script">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="LkOLAdv.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-O' + LkOc.Flag + LkOl.Flag + LkOt.Flag + LkOx.Flag + LkOy.Flag);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcSoftwareMapFileCustom_Script">
                    <invisible/>
                    <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-m' + LkMapFileCallgraph.Flag + LkMapFileProcessed.Flag + LkMapFileLink.Flag + LkMapFileLocate.Flag + LkMapFileMemory.Flag + LkMapFileOverlay.Flag + LkMapFileStatics.Flag + LkMapFileCrossRef.Flag + LkMapFileLsl.Flag + LkMapFileRules.Flag );
                        </selected>
                    </makefile_generator>
                </text>
            </group>

            <group id="LkhcHardwareCore">
                <tool_id id_ref="LK_HW"/>
                <caption>Hardware Core</caption>
                <text id="LkhcHardwareMapFile">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="LkMap.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddGeneratedFile( '"$(OUTDIR)\$(PROJ).hw.map"');
                            DXP.AddToolCmdOption( '-M"$(OUTDIR)\$(PROJ).hw.map"' );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcHardwareEndianness">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( HwCompEndianness.Flag );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcHardwareUserProvidedInitCode">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( '-i' );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcHardwareNoRomCopy">
                    <invisible/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( '-N' );
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcHardwareOL_Script">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="NOT LkOLAdv.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption(LkOL0.Flag + LkOL1.Flag + LkOL2.Flag);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcHardwareOLAdv_Script">
                    <invisible/>
                    <default state="SELECTED"/>
                    <generate_option if="LkOLAdv.Selected"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-O' + LkOc.Flag + LkOl.Flag + LkOt.Flag + LkOx.Flag + LkOy.Flag);
                        </selected>
                    </makefile_generator>
                </text>
                <text id="LkhcHardwareMapFileCustom_Script">
                    <invisible/>
                    <generate_option if="NOT LkLib.Selected AND LkMap.Selected"/>
                    <default state="SELECTED"/>
                    <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption('-m' + LkMapFileCallgraph.Flag + LkMapFileProcessed.Flag + LkMapFileLink.Flag + LkMapFileLocate.Flag + LkMapFileMemory.Flag + LkMapFileOverlay.Flag + LkMapFileStatics.Flag + LkMapFileCrossRef.Flag + LkMapFileLsl.Flag + LkMapFileRules.Flag );
                        </selected>
                    </makefile_generator>
                </text>
            </group>
        </group>

    <group id="Hdlhc">
        <caption>HDLHC</caption>
	 <tool_id id_ref="HDLHC"/>
         <invisible/>
                <group>
                    <caption>HDL Interface</caption>
                    <tool_id id_ref="HDLHC"/>
                    <text id="HwCompTopLevelEntity">
                        <caption>Toplevel entity name</caption>
                        <default state=""/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption( '--toplevel=' + HwCompTopLevelEntity.State );
                            </selected>
                        </makefile_generator>
                    </text>
                    <text id="ASP_Name">
                        <invisible/>
                        <default state=""/>
                        <generate_option if="NOT HwCompTopLevelEntity.Selected AND NOT AnsiSameText(ASP_Name.State,'')"/>
                        <makefile_generator>
                            <selected>
                                DXP.AddToolCmdOption( '--toplevel=Configurable_' + ASP_Name.State );
                            </selected>
                        </makefile_generator>
                    </text>
                    <text id="HwCompWishboneAddrWidth">
                        <caption>Number of wishbone address lines</caption>
                        <invisible/>
                        <default state="4"/>
                        <makefile_generator>
                            <selected>
                                HwCompWishboneAddrWidth.Flag := '--wishbone-address-width=' + HwCompWishboneAddrWidth.State;
                                DXP.AddToolCmdOption( HwCompWishboneAddrWidth.Flag );
                            </selected>
                            <not_selected>
                                HwCompWishboneAddrWidth.Flag := '';
                            </not_selected>
                        </makefile_generator>
                    </text>
                    <text id="CompAdditional_HDLHC">
                       <multi/>
                        <caption>Additional CHC HDL generation options</caption>
                        <tool_tip>Here you can specify additional options for hdlhc,<br/>to influence the vhdl/verilog generation.</tool_tip>
                        <makefile_generator>
                        <selected>
                            DXP.AddToolCmdOption( CompAdditional_HDLHC.State );
                        </selected>
                    </makefile_generator>
                </text>
                </group>
                <group>
                    <caption>HDL Generation</caption>
		    <tool_id id_ref="HDLHC"/>
                    <choices id="Choices_HwCompMuxComponents">
                        <default state=""/>
                        <choice id="HwCompMuxComponents">
                            <caption>Generate separate components for multiplexors</caption>
                            <tool_tip>When this option is set, multiplexors for input ports of components will be created in a separate component. By default, the multiplexors will be generated in a process.</tool_tip>
                            <makefile_generator>
                            <selected>
                                HwCompMuxComponents.Flag := '--mux-components';
                                DXP.AddToolCmdOption( HwCompMuxComponents.Flag );
                            </selected>
                            <not_selected>
                                HwCompMuxComponents.Flag := '';
                            </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                    <choices id="Choices_HwCoregenMemories">
                        <default state=""/>
                        <choice id="HwCoregenMemories">
                            <caption>Generate Coregen macros as memory implementation.</caption>
                            <tool_tip>When this option is set, blockram memory will be generated by Altium CoreGenerator. By default, the memory is inferred from vhdl. However, not all synthesizers support this (fully).</tool_tip>
                            <makefile_generator>
                            <selected>
                                HwCoregenMemories.Flag := '--coregen-memory';
                                DXP.AddToolCmdOption( HwCoregenMemories.Flag );
                            </selected>
                            <not_selected>
                                HwCoregenMemories.Flag := '';
                            </not_selected>
                            </makefile_generator>
                        </choice>
                    </choices>
                </group>
                <group>
                    <caption>Output Files</caption>
                    <tool_id id_ref="HDLHC"/>
                    <text id="HwCompVhdl">
                        <caption>VHDL</caption>
                        <makefile_generator>
                            <selected>
                                HwCompVhdl.Flag := '--vhdl=' + HwCompVhdl.State;
                                DXP.AddToolCmdOption( HwCompVhdl.Flag );
                            </selected>
                            <not_selected>
                                HwCompVhdl.Flag := '--vhdl="' + projVHDLFileName + '"';
                                DXP.AddToolCmdOption( HwCompVhdl.Flag );
                            </not_selected>
                        </makefile_generator>
                        <button on_click="DXP.FileOpenDialog(HwCompVhdl);"/>        
                    </text>
                    <text id="HwCompVerilog">
                        <caption>Verilog</caption>
                        <makefile_generator>
                            <selected>
                                HwCompVerilog.Flag := '--verilog=' + HwCompVerilog.State;
                                DXP.AddToolCmdOption( HwCompVerilog.Flag );
                            </selected>
                            <not_selected>
                                HwCompVerilog.Flag := '--verilog="' + projVerilogFileName + '"';
                                DXP.AddToolCmdOption( HwCompVerilog.Flag );
                            </not_selected>
                        </makefile_generator>
                        <button on_click="DXP.FileOpenDialog(HwCompVerilog);"/>        
                    </text>
                </group>
		<group id="HdlDebugInformation">
                  <caption>Debug Information</caption>
                  <tool_id id_ref="HDLHC"/>
                  <choices id="Choices_HwCompDebug">
                      <choice id="HwCompTraceFunctions">
                          <caption>Trace function entries</caption>
                          <makefile_generator>
                              <selected>
                                  HwCompTraceFunctions.Flag := '--trace=f';
                                  DXP.AddToolCmdOption(HwCompTraceFunctions.Flag);
                              </selected>
                              <not_selected>
                                  HwCompTraceFunctions.Flag := '';
                              </not_selected>
                          </makefile_generator>
                      </choice>
                      <choice id="HwCompTraceStates">
                          <caption>Trace state transitions</caption>
                          <makefile_generator>
                              <selected>
                                  HwCompTraceStates.Flag := '--trace=s';
                                  DXP.AddToolCmdOption(HwCompTraceStates.Flag);
                              </selected>
                              <not_selected>
                                  HwCompTraceStates.Flag := '';
                              </not_selected>
                          </makefile_generator>
                      </choice>
                      <choice id="HwCompTraceMemory">
                          <caption>Trace memory accesses</caption>
                          <makefile_generator>
                              <selected>
                                  HwCompTraceMemory.Flag := '--trace=f';
                                  DXP.AddToolCmdOption(HwCompTraceMemory.Flag);
                              </selected>
                              <not_selected>
                                  HwCompTraceMemory.Flag := '';
                              </not_selected>
                          </makefile_generator>
                      </choice>
                  </choices>
              </group>
    </group>

        <text id="CompLslIncludes">
            <tool_id id_ref="CC"/>
            <default state="SELECTED"/>
            <makefile_generator>
                <selected>
                    DXP.AddToolCmdOption('--lsl-include-directory="$(PROJDIR)\' + getWorkDir + '"');
                    If HwCompOnlyRtlQualfied.Selected Then
                        DXP.AddToolCmdOption('--lsl-include-directory="$(PRODDIR)\c' + HwCompCoreCompatibility.State + '\include.lsl"');
                    DXP.AddToolCmdOption(LkStdLsl.Flag);
                </selected>
            </makefile_generator>
        </text>
        <text id="LkLslIncludes">
            <tool_id id_ref="LK_HW"/>
            <default state="SELECTED"/>
            <makefile_generator>
                <selected>
                    DXP.AddToolCmdOption('-I"$(PROJDIR)\' + getWorkDir + '"');
                    If HwCompOnlyRtlQualfied.Selected Then
                        DXP.AddToolCmdOption('-I"$(PRODDIR)\c' + HwCompCoreCompatibility.State + '\include.lsl"');
                    DXP.AddToolCmdOption(LkStdLsl.Flag);
                </selected>
            </makefile_generator>
        </text>

    </options>
    <tool_definitions> 
        <options>
            <macro name="OPT_CPU" value="OPT_CPU"/>
            <macro name="OPT_ARCH" value="OPT_ARCH"/>
            <macro name="OPT_CC" value="DXP.GetToolCmdOption('CC')"/>
            <macro name="OPT_AS" value="DXP.GetToolCmdOption('AS')"/>
            <macro name="OPT_LK" value="DXP.GetToolCmdOption('LK')"/>
            <macro name="OPT_LK_SW" value="DXP.GetToolCmdOption('LK_SW')"/>
            <macro name="OPT_LK_HW" value="DXP.GetToolCmdOption('LK_HW')"/>
            <macro name="OPT_HDLHC" value="DXP.GetToolCmdOption('HDLHC')"/>
        </options>

        <tool>
            <tool_id id="CC"/>
            <suffix_src value=".c"/>
            <suffix_dest value=".src"/>
            <depend_method value="4"/>
            <opt_action value="$(OPT_ARCH) $(OPT_CPU) $(OPT_CC) %file"/>
            <action>
                <![CDATA[
    @echo Compiling
    %exe(chc.exe) -o "$@" --dep-file="$*.d" --make-target="$@" -f %optfile
                ]]>
            </action>
        </tool>

        <tool>
            <tool_id id="AS"/>
            <suffix_src value=".src"/>
            <suffix_dest value=".obj"/>
            <depend_method value="2"/>
            <opt_action value="$(OPT_CPU) $(OPT_AS) %file"/>
            <action>
                <![CDATA[
    @echo Assembling ${*F}.src
    %exe(ashc.exe) -o "$@" -f %optfile
                ]]>
            </action>
        </tool>

        <tool>
            <tool_id id="LK"/>
            <suffix_src value=".obj"/>
            <suffix_dest value=".elf"/>
            <opt_action value="-Chc $(OPT_LK_HW) -OC %file"/>
            <action>
                <![CDATA[
    @echo Linking and Locating ${@F}
    %exe(lkhc.exe) -o "$@" --dep-file="$*.d" --make-target="$@" -f %optfile
                ]]>
            </action>
        </tool>

        <tool>
            <tool_id id="HDLHC"/>
            <suffix_src value=".obj"/>
            <suffix_dest value=".vhd"/>

            <opt_action value="$(OPT_HDLHC) %file"/>
            <action>
                <![CDATA[
    @echo Generating HDL ${@F}
    %exe(hdlhc.exe) -f %optfile
                ]]>
            </action>
        </tool>
    </tool_definitions>
</tool_chain>
