/**************************************************************************
**									  *
**  FILE	:  wmemset.c						  *
**									  *
**  DESCRIPTION :  Source file for wmemset routine.			  *
**									  *
**  Copyright 1996-2010 Altium BV                                         *
**									  *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Copy the value of c into the first n wide characters of the object
 * pointed to by s.
 *
 * Return the value of s.
 */
wchar_t*
wmemset( wchar_t* s, wchar_t c, size_t n )
{
	wchar_t* dst;

	for ( dst = s; n > 0; n--, dst++ )
	{
		*dst = c;
	}

	return s;
}

#endif
