/**************************************************************************
**									  *
**  FILE	:  wctype.c						  *
**									  *
**  DESCRIPTION :  Source file for wctype routine.			  *
**									  *
**  Copyright 1996-2010 Altium BV                                         *
**									  *
**************************************************************************/

#include <string.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wctype.h>

/*
 * Construct a value with type wctype_t that describes a class of wide
 * characters identified by the string argument property.  Return 0 on
 * failure.
 */
wctype_t
wctype( const char* property )
{
	if ( strcmp( property, "alnum" ) == 0 )
	{
		return _alnum;
	}
	if ( strcmp( property, "alpha" ) == 0 )
	{
		return _alpha;
	}
	if ( strcmp( property, "blank" ) == 0 )
	{
		return _blank;
	}
	if ( strcmp( property, "cntrl" ) == 0 )
	{
		return _cntrl;
	}
	if ( strcmp( property, "digit" ) == 0 )
	{
		return _digit;
	}
	if ( strcmp( property, "graph" ) == 0 )
	{
		return _graph;
	}
	if ( strcmp( property, "lower" ) == 0 )
	{
		return _lower;
	}
	if ( strcmp( property, "print" ) == 0 )
	{
		return _print;
	}
	if ( strcmp( property, "punct" ) == 0 )
	{
		return _punct;
	}
	if ( strcmp( property, "space" ) == 0 )
	{
		return _space;
	}
	if ( strcmp( property, "upper" ) == 0 )
	{
		return _upper;
	}
	if ( strcmp( property, "xdigit" ) == 0 )
	{
		return _xdigit;
	}

	return 0;
}

#endif
