/**************************************************************************
**                                                                        *
**  FILE        :  wcstoumax.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for wcstoumax() routine                    *
**                 Converts a wide string to a maximum sized unsigned     *
**                 integer value                                          *
**                 Conversion is done until an unknown character is met   *
**                 or until the value doesn't fit anymore                 *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <inttypes.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wchar.h>

uintmax_t
wcstoumax( const wchar_t* restrict str, wchar_t** restrict ptr,
	   int base )
{
	return (uintmax_t) wcstoull( str, ptr, base );
}

#endif
