/**************************************************************************
**                                                                        *
**  FILE        :  wcstoimax.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for wcstoimax() routine                    *
**                 Converts a wide string to a maximum sized integer      *
**                 value                                                  *
**                 Conversion is done until an unknown character is met   *
**                 or until the value doesn't fit anymore                 *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <inttypes.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wchar.h>

intmax_t
wcstoimax( const wchar_t* restrict str, wchar_t** restrict ptr,
	   int base )
{
	return (intmax_t) wcstoll( str, ptr, base );
}

#endif
