/**************************************************************************
**									  *
**  FILE	:  wcstof.c						  *
**									  *
**  DESCRIPTION :  Source file for wcstof routine.			  *
**									  *
**  Copyright 1996-2010 Altium BV                                         *
**									  *
**************************************************************************/

#include <float.h>
#include <math.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wchar.h>

#ifndef FLT_MAX_10_MANT
/* #define FLT_MAX_10_MANT (FLT_MAX)/pow(10,FLT_MAX_10_EXP) */
#define FLT_MAX_10_MANT	3.40282347		/* (pow(2,128)-pow(2,104))/pow(10,38) */
#endif
#ifndef FLT_MIN_10_MANT
/* #define FLT_MIN_10_MANT (FLT_MIN)/(pow(10,FLT_MIN_10_EXP)-1) */
#define FLT_MIN_10_MANT	1.17549435		/* pow(2,-126)/pow(10,-38) */
#endif

extern long double _wcstod( const wchar_t * restrict p, wchar_t ** restrict ptr,
			    int min_exponent, int max_exponent, long double min_mantissa,
			    long double max_mantissa, long double huge_value );

float
wcstof( const wchar_t* restrict nptr, wchar_t** restrict endptr )
{
	return (float) _wcstod( nptr, endptr, FLT_MIN_10_EXP, FLT_MAX_10_EXP,
				FLT_MIN_10_MANT, FLT_MAX_10_MANT, HUGE_VALF);
}

#endif
