/**************************************************************************
**									  *
**  FILE	:  wcsrtomb.c						  *
**									  *
**  DESCRIPTION :  Source file for wcsrtombs routine.			  *
**									  *
**  Copyright 1996-2010 Altium BV                                         *
**									  *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Convert a sequence of wide characters from the array indirectly pointed
 * to by src into a sequence of corresponding multibyte characters,
 * beginning in the conversion state described by the object pointed to by
 * ps. The converted characters (including a terminating null wide
 * character) are stored into the array pointed to by dst.
 *
 * Return (size_t) -1 if an encoding error occured; otherwise return the
 * number of bytes in the resulting multibyte sequence, not including the
 * terminating null (if any).
 */
size_t
wcsrtombs( char* restrict dst, const wchar_t** restrict src, size_t len,
	   mbstate_t* restrict ps )
{
	char		c;
	const wchar_t*	ptwc;
	size_t		result;
	size_t		n_bytes;
	mbstate_t	internal_state;
	mbstate_t*	ptstate;

	ptstate = &internal_state;
	n_bytes = 0;

	if ( src != NULL && *src != NULL )
	{
		if ( ps == NULL )
		{
			INIT_MBSTATE_OBJECT( *ptstate );
		}
		else
		{
			*ptstate = *ps;
		}
		for ( ptwc = *src; n_bytes < len; n_bytes++, ptwc++ )
		{
			result = wcrtomb( &c, *ptwc, ptstate );

			if ( result == (size_t) -1 )
			{
			/* Encoding error occured.
			 */
				n_bytes = (size_t) -1;
				break;
			}

			if ( dst != NULL )
			{
				*dst = c;
				dst++;
			}

			if ( *ptwc == (wchar_t) 0 )
			{
			/* Reached end of wide character string.
			 */
				ptwc = NULL;
				break;
			}
		}

		if ( n_bytes != (size_t) -1 )
		{
			*src = ptwc;

			if ( ps != NULL )
			{
				*ps = *ptstate;
			}
		}
	}

	return n_bytes;
}

#endif
