/**************************************************************************
**                                                                        *
**  FILE        :  wcscspn.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wcscspn routine.                       *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Compute the length of the maximum initial segment of the wide string 
 * pointed to by s1 which consists entirely of wide characters NOT from the
 * wide string pointed to by s2.
 *
 * Return the length of the segment.
 */
size_t wcscspn(const wchar_t *s1, const wchar_t *s2)
{
	size_t count = 0;

	if (s1 && s2)
	{
		for (; *s1; s1++, count++)
		{
			if (wcschr(s2, *s1))
			{
				break;
			}
		}
	}

	return count;
}

#endif
