/**************************************************************************
**                                                                        *
**  FILE        :  wcscmp.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for wcscmp routine.                        *
**                 Compares s1 and s2.                                    *
**                 Returns < 0 if s1 <  s2                                *
**                           0 if s1 == s2                                *
**                         > 0 if s1 >  s2                                *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

int wcscmp(const wchar_t *s1, const wchar_t *s2)
{
	if (s1 && s2)
	{
		while (*s1 == *s2 && *s1)
		{
			s1++;
			s2++;
		}
     
		return (int) (*s1 - *s2);
	}

	return 0;
}

#endif
