/**************************************************************************
**                                                                        *
**  FILE        :  wcschr.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for wcschr routine.                        *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Locate the first occurence of c in the wide string pointed to by s. the 
 * terminating null wide character is considered to be part of the wide 
 * string.
 *
 * Return a pointer to the located wide character if found; otherwise
 * return a null pointer.
 */
wchar_t *wcschr(const wchar_t *s, wchar_t c)
{
	if (s)
	{
		for (; *s; s++)
		{
			if (*s == c)
			{
				return (wchar_t *) s;
			}
		}

		/* Check also for the terminating null wide character.
		 */
		if (c == (wchar_t) 0)
		{
			return (wchar_t *) s;
		}
	}

	return NULL;
}

#endif
