/**************************************************************************
**                                                                        *
**  FILE        :  vsnprintf.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for vsnprintf() routine.                   *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <limits.h>
#include <io.h>

int vsnprintf( char * restrict s, size_t n, const char * restrict format, va_list arg )
{
	int		chars;
	struct _io	buf;

	buf.fp = NULL;
	buf.ptr = s;
	buf.end = ( s ? s + n - 1 : NULL );
	chars = _doprint( & buf, format, arg );
	if (s && n) *buf.ptr = 0;

	return chars;
}
