/**************************************************************************
**                                                                        *
**  FILE        :  tmpnam.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for tmpnam() routine                       *
**                 Generates a 'unique' file name. This function may be   *
**                 called TMP_MAX times before the same name is returned  *
**                                                                        *
**                 This routine may be customised.                        *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <string.h>

char *
tmpnam( char * s )
{
	/* 's' buffer for temporary file name */
	int	i;
	char	*p;
	unsigned	int	j;
	static unsigned	int	r;
	static	char	namebuf[ L_tmpnam ];

	if ( s == NULL )
	{
		s = namebuf;
	}
	r++;
	strcpy( s, _P_tmpdir );
	p = s + L_tmpnam - 1;
	*p = '\0';
	i = L_tmpnam - sizeof(_P_tmpdir);
	for ( j = r; --i >= 0; j >>= 3 )
	{
		*--p = '0' + (j & 07);
	}
	return s;
}
